# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/recommendationengine/v1beta1/catalog_service_pb"
require "google/cloud/recommendation_engine/v1beta1/catalog_service/rest/service_stub"

module Google
  module Cloud
    module RecommendationEngine
      module V1beta1
        module CatalogService
          module Rest
            ##
            # REST client for the CatalogService service.
            #
            # Service for ingesting catalog information of the customer's website.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "recommendationengine.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :catalog_service_stub

              ##
              # Configure the CatalogService Client class.
              #
              # See {::Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all CatalogService clients
              #   ::Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "RecommendationEngine", "V1beta1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_catalog_item.timeout = 600.0
                  default_config.rpcs.create_catalog_item.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_catalog_item.timeout = 600.0
                  default_config.rpcs.get_catalog_item.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_catalog_items.timeout = 600.0
                  default_config.rpcs.list_catalog_items.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.update_catalog_item.timeout = 600.0
                  default_config.rpcs.update_catalog_item.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_catalog_item.timeout = 600.0
                  default_config.rpcs.delete_catalog_item.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.import_catalog_items.timeout = 600.0
                  default_config.rpcs.import_catalog_items.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the CatalogService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @catalog_service_stub.universe_domain
              end

              ##
              # Create a new CatalogService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the CatalogService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @catalog_service_stub = ::Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @catalog_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @catalog_service_stub.logger
              end

              # Service calls

              ##
              # Creates a catalog item.
              #
              # @overload create_catalog_item(request, options = nil)
              #   Pass arguments to `create_catalog_item` via a request object, either of type
              #   {::Google::Cloud::RecommendationEngine::V1beta1::CreateCatalogItemRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::RecommendationEngine::V1beta1::CreateCatalogItemRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_catalog_item(parent: nil, catalog_item: nil)
              #   Pass arguments to `create_catalog_item` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent catalog resource name, such as
              #     `projects/*/locations/global/catalogs/default_catalog`.
              #   @param catalog_item [::Google::Cloud::RecommendationEngine::V1beta1::CatalogItem, ::Hash]
              #     Required. The catalog item to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::RecommendationEngine::V1beta1::CatalogItem]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::RecommendationEngine::V1beta1::CatalogItem]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommendation_engine/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::RecommendationEngine::V1beta1::CreateCatalogItemRequest.new
              #
              #   # Call the create_catalog_item method.
              #   result = client.create_catalog_item request
              #
              #   # The returned object is of type Google::Cloud::RecommendationEngine::V1beta1::CatalogItem.
              #   p result
              #
              def create_catalog_item request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RecommendationEngine::V1beta1::CreateCatalogItemRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_catalog_item.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::RecommendationEngine::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_catalog_item.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_catalog_item.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @catalog_service_stub.create_catalog_item request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a specific catalog item.
              #
              # @overload get_catalog_item(request, options = nil)
              #   Pass arguments to `get_catalog_item` via a request object, either of type
              #   {::Google::Cloud::RecommendationEngine::V1beta1::GetCatalogItemRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::RecommendationEngine::V1beta1::GetCatalogItemRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_catalog_item(name: nil)
              #   Pass arguments to `get_catalog_item` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Full resource name of catalog item, such as
              #     `projects/*/locations/global/catalogs/default_catalog/catalogitems/some_catalog_item_id`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::RecommendationEngine::V1beta1::CatalogItem]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::RecommendationEngine::V1beta1::CatalogItem]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommendation_engine/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::RecommendationEngine::V1beta1::GetCatalogItemRequest.new
              #
              #   # Call the get_catalog_item method.
              #   result = client.get_catalog_item request
              #
              #   # The returned object is of type Google::Cloud::RecommendationEngine::V1beta1::CatalogItem.
              #   p result
              #
              def get_catalog_item request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RecommendationEngine::V1beta1::GetCatalogItemRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_catalog_item.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::RecommendationEngine::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_catalog_item.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_catalog_item.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @catalog_service_stub.get_catalog_item request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a list of catalog items.
              #
              # @overload list_catalog_items(request, options = nil)
              #   Pass arguments to `list_catalog_items` via a request object, either of type
              #   {::Google::Cloud::RecommendationEngine::V1beta1::ListCatalogItemsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::RecommendationEngine::V1beta1::ListCatalogItemsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_catalog_items(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_catalog_items` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent catalog resource name, such as
              #     `projects/*/locations/global/catalogs/default_catalog`.
              #   @param page_size [::Integer]
              #     Optional. Maximum number of results to return per page. If zero, the
              #     service will choose a reasonable default.
              #   @param page_token [::String]
              #     Optional. The previous ListCatalogItemsResponse.next_page_token.
              #   @param filter [::String]
              #     Optional. A filter to apply on the list results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::RecommendationEngine::V1beta1::CatalogItem>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::RecommendationEngine::V1beta1::CatalogItem>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommendation_engine/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::RecommendationEngine::V1beta1::ListCatalogItemsRequest.new
              #
              #   # Call the list_catalog_items method.
              #   result = client.list_catalog_items request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::RecommendationEngine::V1beta1::CatalogItem.
              #     p item
              #   end
              #
              def list_catalog_items request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RecommendationEngine::V1beta1::ListCatalogItemsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_catalog_items.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::RecommendationEngine::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_catalog_items.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_catalog_items.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @catalog_service_stub.list_catalog_items request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @catalog_service_stub, :list_catalog_items, "catalog_items", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a catalog item. Partial updating is supported. Non-existing
              # items will be created.
              #
              # @overload update_catalog_item(request, options = nil)
              #   Pass arguments to `update_catalog_item` via a request object, either of type
              #   {::Google::Cloud::RecommendationEngine::V1beta1::UpdateCatalogItemRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::RecommendationEngine::V1beta1::UpdateCatalogItemRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_catalog_item(name: nil, catalog_item: nil, update_mask: nil)
              #   Pass arguments to `update_catalog_item` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Full resource name of catalog item, such as
              #     `projects/*/locations/global/catalogs/default_catalog/catalogItems/some_catalog_item_id`.
              #   @param catalog_item [::Google::Cloud::RecommendationEngine::V1beta1::CatalogItem, ::Hash]
              #     Required. The catalog item to update/create. The 'catalog_item_id' field
              #     has to match that in the 'name'.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Indicates which fields in the provided 'item' to update. If not
              #     set, will by default update all fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::RecommendationEngine::V1beta1::CatalogItem]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::RecommendationEngine::V1beta1::CatalogItem]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommendation_engine/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::RecommendationEngine::V1beta1::UpdateCatalogItemRequest.new
              #
              #   # Call the update_catalog_item method.
              #   result = client.update_catalog_item request
              #
              #   # The returned object is of type Google::Cloud::RecommendationEngine::V1beta1::CatalogItem.
              #   p result
              #
              def update_catalog_item request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RecommendationEngine::V1beta1::UpdateCatalogItemRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_catalog_item.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::RecommendationEngine::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_catalog_item.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_catalog_item.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @catalog_service_stub.update_catalog_item request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a catalog item.
              #
              # @overload delete_catalog_item(request, options = nil)
              #   Pass arguments to `delete_catalog_item` via a request object, either of type
              #   {::Google::Cloud::RecommendationEngine::V1beta1::DeleteCatalogItemRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::RecommendationEngine::V1beta1::DeleteCatalogItemRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_catalog_item(name: nil)
              #   Pass arguments to `delete_catalog_item` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Full resource name of catalog item, such as
              #     `projects/*/locations/global/catalogs/default_catalog/catalogItems/some_catalog_item_id`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommendation_engine/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::RecommendationEngine::V1beta1::DeleteCatalogItemRequest.new
              #
              #   # Call the delete_catalog_item method.
              #   result = client.delete_catalog_item request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_catalog_item request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RecommendationEngine::V1beta1::DeleteCatalogItemRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_catalog_item.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::RecommendationEngine::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_catalog_item.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_catalog_item.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @catalog_service_stub.delete_catalog_item request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Bulk import of multiple catalog items. Request processing may be
              # synchronous. No partial updating supported. Non-existing items will be
              # created.
              #
              # Operation.response is of type ImportResponse. Note that it is
              # possible for a subset of the items to be successfully updated.
              #
              # @overload import_catalog_items(request, options = nil)
              #   Pass arguments to `import_catalog_items` via a request object, either of type
              #   {::Google::Cloud::RecommendationEngine::V1beta1::ImportCatalogItemsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::RecommendationEngine::V1beta1::ImportCatalogItemsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_catalog_items(parent: nil, request_id: nil, input_config: nil, errors_config: nil)
              #   Pass arguments to `import_catalog_items` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. `projects/1234/locations/global/catalogs/default_catalog`
              #   @param request_id [::String]
              #     Optional. Unique identifier provided by client, within the ancestor
              #     dataset scope. Ensures idempotency and used for request deduplication.
              #     Server-generated if unspecified. Up to 128 characters long. This is
              #     returned as google.longrunning.Operation.name in the response.
              #   @param input_config [::Google::Cloud::RecommendationEngine::V1beta1::InputConfig, ::Hash]
              #     Required. The desired input location of the data.
              #   @param errors_config [::Google::Cloud::RecommendationEngine::V1beta1::ImportErrorsConfig, ::Hash]
              #     Optional. The desired location of errors incurred during the Import.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommendation_engine/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::RecommendationEngine::V1beta1::ImportCatalogItemsRequest.new
              #
              #   # Call the import_catalog_items method.
              #   result = client.import_catalog_items request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def import_catalog_items request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RecommendationEngine::V1beta1::ImportCatalogItemsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_catalog_items.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::RecommendationEngine::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_catalog_items.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_catalog_items.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @catalog_service_stub.import_catalog_items request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the CatalogService REST API.
              #
              # This class represents the configuration for CatalogService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_catalog_item to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_catalog_item.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::RecommendationEngine::V1beta1::CatalogService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_catalog_item.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "recommendationengine.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the CatalogService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_catalog_item`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_catalog_item
                  ##
                  # RPC-specific configuration for `get_catalog_item`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_catalog_item
                  ##
                  # RPC-specific configuration for `list_catalog_items`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_catalog_items
                  ##
                  # RPC-specific configuration for `update_catalog_item`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_catalog_item
                  ##
                  # RPC-specific configuration for `delete_catalog_item`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_catalog_item
                  ##
                  # RPC-specific configuration for `import_catalog_items`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_catalog_items

                  # @private
                  def initialize parent_rpcs = nil
                    create_catalog_item_config = parent_rpcs.create_catalog_item if parent_rpcs.respond_to? :create_catalog_item
                    @create_catalog_item = ::Gapic::Config::Method.new create_catalog_item_config
                    get_catalog_item_config = parent_rpcs.get_catalog_item if parent_rpcs.respond_to? :get_catalog_item
                    @get_catalog_item = ::Gapic::Config::Method.new get_catalog_item_config
                    list_catalog_items_config = parent_rpcs.list_catalog_items if parent_rpcs.respond_to? :list_catalog_items
                    @list_catalog_items = ::Gapic::Config::Method.new list_catalog_items_config
                    update_catalog_item_config = parent_rpcs.update_catalog_item if parent_rpcs.respond_to? :update_catalog_item
                    @update_catalog_item = ::Gapic::Config::Method.new update_catalog_item_config
                    delete_catalog_item_config = parent_rpcs.delete_catalog_item if parent_rpcs.respond_to? :delete_catalog_item
                    @delete_catalog_item = ::Gapic::Config::Method.new delete_catalog_item_config
                    import_catalog_items_config = parent_rpcs.import_catalog_items if parent_rpcs.respond_to? :import_catalog_items
                    @import_catalog_items = ::Gapic::Config::Method.new import_catalog_items_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
