# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module RecaptchaEnterprise
      module V1beta1
        # The create assessment request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project in which the assessment is created,
        #     in the format `projects/{project_number}`.
        # @!attribute [rw] assessment
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::Assessment]
        #     Required. The assessment details.
        class CreateAssessmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes an event in the lifecycle of a payment transaction.
        # @!attribute [rw] event_type
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::TransactionEvent::TransactionEventType]
        #     Optional. The type of this transaction event.
        # @!attribute [rw] reason
        #   @return [::String]
        #     Optional. The reason or standardized code that corresponds with this
        #     transaction event, if one exists. For example, a CHARGEBACK event with code
        #     6005.
        # @!attribute [rw] value
        #   @return [::Float]
        #     Optional. The value that corresponds with this transaction event, if one
        #     exists. For example, a refund event where $5.00 was refunded. Currency is
        #     obtained from the original transaction data.
        # @!attribute [rw] event_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Timestamp when this transaction event occurred; otherwise assumed
        #     to be the time of the API call.
        class TransactionEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum that represents an event in the payment transaction lifecycle.
          module TransactionEventType
            # Default, unspecified event type.
            TRANSACTION_EVENT_TYPE_UNSPECIFIED = 0

            # Indicates that the transaction is approved by the merchant. The
            # accompanying reasons can include terms such as 'INHOUSE', 'ACCERTIFY',
            # 'CYBERSOURCE', or 'MANUAL_REVIEW'.
            MERCHANT_APPROVE = 1

            # Indicates that the transaction is denied and concluded due to risks
            # detected by the merchant. The accompanying reasons can include terms such
            # as 'INHOUSE',  'ACCERTIFY',  'CYBERSOURCE', or 'MANUAL_REVIEW'.
            MERCHANT_DENY = 2

            # Indicates that the transaction is being evaluated by a human, due to
            # suspicion or risk.
            MANUAL_REVIEW = 3

            # Indicates that the authorization attempt with the card issuer succeeded.
            AUTHORIZATION = 4

            # Indicates that the authorization attempt with the card issuer failed.
            # The accompanying reasons can include Visa's '54' indicating that the card
            # is expired, or '82' indicating that the CVV is incorrect.
            AUTHORIZATION_DECLINE = 5

            # Indicates that the transaction is completed because the funds were
            # settled.
            PAYMENT_CAPTURE = 6

            # Indicates that the transaction could not be completed because the funds
            # were not settled.
            PAYMENT_CAPTURE_DECLINE = 7

            # Indicates that the transaction has been canceled. Specify the reason
            # for the cancellation. For example, 'INSUFFICIENT_INVENTORY'.
            CANCEL = 8

            # Indicates that the merchant has received a chargeback inquiry due to
            # fraud for the transaction, requesting additional information before a
            # fraud chargeback is officially issued and a formal chargeback
            # notification is sent.
            CHARGEBACK_INQUIRY = 9

            # Indicates that the merchant has received a chargeback alert due to fraud
            # for the transaction. The process of resolving the dispute without
            # involving the payment network is started.
            CHARGEBACK_ALERT = 10

            # Indicates that a fraud notification is issued for the transaction, sent
            # by the payment instrument's issuing bank because the transaction appears
            # to be fraudulent. We recommend including TC40 or SAFE data in the
            # `reason` field for this event type. For partial chargebacks, we recommend
            # that you include an amount in the `value` field.
            FRAUD_NOTIFICATION = 11

            # Indicates that the merchant is informed by the payment network that the
            # transaction has entered the chargeback process due to fraud. Reason code
            # examples include Discover's '6005' and '6041'. For partial chargebacks,
            # we recommend that you include an amount in the `value` field.
            CHARGEBACK = 12

            # Indicates that the transaction has entered the chargeback process due to
            # fraud, and that the merchant has chosen to enter representment. Reason
            # examples include Discover's '6005' and '6041'. For partial chargebacks,
            # we recommend that you include an amount in the `value` field.
            CHARGEBACK_REPRESENTMENT = 13

            # Indicates that the transaction has had a fraud chargeback which was
            # illegitimate and was reversed as a result. For partial chargebacks, we
            # recommend that you include an amount in the `value` field.
            CHARGEBACK_REVERSE = 14

            # Indicates that the merchant has received a refund for a completed
            # transaction. For partial refunds, we recommend that you include an amount
            # in the `value` field. Reason example: 'TAX_EXEMPT' (partial refund of
            # exempt tax)
            REFUND_REQUEST = 15

            # Indicates that the merchant has received a refund request for this
            # transaction, but that they have declined it. For partial refunds, we
            # recommend that you include an amount in the `value` field. Reason
            # example: 'TAX_EXEMPT' (partial refund of exempt tax)
            REFUND_DECLINE = 16

            # Indicates that the completed transaction was refunded by the merchant.
            # For partial refunds, we recommend that you include an amount in the
            # `value` field. Reason example: 'TAX_EXEMPT' (partial refund of exempt
            # tax)
            REFUND = 17

            # Indicates that the completed transaction was refunded by the merchant,
            # and that this refund was reversed. For partial refunds, we recommend that
            # you include an amount in the `value` field.
            REFUND_REVERSE = 18
          end
        end

        # The request message to annotate an Assessment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Assessment, in the format
        #     `projects/{project_number}/assessments/{assessment_id}`.
        # @!attribute [rw] annotation
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::AnnotateAssessmentRequest::Annotation]
        #     Optional. The annotation that is assigned to the Event. This field can be
        #     left empty to provide reasons that apply to an event without concluding
        #     whether the event is legitimate or fraudulent.
        # @!attribute [rw] reasons
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1beta1::AnnotateAssessmentRequest::Reason>]
        #     Optional. Reasons for the annotation that are assigned to the event.
        # @!attribute [rw] hashed_account_id
        #   @return [::String]
        #     Optional. Unique stable hashed user identifier to apply to the assessment.
        #     This is an alternative to setting the `hashed_account_id` in
        #     `CreateAssessment`, for example, when the account identifier is not yet
        #     known in the initial request. It is recommended that the identifier is
        #     hashed using hmac-sha256 with stable secret.
        # @!attribute [rw] transaction_event
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::TransactionEvent]
        #     Optional. If the assessment is part of a payment transaction, provide
        #     details on payment lifecycle events that occur in the transaction.
        class AnnotateAssessmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum that represents the types of annotations.
          module Annotation
            # Default unspecified type.
            ANNOTATION_UNSPECIFIED = 0

            # Provides information that the event turned out to be legitimate.
            LEGITIMATE = 1

            # Provides information that the event turned out to be fraudulent.
            FRAUDULENT = 2

            # Provides information that the event was related to a login event in which
            # the user typed the correct password. Deprecated, prefer indicating
            # CORRECT_PASSWORD through the reasons field instead.
            PASSWORD_CORRECT = 3

            # Provides information that the event was related to a login event in which
            # the user typed the incorrect password. Deprecated, prefer indicating
            # INCORRECT_PASSWORD through the reasons field instead.
            PASSWORD_INCORRECT = 4
          end

          # Enum that represents potential reasons for annotating an assessment.
          module Reason
            # Default unspecified reason.
            REASON_UNSPECIFIED = 0

            # Indicates that the transaction had a chargeback issued with no other
            # details. When possible, specify the type by using CHARGEBACK_FRAUD or
            # CHARGEBACK_DISPUTE instead.
            CHARGEBACK = 1

            # Indicates that the transaction had a chargeback issued related to an
            # alleged unauthorized transaction from the cardholder's perspective (for
            # example, the card number was stolen).
            CHARGEBACK_FRAUD = 8

            # Indicates that the transaction had a chargeback issued related to the
            # cardholder having provided their card details but allegedly not being
            # satisfied with the purchase (for example, misrepresentation, attempted
            # cancellation).
            CHARGEBACK_DISPUTE = 9

            # Indicates that the completed payment transaction was refunded by the
            # seller.
            REFUND = 10

            # Indicates that the completed payment transaction was determined to be
            # fraudulent by the seller, and was cancelled and refunded as a result.
            REFUND_FRAUD = 11

            # Indicates that the payment transaction was accepted, and the user was
            # charged.
            TRANSACTION_ACCEPTED = 12

            # Indicates that the payment transaction was declined, for example due to
            # invalid card details.
            TRANSACTION_DECLINED = 13

            # Indicates the transaction associated with the assessment is suspected of
            # being fraudulent based on the payment method, billing details, shipping
            # address or other transaction information.
            PAYMENT_HEURISTICS = 2

            # Indicates that the user was served a 2FA challenge. An old assessment
            # with `ENUM_VALUES.INITIATED_TWO_FACTOR` reason that has not been
            # overwritten with `PASSED_TWO_FACTOR` is treated as an abandoned 2FA flow.
            # This is equivalent to `FAILED_TWO_FACTOR`.
            INITIATED_TWO_FACTOR = 7

            # Indicates that the user passed a 2FA challenge.
            PASSED_TWO_FACTOR = 3

            # Indicates that the user failed a 2FA challenge.
            FAILED_TWO_FACTOR = 4

            # Indicates the user provided the correct password.
            CORRECT_PASSWORD = 5

            # Indicates the user provided an incorrect password.
            INCORRECT_PASSWORD = 6

            # Indicates that the user sent unwanted and abusive messages to other users
            # of the platform, such as spam, scams, phishing, or social engineering.
            SOCIAL_SPAM = 14
          end
        end

        # Empty response for AnnotateAssessment.
        class AnnotateAssessmentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Password leak verification info.
        # @!attribute [rw] hashed_user_credentials
        #   @return [::String]
        #     Optional. Scrypt hash of the username+password that the customer wants to
        #     verify against a known password leak.
        # @!attribute [r] credentials_leaked
        #   @return [::Boolean]
        #     Output only. Whether or not the user's credentials are present in a known
        #     leak.
        # @!attribute [rw] canonicalized_username
        #   @return [::String]
        #     Optional. The username part of the user credentials for which we want to
        #     trigger a leak check in canonicalized form. This is the same data used to
        #     create the hashed_user_credentials on the customer side.
        class PasswordLeakVerification
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A reCAPTCHA Enterprise assessment resource.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name for the Assessment in the format
        #     `projects/{project_number}/assessments/{assessment_id}`.
        # @!attribute [rw] event
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::Event]
        #     The event being assessed.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Legitimate event score from 0.0 to 1.0.
        #     (1.0 means very likely legitimate traffic while 0.0 means very likely
        #     non-legitimate traffic).
        # @!attribute [r] token_properties
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::TokenProperties]
        #     Output only. Properties of the provided event token.
        # @!attribute [r] reasons
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1beta1::Assessment::ClassificationReason>]
        #     Output only. Reasons contributing to the risk analysis verdict.
        # @!attribute [rw] password_leak_verification
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::PasswordLeakVerification]
        #     Information about the user's credentials used to check for leaks.
        #     This feature is part of the Early Access Program (EAP). Exercise caution,
        #     and do not deploy integrations based on this feature in a production
        #     environment.
        # @!attribute [rw] account_defender_assessment
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::AccountDefenderAssessment]
        #     Assessment returned by account defender when a hashed_account_id is
        #     provided.
        # @!attribute [rw] fraud_prevention_assessment
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::FraudPreventionAssessment]
        #     Assessment returned by Fraud Prevention when TransactionData is provided.
        class Assessment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Reasons contributing to the risk analysis verdict.
          module ClassificationReason
            # Default unspecified type.
            CLASSIFICATION_REASON_UNSPECIFIED = 0

            # Interactions matched the behavior of an automated agent.
            AUTOMATION = 1

            # The event originated from an illegitimate environment.
            UNEXPECTED_ENVIRONMENT = 2

            # Traffic volume from the event source is higher than normal.
            TOO_MUCH_TRAFFIC = 3

            # Interactions with the site were significantly different than expected
            # patterns.
            UNEXPECTED_USAGE_PATTERNS = 4

            # Too little traffic has been received from this site thus far to generate
            # quality risk analysis.
            LOW_CONFIDENCE_SCORE = 5

            # The request matches behavioral characteristics of a carding attack.
            SUSPECTED_CARDING = 6

            # The request matches behavioral characteristics of chargebacks for fraud.
            SUSPECTED_CHARGEBACK = 7
          end
        end

        # @!attribute [rw] token
        #   @return [::String]
        #     Optional. The user response token provided by the reCAPTCHA client-side
        #     integration on your site.
        # @!attribute [rw] site_key
        #   @return [::String]
        #     Optional. The site key that was used to invoke reCAPTCHA on your site and
        #     generate the token.
        # @!attribute [rw] user_agent
        #   @return [::String]
        #     Optional. The user agent present in the request from the user's device
        #     related to this event.
        # @!attribute [rw] user_ip_address
        #   @return [::String]
        #     Optional. The IP address in the request from the user's device related to
        #     this event.
        # @!attribute [rw] expected_action
        #   @return [::String]
        #     Optional. The expected action for this type of event. This should be the
        #     same action provided at token generation time on client-side platforms
        #     already integrated with reCAPTCHA.
        # @!attribute [rw] hashed_account_id
        #   @return [::String]
        #     Optional. Unique stable hashed user identifier for the request. The
        #     identifier must be hashed using hmac-sha256 with stable secret.
        # @!attribute [rw] transaction_data
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::TransactionData]
        #     Optional. Data describing a payment transaction to be assessed. Sending
        #     this data enables reCAPTCHA Fraud Prevention and the
        #     FraudPreventionAssessment component in the response.
        # @!attribute [rw] fraud_prevention
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::Event::FraudPrevention]
        #     Optional. The Fraud Prevention setting for this Assessment.
        class Event
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Setting that controls Fraud Prevention assessments.
          module FraudPrevention
            # Default, unspecified setting. `fraud_prevention_assessment` is returned
            # if `transaction_data` is present in `Event` and Fraud Prevention is
            # enabled in the Google Cloud console.
            FRAUD_PREVENTION_UNSPECIFIED = 0

            # Enable Fraud Prevention for this assessment, if Fraud Prevention is
            # enabled in the Google Cloud console.
            ENABLED = 1

            # Disable Fraud Prevention for this assessment, regardless of the Google
            # Cloud console settings.
            DISABLED = 2
          end
        end

        # Transaction data associated with a payment protected by reCAPTCHA.
        # @!attribute [rw] transaction_id
        #   @return [::String]
        #     Unique identifier for the transaction. This custom identifier can be used
        #     to reference this transaction in the future, for example, labeling a refund
        #     or chargeback event. Two attempts at the same transaction should use the
        #     same transaction id.
        # @!attribute [rw] payment_method
        #   @return [::String]
        #     The payment method for the transaction. The allowed values are:
        #
        #     * credit-card
        #     * debit-card
        #     * gift-card
        #     * processor-\\{name} (If a third-party is used, for example,
        #     processor-paypal)
        #     * custom-\\{name} (If an alternative method is used, for example,
        #     custom-crypto)
        # @!attribute [rw] card_bin
        #   @return [::String]
        #     The Bank Identification Number - generally the first 6 or 8 digits of the
        #     card.
        # @!attribute [rw] card_last_four
        #   @return [::String]
        #     The last four digits of the card.
        # @!attribute [rw] currency_code
        #   @return [::String]
        #     The currency code in ISO-4217 format.
        # @!attribute [rw] value
        #   @return [::Float]
        #     The decimal value of the transaction in the specified currency.
        # @!attribute [rw] shipping_value
        #   @return [::Float]
        #     The value of shipping in the specified currency. 0 for free or no shipping.
        # @!attribute [rw] shipping_address
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::TransactionData::Address]
        #     Destination address if this transaction involves shipping a physical item.
        # @!attribute [rw] billing_address
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::TransactionData::Address]
        #     Address associated with the payment method when applicable.
        # @!attribute [rw] user
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::TransactionData::User]
        #     Information about the user paying/initiating the transaction.
        # @!attribute [rw] merchants
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1beta1::TransactionData::User>]
        #     Information about the user or users fulfilling the transaction.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1beta1::TransactionData::Item>]
        #     Items purchased in this transaction.
        # @!attribute [rw] gateway_info
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::TransactionData::GatewayInfo]
        #     Information about the payment gateway's response to the transaction.
        class TransactionData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Structured address format for billing and shipping addresses.
          # @!attribute [rw] recipient
          #   @return [::String]
          #     The recipient name, potentially including information such as "care of".
          # @!attribute [rw] address
          #   @return [::Array<::String>]
          #     The first lines of the address. The first line generally contains the
          #     street name and number, and further lines may include information such as
          #     an apartment number.
          # @!attribute [rw] locality
          #   @return [::String]
          #     The town/city of the address.
          # @!attribute [rw] administrative_area
          #   @return [::String]
          #     The state, province, or otherwise administrative area of the address.
          # @!attribute [rw] region_code
          #   @return [::String]
          #     The CLDR country/region of the address.
          # @!attribute [rw] postal_code
          #   @return [::String]
          #     The postal or ZIP code of the address.
          class Address
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details about a user's account involved in the transaction.
          # @!attribute [rw] account_id
          #   @return [::String]
          #     Unique account identifier for this user. If using account defender,
          #     this should match the hashed_account_id field. Otherwise, a unique and
          #     persistent identifier for this account.
          # @!attribute [rw] creation_ms
          #   @return [::Integer]
          #     The epoch milliseconds of the user's account creation.
          # @!attribute [rw] email
          #   @return [::String]
          #     The email address of the user.
          # @!attribute [rw] email_verified
          #   @return [::Boolean]
          #     Whether the email has been verified to be accessible by the user (OTP or
          #     similar).
          # @!attribute [rw] phone_number
          #   @return [::String]
          #     The phone number of the user, with country code.
          # @!attribute [rw] phone_verified
          #   @return [::Boolean]
          #     Whether the phone number has been verified to be accessible by the user
          #     (OTP or similar).
          class User
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Line items being purchased in this transaction.
          # @!attribute [rw] name
          #   @return [::String]
          #     The full name of the item.
          # @!attribute [rw] value
          #   @return [::Float]
          #     The value per item that the user is paying, in the transaction currency,
          #     after discounts.
          # @!attribute [rw] quantity
          #   @return [::Integer]
          #     The quantity of this item that is being purchased.
          # @!attribute [rw] merchant_account_id
          #   @return [::String]
          #     When a merchant is specified, its corresponding account_id. Necessary to
          #     populate marketplace-style transactions.
          class Item
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details about the transaction from the gateway.
          # @!attribute [rw] name
          #   @return [::String]
          #     Name of the gateway service (for example, stripe, square, paypal).
          # @!attribute [rw] gateway_response_code
          #   @return [::String]
          #     Gateway response code describing the state of the transaction.
          # @!attribute [rw] avs_response_code
          #   @return [::String]
          #     AVS response code from the gateway
          #     (available only when reCAPTCHA is called after authorization).
          # @!attribute [rw] cvv_response_code
          #   @return [::String]
          #     CVV response code from the gateway
          #     (available only when reCAPTCHA is called after authorization).
          class GatewayInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] valid
        #   @return [::Boolean]
        #     Whether the provided user response token is valid. When valid = false, the
        #     reason could be specified in invalid_reason or it could also be due to
        #     a user failing to solve a challenge or a sitekey mismatch (i.e the sitekey
        #     used to generate the token was different than the one specified in the
        #     assessment).
        # @!attribute [rw] invalid_reason
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::TokenProperties::InvalidReason]
        #     Reason associated with the response when valid = false.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The timestamp corresponding to the generation of the token.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     The hostname of the page on which the token was generated.
        # @!attribute [rw] action
        #   @return [::String]
        #     Action name provided at token generation.
        class TokenProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum that represents the types of invalid token reasons.
          module InvalidReason
            # Default unspecified type.
            INVALID_REASON_UNSPECIFIED = 0

            # If the failure reason was not accounted for.
            UNKNOWN_INVALID_REASON = 1

            # The provided user verification token was malformed.
            MALFORMED = 2

            # The user verification token had expired.
            EXPIRED = 3

            # The user verification had already been seen.
            DUPE = 4

            # The user verification token did not match the provided site key.
            # This may be a configuration error (for example, development keys used in
            # production) or end users trying to use verification tokens from other
            # sites.
            SITE_MISMATCH = 5

            # The user verification token was not present.  It is a required input.
            MISSING = 6

            # A retriable error (such as network failure) occurred on the browser.
            # Could easily be simulated by an attacker.
            BROWSER_ERROR = 7
          end
        end

        # Assessment for Fraud Prevention.
        # @!attribute [r] transaction_risk
        #   @return [::Float]
        #     Output only. Probability (0-1) of this transaction being fraudulent.
        #     Summarizes the combined risk of attack vectors below.
        # @!attribute [r] stolen_instrument_verdict
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::FraudPreventionAssessment::StolenInstrumentVerdict]
        #     Output only. Assessment of this transaction for risk of a stolen
        #     instrument.
        # @!attribute [r] card_testing_verdict
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::FraudPreventionAssessment::CardTestingVerdict]
        #     Output only. Assessment of this transaction for risk of being part of a
        #     card testing attack.
        # @!attribute [r] behavioral_trust_verdict
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1beta1::FraudPreventionAssessment::BehavioralTrustVerdict]
        #     Output only. Assessment of this transaction for behavioral trust.
        class FraudPreventionAssessment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Information about stolen instrument fraud, where the user is not the
          # legitimate owner of the instrument being used for the purchase.
          # @!attribute [r] risk
          #   @return [::Float]
          #     Output only. Probability (0-1) of this transaction being executed with a
          #     stolen instrument.
          class StolenInstrumentVerdict
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Information about card testing fraud, where an adversary is testing
          # fraudulently obtained cards or brute forcing their details.
          # @!attribute [r] risk
          #   @return [::Float]
          #     Output only. Probability (0-1) of this transaction attempt being part of
          #     a card testing attack.
          class CardTestingVerdict
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Information about behavioral trust of the transaction.
          # @!attribute [r] trust
          #   @return [::Float]
          #     Output only. Probability (0-1) of this transaction attempt being executed
          #     in a behaviorally trustworthy way.
          class BehavioralTrustVerdict
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Account defender risk assessment.
        # @!attribute [rw] labels
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1beta1::AccountDefenderAssessment::AccountDefenderLabel>]
        #     Labels for this request.
        class AccountDefenderAssessment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Labels returned by account defender for this request.
          module AccountDefenderLabel
            # Default unspecified type.
            ACCOUNT_DEFENDER_LABEL_UNSPECIFIED = 0

            # The request matches a known good profile for the user.
            PROFILE_MATCH = 1

            # The request is potentially a suspicious login event and should be further
            # verified either via multi-factor authentication or another system.
            SUSPICIOUS_LOGIN_ACTIVITY = 2

            # The request matched a profile that previously had suspicious account
            # creation behavior. This could mean this is a fake account.
            SUSPICIOUS_ACCOUNT_CREATION = 3

            # The account in the request has a high number of related accounts. It does
            # not necessarily imply that the account is bad but could require
            # investigating.
            RELATED_ACCOUNTS_NUMBER_HIGH = 4
          end
        end
      end
    end
  end
end
