# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module RecaptchaEnterprise
      module V1
        # The create assessment request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project in which the assessment is created,
        #     in the format `projects/{project}`.
        # @!attribute [rw] assessment
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::Assessment]
        #     Required. The assessment details.
        class CreateAssessmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes an event in the lifecycle of a payment transaction.
        # @!attribute [rw] event_type
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::TransactionEvent::TransactionEventType]
        #     Optional. The type of this transaction event.
        # @!attribute [rw] reason
        #   @return [::String]
        #     Optional. The reason or standardized code that corresponds with this
        #     transaction event, if one exists. For example, a CHARGEBACK event with code
        #     6005.
        # @!attribute [rw] value
        #   @return [::Float]
        #     Optional. The value that corresponds with this transaction event, if one
        #     exists. For example, a refund event where $5.00 was refunded. Currency is
        #     obtained from the original transaction data.
        # @!attribute [rw] event_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Timestamp when this transaction event occurred; otherwise assumed
        #     to be the time of the API call.
        class TransactionEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum that represents an event in the payment transaction lifecycle.
          # Ensure that applications can handle values not explicitly listed.
          module TransactionEventType
            # Default, unspecified event type.
            TRANSACTION_EVENT_TYPE_UNSPECIFIED = 0

            # Indicates that the transaction is approved by the merchant. The
            # accompanying reasons can include terms such as 'INHOUSE', 'ACCERTIFY',
            # 'CYBERSOURCE', or 'MANUAL_REVIEW'.
            MERCHANT_APPROVE = 1

            # Indicates that the transaction is denied and concluded due to risks
            # detected by the merchant. The accompanying reasons can include terms such
            # as 'INHOUSE',  'ACCERTIFY',  'CYBERSOURCE', or 'MANUAL_REVIEW'.
            MERCHANT_DENY = 2

            # Indicates that the transaction is being evaluated by a human, due to
            # suspicion or risk.
            MANUAL_REVIEW = 3

            # Indicates that the authorization attempt with the card issuer succeeded.
            AUTHORIZATION = 4

            # Indicates that the authorization attempt with the card issuer failed.
            # The accompanying reasons can include Visa's '54' indicating that the card
            # is expired, or '82' indicating that the CVV is incorrect.
            AUTHORIZATION_DECLINE = 5

            # Indicates that the transaction is completed because the funds were
            # settled.
            PAYMENT_CAPTURE = 6

            # Indicates that the transaction could not be completed because the funds
            # were not settled.
            PAYMENT_CAPTURE_DECLINE = 7

            # Indicates that the transaction has been canceled. Specify the reason
            # for the cancellation. For example, 'INSUFFICIENT_INVENTORY'.
            CANCEL = 8

            # Indicates that the merchant has received a chargeback inquiry due to
            # fraud for the transaction, requesting additional information before a
            # fraud chargeback is officially issued and a formal chargeback
            # notification is sent.
            CHARGEBACK_INQUIRY = 9

            # Indicates that the merchant has received a chargeback alert due to fraud
            # for the transaction. The process of resolving the dispute without
            # involving the payment network is started.
            CHARGEBACK_ALERT = 10

            # Indicates that a fraud notification is issued for the transaction, sent
            # by the payment instrument's issuing bank because the transaction appears
            # to be fraudulent. We recommend including TC40 or SAFE data in the
            # `reason` field for this event type. For partial chargebacks, we recommend
            # that you include an amount in the `value` field.
            FRAUD_NOTIFICATION = 11

            # Indicates that the merchant is informed by the payment network that the
            # transaction has entered the chargeback process due to fraud. Reason code
            # examples include Discover's '6005' and '6041'. For partial chargebacks,
            # we recommend that you include an amount in the `value` field.
            CHARGEBACK = 12

            # Indicates that the transaction has entered the chargeback process due to
            # fraud, and that the merchant has chosen to enter representment. Reason
            # examples include Discover's '6005' and '6041'. For partial chargebacks,
            # we recommend that you include an amount in the `value` field.
            CHARGEBACK_REPRESENTMENT = 13

            # Indicates that the transaction has had a fraud chargeback which was
            # illegitimate and was reversed as a result. For partial chargebacks, we
            # recommend that you include an amount in the `value` field.
            CHARGEBACK_REVERSE = 14

            # Indicates that the merchant has received a refund for a completed
            # transaction. For partial refunds, we recommend that you include an amount
            # in the `value` field. Reason example: 'TAX_EXEMPT' (partial refund of
            # exempt tax)
            REFUND_REQUEST = 15

            # Indicates that the merchant has received a refund request for this
            # transaction, but that they have declined it. For partial refunds, we
            # recommend that you include an amount in the `value` field. Reason
            # example: 'TAX_EXEMPT' (partial refund of exempt tax)
            REFUND_DECLINE = 16

            # Indicates that the completed transaction was refunded by the merchant.
            # For partial refunds, we recommend that you include an amount in the
            # `value` field. Reason example: 'TAX_EXEMPT' (partial refund of exempt
            # tax)
            REFUND = 17

            # Indicates that the completed transaction was refunded by the merchant,
            # and that this refund was reversed. For partial refunds, we recommend that
            # you include an amount in the `value` field.
            REFUND_REVERSE = 18
          end
        end

        # Details on a phone authentication event
        # @!attribute [rw] phone_number
        #   @return [::String]
        #     Required. Phone number in E.164 format for which a multi-factor
        #     authentication challenge was initiated, succeeded, or failed.
        # @!attribute [rw] event_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. The time at which the multi-factor authentication event
        #     (challenge or verification) occurred.
        class PhoneAuthenticationEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message to annotate an Assessment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Assessment, in the format
        #     `projects/{project}/assessments/{assessment}`.
        # @!attribute [rw] annotation
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::AnnotateAssessmentRequest::Annotation]
        #     Optional. The annotation that is assigned to the Event. This field can be
        #     left empty to provide reasons that apply to an event without concluding
        #     whether the event is legitimate or fraudulent.
        # @!attribute [rw] reasons
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::AnnotateAssessmentRequest::Reason>]
        #     Optional. Reasons for the annotation that are assigned to the event.
        # @!attribute [rw] account_id
        #   @return [::String]
        #     Optional. A stable account identifier to apply to the assessment. This is
        #     an alternative to setting `account_id` in `CreateAssessment`, for example
        #     when a stable account identifier is not yet known in the initial request.
        # @!attribute [rw] hashed_account_id
        #   @return [::String]
        #     Optional. A stable hashed account identifier to apply to the assessment.
        #     This is an alternative to setting `hashed_account_id` in
        #     `CreateAssessment`, for example when a stable account identifier is not yet
        #     known in the initial request.
        # @!attribute [rw] transaction_event
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::TransactionEvent]
        #     Optional. If the assessment is part of a payment transaction, provide
        #     details on payment lifecycle events that occur in the transaction.
        # @!attribute [rw] phone_authentication_event
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::PhoneAuthenticationEvent]
        #     Optional. If using an external multi-factor authentication provider,
        #     provide phone authentication details for fraud detection purposes.
        class AnnotateAssessmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum that represents the types of annotations.
          module Annotation
            # Default unspecified type.
            ANNOTATION_UNSPECIFIED = 0

            # Provides information that the event turned out to be legitimate.
            LEGITIMATE = 1

            # Provides information that the event turned out to be fraudulent.
            FRAUDULENT = 2

            # Provides information that the event was related to a login event in which
            # the user typed the correct password. Deprecated, prefer indicating
            # CORRECT_PASSWORD through the reasons field instead.
            PASSWORD_CORRECT = 3

            # Provides information that the event was related to a login event in which
            # the user typed the incorrect password. Deprecated, prefer indicating
            # INCORRECT_PASSWORD through the reasons field instead.
            PASSWORD_INCORRECT = 4
          end

          # Enum that represents potential reasons for annotating an assessment.
          module Reason
            # Unspecified reason. Do not use.
            REASON_UNSPECIFIED = 0

            # Indicates that the transaction had a chargeback issued with no other
            # details. When possible, specify the type by using CHARGEBACK_FRAUD or
            # CHARGEBACK_DISPUTE instead.
            CHARGEBACK = 1

            # Indicates that the transaction had a chargeback issued related to an
            # alleged unauthorized transaction from the cardholder's perspective (for
            # example, the card number was stolen).
            CHARGEBACK_FRAUD = 8

            # Indicates that the transaction had a chargeback issued related to the
            # cardholder having provided their card details but allegedly not being
            # satisfied with the purchase (for example, misrepresentation, attempted
            # cancellation).
            CHARGEBACK_DISPUTE = 9

            # Indicates that the completed payment transaction was refunded by the
            # seller.
            REFUND = 10

            # Indicates that the completed payment transaction was determined to be
            # fraudulent by the seller, and was cancelled and refunded as a result.
            REFUND_FRAUD = 11

            # Indicates that the payment transaction was accepted, and the user was
            # charged.
            TRANSACTION_ACCEPTED = 12

            # Indicates that the payment transaction was declined, for example due to
            # invalid card details.
            TRANSACTION_DECLINED = 13

            # Indicates the transaction associated with the assessment is suspected of
            # being fraudulent based on the payment method, billing details, shipping
            # address or other transaction information.
            PAYMENT_HEURISTICS = 2

            # Indicates that the user was served a 2FA challenge. An old assessment
            # with `ENUM_VALUES.INITIATED_TWO_FACTOR` reason that has not been
            # overwritten with `PASSED_TWO_FACTOR` is treated as an abandoned 2FA flow.
            # This is equivalent to `FAILED_TWO_FACTOR`.
            INITIATED_TWO_FACTOR = 7

            # Indicates that the user passed a 2FA challenge.
            PASSED_TWO_FACTOR = 3

            # Indicates that the user failed a 2FA challenge.
            FAILED_TWO_FACTOR = 4

            # Indicates the user provided the correct password.
            CORRECT_PASSWORD = 5

            # Indicates the user provided an incorrect password.
            INCORRECT_PASSWORD = 6

            # Indicates that the user sent unwanted and abusive messages to other users
            # of the platform, such as spam, scams, phishing, or social engineering.
            SOCIAL_SPAM = 14
          end
        end

        # Empty response for AnnotateAssessment.
        class AnnotateAssessmentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about a verification endpoint that can be used for 2FA.
        # @!attribute [rw] email_address
        #   @return [::String]
        #     Email address for which to trigger a verification request.
        #
        #     Note: The following fields are mutually exclusive: `email_address`, `phone_number`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] phone_number
        #   @return [::String]
        #     Phone number for which to trigger a verification request. Should be given
        #     in E.164 format.
        #
        #     Note: The following fields are mutually exclusive: `phone_number`, `email_address`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] request_token
        #   @return [::String]
        #     Output only. Token to provide to the client to trigger endpoint
        #     verification. It must be used within 15 minutes.
        # @!attribute [r] last_verification_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp of the last successful verification for the
        #     endpoint, if any.
        class EndpointVerificationInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about account verification, used for identity verification.
        # @!attribute [rw] endpoints
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::EndpointVerificationInfo>]
        #     Optional. Endpoints that can be used for identity verification.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     Optional. Language code preference for the verification message, set as a
        #     IETF BCP 47 language code.
        # @!attribute [r] latest_verification_result
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::AccountVerificationInfo::Result]
        #     Output only. Result of the latest account verification challenge.
        # @!attribute [rw] username
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Username of the account that is being verified. Deprecated. Customers
        #     should now provide the `account_id` field in `event.user_info`.
        class AccountVerificationInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Result of the account verification as contained in the verdict token issued
          # at the end of the verification flow.
          # Ensure that applications can handle values not explicitly listed.
          module Result
            # No information about the latest account verification.
            RESULT_UNSPECIFIED = 0

            # The user was successfully verified. This means the account verification
            # challenge was successfully completed.
            SUCCESS_USER_VERIFIED = 1

            # The user failed the verification challenge.
            ERROR_USER_NOT_VERIFIED = 2

            # The site is not properly onboarded to use the account verification
            # feature.
            ERROR_SITE_ONBOARDING_INCOMPLETE = 3

            # The recipient is not allowed for account verification. This can occur
            # during integration but should not occur in production.
            ERROR_RECIPIENT_NOT_ALLOWED = 4

            # The recipient has already been sent too many verification codes in a
            # short amount of time.
            ERROR_RECIPIENT_ABUSE_LIMIT_EXHAUSTED = 5

            # The verification flow could not be completed due to a critical internal
            # error.
            ERROR_CRITICAL_INTERNAL = 6

            # The client has exceeded their two factor request quota for this period of
            # time.
            ERROR_CUSTOMER_QUOTA_EXHAUSTED = 7

            # The request cannot be processed at the time because of an incident. This
            # bypass can be restricted to a problematic destination email domain, a
            # customer, or could affect the entire service.
            ERROR_VERIFICATION_BYPASSED = 8

            # The request parameters do not match with the token provided and cannot be
            # processed.
            ERROR_VERDICT_MISMATCH = 9
          end
        end

        # Private password leak verification info.
        # @!attribute [rw] lookup_hash_prefix
        #   @return [::String]
        #     Required. Exactly 26-bit prefix of the SHA-256 hash of the canonicalized
        #     username. It is used to look up password leaks associated with that hash
        #     prefix.
        # @!attribute [rw] encrypted_user_credentials_hash
        #   @return [::String]
        #     Optional. Encrypted Scrypt hash of the canonicalized username+password. It
        #     is re-encrypted by the server and returned through
        #     `reencrypted_user_credentials_hash`.
        # @!attribute [r] encrypted_leak_match_prefixes
        #   @return [::Array<::String>]
        #     Output only. List of prefixes of the encrypted potential password leaks
        #     that matched the given parameters. They must be compared with the
        #     client-side decryption prefix of `reencrypted_user_credentials_hash`
        # @!attribute [r] reencrypted_user_credentials_hash
        #   @return [::String]
        #     Output only. Corresponds to the re-encryption of the
        #     `encrypted_user_credentials_hash` field. It is used to match potential
        #     password leaks within `encrypted_leak_match_prefixes`.
        class PrivatePasswordLeakVerification
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A reCAPTCHA Enterprise assessment resource.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource name for the Assessment in the format
        #     `projects/{project}/assessments/{assessment}`.
        # @!attribute [rw] event
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::Event]
        #     Optional. The event being assessed.
        # @!attribute [r] risk_analysis
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::RiskAnalysis]
        #     Output only. The risk analysis result for the event being assessed.
        # @!attribute [r] token_properties
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::TokenProperties]
        #     Output only. Properties of the provided event token.
        # @!attribute [rw] account_verification
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::AccountVerificationInfo]
        #     Optional. Account verification information for identity verification. The
        #     assessment event must include a token and site key to use this feature.
        # @!attribute [r] account_defender_assessment
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::AccountDefenderAssessment]
        #     Output only. Assessment returned by account defender when an account
        #     identifier is provided.
        # @!attribute [rw] private_password_leak_verification
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::PrivatePasswordLeakVerification]
        #     Optional. The private password leak verification field contains the
        #     parameters that are used to to check for leaks privately without sharing
        #     user credentials.
        # @!attribute [r] firewall_policy_assessment
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FirewallPolicyAssessment]
        #     Output only. Assessment returned when firewall policies belonging to the
        #     project are evaluated using the field firewall_policy_evaluation.
        # @!attribute [r] fraud_prevention_assessment
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FraudPreventionAssessment]
        #     Output only. Assessment returned by Fraud Prevention when TransactionData
        #     is provided.
        # @!attribute [r] fraud_signals
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FraudSignals]
        #     Output only. Fraud Signals specific to the users involved in a payment
        #     transaction.
        # @!attribute [r] phone_fraud_assessment
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::PhoneFraudAssessment]
        #     Output only. Assessment returned when a site key, a token, and a phone
        #     number as `user_id` are provided. Account defender and SMS toll fraud
        #     protection need to be enabled.
        # @!attribute [rw] assessment_environment
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::AssessmentEnvironment]
        #     Optional. The environment creating the assessment. This describes your
        #     environment (the system invoking CreateAssessment), NOT the environment of
        #     your user.
        class Assessment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The event being assessed.
        # @!attribute [rw] token
        #   @return [::String]
        #     Optional. The user response token provided by the reCAPTCHA Enterprise
        #     client-side integration on your site.
        # @!attribute [rw] site_key
        #   @return [::String]
        #     Optional. The site key that was used to invoke reCAPTCHA Enterprise on your
        #     site and generate the token.
        # @!attribute [rw] user_agent
        #   @return [::String]
        #     Optional. The user agent present in the request from the user's device
        #     related to this event.
        # @!attribute [rw] user_ip_address
        #   @return [::String]
        #     Optional. The IP address in the request from the user's device related to
        #     this event.
        # @!attribute [rw] expected_action
        #   @return [::String]
        #     Optional. The expected action for this type of event. This should be the
        #     same action provided at token generation time on client-side platforms
        #     already integrated with recaptcha enterprise.
        # @!attribute [rw] hashed_account_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Optional. Deprecated: use `user_info.account_id` instead.
        #     Unique stable hashed user identifier for the request. The identifier must
        #     be hashed using hmac-sha256 with stable secret.
        # @!attribute [rw] express
        #   @return [::Boolean]
        #     Optional. Flag for a reCAPTCHA express request for an assessment without a
        #     token. If enabled, `site_key` must reference an Express site key.
        # @!attribute [rw] requested_uri
        #   @return [::String]
        #     Optional. The URI resource the user requested that triggered an assessment.
        # @!attribute [rw] waf_token_assessment
        #   @return [::Boolean]
        #     Optional. Flag for running Web Application Firewall (WAF) token assessment.
        #     If enabled, the token must be specified, and have been created by a
        #     WAF-enabled key.
        # @!attribute [rw] ja3
        #   @return [::String]
        #     Optional. JA3 fingerprint for SSL clients. To learn how to compute this
        #     fingerprint, please refer to https://github.com/salesforce/ja3.
        # @!attribute [rw] ja4
        #   @return [::String]
        #     Optional. JA4 fingerprint for SSL clients. To learn how to compute this
        #     fingerprint, please refer to https://github.com/FoxIO-LLC/ja4.
        # @!attribute [rw] headers
        #   @return [::Array<::String>]
        #     Optional. HTTP header information about the request.
        # @!attribute [rw] firewall_policy_evaluation
        #   @return [::Boolean]
        #     Optional. Flag for enabling firewall policy config assessment.
        #     If this flag is enabled, the firewall policy is evaluated and a
        #     suggested firewall action is returned in the response.
        # @!attribute [rw] transaction_data
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::TransactionData]
        #     Optional. Data describing a payment transaction to be assessed. Sending
        #     this data enables reCAPTCHA Enterprise Fraud Prevention and the
        #     FraudPreventionAssessment component in the response.
        # @!attribute [rw] user_info
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::UserInfo]
        #     Optional. Information about the user that generates this event, when they
        #     can be identified. They are often identified through the use of an account
        #     for logged-in requests or login/registration requests, or by providing user
        #     identifiers for guest actions like checkout.
        # @!attribute [rw] fraud_prevention
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::Event::FraudPrevention]
        #     Optional. The Fraud Prevention setting for this assessment.
        class Event
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Setting that controls Fraud Prevention assessments.
          # Ensure that applications can handle values not explicitly listed.
          module FraudPrevention
            # Default, unspecified setting. `fraud_prevention_assessment` is returned
            # if `transaction_data` is present in `Event` and Fraud Prevention is
            # enabled in the Google Cloud console.
            FRAUD_PREVENTION_UNSPECIFIED = 0

            # Enable Fraud Prevention for this assessment, if Fraud Prevention is
            # enabled in the Google Cloud console.
            ENABLED = 1

            # Disable Fraud Prevention for this assessment, regardless of the Google
            # Cloud console settings.
            DISABLED = 2
          end
        end

        # Transaction data associated with a payment protected by reCAPTCHA Enterprise.
        # @!attribute [rw] transaction_id
        #   @return [::String]
        #     Unique identifier for the transaction. This custom identifier can be used
        #     to reference this transaction in the future, for example, labeling a refund
        #     or chargeback event. Two attempts at the same transaction should use the
        #     same transaction id.
        # @!attribute [rw] payment_method
        #   @return [::String]
        #     Optional. The payment method for the transaction. The allowed values are:
        #
        #     * credit-card
        #     * debit-card
        #     * gift-card
        #     * processor-\\{name} (If a third-party is used, for example,
        #     processor-paypal)
        #     * custom-\\{name} (If an alternative method is used, for example,
        #     custom-crypto)
        # @!attribute [rw] card_bin
        #   @return [::String]
        #     Optional. The Bank Identification Number - generally the first 6 or 8
        #     digits of the card.
        # @!attribute [rw] card_last_four
        #   @return [::String]
        #     Optional. The last four digits of the card.
        # @!attribute [rw] currency_code
        #   @return [::String]
        #     Optional. The currency code in ISO-4217 format.
        # @!attribute [rw] value
        #   @return [::Float]
        #     Optional. The decimal value of the transaction in the specified currency.
        # @!attribute [rw] shipping_value
        #   @return [::Float]
        #     Optional. The value of shipping in the specified currency. 0 for free or no
        #     shipping.
        # @!attribute [rw] shipping_address
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::TransactionData::Address]
        #     Optional. Destination address if this transaction involves shipping a
        #     physical item.
        # @!attribute [rw] billing_address
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::TransactionData::Address]
        #     Optional. Address associated with the payment method when applicable.
        # @!attribute [rw] user
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::TransactionData::User]
        #     Optional. Information about the user paying/initiating the transaction.
        # @!attribute [rw] merchants
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::TransactionData::User>]
        #     Optional. Information about the user or users fulfilling the transaction.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::TransactionData::Item>]
        #     Optional. Items purchased in this transaction.
        # @!attribute [rw] gateway_info
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::TransactionData::GatewayInfo]
        #     Optional. Information about the payment gateway's response to the
        #     transaction.
        class TransactionData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Structured address format for billing and shipping addresses.
          # @!attribute [rw] recipient
          #   @return [::String]
          #     Optional. The recipient name, potentially including information such as
          #     "care of".
          # @!attribute [rw] address
          #   @return [::Array<::String>]
          #     Optional. The first lines of the address. The first line generally
          #     contains the street name and number, and further lines may include
          #     information such as an apartment number.
          # @!attribute [rw] locality
          #   @return [::String]
          #     Optional. The town/city of the address.
          # @!attribute [rw] administrative_area
          #   @return [::String]
          #     Optional. The state, province, or otherwise administrative area of the
          #     address.
          # @!attribute [rw] region_code
          #   @return [::String]
          #     Optional. The CLDR country/region of the address.
          # @!attribute [rw] postal_code
          #   @return [::String]
          #     Optional. The postal or ZIP code of the address.
          class Address
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details about a user's account involved in the transaction.
          # @!attribute [rw] account_id
          #   @return [::String]
          #     Optional. Unique account identifier for this user. If using account
          #     defender, this should match the hashed_account_id field. Otherwise, a
          #     unique and persistent identifier for this account.
          # @!attribute [rw] creation_ms
          #   @return [::Integer]
          #     Optional. The epoch milliseconds of the user's account creation.
          # @!attribute [rw] email
          #   @return [::String]
          #     Optional. The email address of the user.
          # @!attribute [rw] email_verified
          #   @return [::Boolean]
          #     Optional. Whether the email has been verified to be accessible by the
          #     user (OTP or similar).
          # @!attribute [rw] phone_number
          #   @return [::String]
          #     Optional. The phone number of the user, with country code.
          # @!attribute [rw] phone_verified
          #   @return [::Boolean]
          #     Optional. Whether the phone number has been verified to be accessible by
          #     the user (OTP or similar).
          class User
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Line items being purchased in this transaction.
          # @!attribute [rw] name
          #   @return [::String]
          #     Optional. The full name of the item.
          # @!attribute [rw] value
          #   @return [::Float]
          #     Optional. The value per item that the user is paying, in the transaction
          #     currency, after discounts.
          # @!attribute [rw] quantity
          #   @return [::Integer]
          #     Optional. The quantity of this item that is being purchased.
          # @!attribute [rw] merchant_account_id
          #   @return [::String]
          #     Optional. When a merchant is specified, its corresponding account_id.
          #     Necessary to populate marketplace-style transactions.
          class Item
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details about the transaction from the gateway.
          # @!attribute [rw] name
          #   @return [::String]
          #     Optional. Name of the gateway service (for example, stripe, square,
          #     paypal).
          # @!attribute [rw] gateway_response_code
          #   @return [::String]
          #     Optional. Gateway response code describing the state of the transaction.
          # @!attribute [rw] avs_response_code
          #   @return [::String]
          #     Optional. AVS response code from the gateway
          #     (available only when reCAPTCHA Enterprise is called after authorization).
          # @!attribute [rw] cvv_response_code
          #   @return [::String]
          #     Optional. CVV response code from the gateway
          #     (available only when reCAPTCHA Enterprise is called after authorization).
          class GatewayInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # User information associated with a request protected by reCAPTCHA Enterprise.
        # @!attribute [rw] create_account_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Creation time for this account associated with this user. Leave
        #     blank for non logged-in actions, guest checkout, or when there is no
        #     account associated with the current user.
        # @!attribute [rw] account_id
        #   @return [::String]
        #     Optional. For logged-in requests or login/registration requests, the unique
        #     account identifier associated with this user. You can use the username if
        #     it is stable (meaning it is the same for every request associated with the
        #     same user), or any stable user ID of your choice. Leave blank for non
        #     logged-in actions or guest checkout.
        # @!attribute [rw] user_ids
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::UserId>]
        #     Optional. Identifiers associated with this user or request.
        class UserInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An identifier associated with a user.
        # @!attribute [rw] email
        #   @return [::String]
        #     Optional. An email address.
        #
        #     Note: The following fields are mutually exclusive: `email`, `phone_number`, `username`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] phone_number
        #   @return [::String]
        #     Optional. A phone number. Should use the E.164 format.
        #
        #     Note: The following fields are mutually exclusive: `phone_number`, `email`, `username`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] username
        #   @return [::String]
        #     Optional. A unique username, if different from all the other identifiers
        #     and `account_id` that are provided. Can be a unique login handle or
        #     display name for a user.
        #
        #     Note: The following fields are mutually exclusive: `username`, `email`, `phone_number`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class UserId
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Risk analysis result for an event.
        # @!attribute [r] score
        #   @return [::Float]
        #     Output only. Legitimate event score from 0.0 to 1.0.
        #     (1.0 means very likely legitimate traffic while 0.0 means very likely
        #     non-legitimate traffic).
        # @!attribute [r] reasons
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::RiskAnalysis::ClassificationReason>]
        #     Output only. Reasons contributing to the risk analysis verdict.
        # @!attribute [r] extended_verdict_reasons
        #   @return [::Array<::String>]
        #     Output only. Extended verdict reasons to be used for experimentation only.
        #     The set of possible reasons is subject to change.
        # @!attribute [r] challenge
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::RiskAnalysis::Challenge]
        #     Output only. Challenge information for POLICY_BASED_CHALLENGE and INVISIBLE
        #     keys.
        # @!attribute [r] verified_bots
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::Bot>]
        #     Output only. Bots with identities that have been verified by reCAPTCHA and
        #     detected in the event.
        class RiskAnalysis
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Reasons contributing to the risk analysis verdict.
          # Ensure that applications can handle values not explicitly listed.
          module ClassificationReason
            # Default unspecified type.
            CLASSIFICATION_REASON_UNSPECIFIED = 0

            # Interactions matched the behavior of an automated agent.
            AUTOMATION = 1

            # The event originated from an illegitimate environment.
            UNEXPECTED_ENVIRONMENT = 2

            # Traffic volume from the event source is higher than normal.
            TOO_MUCH_TRAFFIC = 3

            # Interactions with the site were significantly different than expected
            # patterns.
            UNEXPECTED_USAGE_PATTERNS = 4

            # Too little traffic has been received from this site thus far to generate
            # quality risk analysis.
            LOW_CONFIDENCE_SCORE = 5

            # The request matches behavioral characteristics of a carding attack.
            SUSPECTED_CARDING = 6

            # The request matches behavioral characteristics of chargebacks for fraud.
            SUSPECTED_CHARGEBACK = 7
          end

          # Challenge information for POLICY_BASED_CHALLENGE and INVISIBLE keys.
          # Ensure that applications can handle values not explicitly listed.
          module Challenge
            # Default unspecified type.
            CHALLENGE_UNSPECIFIED = 0

            # No challenge was presented for solving.
            NOCAPTCHA = 1

            # A solution was submitted that was correct.
            PASSED = 2

            # A solution was submitted that was incorrect or otherwise
            # deemed suspicious.
            FAILED = 3
          end
        end

        # Bot information and metadata.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. Enumerated string value that indicates the identity of the bot,
        #     formatted in kebab-case.
        # @!attribute [rw] bot_type
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::Bot::BotType]
        #     Optional. Enumerated field representing the type of bot.
        class Bot
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Types of bots.
          # Ensure that applications can handle values not explicitly listed.
          module BotType
            # Default unspecified type.
            BOT_TYPE_UNSPECIFIED = 0

            # Software program that interacts with a site and performs tasks
            # autonomously.
            AI_AGENT = 1

            # Software that extracts specific data from sites for use.
            CONTENT_SCRAPER = 2

            # Software that crawls sites and stores content for the purpose of
            # efficient retrieval, likely as part of a search engine.
            SEARCH_INDEXER = 3
          end
        end

        # Properties of the provided event token.
        # @!attribute [r] valid
        #   @return [::Boolean]
        #     Output only. Whether the provided user response token is valid. When valid
        #     = false, the reason could be specified in invalid_reason or it could also
        #     be due to a user failing to solve a challenge or a sitekey mismatch (i.e
        #     the sitekey used to generate the token was different than the one specified
        #     in the assessment).
        # @!attribute [r] invalid_reason
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::TokenProperties::InvalidReason]
        #     Output only. Reason associated with the response when valid = false.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp corresponding to the generation of the token.
        # @!attribute [r] hostname
        #   @return [::String]
        #     Output only. The hostname of the page on which the token was generated (Web
        #     keys only).
        # @!attribute [r] android_package_name
        #   @return [::String]
        #     Output only. The name of the Android package with which the token was
        #     generated (Android keys only).
        # @!attribute [r] ios_bundle_id
        #   @return [::String]
        #     Output only. The ID of the iOS bundle with which the token was generated
        #     (iOS keys only).
        # @!attribute [r] action
        #   @return [::String]
        #     Output only. Action name provided at token generation.
        class TokenProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum that represents the types of invalid token reasons.
          # Ensure that applications can handle values not explicitly listed.
          module InvalidReason
            # Default unspecified type.
            INVALID_REASON_UNSPECIFIED = 0

            # If the failure reason was not accounted for.
            UNKNOWN_INVALID_REASON = 1

            # The provided user verification token was malformed.
            MALFORMED = 2

            # The user verification token had expired.
            EXPIRED = 3

            # The user verification had already been seen.
            DUPE = 4

            # The user verification token was not present.
            MISSING = 5

            # A retriable error (such as network failure) occurred on the browser.
            # Could easily be simulated by an attacker.
            BROWSER_ERROR = 6

            # The action provided at token generation was different than
            # the `expected_action` in the assessment request. The comparison is
            # case-insensitive. This reason can only be returned if all of the
            # following are true:
            #
            #   - your `site_key` has the POLICY_BASED_CHALLENGE integration type
            #   - you set an action score threshold higher than 0.0
            #   - you provided a non-empty `expected_action`
            UNEXPECTED_ACTION = 7
          end
        end

        # Assessment for Fraud Prevention.
        # @!attribute [r] transaction_risk
        #   @return [::Float]
        #     Output only. Probability of this transaction being fraudulent. Summarizes
        #     the combined risk of attack vectors below. Values are from 0.0 (lowest)
        #     to 1.0 (highest).
        # @!attribute [r] risk_reasons
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::FraudPreventionAssessment::RiskReason>]
        #     Output only. Reasons why the transaction is probably fraudulent and
        #     received a high transaction risk score.
        # @!attribute [r] stolen_instrument_verdict
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FraudPreventionAssessment::StolenInstrumentVerdict]
        #     Output only. Assessment of this transaction for risk of a stolen
        #     instrument.
        # @!attribute [r] card_testing_verdict
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FraudPreventionAssessment::CardTestingVerdict]
        #     Output only. Assessment of this transaction for risk of being part of a
        #     card testing attack.
        # @!attribute [r] behavioral_trust_verdict
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FraudPreventionAssessment::BehavioralTrustVerdict]
        #     Output only. Assessment of this transaction for behavioral trust.
        class FraudPreventionAssessment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Risk reasons applicable to the Fraud Prevention assessment.
          # @!attribute [r] reason
          #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FraudPreventionAssessment::RiskReason::Reason]
          #     Output only. Risk reasons applicable to the Fraud Prevention assessment.
          class RiskReason
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Risk reasons applicable to the Fraud Prevention assessment. New risk
            # reasons will be added over time.
            module Reason
              # Default unspecified type.
              REASON_UNSPECIFIED = 0

              # A suspiciously high number of recent transactions have used identifiers
              # present in this transaction.
              HIGH_TRANSACTION_VELOCITY = 1

              # User is cycling through a suspiciously large number of identifiers,
              # suggesting enumeration or validation attacks within a potential fraud
              # network.
              EXCESSIVE_ENUMERATION_PATTERN = 2

              # User has a short history or no history in the reCAPTCHA network,
              # suggesting the possibility of synthetic identity generation.
              SHORT_IDENTITY_HISTORY = 3

              # Identifiers used in this transaction originate from an unusual or
              # conflicting set of geolocations.
              GEOLOCATION_DISCREPANCY = 4

              # This transaction is linked to a cluster of known fraudulent activity.
              ASSOCIATED_WITH_FRAUD_CLUSTER = 5
            end
          end

          # Information about stolen instrument fraud, where the user is not the
          # legitimate owner of the instrument being used for the purchase.
          # @!attribute [r] risk
          #   @return [::Float]
          #     Output only. Probability of this transaction being executed with a stolen
          #     instrument. Values are from 0.0 (lowest) to 1.0 (highest).
          class StolenInstrumentVerdict
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Information about card testing fraud, where an adversary is testing
          # fraudulently obtained cards or brute forcing their details.
          # @!attribute [r] risk
          #   @return [::Float]
          #     Output only. Probability of this transaction attempt being part of a card
          #     testing attack. Values are from 0.0 (lowest) to 1.0 (highest).
          class CardTestingVerdict
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Information about behavioral trust of the transaction.
          # @!attribute [r] trust
          #   @return [::Float]
          #     Output only. Probability of this transaction attempt being executed in a
          #     behaviorally trustworthy way. Values are from 0.0 (lowest) to 1.0
          #     (highest).
          class BehavioralTrustVerdict
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Fraud signals describing users and cards involved in the transaction.
        # @!attribute [r] user_signals
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FraudSignals::UserSignals]
        #     Output only. Signals describing the end user in this transaction.
        # @!attribute [r] card_signals
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FraudSignals::CardSignals]
        #     Output only. Signals describing the payment card or cards used in this
        #     transaction.
        class FraudSignals
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Signals describing the user involved in this transaction.
          # @!attribute [r] active_days_lower_bound
          #   @return [::Integer]
          #     Output only. This user (based on email, phone, and other identifiers) has
          #     been seen on the internet for at least this number of days.
          # @!attribute [r] synthetic_risk
          #   @return [::Float]
          #     Output only. Likelihood (from 0.0 to 1.0) this user includes synthetic
          #     components in their identity, such as a randomly generated email address,
          #     temporary phone number, or fake shipping address.
          class UserSignals
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Signals describing the payment card used in this transaction.
          # @!attribute [r] card_labels
          #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::FraudSignals::CardSignals::CardLabel>]
          #     Output only. The labels for the payment card in this transaction.
          class CardSignals
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Risk labels describing the card being assessed, such as its funding
            # mechanism.
            # Ensure that applications can handle values not explicitly listed.
            module CardLabel
              # No label specified.
              CARD_LABEL_UNSPECIFIED = 0

              # This card has been detected as prepaid.
              PREPAID = 1

              # This card has been detected as virtual, such as a card number generated
              # for a single transaction or merchant.
              VIRTUAL = 2

              # This card has been detected as being used in an unexpected geographic
              # location.
              UNEXPECTED_LOCATION = 3
            end
          end
        end

        # Information about SMS toll fraud.
        # @!attribute [r] risk
        #   @return [::Float]
        #     Output only. Probability of an SMS event being fraudulent.
        #     Values are from 0.0 (lowest) to 1.0 (highest).
        # @!attribute [r] reasons
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::SmsTollFraudVerdict::SmsTollFraudReason>]
        #     Output only. Reasons contributing to the SMS toll fraud verdict.
        class SmsTollFraudVerdict
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Reasons contributing to the SMS toll fraud verdict.
          # Ensure that applications can handle values not explicitly listed.
          module SmsTollFraudReason
            # Default unspecified reason
            SMS_TOLL_FRAUD_REASON_UNSPECIFIED = 0

            # The provided phone number was invalid
            INVALID_PHONE_NUMBER = 1
          end
        end

        # Assessment for Phone Fraud
        # @!attribute [r] sms_toll_fraud_verdict
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::SmsTollFraudVerdict]
        #     Output only. Assessment of this phone event for risk of SMS toll fraud.
        class PhoneFraudAssessment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Account defender risk assessment.
        # @!attribute [r] labels
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::AccountDefenderAssessment::AccountDefenderLabel>]
        #     Output only. Labels for this request.
        class AccountDefenderAssessment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Labels returned by account defender for this request.
          # Ensure that applications can handle values not explicitly listed.
          module AccountDefenderLabel
            # Default unspecified type.
            ACCOUNT_DEFENDER_LABEL_UNSPECIFIED = 0

            # The request matches a known good profile for the user.
            PROFILE_MATCH = 1

            # The request is potentially a suspicious login event and must be further
            # verified either through multi-factor authentication or another system.
            SUSPICIOUS_LOGIN_ACTIVITY = 2

            # The request matched a profile that previously had suspicious account
            # creation behavior. This can mean that this is a fake account.
            SUSPICIOUS_ACCOUNT_CREATION = 3

            # The account in the request has a high number of related accounts. It does
            # not necessarily imply that the account is bad but can require further
            # investigation.
            RELATED_ACCOUNTS_NUMBER_HIGH = 4
          end
        end

        # The create key request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project in which the key is created, in the
        #     format `projects/{project}`.
        # @!attribute [rw] key
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::Key]
        #     Required. Information to create a reCAPTCHA Enterprise key.
        class CreateKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The list keys request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project that contains the keys that is
        #     listed, in the format `projects/{project}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of keys to return. Default is 10. Max limit is
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The next_page_token value returned from a previous.
        #     ListKeysRequest, if any.
        class ListKeysRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response to request to list keys in a project.
        # @!attribute [rw] keys
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::Key>]
        #     Key details.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results. It is set to empty if no keys
        #     remain in results.
        class ListKeysResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The retrieve legacy secret key request message.
        # @!attribute [rw] key
        #   @return [::String]
        #     Required. The public key name linked to the requested secret key in the
        #     format `projects/{project}/keys/{key}`.
        class RetrieveLegacySecretKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The get key request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the requested key, in the format
        #     `projects/{project}/keys/{key}`.
        class GetKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The update key request message.
        # @!attribute [rw] key
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::Key]
        #     Required. The key to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The mask to control which fields of the key get updated. If the
        #     mask is not present, all fields are updated.
        class UpdateKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The delete key request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the key to be deleted, in the format
        #     `projects/{project}/keys/{key}`.
        class DeleteKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The create firewall policy request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project this policy applies to, in the format
        #     `projects/{project}`.
        # @!attribute [rw] firewall_policy
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FirewallPolicy]
        #     Required. Information to create the policy.
        class CreateFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The list firewall policies request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project to list the policies for, in the format
        #     `projects/{project}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of policies to return. Default is 10. Max
        #     limit is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The next_page_token value returned from a previous.
        #     ListFirewallPoliciesRequest, if any.
        class ListFirewallPoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response to request to list firewall policies belonging to a project.
        # @!attribute [rw] firewall_policies
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::FirewallPolicy>]
        #     Policy details.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results. It is set to empty if no
        #     policies remain in results.
        class ListFirewallPoliciesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The get firewall policy request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the requested policy, in the format
        #     `projects/{project}/firewallpolicies/{firewallpolicy}`.
        class GetFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The update firewall policy request message.
        # @!attribute [rw] firewall_policy
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FirewallPolicy]
        #     Required. The policy to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The mask to control which fields of the policy get updated. If
        #     the mask is not present, all fields are updated.
        class UpdateFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The delete firewall policy request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the policy to be deleted, in the format
        #     `projects/{project}/firewallpolicies/{firewallpolicy}`.
        class DeleteFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The reorder firewall policies request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project to list the policies for, in the format
        #     `projects/{project}`.
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. A list containing all policy names, in the new order. Each name
        #     is in the format `projects/{project}/firewallpolicies/{firewallpolicy}`.
        class ReorderFirewallPoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The reorder firewall policies response message.
        class ReorderFirewallPoliciesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The migrate key request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the key to be migrated, in the format
        #     `projects/{project}/keys/{key}`.
        # @!attribute [rw] skip_billing_check
        #   @return [::Boolean]
        #     Optional. If true, skips the billing check.
        #     A reCAPTCHA Enterprise key or migrated key behaves differently than a
        #     reCAPTCHA (non-Enterprise version) key when you reach a quota limit (see
        #     https://docs.cloud.google.com/recaptcha/quotas#quota_limit). To avoid
        #     any disruption of your usage, we check that a billing account is present.
        #     If your usage of reCAPTCHA is under the free quota, you can safely skip the
        #     billing check and proceed with the migration. See
        #     https://cloud.google.com/recaptcha/docs/billing-information.
        class MigrateKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The get metrics request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the requested metrics, in the format
        #     `projects/{project}/keys/{key}/metrics`.
        class GetMetricsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metrics for a single Key.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The name of the metrics, in the format
        #     `projects/{project}/keys/{key}/metrics`.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Inclusive start time aligned to a day in the America/Los_Angeles (Pacific)
        #     timezone.
        # @!attribute [rw] score_metrics
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::ScoreMetrics>]
        #     Metrics are continuous and in order by dates, and in the granularity
        #     of day. All Key types should have score-based data.
        # @!attribute [rw] challenge_metrics
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::ChallengeMetrics>]
        #     Metrics are continuous and in order by dates, and in the granularity
        #     of day. Only challenge-based keys (CHECKBOX, INVISIBLE) have
        #     challenge-based data.
        class Metrics
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Secret key is used only in legacy reCAPTCHA. It must be used in a 3rd party
        # integration with legacy reCAPTCHA.
        # @!attribute [rw] legacy_secret_key
        #   @return [::String]
        #     The secret key (also known as shared secret) authorizes communication
        #     between your application backend and the reCAPTCHA Enterprise server to
        #     create an assessment.
        #     The secret key needs to be kept safe for security purposes.
        class RetrieveLegacySecretKeyResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A key used to identify and configure applications (web and/or mobile) that
        # use reCAPTCHA Enterprise.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name for the Key in the format
        #     `projects/{project}/keys/{key}`.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Human-readable display name of this key. Modifiable by user.
        # @!attribute [rw] web_settings
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::WebKeySettings]
        #     Settings for keys that can be used by websites.
        #
        #     Note: The following fields are mutually exclusive: `web_settings`, `android_settings`, `ios_settings`, `express_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] android_settings
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::AndroidKeySettings]
        #     Settings for keys that can be used by Android apps.
        #
        #     Note: The following fields are mutually exclusive: `android_settings`, `web_settings`, `ios_settings`, `express_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] ios_settings
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::IOSKeySettings]
        #     Settings for keys that can be used by iOS apps.
        #
        #     Note: The following fields are mutually exclusive: `ios_settings`, `web_settings`, `android_settings`, `express_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] express_settings
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::ExpressKeySettings]
        #     Settings for keys that can be used by reCAPTCHA Express.
        #
        #     Note: The following fields are mutually exclusive: `express_settings`, `web_settings`, `android_settings`, `ios_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. See [Creating and managing labels]
        #     (https://cloud.google.com/recaptcha/docs/labels).
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp corresponding to the creation of this key.
        # @!attribute [rw] testing_options
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::TestingOptions]
        #     Optional. Options for user acceptance testing.
        # @!attribute [rw] waf_settings
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::WafSettings]
        #     Optional. Settings for Web Application Firewall (WAF).
        class Key
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Options for user acceptance testing.
        # @!attribute [rw] testing_score
        #   @return [::Float]
        #     Optional. All assessments for this Key return this score. Must be between 0
        #     (likely not legitimate) and 1 (likely legitimate) inclusive.
        # @!attribute [rw] testing_challenge
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::TestingOptions::TestingChallenge]
        #     Optional. For challenge-based keys only (CHECKBOX, INVISIBLE), all
        #     challenge requests for this site return nocaptcha if NOCAPTCHA, or an
        #     unsolvable challenge if CHALLENGE.
        class TestingOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum that represents the challenge option for challenge-based (for example,
          # CHECKBOX and INVISIBLE) testing keys.
          # Ensure that applications can handle values not explicitly listed.
          module TestingChallenge
            # Perform the normal risk analysis and return either nocaptcha or a
            # challenge depending on risk and trust factors.
            TESTING_CHALLENGE_UNSPECIFIED = 0

            # Challenge requests for this key always return a nocaptcha, which
            # does not require a solution.
            NOCAPTCHA = 1

            # Challenge requests for this key always return an unsolvable
            # challenge.
            UNSOLVABLE_CHALLENGE = 2
          end
        end

        # Settings specific to keys that can be used by websites.
        # @!attribute [rw] allow_all_domains
        #   @return [::Boolean]
        #     Optional. If set to true, it means allowed_domains are not enforced.
        # @!attribute [rw] allowed_domains
        #   @return [::Array<::String>]
        #     Optional. Domains or subdomains of websites allowed to use the key. All
        #     subdomains of an allowed domain are automatically allowed. A valid domain
        #     requires a host and must not include any path, port, query or fragment.
        #     Examples: 'example.com' or 'subdomain.example.com'
        #     Each key supports a maximum of 250 domains. To use a key on more domains,
        #     set `allow_all_domains` to true. When this is set, you are responsible for
        #     validating the hostname by checking the `token_properties.hostname` field
        #     in each assessment response against your list of allowed domains.
        # @!attribute [rw] allow_amp_traffic
        #   @return [::Boolean]
        #     Optional. If set to true, the key can be used on AMP (Accelerated Mobile
        #     Pages) websites. This is supported only for the SCORE integration type.
        # @!attribute [rw] integration_type
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::WebKeySettings::IntegrationType]
        #     Required. Describes how this key is integrated with the website.
        # @!attribute [rw] challenge_security_preference
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::WebKeySettings::ChallengeSecurityPreference]
        #     Optional. Settings for the frequency and difficulty at which this key
        #     triggers captcha challenges. This should only be specified for
        #     `IntegrationType` CHECKBOX, INVISIBLE or POLICY_BASED_CHALLENGE.
        # @!attribute [rw] challenge_settings
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::WebKeySettings::ChallengeSettings]
        #     Optional. Challenge settings.
        class WebKeySettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Per-action challenge settings.
          # @!attribute [rw] score_threshold
          #   @return [::Float]
          #     Required. A challenge is triggered if the end-user score is below that
          #     threshold. Value must be between 0 and 1 (inclusive).
          class ActionSettings
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Settings for POLICY_BASED_CHALLENGE keys to control when a challenge is
          # triggered.
          # @!attribute [rw] default_settings
          #   @return [::Google::Cloud::RecaptchaEnterprise::V1::WebKeySettings::ActionSettings]
          #     Required. Defines when a challenge is triggered (unless the default
          #     threshold is overridden for the given action, see `action_settings`).
          # @!attribute [rw] action_settings
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::RecaptchaEnterprise::V1::WebKeySettings::ActionSettings}]
          #     Optional. The action to score threshold map.
          #     The action name should be the same as the action name passed in the
          #     `data-action` attribute
          #     (see https://cloud.google.com/recaptcha/docs/actions-website).
          #     Action names are case-insensitive.
          #     There is a maximum of 100 action settings.
          #     An action name has a maximum length of 100.
          class ChallengeSettings
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::RecaptchaEnterprise::V1::WebKeySettings::ActionSettings]
            class ActionSettingsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Enum that represents the integration types for web keys.
          # Ensure that applications can handle values not explicitly listed.
          module IntegrationType
            # Default type that indicates this enum hasn't been specified. This is not
            # a valid IntegrationType, one of the other types must be specified
            # instead.
            INTEGRATION_TYPE_UNSPECIFIED = 0

            # Only used to produce scores. It doesn't display the "I'm not a robot"
            # checkbox and never shows captcha challenges.
            SCORE = 1

            # Displays the "I'm not a robot" checkbox and may show captcha challenges
            # after it is checked.
            CHECKBOX = 2

            # Doesn't display the "I'm not a robot" checkbox, but may show captcha
            # challenges after risk analysis.
            INVISIBLE = 3

            # Displays a visual challenge or not depending on the user risk analysis
            # score.
            POLICY_BASED_CHALLENGE = 5
          end

          # Enum that represents the possible challenge frequency and difficulty
          # configurations for a web key.
          # Ensure that applications can handle values not explicitly listed.
          module ChallengeSecurityPreference
            # Default type that indicates this enum hasn't been specified.
            CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED = 0

            # Key tends to show fewer and easier challenges.
            USABILITY = 1

            # Key tends to show balanced (in amount and difficulty) challenges.
            BALANCE = 2

            # Key tends to show more and harder challenges.
            SECURITY = 3
          end
        end

        # Settings specific to keys that can be used by Android apps.
        # @!attribute [rw] allow_all_package_names
        #   @return [::Boolean]
        #     Optional. If set to true, allowed_package_names are not enforced.
        # @!attribute [rw] allowed_package_names
        #   @return [::Array<::String>]
        #     Optional. Android package names of apps allowed to use the key.
        #     Example: 'com.companyname.appname'
        #     Each key supports a maximum of 250 package names. To use a key on more
        #     apps, set `allow_all_package_names` to true. When this is set, you
        #     are responsible for validating the package name by checking the
        #     `token_properties.android_package_name` field in each assessment response
        #     against your list of allowed package names.
        # @!attribute [rw] support_non_google_app_store_distribution
        #   @return [::Boolean]
        #     Optional. Set to true for keys that are used in an Android application that
        #     is available for download in app stores in addition to the Google Play
        #     Store.
        class AndroidKeySettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings specific to keys that can be used by iOS apps.
        # @!attribute [rw] allow_all_bundle_ids
        #   @return [::Boolean]
        #     Optional. If set to true, allowed_bundle_ids are not enforced.
        # @!attribute [rw] allowed_bundle_ids
        #   @return [::Array<::String>]
        #     Optional. iOS bundle IDs of apps allowed to use the key.
        #     Example: 'com.companyname.productname.appname'
        #     Each key supports a maximum of 250 bundle IDs. To use a key on more
        #     apps, set `allow_all_bundle_ids` to true. When this is set, you
        #     are responsible for validating the bundle id by checking the
        #     `token_properties.ios_bundle_id` field in each assessment response
        #     against your list of allowed bundle IDs.
        # @!attribute [rw] apple_developer_id
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::AppleDeveloperId]
        #     Optional. Apple Developer account details for the app that is protected by
        #     the reCAPTCHA Key. reCAPTCHA leverages platform-specific checks like Apple
        #     App Attest and Apple DeviceCheck to protect your app from abuse. Providing
        #     these fields allows reCAPTCHA to get a better assessment of the integrity
        #     of your app.
        class IOSKeySettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings specific to keys that can be used for reCAPTCHA Express.
        class ExpressKeySettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains fields that are required to perform Apple-specific integrity checks.
        # @!attribute [rw] private_key
        #   @return [::String]
        #     Required. Input only. A private key (downloaded as a text file with a .p8
        #     file extension) generated for your Apple Developer account. Ensure that
        #     Apple DeviceCheck is enabled for the private key.
        # @!attribute [rw] key_id
        #   @return [::String]
        #     Required. The Apple developer key ID (10-character string).
        # @!attribute [rw] team_id
        #   @return [::String]
        #     Required. The Apple team ID (10-character string) owning the provisioning
        #     profile used to build your application.
        class AppleDeveloperId
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Score distribution.
        # @!attribute [rw] score_buckets
        #   @return [::Google::Protobuf::Map{::Integer => ::Integer}]
        #     Map key is score value multiplied by 100. The scores are discrete values
        #     between [0, 1]. The maximum number of buckets is on order of a few dozen,
        #     but typically much lower (ie. 10).
        class ScoreDistribution
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::Integer]
          # @!attribute [rw] value
          #   @return [::Integer]
          class ScoreBucketsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Metrics related to scoring.
        # @!attribute [rw] overall_metrics
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::ScoreDistribution]
        #     Aggregated score metrics for all traffic.
        # @!attribute [rw] action_metrics
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::RecaptchaEnterprise::V1::ScoreDistribution}]
        #     Action-based metrics. The map key is the action name which specified by the
        #     site owners at time of the "execute" client-side call.
        class ScoreMetrics
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::RecaptchaEnterprise::V1::ScoreDistribution]
          class ActionMetricsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Metrics related to challenges.
        # @!attribute [rw] pageload_count
        #   @return [::Integer]
        #     Count of reCAPTCHA checkboxes or badges rendered. This is mostly equivalent
        #     to a count of pageloads for pages that include reCAPTCHA.
        # @!attribute [rw] nocaptcha_count
        #   @return [::Integer]
        #     Count of nocaptchas (successful verification without a challenge) issued.
        # @!attribute [rw] failed_count
        #   @return [::Integer]
        #     Count of submitted challenge solutions that were incorrect or otherwise
        #     deemed suspicious such that a subsequent challenge was triggered.
        # @!attribute [rw] passed_count
        #   @return [::Integer]
        #     Count of nocaptchas (successful verification without a challenge) plus
        #     submitted challenge solutions that were correct and resulted in
        #     verification.
        class ChallengeMetrics
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Policy config assessment.
        # @!attribute [r] error
        #   @return [::Google::Rpc::Status]
        #     Output only. If the processing of a policy config fails, an error is
        #     populated and the firewall_policy is left empty.
        # @!attribute [r] firewall_policy
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FirewallPolicy]
        #     Output only. The policy that matched the request. If more than one policy
        #     may match, this is the first match. If no policy matches the incoming
        #     request, the policy field is left empty.
        class FirewallPolicyAssessment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An individual action. Each action represents what to do if a policy
        # matches.
        # @!attribute [rw] allow
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FirewallAction::AllowAction]
        #     The user request did not match any policy and should be allowed
        #     access to the requested resource.
        #
        #     Note: The following fields are mutually exclusive: `allow`, `block`, `include_recaptcha_script`, `redirect`, `substitute`, `set_header`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] block
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FirewallAction::BlockAction]
        #     This action denies access to a given page. The user gets an HTTP
        #     error code.
        #
        #     Note: The following fields are mutually exclusive: `block`, `allow`, `include_recaptcha_script`, `redirect`, `substitute`, `set_header`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] include_recaptcha_script
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FirewallAction::IncludeRecaptchaScriptAction]
        #     This action injects reCAPTCHA JavaScript code into the HTML page
        #     returned by the site backend.
        #
        #     Note: The following fields are mutually exclusive: `include_recaptcha_script`, `allow`, `block`, `redirect`, `substitute`, `set_header`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] redirect
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FirewallAction::RedirectAction]
        #     This action redirects the request to a reCAPTCHA interstitial to
        #     attach a token.
        #
        #     Note: The following fields are mutually exclusive: `redirect`, `allow`, `block`, `include_recaptcha_script`, `substitute`, `set_header`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] substitute
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FirewallAction::SubstituteAction]
        #     This action transparently serves a different page to an offending
        #     user.
        #
        #     Note: The following fields are mutually exclusive: `substitute`, `allow`, `block`, `include_recaptcha_script`, `redirect`, `set_header`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] set_header
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::FirewallAction::SetHeaderAction]
        #     This action sets a custom header but allow the request to continue
        #     to the customer backend.
        #
        #     Note: The following fields are mutually exclusive: `set_header`, `allow`, `block`, `include_recaptcha_script`, `redirect`, `substitute`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class FirewallAction
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An allow action continues processing a request unimpeded.
          class AllowAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A block action serves an HTTP error code a prevents the request from
          # hitting the backend.
          class BlockAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An include reCAPTCHA script action involves injecting reCAPTCHA JavaScript
          # code into the HTML returned by the site backend. This reCAPTCHA
          # script is tasked with collecting user signals on the requested web page,
          # issuing tokens as a cookie within the site domain, and enabling their
          # utilization in subsequent page requests.
          class IncludeRecaptchaScriptAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A redirect action returns a 307 (temporary redirect) response, pointing
          # the user to a reCAPTCHA interstitial page to attach a token.
          class RedirectAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A substitute action transparently serves a different page than the one
          # requested.
          # @!attribute [rw] path
          #   @return [::String]
          #     Optional. The address to redirect to. The target is a relative path in
          #     the current host. Example: "/blog/404.html".
          class SubstituteAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A set header action sets a header and forwards the request to the
          # backend. This can be used to trigger custom protection implemented on the
          # backend.
          # @!attribute [rw] key
          #   @return [::String]
          #     Optional. The header key to set in the request to the backend server.
          # @!attribute [rw] value
          #   @return [::String]
          #     Optional. The header value to set in the request to the backend server.
          class SetHeaderAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A FirewallPolicy represents a single matching pattern and resulting actions
        # to take.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name for the FirewallPolicy in the format
        #     `projects/{project}/firewallpolicies/{firewallpolicy}`.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A description of what this policy aims to achieve, for
        #     convenience purposes. The description can at most include 256 UTF-8
        #     characters.
        # @!attribute [rw] path
        #   @return [::String]
        #     Optional. The path for which this policy applies, specified as a glob
        #     pattern. For more information on glob, see the [manual
        #     page](https://man7.org/linux/man-pages/man7/glob.7.html).
        #     A path has a max length of 200 characters.
        # @!attribute [rw] condition
        #   @return [::String]
        #     Optional. A CEL (Common Expression Language) conditional expression that
        #     specifies if this policy applies to an incoming user request. If this
        #     condition evaluates to true and the requested path matched the path
        #     pattern, the associated actions should be executed by the caller. The
        #     condition string is checked for CEL syntax correctness on creation. For
        #     more information, see the [CEL spec](https://github.com/google/cel-spec)
        #     and its [language
        #     definition](https://github.com/google/cel-spec/blob/master/doc/langdef.md).
        #     A condition has a max length of 500 characters.
        # @!attribute [rw] actions
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::FirewallAction>]
        #     Optional. The actions that the caller should take regarding user access.
        #     There should be at most one terminal action. A terminal action is any
        #     action that forces a response, such as `AllowAction`,
        #     `BlockAction` or `SubstituteAction`.
        #     Zero or more non-terminal actions such as `SetHeader` might be
        #     specified. A single policy can contain up to 16 actions.
        class FirewallPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message to list memberships in a related account group.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name for the related account group in the format
        #     `projects/{project}/relatedaccountgroups/{relatedaccountgroup}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of accounts to return. The service might
        #     return fewer than this value. If unspecified, at most 50 accounts are
        #     returned. The maximum value is 1000; values above 1000 are coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     `ListRelatedAccountGroupMemberships` call.
        #
        #     When paginating, all other parameters provided to
        #     `ListRelatedAccountGroupMemberships` must match the call that provided the
        #     page token.
        class ListRelatedAccountGroupMembershipsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response to a `ListRelatedAccountGroupMemberships` call.
        # @!attribute [rw] related_account_group_memberships
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::RelatedAccountGroupMembership>]
        #     The memberships listed by the query.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListRelatedAccountGroupMembershipsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message to list related account groups.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project to list related account groups from, in
        #     the format `projects/{project}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of groups to return. The service might return
        #     fewer than this value. If unspecified, at most 50 groups are returned. The
        #     maximum value is 1000; values above 1000 are coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListRelatedAccountGroups`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListRelatedAccountGroups` must match the call that provided the page
        #     token.
        class ListRelatedAccountGroupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response to a `ListRelatedAccountGroups` call.
        # @!attribute [rw] related_account_groups
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::RelatedAccountGroup>]
        #     The groups of related accounts listed by the query.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListRelatedAccountGroupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message to search related account group memberships.
        # @!attribute [rw] project
        #   @return [::String]
        #     Required. The name of the project to search related account group
        #     memberships from. Specify the project name in the following format:
        #     `projects/{project}`.
        # @!attribute [rw] account_id
        #   @return [::String]
        #     Optional. The unique stable account identifier used to search connections.
        #     The identifier should correspond to an `account_id` provided in a previous
        #     `CreateAssessment` or `AnnotateAssessment` call. Either hashed_account_id
        #     or account_id must be set, but not both.
        # @!attribute [rw] hashed_account_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Optional. Deprecated: use `account_id` instead.
        #     The unique stable hashed account identifier used to search connections. The
        #     identifier should correspond to a `hashed_account_id` provided in a
        #     previous `CreateAssessment` or `AnnotateAssessment` call. Either
        #     hashed_account_id or account_id must be set, but not both.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of groups to return. The service might return
        #     fewer than this value. If unspecified, at most 50 groups are returned. The
        #     maximum value is 1000; values above 1000 are coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     `SearchRelatedAccountGroupMemberships` call. Provide this to retrieve the
        #     subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `SearchRelatedAccountGroupMemberships` must match the call that provided
        #     the page token.
        class SearchRelatedAccountGroupMembershipsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response to a `SearchRelatedAccountGroupMemberships` call.
        # @!attribute [rw] related_account_group_memberships
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::RelatedAccountGroupMembership>]
        #     The queried memberships.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class SearchRelatedAccountGroupMembershipsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The AddIpOverride request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the key to which the IP override is added, in the
        #     format `projects/{project}/keys/{key}`.
        # @!attribute [rw] ip_override_data
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::IpOverrideData]
        #     Required. IP override added to the key.
        class AddIpOverrideRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for AddIpOverride.
        class AddIpOverrideResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The RemoveIpOverride request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the key from which the IP override is removed, in the
        #     format `projects/{project}/keys/{key}`.
        # @!attribute [rw] ip_override_data
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::IpOverrideData]
        #     Required. IP override to be removed from the key.
        class RemoveIpOverrideRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for RemoveIpOverride.
        class RemoveIpOverrideResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The ListIpOverrides request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent key for which the IP overrides are listed, in the
        #     format `projects/{project}/keys/{key}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of overrides to return. Default is 10. Max
        #     limit is 100. If the number of overrides is less than the page_size, all
        #     overrides are returned. If the page size is more than 100, it is coerced to
        #     100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The next_page_token value returned from a previous
        #     ListIpOverridesRequest, if any.
        class ListIpOverridesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListIpOverrides.
        # @!attribute [rw] ip_overrides
        #   @return [::Array<::Google::Cloud::RecaptchaEnterprise::V1::IpOverrideData>]
        #     IP Overrides details.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results. If this field is empty, no keys
        #     remain in the results.
        class ListIpOverridesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A membership in a group of related accounts.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Identifier. The resource name for this membership in the format
        #     `projects/{project}/relatedaccountgroups/{relatedaccountgroup}/memberships/{membership}`.
        # @!attribute [rw] account_id
        #   @return [::String]
        #     The unique stable account identifier of the member. The identifier
        #     corresponds to an `account_id` provided in a previous `CreateAssessment` or
        #     `AnnotateAssessment` call.
        # @!attribute [rw] hashed_account_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated: use `account_id` instead.
        #     The unique stable hashed account identifier of the member. The identifier
        #     corresponds to a `hashed_account_id` provided in a previous
        #     `CreateAssessment` or `AnnotateAssessment` call.
        class RelatedAccountGroupMembership
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A group of related accounts.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Identifier. The resource name for the related account group in
        #     the format
        #     `projects/{project}/relatedaccountgroups/{related_account_group}`.
        class RelatedAccountGroup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings specific to keys that can be used for WAF (Web Application
        # Firewall).
        # @!attribute [rw] waf_service
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::WafSettings::WafService]
        #     Required. The Web Application Firewall (WAF) service that uses this key.
        # @!attribute [rw] waf_feature
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::WafSettings::WafFeature]
        #     Required. The Web Application Firewall (WAF) feature for which this key is
        #     enabled.
        class WafSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Supported WAF features. For more information, see
          # https://cloud.google.com/recaptcha/docs/usecase#comparison_of_features.
          # Ensure that applications can handle values not explicitly listed.
          module WafFeature
            # Undefined feature.
            WAF_FEATURE_UNSPECIFIED = 0

            # Redirects suspicious traffic to reCAPTCHA.
            CHALLENGE_PAGE = 1

            # Use reCAPTCHA session-tokens to protect the whole user session on the
            # site's domain.
            SESSION_TOKEN = 2

            # Use reCAPTCHA action-tokens to protect user actions.
            ACTION_TOKEN = 3

            # Deprecated: Use `express_settings` instead.
            EXPRESS = 5
          end

          # Web Application Firewalls that reCAPTCHA supports.
          # Ensure that applications can handle values not explicitly listed.
          module WafService
            # Undefined WAF
            WAF_SERVICE_UNSPECIFIED = 0

            # Cloud Armor
            CA = 1

            # Fastly
            FASTLY = 3

            # Cloudflare
            CLOUDFLARE = 4

            # Akamai
            AKAMAI = 5
          end
        end

        # The environment creating the assessment. This describes your environment
        # (the system invoking CreateAssessment), NOT the environment of your user.
        # @!attribute [rw] client
        #   @return [::String]
        #     Optional. Identifies the client module initiating the CreateAssessment
        #     request. This can be the link to the client module's project. Examples
        #     include:
        #
        #       -
        #       "github.com/GoogleCloudPlatform/recaptcha-enterprise-google-tag-manager"
        #       - "wordpress.org/plugins/recaptcha-something"
        # @!attribute [rw] version
        #   @return [::String]
        #     Optional. The version of the client module. For example, "1.0.0".
        class AssessmentEnvironment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about the IP or IP range override.
        # @!attribute [rw] ip
        #   @return [::String]
        #     Required. The IP address to override (can be IPv4, IPv6 or CIDR).
        #     The IP override must be a valid IPv4 or IPv6 address, or a CIDR range.
        #     The IP override must be a public IP address.
        #     Example of IPv4: 168.192.5.6
        #     Example of IPv6: 2001:0000:130F:0000:0000:09C0:876A:130B
        #     Example of IPv4 with CIDR: 168.192.5.0/24
        #     Example of IPv6 with CIDR: 2001:0DB8:1234::/48
        # @!attribute [rw] override_type
        #   @return [::Google::Cloud::RecaptchaEnterprise::V1::IpOverrideData::OverrideType]
        #     Required. Describes the type of IP override.
        class IpOverrideData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum that represents the type of IP override.
          # Ensure that applications can handle values not explicitly listed.
          module OverrideType
            # Default override type that indicates this enum hasn't been specified.
            OVERRIDE_TYPE_UNSPECIFIED = 0

            # Allowlist the IP address; i.e. give a `risk_analysis.score` of 0.9 for
            # all valid assessments.
            ALLOW = 1
          end
        end
      end
    end
  end
end
