# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment_pb"
require "google/cloud/rapid_migration_assessment/v1/rapid_migration_assessment/rest"


class ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_collector
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    collector_id = "hello world"
    collector = {}
    request_id = "hello world"

    create_collector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::ServiceStub.stub :transcode_create_collector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_collector_client_stub do
        # Create client
        client = ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_collector({ parent: parent, collector_id: collector_id, collector: collector, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_collector parent: parent, collector_id: collector_id, collector: collector, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_collector ::Google::Cloud::RapidMigrationAssessment::V1::CreateCollectorRequest.new(parent: parent, collector_id: collector_id, collector: collector, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_collector({ parent: parent, collector_id: collector_id, collector: collector, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_collector(::Google::Cloud::RapidMigrationAssessment::V1::CreateCollectorRequest.new(parent: parent, collector_id: collector_id, collector: collector, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_collector_client_stub.call_count
      end
    end
  end

  def test_create_annotation
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    annotation = {}
    request_id = "hello world"

    create_annotation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::ServiceStub.stub :transcode_create_annotation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_annotation_client_stub do
        # Create client
        client = ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_annotation({ parent: parent, annotation: annotation, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_annotation parent: parent, annotation: annotation, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_annotation ::Google::Cloud::RapidMigrationAssessment::V1::CreateAnnotationRequest.new(parent: parent, annotation: annotation, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_annotation({ parent: parent, annotation: annotation, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_annotation(::Google::Cloud::RapidMigrationAssessment::V1::CreateAnnotationRequest.new(parent: parent, annotation: annotation, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_annotation_client_stub.call_count
      end
    end
  end

  def test_get_annotation
    # Create test objects.
    client_result = ::Google::Cloud::RapidMigrationAssessment::V1::Annotation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_annotation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::ServiceStub.stub :transcode_get_annotation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_annotation_client_stub do
        # Create client
        client = ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_annotation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_annotation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_annotation ::Google::Cloud::RapidMigrationAssessment::V1::GetAnnotationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_annotation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_annotation(::Google::Cloud::RapidMigrationAssessment::V1::GetAnnotationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_annotation_client_stub.call_count
      end
    end
  end

  def test_list_collectors
    # Create test objects.
    client_result = ::Google::Cloud::RapidMigrationAssessment::V1::ListCollectorsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_collectors_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::ServiceStub.stub :transcode_list_collectors_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_collectors_client_stub do
        # Create client
        client = ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_collectors({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_collectors parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_collectors ::Google::Cloud::RapidMigrationAssessment::V1::ListCollectorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_collectors({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_collectors(::Google::Cloud::RapidMigrationAssessment::V1::ListCollectorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_collectors_client_stub.call_count
      end
    end
  end

  def test_get_collector
    # Create test objects.
    client_result = ::Google::Cloud::RapidMigrationAssessment::V1::Collector.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_collector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::ServiceStub.stub :transcode_get_collector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_collector_client_stub do
        # Create client
        client = ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_collector({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_collector name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_collector ::Google::Cloud::RapidMigrationAssessment::V1::GetCollectorRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_collector({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_collector(::Google::Cloud::RapidMigrationAssessment::V1::GetCollectorRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_collector_client_stub.call_count
      end
    end
  end

  def test_update_collector
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    collector = {}
    request_id = "hello world"

    update_collector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::ServiceStub.stub :transcode_update_collector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_collector_client_stub do
        # Create client
        client = ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_collector({ update_mask: update_mask, collector: collector, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_collector update_mask: update_mask, collector: collector, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_collector ::Google::Cloud::RapidMigrationAssessment::V1::UpdateCollectorRequest.new(update_mask: update_mask, collector: collector, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_collector({ update_mask: update_mask, collector: collector, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_collector(::Google::Cloud::RapidMigrationAssessment::V1::UpdateCollectorRequest.new(update_mask: update_mask, collector: collector, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_collector_client_stub.call_count
      end
    end
  end

  def test_delete_collector
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_collector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::ServiceStub.stub :transcode_delete_collector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_collector_client_stub do
        # Create client
        client = ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_collector({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_collector name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_collector ::Google::Cloud::RapidMigrationAssessment::V1::DeleteCollectorRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_collector({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_collector(::Google::Cloud::RapidMigrationAssessment::V1::DeleteCollectorRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_collector_client_stub.call_count
      end
    end
  end

  def test_resume_collector
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    resume_collector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::ServiceStub.stub :transcode_resume_collector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, resume_collector_client_stub do
        # Create client
        client = ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.resume_collector({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.resume_collector name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.resume_collector ::Google::Cloud::RapidMigrationAssessment::V1::ResumeCollectorRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.resume_collector({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.resume_collector(::Google::Cloud::RapidMigrationAssessment::V1::ResumeCollectorRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, resume_collector_client_stub.call_count
      end
    end
  end

  def test_register_collector
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    register_collector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::ServiceStub.stub :transcode_register_collector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, register_collector_client_stub do
        # Create client
        client = ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.register_collector({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.register_collector name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.register_collector ::Google::Cloud::RapidMigrationAssessment::V1::RegisterCollectorRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.register_collector({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.register_collector(::Google::Cloud::RapidMigrationAssessment::V1::RegisterCollectorRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, register_collector_client_stub.call_count
      end
    end
  end

  def test_pause_collector
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    pause_collector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::ServiceStub.stub :transcode_pause_collector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, pause_collector_client_stub do
        # Create client
        client = ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.pause_collector({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.pause_collector name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.pause_collector ::Google::Cloud::RapidMigrationAssessment::V1::PauseCollectorRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.pause_collector({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.pause_collector(::Google::Cloud::RapidMigrationAssessment::V1::PauseCollectorRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, pause_collector_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client::Configuration, config
  end
end
