# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module RapidMigrationAssessment
      module V1
        # Message describing a MC Source of type Guest OS Scan.
        # @!attribute [rw] core_source
        #   @return [::String]
        #     reference to the corresponding Guest OS Scan in MC Source.
        class GuestOsScan
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing a MC Source of type VSphere Scan.
        # @!attribute [rw] core_source
        #   @return [::String]
        #     reference to the corresponding VSphere Scan in MC Source.
        class VSphereScan
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing Collector object.
        # @!attribute [rw] name
        #   @return [::String]
        #     name of resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time stamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update time stamp.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User specified name of the Collector.
        # @!attribute [rw] description
        #   @return [::String]
        #     User specified description of the Collector.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Service Account email used to ingest data to this Collector.
        # @!attribute [r] bucket
        #   @return [::String]
        #     Output only. Store cloud storage bucket name (which is a guid) created with
        #     this Collector.
        # @!attribute [rw] expected_asset_count
        #   @return [::Integer]
        #     User specified expected asset count.
        # @!attribute [r] state
        #   @return [::Google::Cloud::RapidMigrationAssessment::V1::Collector::State]
        #     Output only. State of the Collector.
        # @!attribute [r] client_version
        #   @return [::String]
        #     Output only. Client version.
        # @!attribute [r] guest_os_scan
        #   @return [::Google::Cloud::RapidMigrationAssessment::V1::GuestOsScan]
        #     Output only. Reference to MC Source Guest Os Scan.
        # @!attribute [r] vsphere_scan
        #   @return [::Google::Cloud::RapidMigrationAssessment::V1::VSphereScan]
        #     Output only. Reference to MC Source vsphere_scan.
        # @!attribute [rw] collection_days
        #   @return [::Integer]
        #     How many days to collect data.
        # @!attribute [rw] eula_uri
        #   @return [::String]
        #     Uri for EULA (End User License Agreement) from customer.
        class Collector
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # -- Using suggestion from API Linter Analyzer for nesting enum --
          # -- https://linter.aip.dev/216/nesting --
          # State of a Collector (server_side).
          # States are used for internal purposes and named to keep
          # convention of legacy product:
          # https://cloud.google.com/migrate/stratozone/docs/about-stratoprobe.
          module State
            # Collector state is not recognized.
            STATE_UNSPECIFIED = 0

            # Collector started to create, but hasn't been completed MC source creation
            # and db object creation.
            STATE_INITIALIZING = 1

            # Collector has been created, MC source creation and db object creation
            # completed.
            STATE_READY_TO_USE = 2

            # Collector client has been registered with client.
            STATE_REGISTERED = 3

            # Collector client is actively scanning.
            STATE_ACTIVE = 4

            # Collector is not actively scanning.
            STATE_PAUSED = 5

            # Collector is starting background job for deletion.
            STATE_DELETING = 6

            # Collector completed all tasks for deletion.
            STATE_DECOMMISSIONED = 7

            # Collector is in error state.
            STATE_ERROR = 8
          end
        end

        # Message describing an Annotation
        # @!attribute [rw] name
        #   @return [::String]
        #     name of resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time stamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update time stamp.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::RapidMigrationAssessment::V1::Annotation::Type]
        #     Type of an annotation.
        class Annotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Types for project level setting.
          module Type
            # Unknown type
            TYPE_UNSPECIFIED = 0

            # Indicates that this project has opted into StratoZone export.
            TYPE_LEGACY_EXPORT_CONSENT = 1

            # Indicates that this project is created by Qwiklab.
            TYPE_QWIKLAB = 2
          end
        end
      end
    end
  end
end
