# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment_pb"
require "google/cloud/rapid_migration_assessment/v1/rapid_migration_assessment/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module RapidMigrationAssessment
      module V1
        module RapidMigrationAssessment
          module Rest
            ##
            # REST client for the RapidMigrationAssessment service.
            #
            # Service describing handlers for resources.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "rapidmigrationassessment.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :rapid_migration_assessment_stub

              ##
              # Configure the RapidMigrationAssessment Client class.
              #
              # See {::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all RapidMigrationAssessment clients
              #   ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "RapidMigrationAssessment", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_collector.timeout = 60.0

                  default_config.rpcs.create_annotation.timeout = 60.0

                  default_config.rpcs.get_annotation.timeout = 60.0
                  default_config.rpcs.get_annotation.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_collectors.timeout = 60.0
                  default_config.rpcs.list_collectors.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_collector.timeout = 60.0
                  default_config.rpcs.get_collector.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.update_collector.timeout = 60.0

                  default_config.rpcs.delete_collector.timeout = 60.0

                  default_config.rpcs.resume_collector.timeout = 60.0

                  default_config.rpcs.register_collector.timeout = 60.0

                  default_config.rpcs.pause_collector.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the RapidMigrationAssessment Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @rapid_migration_assessment_stub.universe_domain
              end

              ##
              # Create a new RapidMigrationAssessment REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the RapidMigrationAssessment client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @rapid_migration_assessment_stub = ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @rapid_migration_assessment_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @rapid_migration_assessment_stub.endpoint
                  config.universe_domain = @rapid_migration_assessment_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @rapid_migration_assessment_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @rapid_migration_assessment_stub.logger
              end

              # Service calls

              ##
              # Create a Collector to manage the on-prem appliance which collects
              # information about Customer assets.
              #
              # @overload create_collector(request, options = nil)
              #   Pass arguments to `create_collector` via a request object, either of type
              #   {::Google::Cloud::RapidMigrationAssessment::V1::CreateCollectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::RapidMigrationAssessment::V1::CreateCollectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_collector(parent: nil, collector_id: nil, collector: nil, request_id: nil)
              #   Pass arguments to `create_collector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of the parent (project+location).
              #   @param collector_id [::String]
              #     Required. Id of the requesting object.
              #   @param collector [::Google::Cloud::RapidMigrationAssessment::V1::Collector, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/rapid_migration_assessment/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::RapidMigrationAssessment::V1::CreateCollectorRequest.new
              #
              #   # Call the create_collector method.
              #   result = client.create_collector request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_collector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RapidMigrationAssessment::V1::CreateCollectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_collector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::RapidMigrationAssessment::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_collector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_collector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @rapid_migration_assessment_stub.create_collector request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an Annotation
              #
              # @overload create_annotation(request, options = nil)
              #   Pass arguments to `create_annotation` via a request object, either of type
              #   {::Google::Cloud::RapidMigrationAssessment::V1::CreateAnnotationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::RapidMigrationAssessment::V1::CreateAnnotationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_annotation(parent: nil, annotation: nil, request_id: nil)
              #   Pass arguments to `create_annotation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of the parent (project+location).
              #   @param annotation [::Google::Cloud::RapidMigrationAssessment::V1::Annotation, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/rapid_migration_assessment/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::RapidMigrationAssessment::V1::CreateAnnotationRequest.new
              #
              #   # Call the create_annotation method.
              #   result = client.create_annotation request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_annotation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RapidMigrationAssessment::V1::CreateAnnotationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_annotation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::RapidMigrationAssessment::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_annotation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_annotation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @rapid_migration_assessment_stub.create_annotation request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Annotation.
              #
              # @overload get_annotation(request, options = nil)
              #   Pass arguments to `get_annotation` via a request object, either of type
              #   {::Google::Cloud::RapidMigrationAssessment::V1::GetAnnotationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::RapidMigrationAssessment::V1::GetAnnotationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_annotation(name: nil)
              #   Pass arguments to `get_annotation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::RapidMigrationAssessment::V1::Annotation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::RapidMigrationAssessment::V1::Annotation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/rapid_migration_assessment/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::RapidMigrationAssessment::V1::GetAnnotationRequest.new
              #
              #   # Call the get_annotation method.
              #   result = client.get_annotation request
              #
              #   # The returned object is of type Google::Cloud::RapidMigrationAssessment::V1::Annotation.
              #   p result
              #
              def get_annotation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RapidMigrationAssessment::V1::GetAnnotationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_annotation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::RapidMigrationAssessment::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_annotation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_annotation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @rapid_migration_assessment_stub.get_annotation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Collectors in a given project and location.
              #
              # @overload list_collectors(request, options = nil)
              #   Pass arguments to `list_collectors` via a request object, either of type
              #   {::Google::Cloud::RapidMigrationAssessment::V1::ListCollectorsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::RapidMigrationAssessment::V1::ListCollectorsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_collectors(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_collectors` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListCollectorsRequest.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results.
              #   @param order_by [::String]
              #     Hint for how to order the results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::RapidMigrationAssessment::V1::Collector>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::RapidMigrationAssessment::V1::Collector>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/rapid_migration_assessment/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::RapidMigrationAssessment::V1::ListCollectorsRequest.new
              #
              #   # Call the list_collectors method.
              #   result = client.list_collectors request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::RapidMigrationAssessment::V1::Collector.
              #     p item
              #   end
              #
              def list_collectors request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RapidMigrationAssessment::V1::ListCollectorsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_collectors.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::RapidMigrationAssessment::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_collectors.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_collectors.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @rapid_migration_assessment_stub.list_collectors request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @rapid_migration_assessment_stub, :list_collectors, "collectors", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Collector.
              #
              # @overload get_collector(request, options = nil)
              #   Pass arguments to `get_collector` via a request object, either of type
              #   {::Google::Cloud::RapidMigrationAssessment::V1::GetCollectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::RapidMigrationAssessment::V1::GetCollectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_collector(name: nil)
              #   Pass arguments to `get_collector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::RapidMigrationAssessment::V1::Collector]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::RapidMigrationAssessment::V1::Collector]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/rapid_migration_assessment/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::RapidMigrationAssessment::V1::GetCollectorRequest.new
              #
              #   # Call the get_collector method.
              #   result = client.get_collector request
              #
              #   # The returned object is of type Google::Cloud::RapidMigrationAssessment::V1::Collector.
              #   p result
              #
              def get_collector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RapidMigrationAssessment::V1::GetCollectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_collector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::RapidMigrationAssessment::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_collector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_collector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @rapid_migration_assessment_stub.get_collector request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Collector.
              #
              # @overload update_collector(request, options = nil)
              #   Pass arguments to `update_collector` via a request object, either of type
              #   {::Google::Cloud::RapidMigrationAssessment::V1::UpdateCollectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::RapidMigrationAssessment::V1::UpdateCollectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_collector(update_mask: nil, collector: nil, request_id: nil)
              #   Pass arguments to `update_collector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     Collector resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param collector [::Google::Cloud::RapidMigrationAssessment::V1::Collector, ::Hash]
              #     Required. The resource being updated.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/rapid_migration_assessment/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::RapidMigrationAssessment::V1::UpdateCollectorRequest.new
              #
              #   # Call the update_collector method.
              #   result = client.update_collector request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_collector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RapidMigrationAssessment::V1::UpdateCollectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_collector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::RapidMigrationAssessment::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_collector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_collector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @rapid_migration_assessment_stub.update_collector request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Collector - changes state of collector to "Deleting".
              # Background jobs does final deletion through producer API.
              #
              # @overload delete_collector(request, options = nil)
              #   Pass arguments to `delete_collector` via a request object, either of type
              #   {::Google::Cloud::RapidMigrationAssessment::V1::DeleteCollectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::RapidMigrationAssessment::V1::DeleteCollectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_collector(name: nil, request_id: nil)
              #   Pass arguments to `delete_collector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/rapid_migration_assessment/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::RapidMigrationAssessment::V1::DeleteCollectorRequest.new
              #
              #   # Call the delete_collector method.
              #   result = client.delete_collector request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_collector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RapidMigrationAssessment::V1::DeleteCollectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_collector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::RapidMigrationAssessment::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_collector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_collector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @rapid_migration_assessment_stub.delete_collector request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Resumes the given collector.
              #
              # @overload resume_collector(request, options = nil)
              #   Pass arguments to `resume_collector` via a request object, either of type
              #   {::Google::Cloud::RapidMigrationAssessment::V1::ResumeCollectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::RapidMigrationAssessment::V1::ResumeCollectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload resume_collector(name: nil, request_id: nil)
              #   Pass arguments to `resume_collector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/rapid_migration_assessment/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::RapidMigrationAssessment::V1::ResumeCollectorRequest.new
              #
              #   # Call the resume_collector method.
              #   result = client.resume_collector request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def resume_collector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RapidMigrationAssessment::V1::ResumeCollectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.resume_collector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::RapidMigrationAssessment::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.resume_collector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.resume_collector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @rapid_migration_assessment_stub.resume_collector request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Registers the given collector.
              #
              # @overload register_collector(request, options = nil)
              #   Pass arguments to `register_collector` via a request object, either of type
              #   {::Google::Cloud::RapidMigrationAssessment::V1::RegisterCollectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::RapidMigrationAssessment::V1::RegisterCollectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload register_collector(name: nil, request_id: nil)
              #   Pass arguments to `register_collector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/rapid_migration_assessment/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::RapidMigrationAssessment::V1::RegisterCollectorRequest.new
              #
              #   # Call the register_collector method.
              #   result = client.register_collector request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def register_collector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RapidMigrationAssessment::V1::RegisterCollectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.register_collector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::RapidMigrationAssessment::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.register_collector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.register_collector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @rapid_migration_assessment_stub.register_collector request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Pauses the given collector.
              #
              # @overload pause_collector(request, options = nil)
              #   Pass arguments to `pause_collector` via a request object, either of type
              #   {::Google::Cloud::RapidMigrationAssessment::V1::PauseCollectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::RapidMigrationAssessment::V1::PauseCollectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload pause_collector(name: nil, request_id: nil)
              #   Pass arguments to `pause_collector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/rapid_migration_assessment/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::RapidMigrationAssessment::V1::PauseCollectorRequest.new
              #
              #   # Call the pause_collector method.
              #   result = client.pause_collector request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def pause_collector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RapidMigrationAssessment::V1::PauseCollectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.pause_collector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::RapidMigrationAssessment::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.pause_collector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.pause_collector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @rapid_migration_assessment_stub.pause_collector request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the RapidMigrationAssessment REST API.
              #
              # This class represents the configuration for RapidMigrationAssessment REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_collector to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_collector.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::RapidMigrationAssessment::V1::RapidMigrationAssessment::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_collector.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "rapidmigrationassessment.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the RapidMigrationAssessment API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_collector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_collector
                  ##
                  # RPC-specific configuration for `create_annotation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_annotation
                  ##
                  # RPC-specific configuration for `get_annotation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_annotation
                  ##
                  # RPC-specific configuration for `list_collectors`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_collectors
                  ##
                  # RPC-specific configuration for `get_collector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_collector
                  ##
                  # RPC-specific configuration for `update_collector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_collector
                  ##
                  # RPC-specific configuration for `delete_collector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_collector
                  ##
                  # RPC-specific configuration for `resume_collector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :resume_collector
                  ##
                  # RPC-specific configuration for `register_collector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :register_collector
                  ##
                  # RPC-specific configuration for `pause_collector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :pause_collector

                  # @private
                  def initialize parent_rpcs = nil
                    create_collector_config = parent_rpcs.create_collector if parent_rpcs.respond_to? :create_collector
                    @create_collector = ::Gapic::Config::Method.new create_collector_config
                    create_annotation_config = parent_rpcs.create_annotation if parent_rpcs.respond_to? :create_annotation
                    @create_annotation = ::Gapic::Config::Method.new create_annotation_config
                    get_annotation_config = parent_rpcs.get_annotation if parent_rpcs.respond_to? :get_annotation
                    @get_annotation = ::Gapic::Config::Method.new get_annotation_config
                    list_collectors_config = parent_rpcs.list_collectors if parent_rpcs.respond_to? :list_collectors
                    @list_collectors = ::Gapic::Config::Method.new list_collectors_config
                    get_collector_config = parent_rpcs.get_collector if parent_rpcs.respond_to? :get_collector
                    @get_collector = ::Gapic::Config::Method.new get_collector_config
                    update_collector_config = parent_rpcs.update_collector if parent_rpcs.respond_to? :update_collector
                    @update_collector = ::Gapic::Config::Method.new update_collector_config
                    delete_collector_config = parent_rpcs.delete_collector if parent_rpcs.respond_to? :delete_collector
                    @delete_collector = ::Gapic::Config::Method.new delete_collector_config
                    resume_collector_config = parent_rpcs.resume_collector if parent_rpcs.respond_to? :resume_collector
                    @resume_collector = ::Gapic::Config::Method.new resume_collector_config
                    register_collector_config = parent_rpcs.register_collector if parent_rpcs.respond_to? :register_collector
                    @register_collector = ::Gapic::Config::Method.new register_collector_config
                    pause_collector_config = parent_rpcs.pause_collector if parent_rpcs.respond_to? :pause_collector
                    @pause_collector = ::Gapic::Config::Method.new pause_collector_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
