# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/pubsub/v1/pubsub_pb"
require "google/cloud/pubsub/v1/subscription_admin"

class ::Google::Cloud::PubSub::V1::SubscriptionAdmin::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_subscription
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PubSub::V1::Subscription.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    topic = "hello world"
    push_config = {}
    bigquery_config = {}
    cloud_storage_config = {}
    ack_deadline_seconds = 42
    retain_acked_messages = true
    message_retention_duration = {}
    labels = {}
    enable_message_ordering = true
    expiration_policy = {}
    filter = "hello world"
    dead_letter_policy = {}
    retry_policy = {}
    detached = true
    enable_exactly_once_delivery = true
    topic_message_retention_duration = {}
    state = :STATE_UNSPECIFIED
    analytics_hub_subscription_info = {}
    message_transforms = [{}]
    tags = {}

    create_subscription_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_subscription, name
      assert_kind_of ::Google::Cloud::PubSub::V1::Subscription, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["topic"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::PubSub::V1::PushConfig), request["push_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::PubSub::V1::BigQueryConfig), request["bigquery_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::PubSub::V1::CloudStorageConfig), request["cloud_storage_config"]
      assert_equal 42, request["ack_deadline_seconds"]
      assert_equal true, request["retain_acked_messages"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["message_retention_duration"]
      assert_equal({}, request["labels"].to_h)
      assert_equal true, request["enable_message_ordering"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::PubSub::V1::ExpirationPolicy), request["expiration_policy"]
      assert_equal "hello world", request["filter"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::PubSub::V1::DeadLetterPolicy), request["dead_letter_policy"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::PubSub::V1::RetryPolicy), request["retry_policy"]
      assert_equal true, request["detached"]
      assert_equal true, request["enable_exactly_once_delivery"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["topic_message_retention_duration"]
      assert_equal :STATE_UNSPECIFIED, request["state"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::PubSub::V1::Subscription::AnalyticsHubSubscriptionInfo), request["analytics_hub_subscription_info"]
      assert_kind_of ::Google::Cloud::PubSub::V1::MessageTransform, request["message_transforms"].first
      assert_equal({}, request["tags"].to_h)
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_subscription_client_stub do
      # Create client
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_subscription({ name: name, topic: topic, push_config: push_config, bigquery_config: bigquery_config, cloud_storage_config: cloud_storage_config, ack_deadline_seconds: ack_deadline_seconds, retain_acked_messages: retain_acked_messages, message_retention_duration: message_retention_duration, labels: labels, enable_message_ordering: enable_message_ordering, expiration_policy: expiration_policy, filter: filter, dead_letter_policy: dead_letter_policy, retry_policy: retry_policy, detached: detached, enable_exactly_once_delivery: enable_exactly_once_delivery, topic_message_retention_duration: topic_message_retention_duration, state: state, analytics_hub_subscription_info: analytics_hub_subscription_info, message_transforms: message_transforms, tags: tags }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_subscription name: name, topic: topic, push_config: push_config, bigquery_config: bigquery_config, cloud_storage_config: cloud_storage_config, ack_deadline_seconds: ack_deadline_seconds, retain_acked_messages: retain_acked_messages, message_retention_duration: message_retention_duration, labels: labels, enable_message_ordering: enable_message_ordering, expiration_policy: expiration_policy, filter: filter, dead_letter_policy: dead_letter_policy, retry_policy: retry_policy, detached: detached, enable_exactly_once_delivery: enable_exactly_once_delivery, topic_message_retention_duration: topic_message_retention_duration, state: state, analytics_hub_subscription_info: analytics_hub_subscription_info, message_transforms: message_transforms, tags: tags do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_subscription ::Google::Cloud::PubSub::V1::Subscription.new(name: name, topic: topic, push_config: push_config, bigquery_config: bigquery_config, cloud_storage_config: cloud_storage_config, ack_deadline_seconds: ack_deadline_seconds, retain_acked_messages: retain_acked_messages, message_retention_duration: message_retention_duration, labels: labels, enable_message_ordering: enable_message_ordering, expiration_policy: expiration_policy, filter: filter, dead_letter_policy: dead_letter_policy, retry_policy: retry_policy, detached: detached, enable_exactly_once_delivery: enable_exactly_once_delivery, topic_message_retention_duration: topic_message_retention_duration, state: state, analytics_hub_subscription_info: analytics_hub_subscription_info, message_transforms: message_transforms, tags: tags) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_subscription({ name: name, topic: topic, push_config: push_config, bigquery_config: bigquery_config, cloud_storage_config: cloud_storage_config, ack_deadline_seconds: ack_deadline_seconds, retain_acked_messages: retain_acked_messages, message_retention_duration: message_retention_duration, labels: labels, enable_message_ordering: enable_message_ordering, expiration_policy: expiration_policy, filter: filter, dead_letter_policy: dead_letter_policy, retry_policy: retry_policy, detached: detached, enable_exactly_once_delivery: enable_exactly_once_delivery, topic_message_retention_duration: topic_message_retention_duration, state: state, analytics_hub_subscription_info: analytics_hub_subscription_info, message_transforms: message_transforms, tags: tags }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_subscription(::Google::Cloud::PubSub::V1::Subscription.new(name: name, topic: topic, push_config: push_config, bigquery_config: bigquery_config, cloud_storage_config: cloud_storage_config, ack_deadline_seconds: ack_deadline_seconds, retain_acked_messages: retain_acked_messages, message_retention_duration: message_retention_duration, labels: labels, enable_message_ordering: enable_message_ordering, expiration_policy: expiration_policy, filter: filter, dead_letter_policy: dead_letter_policy, retry_policy: retry_policy, detached: detached, enable_exactly_once_delivery: enable_exactly_once_delivery, topic_message_retention_duration: topic_message_retention_duration, state: state, analytics_hub_subscription_info: analytics_hub_subscription_info, message_transforms: message_transforms, tags: tags), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_subscription_client_stub.call_rpc_count
    end
  end

  def test_get_subscription
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PubSub::V1::Subscription.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    subscription = "hello world"

    get_subscription_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_subscription, name
      assert_kind_of ::Google::Cloud::PubSub::V1::GetSubscriptionRequest, request
      assert_equal "hello world", request["subscription"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_subscription_client_stub do
      # Create client
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_subscription({ subscription: subscription }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_subscription subscription: subscription do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_subscription ::Google::Cloud::PubSub::V1::GetSubscriptionRequest.new(subscription: subscription) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_subscription({ subscription: subscription }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_subscription(::Google::Cloud::PubSub::V1::GetSubscriptionRequest.new(subscription: subscription), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_subscription_client_stub.call_rpc_count
    end
  end

  def test_update_subscription
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PubSub::V1::Subscription.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    subscription = {}
    update_mask = {}

    update_subscription_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_subscription, name
      assert_kind_of ::Google::Cloud::PubSub::V1::UpdateSubscriptionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::PubSub::V1::Subscription), request["subscription"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_subscription_client_stub do
      # Create client
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_subscription({ subscription: subscription, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_subscription subscription: subscription, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_subscription ::Google::Cloud::PubSub::V1::UpdateSubscriptionRequest.new(subscription: subscription, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_subscription({ subscription: subscription, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_subscription(::Google::Cloud::PubSub::V1::UpdateSubscriptionRequest.new(subscription: subscription, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_subscription_client_stub.call_rpc_count
    end
  end

  def test_list_subscriptions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PubSub::V1::ListSubscriptionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    page_size = 42
    page_token = "hello world"

    list_subscriptions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_subscriptions, name
      assert_kind_of ::Google::Cloud::PubSub::V1::ListSubscriptionsRequest, request
      assert_equal "hello world", request["project"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_subscriptions_client_stub do
      # Create client
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_subscriptions({ project: project, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_subscriptions project: project, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_subscriptions ::Google::Cloud::PubSub::V1::ListSubscriptionsRequest.new(project: project, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_subscriptions({ project: project, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_subscriptions(::Google::Cloud::PubSub::V1::ListSubscriptionsRequest.new(project: project, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_subscriptions_client_stub.call_rpc_count
    end
  end

  def test_delete_subscription
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    subscription = "hello world"

    delete_subscription_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_subscription, name
      assert_kind_of ::Google::Cloud::PubSub::V1::DeleteSubscriptionRequest, request
      assert_equal "hello world", request["subscription"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_subscription_client_stub do
      # Create client
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_subscription({ subscription: subscription }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_subscription subscription: subscription do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_subscription ::Google::Cloud::PubSub::V1::DeleteSubscriptionRequest.new(subscription: subscription) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_subscription({ subscription: subscription }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_subscription(::Google::Cloud::PubSub::V1::DeleteSubscriptionRequest.new(subscription: subscription), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_subscription_client_stub.call_rpc_count
    end
  end

  def test_modify_ack_deadline
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    subscription = "hello world"
    ack_ids = ["hello world"]
    ack_deadline_seconds = 42

    modify_ack_deadline_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :modify_ack_deadline, name
      assert_kind_of ::Google::Cloud::PubSub::V1::ModifyAckDeadlineRequest, request
      assert_equal "hello world", request["subscription"]
      assert_equal ["hello world"], request["ack_ids"]
      assert_equal 42, request["ack_deadline_seconds"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, modify_ack_deadline_client_stub do
      # Create client
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.modify_ack_deadline({ subscription: subscription, ack_ids: ack_ids, ack_deadline_seconds: ack_deadline_seconds }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.modify_ack_deadline subscription: subscription, ack_ids: ack_ids, ack_deadline_seconds: ack_deadline_seconds do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.modify_ack_deadline ::Google::Cloud::PubSub::V1::ModifyAckDeadlineRequest.new(subscription: subscription, ack_ids: ack_ids, ack_deadline_seconds: ack_deadline_seconds) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.modify_ack_deadline({ subscription: subscription, ack_ids: ack_ids, ack_deadline_seconds: ack_deadline_seconds }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.modify_ack_deadline(::Google::Cloud::PubSub::V1::ModifyAckDeadlineRequest.new(subscription: subscription, ack_ids: ack_ids, ack_deadline_seconds: ack_deadline_seconds), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, modify_ack_deadline_client_stub.call_rpc_count
    end
  end

  def test_acknowledge
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    subscription = "hello world"
    ack_ids = ["hello world"]

    acknowledge_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :acknowledge, name
      assert_kind_of ::Google::Cloud::PubSub::V1::AcknowledgeRequest, request
      assert_equal "hello world", request["subscription"]
      assert_equal ["hello world"], request["ack_ids"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, acknowledge_client_stub do
      # Create client
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.acknowledge({ subscription: subscription, ack_ids: ack_ids }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.acknowledge subscription: subscription, ack_ids: ack_ids do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.acknowledge ::Google::Cloud::PubSub::V1::AcknowledgeRequest.new(subscription: subscription, ack_ids: ack_ids) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.acknowledge({ subscription: subscription, ack_ids: ack_ids }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.acknowledge(::Google::Cloud::PubSub::V1::AcknowledgeRequest.new(subscription: subscription, ack_ids: ack_ids), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, acknowledge_client_stub.call_rpc_count
    end
  end

  def test_pull
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PubSub::V1::PullResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    subscription = "hello world"
    return_immediately = true
    max_messages = 42

    pull_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :pull, name
      assert_kind_of ::Google::Cloud::PubSub::V1::PullRequest, request
      assert_equal "hello world", request["subscription"]
      assert_equal true, request["return_immediately"]
      assert_equal 42, request["max_messages"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, pull_client_stub do
      # Create client
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.pull({ subscription: subscription, return_immediately: return_immediately, max_messages: max_messages }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.pull subscription: subscription, return_immediately: return_immediately, max_messages: max_messages do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.pull ::Google::Cloud::PubSub::V1::PullRequest.new(subscription: subscription, return_immediately: return_immediately, max_messages: max_messages) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.pull({ subscription: subscription, return_immediately: return_immediately, max_messages: max_messages }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.pull(::Google::Cloud::PubSub::V1::PullRequest.new(subscription: subscription, return_immediately: return_immediately, max_messages: max_messages), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, pull_client_stub.call_rpc_count
    end
  end

  def test_streaming_pull
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PubSub::V1::StreamingPullResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    subscription = "hello world"
    ack_ids = ["hello world"]
    modify_deadline_seconds = [42]
    modify_deadline_ack_ids = ["hello world"]
    stream_ack_deadline_seconds = 42
    client_id = "hello world"
    max_outstanding_messages = 42
    max_outstanding_bytes = 42
    protocol_version = 42

    streaming_pull_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :streaming_pull, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, streaming_pull_client_stub do
      # Create client
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { subscription: subscription, ack_ids: ack_ids, modify_deadline_seconds: modify_deadline_seconds, modify_deadline_ack_ids: modify_deadline_ack_ids, stream_ack_deadline_seconds: stream_ack_deadline_seconds, client_id: client_id, max_outstanding_messages: max_outstanding_messages, max_outstanding_bytes: max_outstanding_bytes, protocol_version: protocol_version }
      request_proto = ::Google::Cloud::PubSub::V1::StreamingPullRequest.new subscription: subscription, ack_ids: ack_ids, modify_deadline_seconds: modify_deadline_seconds, modify_deadline_ack_ids: modify_deadline_ack_ids, stream_ack_deadline_seconds: stream_ack_deadline_seconds, client_id: client_id, max_outstanding_messages: max_outstanding_messages, max_outstanding_bytes: max_outstanding_bytes, protocol_version: protocol_version
      enum_input = [request_hash, request_proto].to_enum
      client.streaming_pull enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::PubSub::V1::StreamingPullResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { subscription: subscription, ack_ids: ack_ids, modify_deadline_seconds: modify_deadline_seconds, modify_deadline_ack_ids: modify_deadline_ack_ids, stream_ack_deadline_seconds: stream_ack_deadline_seconds, client_id: client_id, max_outstanding_messages: max_outstanding_messages, max_outstanding_bytes: max_outstanding_bytes, protocol_version: protocol_version }
      request_proto = ::Google::Cloud::PubSub::V1::StreamingPullRequest.new subscription: subscription, ack_ids: ack_ids, modify_deadline_seconds: modify_deadline_seconds, modify_deadline_ack_ids: modify_deadline_ack_ids, stream_ack_deadline_seconds: stream_ack_deadline_seconds, client_id: client_id, max_outstanding_messages: max_outstanding_messages, max_outstanding_bytes: max_outstanding_bytes, protocol_version: protocol_version
      stream_input = Gapic::StreamInput.new
      client.streaming_pull stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::PubSub::V1::StreamingPullResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { subscription: subscription, ack_ids: ack_ids, modify_deadline_seconds: modify_deadline_seconds, modify_deadline_ack_ids: modify_deadline_ack_ids, stream_ack_deadline_seconds: stream_ack_deadline_seconds, client_id: client_id, max_outstanding_messages: max_outstanding_messages, max_outstanding_bytes: max_outstanding_bytes, protocol_version: protocol_version }
      request_proto = ::Google::Cloud::PubSub::V1::StreamingPullRequest.new subscription: subscription, ack_ids: ack_ids, modify_deadline_seconds: modify_deadline_seconds, modify_deadline_ack_ids: modify_deadline_ack_ids, stream_ack_deadline_seconds: stream_ack_deadline_seconds, client_id: client_id, max_outstanding_messages: max_outstanding_messages, max_outstanding_bytes: max_outstanding_bytes, protocol_version: protocol_version
      enum_input = [request_hash, request_proto].to_enum
      client.streaming_pull enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::PubSub::V1::StreamingPullResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { subscription: subscription, ack_ids: ack_ids, modify_deadline_seconds: modify_deadline_seconds, modify_deadline_ack_ids: modify_deadline_ack_ids, stream_ack_deadline_seconds: stream_ack_deadline_seconds, client_id: client_id, max_outstanding_messages: max_outstanding_messages, max_outstanding_bytes: max_outstanding_bytes, protocol_version: protocol_version }
      request_proto = ::Google::Cloud::PubSub::V1::StreamingPullRequest.new subscription: subscription, ack_ids: ack_ids, modify_deadline_seconds: modify_deadline_seconds, modify_deadline_ack_ids: modify_deadline_ack_ids, stream_ack_deadline_seconds: stream_ack_deadline_seconds, client_id: client_id, max_outstanding_messages: max_outstanding_messages, max_outstanding_bytes: max_outstanding_bytes, protocol_version: protocol_version
      stream_input = Gapic::StreamInput.new
      client.streaming_pull stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::PubSub::V1::StreamingPullResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, streaming_pull_client_stub.call_rpc_count
      streaming_pull_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::PubSub::V1::StreamingPullRequest, r
          assert_equal "hello world", r["subscription"]
          assert_equal ["hello world"], r["ack_ids"]
          assert_equal [42], r["modify_deadline_seconds"]
          assert_equal ["hello world"], r["modify_deadline_ack_ids"]
          assert_equal 42, r["stream_ack_deadline_seconds"]
          assert_equal "hello world", r["client_id"]
          assert_equal 42, r["max_outstanding_messages"]
          assert_equal 42, r["max_outstanding_bytes"]
          assert_equal 42, r["protocol_version"]
        end
      end
    end
  end

  def test_modify_push_config
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    subscription = "hello world"
    push_config = {}

    modify_push_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :modify_push_config, name
      assert_kind_of ::Google::Cloud::PubSub::V1::ModifyPushConfigRequest, request
      assert_equal "hello world", request["subscription"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::PubSub::V1::PushConfig), request["push_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, modify_push_config_client_stub do
      # Create client
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.modify_push_config({ subscription: subscription, push_config: push_config }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.modify_push_config subscription: subscription, push_config: push_config do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.modify_push_config ::Google::Cloud::PubSub::V1::ModifyPushConfigRequest.new(subscription: subscription, push_config: push_config) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.modify_push_config({ subscription: subscription, push_config: push_config }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.modify_push_config(::Google::Cloud::PubSub::V1::ModifyPushConfigRequest.new(subscription: subscription, push_config: push_config), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, modify_push_config_client_stub.call_rpc_count
    end
  end

  def test_get_snapshot
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PubSub::V1::Snapshot.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    snapshot = "hello world"

    get_snapshot_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_snapshot, name
      assert_kind_of ::Google::Cloud::PubSub::V1::GetSnapshotRequest, request
      assert_equal "hello world", request["snapshot"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_snapshot_client_stub do
      # Create client
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_snapshot({ snapshot: snapshot }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_snapshot snapshot: snapshot do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_snapshot ::Google::Cloud::PubSub::V1::GetSnapshotRequest.new(snapshot: snapshot) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_snapshot({ snapshot: snapshot }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_snapshot(::Google::Cloud::PubSub::V1::GetSnapshotRequest.new(snapshot: snapshot), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_snapshot_client_stub.call_rpc_count
    end
  end

  def test_list_snapshots
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PubSub::V1::ListSnapshotsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    page_size = 42
    page_token = "hello world"

    list_snapshots_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_snapshots, name
      assert_kind_of ::Google::Cloud::PubSub::V1::ListSnapshotsRequest, request
      assert_equal "hello world", request["project"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_snapshots_client_stub do
      # Create client
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_snapshots({ project: project, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_snapshots project: project, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_snapshots ::Google::Cloud::PubSub::V1::ListSnapshotsRequest.new(project: project, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_snapshots({ project: project, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_snapshots(::Google::Cloud::PubSub::V1::ListSnapshotsRequest.new(project: project, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_snapshots_client_stub.call_rpc_count
    end
  end

  def test_create_snapshot
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PubSub::V1::Snapshot.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    subscription = "hello world"
    labels = {}
    tags = {}

    create_snapshot_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_snapshot, name
      assert_kind_of ::Google::Cloud::PubSub::V1::CreateSnapshotRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["subscription"]
      assert_equal({}, request["labels"].to_h)
      assert_equal({}, request["tags"].to_h)
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_snapshot_client_stub do
      # Create client
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_snapshot({ name: name, subscription: subscription, labels: labels, tags: tags }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_snapshot name: name, subscription: subscription, labels: labels, tags: tags do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_snapshot ::Google::Cloud::PubSub::V1::CreateSnapshotRequest.new(name: name, subscription: subscription, labels: labels, tags: tags) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_snapshot({ name: name, subscription: subscription, labels: labels, tags: tags }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_snapshot(::Google::Cloud::PubSub::V1::CreateSnapshotRequest.new(name: name, subscription: subscription, labels: labels, tags: tags), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_snapshot_client_stub.call_rpc_count
    end
  end

  def test_update_snapshot
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PubSub::V1::Snapshot.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    snapshot = {}
    update_mask = {}

    update_snapshot_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_snapshot, name
      assert_kind_of ::Google::Cloud::PubSub::V1::UpdateSnapshotRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::PubSub::V1::Snapshot), request["snapshot"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_snapshot_client_stub do
      # Create client
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_snapshot({ snapshot: snapshot, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_snapshot snapshot: snapshot, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_snapshot ::Google::Cloud::PubSub::V1::UpdateSnapshotRequest.new(snapshot: snapshot, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_snapshot({ snapshot: snapshot, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_snapshot(::Google::Cloud::PubSub::V1::UpdateSnapshotRequest.new(snapshot: snapshot, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_snapshot_client_stub.call_rpc_count
    end
  end

  def test_delete_snapshot
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    snapshot = "hello world"

    delete_snapshot_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_snapshot, name
      assert_kind_of ::Google::Cloud::PubSub::V1::DeleteSnapshotRequest, request
      assert_equal "hello world", request["snapshot"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_snapshot_client_stub do
      # Create client
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_snapshot({ snapshot: snapshot }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_snapshot snapshot: snapshot do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_snapshot ::Google::Cloud::PubSub::V1::DeleteSnapshotRequest.new(snapshot: snapshot) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_snapshot({ snapshot: snapshot }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_snapshot(::Google::Cloud::PubSub::V1::DeleteSnapshotRequest.new(snapshot: snapshot), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_snapshot_client_stub.call_rpc_count
    end
  end

  def test_seek
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PubSub::V1::SeekResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    subscription = "hello world"
    time = {}

    seek_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :seek, name
      assert_kind_of ::Google::Cloud::PubSub::V1::SeekRequest, request
      assert_equal "hello world", request["subscription"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["time"]
      assert_equal :time, request.target
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, seek_client_stub do
      # Create client
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.seek({ subscription: subscription, time: time }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.seek subscription: subscription, time: time do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.seek ::Google::Cloud::PubSub::V1::SeekRequest.new(subscription: subscription, time: time) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.seek({ subscription: subscription, time: time }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.seek(::Google::Cloud::PubSub::V1::SeekRequest.new(subscription: subscription, time: time), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, seek_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
