# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module PubSub
      module V1
        # A policy constraining the storage of messages published to the topic.
        # @!attribute [rw] allowed_persistence_regions
        #   @return [::Array<::String>]
        #     Optional. A list of IDs of Google Cloud regions where messages that are
        #     published to the topic may be persisted in storage. Messages published by
        #     publishers running in non-allowed Google Cloud regions (or running outside
        #     of Google Cloud altogether) are routed for storage in one of the allowed
        #     regions. An empty list means that no regions are allowed, and is not a
        #     valid configuration.
        # @!attribute [rw] enforce_in_transit
        #   @return [::Boolean]
        #     Optional. If true, `allowed_persistence_regions` is also used to enforce
        #     in-transit guarantees for messages. That is, Pub/Sub will fail
        #     Publish operations on this topic and subscribe operations
        #     on any subscription attached to this topic in any region that is
        #     not in `allowed_persistence_regions`.
        class MessageStoragePolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings for validating messages published against a schema.
        # @!attribute [rw] schema
        #   @return [::String]
        #     Required. The name of the schema that messages published should be
        #     validated against. Format is `projects/{project}/schemas/{schema}`. The
        #     value of this field will be `_deleted-schema_` if the schema has been
        #     deleted.
        # @!attribute [rw] encoding
        #   @return [::Google::Cloud::PubSub::V1::Encoding]
        #     Optional. The encoding of messages validated against `schema`.
        # @!attribute [rw] first_revision_id
        #   @return [::String]
        #     Optional. The minimum (inclusive) revision allowed for validating messages.
        #     If empty or not present, allow any revision to be validated against
        #     last_revision or any revision created before.
        # @!attribute [rw] last_revision_id
        #   @return [::String]
        #     Optional. The maximum (inclusive) revision allowed for validating messages.
        #     If empty or not present, allow any revision to be validated against
        #     first_revision or any revision created after.
        class SchemaSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings for an ingestion data source on a topic.
        # @!attribute [rw] aws_kinesis
        #   @return [::Google::Cloud::PubSub::V1::IngestionDataSourceSettings::AwsKinesis]
        #     Optional. Amazon Kinesis Data Streams.
        #
        #     Note: The following fields are mutually exclusive: `aws_kinesis`, `cloud_storage`, `azure_event_hubs`, `aws_msk`, `confluent_cloud`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_storage
        #   @return [::Google::Cloud::PubSub::V1::IngestionDataSourceSettings::CloudStorage]
        #     Optional. Cloud Storage.
        #
        #     Note: The following fields are mutually exclusive: `cloud_storage`, `aws_kinesis`, `azure_event_hubs`, `aws_msk`, `confluent_cloud`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] azure_event_hubs
        #   @return [::Google::Cloud::PubSub::V1::IngestionDataSourceSettings::AzureEventHubs]
        #     Optional. Azure Event Hubs.
        #
        #     Note: The following fields are mutually exclusive: `azure_event_hubs`, `aws_kinesis`, `cloud_storage`, `aws_msk`, `confluent_cloud`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] aws_msk
        #   @return [::Google::Cloud::PubSub::V1::IngestionDataSourceSettings::AwsMsk]
        #     Optional. Amazon MSK.
        #
        #     Note: The following fields are mutually exclusive: `aws_msk`, `aws_kinesis`, `cloud_storage`, `azure_event_hubs`, `confluent_cloud`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] confluent_cloud
        #   @return [::Google::Cloud::PubSub::V1::IngestionDataSourceSettings::ConfluentCloud]
        #     Optional. Confluent Cloud.
        #
        #     Note: The following fields are mutually exclusive: `confluent_cloud`, `aws_kinesis`, `cloud_storage`, `azure_event_hubs`, `aws_msk`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] platform_logs_settings
        #   @return [::Google::Cloud::PubSub::V1::PlatformLogsSettings]
        #     Optional. Platform Logs settings. If unset, no Platform Logs will be
        #     generated.
        class IngestionDataSourceSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Ingestion settings for Amazon Kinesis Data Streams.
          # @!attribute [r] state
          #   @return [::Google::Cloud::PubSub::V1::IngestionDataSourceSettings::AwsKinesis::State]
          #     Output only. An output-only field that indicates the state of the Kinesis
          #     ingestion source.
          # @!attribute [rw] stream_arn
          #   @return [::String]
          #     Required. The Kinesis stream ARN to ingest data from.
          # @!attribute [rw] consumer_arn
          #   @return [::String]
          #     Required. The Kinesis consumer ARN to used for ingestion in Enhanced
          #     Fan-Out mode. The consumer must be already created and ready to be used.
          # @!attribute [rw] aws_role_arn
          #   @return [::String]
          #     Required. AWS role ARN to be used for Federated Identity authentication
          #     with Kinesis. Check the Pub/Sub docs for how to set up this role and the
          #     required permissions that need to be attached to it.
          # @!attribute [rw] gcp_service_account
          #   @return [::String]
          #     Required. The GCP service account to be used for Federated Identity
          #     authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
          #     the provided role). The `aws_role_arn` must be set up with
          #     `accounts.google.com:sub` equals to this service account number.
          class AwsKinesis
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Possible states for ingestion from Amazon Kinesis Data Streams.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # Ingestion is active.
              ACTIVE = 1

              # Permission denied encountered while consuming data from Kinesis.
              # This can happen if:
              #   - The provided `aws_role_arn` does not exist or does not have the
              #     appropriate permissions attached.
              #   - The provided `aws_role_arn` is not set up properly for Identity
              #     Federation using `gcp_service_account`.
              #   - The Pub/Sub SA is not granted the
              #     `iam.serviceAccounts.getOpenIdToken` permission on
              #     `gcp_service_account`.
              KINESIS_PERMISSION_DENIED = 2

              # Permission denied encountered while publishing to the topic. This can
              # happen if the Pub/Sub SA has not been granted the [appropriate publish
              # permissions](https://cloud.google.com/pubsub/docs/access-control#pubsub.publisher)
              PUBLISH_PERMISSION_DENIED = 3

              # The Kinesis stream does not exist.
              STREAM_NOT_FOUND = 4

              # The Kinesis consumer does not exist.
              CONSUMER_NOT_FOUND = 5
            end
          end

          # Ingestion settings for Cloud Storage.
          # @!attribute [r] state
          #   @return [::Google::Cloud::PubSub::V1::IngestionDataSourceSettings::CloudStorage::State]
          #     Output only. An output-only field that indicates the state of the Cloud
          #     Storage ingestion source.
          # @!attribute [rw] bucket
          #   @return [::String]
          #     Optional. Cloud Storage bucket. The bucket name must be without any
          #     prefix like "gs://". See the [bucket naming requirements]
          #     (https://cloud.google.com/storage/docs/buckets#naming).
          # @!attribute [rw] text_format
          #   @return [::Google::Cloud::PubSub::V1::IngestionDataSourceSettings::CloudStorage::TextFormat]
          #     Optional. Data from Cloud Storage will be interpreted as text.
          #
          #     Note: The following fields are mutually exclusive: `text_format`, `avro_format`, `pubsub_avro_format`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] avro_format
          #   @return [::Google::Cloud::PubSub::V1::IngestionDataSourceSettings::CloudStorage::AvroFormat]
          #     Optional. Data from Cloud Storage will be interpreted in Avro format.
          #
          #     Note: The following fields are mutually exclusive: `avro_format`, `text_format`, `pubsub_avro_format`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] pubsub_avro_format
          #   @return [::Google::Cloud::PubSub::V1::IngestionDataSourceSettings::CloudStorage::PubSubAvroFormat]
          #     Optional. It will be assumed data from Cloud Storage was written via
          #     [Cloud Storage
          #     subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
          #
          #     Note: The following fields are mutually exclusive: `pubsub_avro_format`, `text_format`, `avro_format`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] minimum_object_create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Optional. Only objects with a larger or equal creation timestamp will be
          #     ingested.
          # @!attribute [rw] match_glob
          #   @return [::String]
          #     Optional. Glob pattern used to match objects that will be ingested. If
          #     unset, all objects will be ingested. See the [supported
          #     patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
          class CloudStorage
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Configuration for reading Cloud Storage data in text format. Each line of
            # text as specified by the delimiter will be set to the `data` field of a
            # Pub/Sub message.
            # @!attribute [rw] delimiter
            #   @return [::String]
            #     Optional. When unset, '\n' is used.
            class TextFormat
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Configuration for reading Cloud Storage data in Avro binary format. The
            # bytes of each object will be set to the `data` field of a Pub/Sub
            # message.
            class AvroFormat
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Configuration for reading Cloud Storage data written via [Cloud Storage
            # subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage). The
            # data and attributes fields of the originally exported Pub/Sub message
            # will be restored when publishing.
            class PubSubAvroFormat
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Possible states for ingestion from Cloud Storage.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # Ingestion is active.
              ACTIVE = 1

              # Permission denied encountered while calling the Cloud Storage API. This
              # can happen if the Pub/Sub SA has not been granted the
              # [appropriate
              # permissions](https://cloud.google.com/storage/docs/access-control/iam-permissions):
              # - storage.objects.list: to list the objects in a bucket.
              # - storage.objects.get: to read the objects in a bucket.
              # - storage.buckets.get: to verify the bucket exists.
              CLOUD_STORAGE_PERMISSION_DENIED = 2

              # Permission denied encountered while publishing to the topic. This can
              # happen if the Pub/Sub SA has not been granted the [appropriate publish
              # permissions](https://cloud.google.com/pubsub/docs/access-control#pubsub.publisher)
              PUBLISH_PERMISSION_DENIED = 3

              # The provided Cloud Storage bucket doesn't exist.
              BUCKET_NOT_FOUND = 4

              # The Cloud Storage bucket has too many objects, ingestion will be
              # paused.
              TOO_MANY_OBJECTS = 5
            end
          end

          # Ingestion settings for Azure Event Hubs.
          # @!attribute [r] state
          #   @return [::Google::Cloud::PubSub::V1::IngestionDataSourceSettings::AzureEventHubs::State]
          #     Output only. An output-only field that indicates the state of the Event
          #     Hubs ingestion source.
          # @!attribute [rw] resource_group
          #   @return [::String]
          #     Optional. Name of the resource group within the azure subscription.
          # @!attribute [rw] namespace
          #   @return [::String]
          #     Optional. The name of the Event Hubs namespace.
          # @!attribute [rw] event_hub
          #   @return [::String]
          #     Optional. The name of the Event Hub.
          # @!attribute [rw] client_id
          #   @return [::String]
          #     Optional. The client id of the Azure application that is being used to
          #     authenticate Pub/Sub.
          # @!attribute [rw] tenant_id
          #   @return [::String]
          #     Optional. The tenant id of the Azure application that is being used to
          #     authenticate Pub/Sub.
          # @!attribute [rw] subscription_id
          #   @return [::String]
          #     Optional. The Azure subscription id.
          # @!attribute [rw] gcp_service_account
          #   @return [::String]
          #     Optional. The GCP service account to be used for Federated Identity
          #     authentication.
          class AzureEventHubs
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Possible states for managed ingestion from Event Hubs.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # Ingestion is active.
              ACTIVE = 1

              # Permission denied encountered while consuming data from Event Hubs.
              # This can happen when `client_id`, or `tenant_id` are invalid. Or the
              # right permissions haven't been granted.
              EVENT_HUBS_PERMISSION_DENIED = 2

              # Permission denied encountered while publishing to the topic.
              PUBLISH_PERMISSION_DENIED = 3

              # The provided Event Hubs namespace couldn't be found.
              NAMESPACE_NOT_FOUND = 4

              # The provided Event Hub couldn't be found.
              EVENT_HUB_NOT_FOUND = 5

              # The provided Event Hubs subscription couldn't be found.
              SUBSCRIPTION_NOT_FOUND = 6

              # The provided Event Hubs resource group couldn't be found.
              RESOURCE_GROUP_NOT_FOUND = 7
            end
          end

          # Ingestion settings for Amazon MSK.
          # @!attribute [r] state
          #   @return [::Google::Cloud::PubSub::V1::IngestionDataSourceSettings::AwsMsk::State]
          #     Output only. An output-only field that indicates the state of the Amazon
          #     MSK ingestion source.
          # @!attribute [rw] cluster_arn
          #   @return [::String]
          #     Required. The Amazon Resource Name (ARN) that uniquely identifies the
          #     cluster.
          # @!attribute [rw] topic
          #   @return [::String]
          #     Required. The name of the topic in the Amazon MSK cluster that Pub/Sub
          #     will import from.
          # @!attribute [rw] aws_role_arn
          #   @return [::String]
          #     Required. AWS role ARN to be used for Federated Identity authentication
          #     with Amazon MSK. Check the Pub/Sub docs for how to set up this role and
          #     the required permissions that need to be attached to it.
          # @!attribute [rw] gcp_service_account
          #   @return [::String]
          #     Required. The GCP service account to be used for Federated Identity
          #     authentication with Amazon MSK (via a `AssumeRoleWithWebIdentity` call
          #     for the provided role). The `aws_role_arn` must be set up with
          #     `accounts.google.com:sub` equals to this service account number.
          class AwsMsk
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Possible states for managed ingestion from Amazon MSK.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # Ingestion is active.
              ACTIVE = 1

              # Permission denied encountered while consuming data from Amazon MSK.
              MSK_PERMISSION_DENIED = 2

              # Permission denied encountered while publishing to the topic.
              PUBLISH_PERMISSION_DENIED = 3

              # The provided MSK cluster wasn't found.
              CLUSTER_NOT_FOUND = 4

              # The provided topic wasn't found.
              TOPIC_NOT_FOUND = 5
            end
          end

          # Ingestion settings for Confluent Cloud.
          # @!attribute [r] state
          #   @return [::Google::Cloud::PubSub::V1::IngestionDataSourceSettings::ConfluentCloud::State]
          #     Output only. An output-only field that indicates the state of the
          #     Confluent Cloud ingestion source.
          # @!attribute [rw] bootstrap_server
          #   @return [::String]
          #     Required. The address of the bootstrap server. The format is url:port.
          # @!attribute [rw] cluster_id
          #   @return [::String]
          #     Required. The id of the cluster.
          # @!attribute [rw] topic
          #   @return [::String]
          #     Required. The name of the topic in the Confluent Cloud cluster that
          #     Pub/Sub will import from.
          # @!attribute [rw] identity_pool_id
          #   @return [::String]
          #     Required. The id of the identity pool to be used for Federated Identity
          #     authentication with Confluent Cloud. See
          #     https://docs.confluent.io/cloud/current/security/authenticate/workload-identities/identity-providers/oauth/identity-pools.html#add-oauth-identity-pools.
          # @!attribute [rw] gcp_service_account
          #   @return [::String]
          #     Required. The GCP service account to be used for Federated Identity
          #     authentication with `identity_pool_id`.
          class ConfluentCloud
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Possible states for managed ingestion from Confluent Cloud.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # Ingestion is active.
              ACTIVE = 1

              # Permission denied encountered while consuming data from Confluent
              # Cloud.
              CONFLUENT_CLOUD_PERMISSION_DENIED = 2

              # Permission denied encountered while publishing to the topic.
              PUBLISH_PERMISSION_DENIED = 3

              # The provided bootstrap server address is unreachable.
              UNREACHABLE_BOOTSTRAP_SERVER = 4

              # The provided cluster wasn't found.
              CLUSTER_NOT_FOUND = 5

              # The provided topic wasn't found.
              TOPIC_NOT_FOUND = 6
            end
          end
        end

        # Settings for Platform Logs produced by Pub/Sub.
        # @!attribute [rw] severity
        #   @return [::Google::Cloud::PubSub::V1::PlatformLogsSettings::Severity]
        #     Optional. The minimum severity level of Platform Logs that will be written.
        class PlatformLogsSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Severity levels of Platform Logs.
          module Severity
            # Default value. Logs level is unspecified. Logs will be disabled.
            SEVERITY_UNSPECIFIED = 0

            # Logs will be disabled.
            DISABLED = 1

            # Debug logs and higher-severity logs will be written.
            DEBUG = 2

            # Info logs and higher-severity logs will be written.
            INFO = 3

            # Warning logs and higher-severity logs will be written.
            WARNING = 4

            # Only error logs will be written.
            ERROR = 5
          end
        end

        # Payload of the Platform Log entry sent when a failure is encountered while
        # ingesting.
        # @!attribute [rw] topic
        #   @return [::String]
        #     Required. Name of the import topic. Format is:
        #     projects/\\{project_name}/topics/\\{topic_name}.
        # @!attribute [rw] error_message
        #   @return [::String]
        #     Required. Error details explaining why ingestion to Pub/Sub has failed.
        # @!attribute [rw] cloud_storage_failure
        #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::CloudStorageFailure]
        #     Optional. Failure when ingesting from Cloud Storage.
        #
        #     Note: The following fields are mutually exclusive: `cloud_storage_failure`, `aws_msk_failure`, `azure_event_hubs_failure`, `confluent_cloud_failure`, `aws_kinesis_failure`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] aws_msk_failure
        #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::AwsMskFailureReason]
        #     Optional. Failure when ingesting from Amazon MSK.
        #
        #     Note: The following fields are mutually exclusive: `aws_msk_failure`, `cloud_storage_failure`, `azure_event_hubs_failure`, `confluent_cloud_failure`, `aws_kinesis_failure`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] azure_event_hubs_failure
        #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::AzureEventHubsFailureReason]
        #     Optional. Failure when ingesting from Azure Event Hubs.
        #
        #     Note: The following fields are mutually exclusive: `azure_event_hubs_failure`, `cloud_storage_failure`, `aws_msk_failure`, `confluent_cloud_failure`, `aws_kinesis_failure`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] confluent_cloud_failure
        #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::ConfluentCloudFailureReason]
        #     Optional. Failure when ingesting from Confluent Cloud.
        #
        #     Note: The following fields are mutually exclusive: `confluent_cloud_failure`, `cloud_storage_failure`, `aws_msk_failure`, `azure_event_hubs_failure`, `aws_kinesis_failure`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] aws_kinesis_failure
        #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::AwsKinesisFailureReason]
        #     Optional. Failure when ingesting from AWS Kinesis.
        #
        #     Note: The following fields are mutually exclusive: `aws_kinesis_failure`, `cloud_storage_failure`, `aws_msk_failure`, `azure_event_hubs_failure`, `confluent_cloud_failure`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class IngestionFailureEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the reason why some data may have been left out of
          # the desired Pub/Sub message due to the API message limits
          # (https://cloud.google.com/pubsub/quotas#resource_limits). For example,
          # when the number of attributes is larger than 100, the number of
          # attributes is truncated to 100 to respect the limit on the attribute count.
          # Other attribute limits are treated similarly. When the size of the desired
          # message would've been larger than 10MB, the message won't be published at
          # all, and ingestion of the subsequent messages will proceed as normal.
          class ApiViolationReason
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Set when an Avro file is unsupported or its format is not valid. When this
          # occurs, one or more Avro objects won't be ingested.
          class AvroFailureReason
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Set when a Pub/Sub message fails to get published due to a schema
          # validation violation.
          class SchemaViolationReason
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Set when a Pub/Sub message fails to get published due to a message
          # transformation error.
          class MessageTransformationFailureReason
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Failure when ingesting from a Cloud Storage source.
          # @!attribute [rw] bucket
          #   @return [::String]
          #     Optional. Name of the Cloud Storage bucket used for ingestion.
          # @!attribute [rw] object_name
          #   @return [::String]
          #     Optional. Name of the Cloud Storage object which contained the section
          #     that couldn't be ingested.
          # @!attribute [rw] object_generation
          #   @return [::Integer]
          #     Optional. Generation of the Cloud Storage object which contained the
          #     section that couldn't be ingested.
          # @!attribute [rw] avro_failure_reason
          #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::AvroFailureReason]
          #     Optional. Failure encountered when parsing an Avro file.
          #
          #     Note: The following fields are mutually exclusive: `avro_failure_reason`, `api_violation_reason`, `schema_violation_reason`, `message_transformation_failure_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] api_violation_reason
          #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::ApiViolationReason]
          #     Optional. The Pub/Sub API limits prevented the desired message from
          #     being published.
          #
          #     Note: The following fields are mutually exclusive: `api_violation_reason`, `avro_failure_reason`, `schema_violation_reason`, `message_transformation_failure_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] schema_violation_reason
          #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::SchemaViolationReason]
          #     Optional. The Pub/Sub message failed schema validation.
          #
          #     Note: The following fields are mutually exclusive: `schema_violation_reason`, `avro_failure_reason`, `api_violation_reason`, `message_transformation_failure_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] message_transformation_failure_reason
          #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::MessageTransformationFailureReason]
          #     Optional. Failure encountered when applying a message transformation to
          #     the Pub/Sub message.
          #
          #     Note: The following fields are mutually exclusive: `message_transformation_failure_reason`, `avro_failure_reason`, `api_violation_reason`, `schema_violation_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class CloudStorageFailure
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Failure when ingesting from an Amazon MSK source.
          # @!attribute [rw] cluster_arn
          #   @return [::String]
          #     Optional. The ARN of the cluster of the topic being ingested from.
          # @!attribute [rw] kafka_topic
          #   @return [::String]
          #     Optional. The name of the Kafka topic being ingested from.
          # @!attribute [rw] partition_id
          #   @return [::Integer]
          #     Optional. The partition ID of the message that failed to be ingested.
          # @!attribute [rw] offset
          #   @return [::Integer]
          #     Optional. The offset within the partition of the message that failed to
          #     be ingested.
          # @!attribute [rw] api_violation_reason
          #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::ApiViolationReason]
          #     Optional. The Pub/Sub API limits prevented the desired message from
          #     being published.
          #
          #     Note: The following fields are mutually exclusive: `api_violation_reason`, `schema_violation_reason`, `message_transformation_failure_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] schema_violation_reason
          #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::SchemaViolationReason]
          #     Optional. The Pub/Sub message failed schema validation.
          #
          #     Note: The following fields are mutually exclusive: `schema_violation_reason`, `api_violation_reason`, `message_transformation_failure_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] message_transformation_failure_reason
          #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::MessageTransformationFailureReason]
          #     Optional. Failure encountered when applying a message transformation to
          #     the Pub/Sub message.
          #
          #     Note: The following fields are mutually exclusive: `message_transformation_failure_reason`, `api_violation_reason`, `schema_violation_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class AwsMskFailureReason
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Failure when ingesting from an Azure Event Hubs source.
          # @!attribute [rw] namespace
          #   @return [::String]
          #     Optional. The namespace containing the event hub being ingested from.
          # @!attribute [rw] event_hub
          #   @return [::String]
          #     Optional. The name of the event hub being ingested from.
          # @!attribute [rw] partition_id
          #   @return [::Integer]
          #     Optional. The partition ID of the message that failed to be ingested.
          # @!attribute [rw] offset
          #   @return [::Integer]
          #     Optional. The offset within the partition of the message that failed to
          #     be ingested.
          # @!attribute [rw] api_violation_reason
          #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::ApiViolationReason]
          #     Optional. The Pub/Sub API limits prevented the desired message from
          #     being published.
          #
          #     Note: The following fields are mutually exclusive: `api_violation_reason`, `schema_violation_reason`, `message_transformation_failure_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] schema_violation_reason
          #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::SchemaViolationReason]
          #     Optional. The Pub/Sub message failed schema validation.
          #
          #     Note: The following fields are mutually exclusive: `schema_violation_reason`, `api_violation_reason`, `message_transformation_failure_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] message_transformation_failure_reason
          #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::MessageTransformationFailureReason]
          #     Optional. Failure encountered when applying a message transformation to
          #     the Pub/Sub message.
          #
          #     Note: The following fields are mutually exclusive: `message_transformation_failure_reason`, `api_violation_reason`, `schema_violation_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class AzureEventHubsFailureReason
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Failure when ingesting from a Confluent Cloud source.
          # @!attribute [rw] cluster_id
          #   @return [::String]
          #     Optional. The cluster ID containing the topic being ingested from.
          # @!attribute [rw] kafka_topic
          #   @return [::String]
          #     Optional. The name of the Kafka topic being ingested from.
          # @!attribute [rw] partition_id
          #   @return [::Integer]
          #     Optional. The partition ID of the message that failed to be ingested.
          # @!attribute [rw] offset
          #   @return [::Integer]
          #     Optional. The offset within the partition of the message that failed to
          #     be ingested.
          # @!attribute [rw] api_violation_reason
          #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::ApiViolationReason]
          #     Optional. The Pub/Sub API limits prevented the desired message from
          #     being published.
          #
          #     Note: The following fields are mutually exclusive: `api_violation_reason`, `schema_violation_reason`, `message_transformation_failure_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] schema_violation_reason
          #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::SchemaViolationReason]
          #     Optional. The Pub/Sub message failed schema validation.
          #
          #     Note: The following fields are mutually exclusive: `schema_violation_reason`, `api_violation_reason`, `message_transformation_failure_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] message_transformation_failure_reason
          #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::MessageTransformationFailureReason]
          #     Optional. Failure encountered when applying a message transformation to
          #     the Pub/Sub message.
          #
          #     Note: The following fields are mutually exclusive: `message_transformation_failure_reason`, `api_violation_reason`, `schema_violation_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class ConfluentCloudFailureReason
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Failure when ingesting from an AWS Kinesis source.
          # @!attribute [rw] stream_arn
          #   @return [::String]
          #     Optional. The stream ARN of the Kinesis stream being ingested from.
          # @!attribute [rw] partition_key
          #   @return [::String]
          #     Optional. The partition key of the message that failed to be ingested.
          # @!attribute [rw] sequence_number
          #   @return [::String]
          #     Optional. The sequence number of the message that failed to be ingested.
          # @!attribute [rw] schema_violation_reason
          #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::SchemaViolationReason]
          #     Optional. The Pub/Sub message failed schema validation.
          #
          #     Note: The following fields are mutually exclusive: `schema_violation_reason`, `message_transformation_failure_reason`, `api_violation_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] message_transformation_failure_reason
          #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::MessageTransformationFailureReason]
          #     Optional. Failure encountered when applying a message transformation to
          #     the Pub/Sub message.
          #
          #     Note: The following fields are mutually exclusive: `message_transformation_failure_reason`, `schema_violation_reason`, `api_violation_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] api_violation_reason
          #   @return [::Google::Cloud::PubSub::V1::IngestionFailureEvent::ApiViolationReason]
          #     Optional. The message failed to be published due to an API violation.
          #     This is only set when the size of the data field of the Kinesis record
          #     is zero.
          #
          #     Note: The following fields are mutually exclusive: `api_violation_reason`, `schema_violation_reason`, `message_transformation_failure_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class AwsKinesisFailureReason
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # User-defined JavaScript function that can transform or filter a Pub/Sub
        # message.
        # @!attribute [rw] function_name
        #   @return [::String]
        #     Required. Name of the JavasScript function that should applied to Pub/Sub
        #     messages.
        # @!attribute [rw] code
        #   @return [::String]
        #     Required. JavaScript code that contains a function `function_name` with the
        #     below signature:
        #
        #     ```
        #       /**
        #       * Transforms a Pub/Sub message.
        #
        #       * @return \\{(Object<string, (string | Object<string, string>)>|null)} - To
        #       * filter a message, return `null`. To transform a message return a map
        #       * with the following keys:
        #       *   - (required) 'data' : \\{string}
        #       *   - (optional) 'attributes' : \\{Object<string, string>}
        #       * Returning empty `attributes` will remove all attributes from the
        #       * message.
        #       *
        #       * @param  \\{(Object<string, (string | Object<string, string>)>} Pub/Sub
        #       * message. Keys:
        #       *   - (required) 'data' : \\{string}
        #       *   - (required) 'attributes' : \\{Object<string, string>}
        #       *
        #       * @param  \\{Object<string, any>} metadata - Pub/Sub message metadata.
        #       * Keys:
        #       *   - (optional) 'message_id'  : \\{string}
        #       *   - (optional) 'publish_time': \\{string} YYYY-MM-DDTHH:MM:SSZ format
        #       *   - (optional) 'ordering_key': \\{string}
        #       */
        #
        #       function <function_name>(message, metadata) {
        #       }
        #     ```
        class JavaScriptUDF
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # All supported message transforms types.
        # @!attribute [rw] javascript_udf
        #   @return [::Google::Cloud::PubSub::V1::JavaScriptUDF]
        #     Optional. JavaScript User Defined Function. If multiple JavaScriptUDF's
        #     are specified on a resource, each must have a unique `function_name`.
        # @!attribute [rw] enabled
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Optional. This field is deprecated, use the `disabled` field to disable
        #     transforms.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     Optional. If true, the transform is disabled and will not be applied to
        #     messages. Defaults to `false`.
        class MessageTransform
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A topic resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Identifier. The name of the topic. It must have the format
        #     `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
        #     and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
        #     underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
        #     signs (`%`). It must be between 3 and 255 characters in length, and it
        #     must not start with `"goog"`.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. See [Creating and managing labels]
        #     (https://cloud.google.com/pubsub/docs/labels).
        # @!attribute [rw] message_storage_policy
        #   @return [::Google::Cloud::PubSub::V1::MessageStoragePolicy]
        #     Optional. Policy constraining the set of Google Cloud Platform regions
        #     where messages published to the topic may be stored. If not present, then
        #     no constraints are in effect.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     Optional. The resource name of the Cloud KMS CryptoKey to be used to
        #     protect access to messages published on this topic.
        #
        #     The expected format is `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        # @!attribute [rw] schema_settings
        #   @return [::Google::Cloud::PubSub::V1::SchemaSettings]
        #     Optional. Settings for validating messages published against a schema.
        # @!attribute [rw] satisfies_pzs
        #   @return [::Boolean]
        #     Optional. Reserved for future use. This field is set only in responses from
        #     the server; it is ignored if it is set in any requests.
        # @!attribute [rw] message_retention_duration
        #   @return [::Google::Protobuf::Duration]
        #     Optional. Indicates the minimum duration to retain a message after it is
        #     published to the topic. If this field is set, messages published to the
        #     topic in the last `message_retention_duration` are always available to
        #     subscribers. For instance, it allows any attached subscription to [seek to
        #     a
        #     timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
        #     that is up to `message_retention_duration` in the past. If this field is
        #     not set, message retention is controlled by settings on individual
        #     subscriptions. Cannot be more than 31 days or less than 10 minutes.
        # @!attribute [r] state
        #   @return [::Google::Cloud::PubSub::V1::Topic::State]
        #     Output only. An output-only field indicating the state of the topic.
        # @!attribute [rw] ingestion_data_source_settings
        #   @return [::Google::Cloud::PubSub::V1::IngestionDataSourceSettings]
        #     Optional. Settings for ingestion from a data source into this topic.
        # @!attribute [rw] message_transforms
        #   @return [::Array<::Google::Cloud::PubSub::V1::MessageTransform>]
        #     Optional. Transforms to be applied to messages published to the topic.
        #     Transforms are applied in the order specified.
        # @!attribute [rw] tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Input only. Immutable. Tag keys/values directly bound to this
        #     resource. For example:
        #       "123/environment": "production",
        #       "123/costCenter": "marketing"
        class Topic
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class TagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The state of the topic.
          module State
            # Default value. This value is unused.
            STATE_UNSPECIFIED = 0

            # The topic does not have any persistent errors.
            ACTIVE = 1

            # Ingestion from the data source has encountered a permanent error.
            # See the more detailed error state in the corresponding ingestion
            # source configuration.
            INGESTION_RESOURCE_ERROR = 2
          end
        end

        # A message that is published by publishers and consumed by subscribers. The
        # message must contain either a non-empty data field or at least one attribute.
        # Note that client libraries represent this object differently
        # depending on the language. See the corresponding [client library
        # documentation](https://cloud.google.com/pubsub/docs/reference/libraries) for
        # more information. See [quotas and limits]
        # (https://cloud.google.com/pubsub/quotas) for more information about message
        # limits.
        # @!attribute [rw] data
        #   @return [::String]
        #     Optional. The message data field. If this field is empty, the message must
        #     contain at least one attribute.
        # @!attribute [rw] attributes
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Attributes for this message. If this field is empty, the message
        #     must contain non-empty data. This can be used to filter messages on the
        #     subscription.
        # @!attribute [rw] message_id
        #   @return [::String]
        #     ID of this message, assigned by the server when the message is published.
        #     Guaranteed to be unique within the topic. This value may be read by a
        #     subscriber that receives a `PubsubMessage` via a `Pull` call or a push
        #     delivery. It must not be populated by the publisher in a `Publish` call.
        # @!attribute [rw] publish_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which the message was published, populated by the server when
        #     it receives the `Publish` call. It must not be populated by the
        #     publisher in a `Publish` call.
        # @!attribute [rw] ordering_key
        #   @return [::String]
        #     Optional. If non-empty, identifies related messages for which publish order
        #     should be respected. If a `Subscription` has `enable_message_ordering` set
        #     to `true`, messages published with the same non-empty `ordering_key` value
        #     will be delivered to subscribers in the order in which they are received by
        #     the Pub/Sub system. All `PubsubMessage`s published in a given
        #     `PublishRequest` must specify the same `ordering_key` value. For more
        #     information, see [ordering
        #     messages](https://cloud.google.com/pubsub/docs/ordering).
        class PubsubMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request for the GetTopic method.
        # @!attribute [rw] topic
        #   @return [::String]
        #     Required. Identifier. The name of the topic to get.
        #     Format is `projects/{project}/topics/{topic}`.
        class GetTopicRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the UpdateTopic method.
        # @!attribute [rw] topic
        #   @return [::Google::Cloud::PubSub::V1::Topic]
        #     Required. The updated topic object.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Indicates which fields in the provided topic to update. Must be
        #     specified and non-empty. Note that if `update_mask` contains
        #     "message_storage_policy" but the `message_storage_policy` is not set in
        #     the `topic` provided above, then the updated value is determined by the
        #     policy configured at the project or organization level.
        class UpdateTopicRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the Publish method.
        # @!attribute [rw] topic
        #   @return [::String]
        #     Required. Identifier. The messages in the request will be published on this
        #     topic. Format is `projects/{project}/topics/{topic}`.
        # @!attribute [rw] messages
        #   @return [::Array<::Google::Cloud::PubSub::V1::PubsubMessage>]
        #     Required. The messages to publish.
        class PublishRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `Publish` method.
        # @!attribute [rw] message_ids
        #   @return [::Array<::String>]
        #     Optional. The server-assigned ID of each published message, in the same
        #     order as the messages in the request. IDs are guaranteed to be unique
        #     within the topic.
        class PublishResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `ListTopics` method.
        # @!attribute [rw] project
        #   @return [::String]
        #     Required. Identifier. The name of the project in which to list topics.
        #     Format is `projects/{project-id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of topics to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value returned by the last `ListTopicsResponse`; indicates
        #     that this is a continuation of a prior `ListTopics` call, and that the
        #     system should return the next page of data.
        class ListTopicsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `ListTopics` method.
        # @!attribute [rw] topics
        #   @return [::Array<::Google::Cloud::PubSub::V1::Topic>]
        #     Optional. The resulting topics.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Optional. If not empty, indicates that there may be more topics that match
        #     the request; this value should be passed in a new `ListTopicsRequest`.
        class ListTopicsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `ListTopicSubscriptions` method.
        # @!attribute [rw] topic
        #   @return [::String]
        #     Required. The name of the topic that subscriptions are attached to.
        #     Format is `projects/{project}/topics/{topic}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of subscription names to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value returned by the last `ListTopicSubscriptionsResponse`;
        #     indicates that this is a continuation of a prior `ListTopicSubscriptions`
        #     call, and that the system should return the next page of data.
        class ListTopicSubscriptionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `ListTopicSubscriptions` method.
        # @!attribute [rw] subscriptions
        #   @return [::Array<::String>]
        #     Optional. The names of subscriptions attached to the topic specified in the
        #     request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Optional. If not empty, indicates that there may be more subscriptions that
        #     match the request; this value should be passed in a new
        #     `ListTopicSubscriptionsRequest` to get more subscriptions.
        class ListTopicSubscriptionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `ListTopicSnapshots` method.
        # @!attribute [rw] topic
        #   @return [::String]
        #     Required. The name of the topic that snapshots are attached to.
        #     Format is `projects/{project}/topics/{topic}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of snapshot names to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value returned by the last `ListTopicSnapshotsResponse`;
        #     indicates that this is a continuation of a prior `ListTopicSnapshots` call,
        #     and that the system should return the next page of data.
        class ListTopicSnapshotsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `ListTopicSnapshots` method.
        # @!attribute [rw] snapshots
        #   @return [::Array<::String>]
        #     Optional. The names of the snapshots that match the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Optional. If not empty, indicates that there may be more snapshots that
        #     match the request; this value should be passed in a new
        #     `ListTopicSnapshotsRequest` to get more snapshots.
        class ListTopicSnapshotsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `DeleteTopic` method.
        # @!attribute [rw] topic
        #   @return [::String]
        #     Required. Identifier. Name of the topic to delete.
        #     Format is `projects/{project}/topics/{topic}`.
        class DeleteTopicRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the DetachSubscription method.
        # @!attribute [rw] subscription
        #   @return [::String]
        #     Required. The subscription to detach.
        #     Format is `projects/{project}/subscriptions/{subscription}`.
        class DetachSubscriptionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the DetachSubscription method.
        # Reserved for future use.
        class DetachSubscriptionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A subscription resource. If none of `push_config`, `bigquery_config`, or
        # `cloud_storage_config` is set, then the subscriber will pull and ack messages
        # using API methods. At most one of these fields may be set.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Identifier. The name of the subscription. It must have the format
        #     `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
        #     start with a letter, and contain only letters (`[A-Za-z]`), numbers
        #     (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
        #     plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
        #     in length, and it must not start with `"goog"`.
        # @!attribute [rw] topic
        #   @return [::String]
        #     Required. The name of the topic from which this subscription is receiving
        #     messages. Format is `projects/{project}/topics/{topic}`. The value of this
        #     field will be `_deleted-topic_` if the topic has been deleted.
        # @!attribute [rw] push_config
        #   @return [::Google::Cloud::PubSub::V1::PushConfig]
        #     Optional. If push delivery is used with this subscription, this field is
        #     used to configure it.
        # @!attribute [rw] bigquery_config
        #   @return [::Google::Cloud::PubSub::V1::BigQueryConfig]
        #     Optional. If delivery to BigQuery is used with this subscription, this
        #     field is used to configure it.
        # @!attribute [rw] cloud_storage_config
        #   @return [::Google::Cloud::PubSub::V1::CloudStorageConfig]
        #     Optional. If delivery to Google Cloud Storage is used with this
        #     subscription, this field is used to configure it.
        # @!attribute [rw] ack_deadline_seconds
        #   @return [::Integer]
        #     Optional. The approximate amount of time (on a best-effort basis) Pub/Sub
        #     waits for the subscriber to acknowledge receipt before resending the
        #     message. In the interval after the message is delivered and before it is
        #     acknowledged, it is considered to be _outstanding_. During that time
        #     period, the message will not be redelivered (on a best-effort basis).
        #
        #     For pull subscriptions, this value is used as the initial value for the ack
        #     deadline. To override this value for a given message, call
        #     `ModifyAckDeadline` with the corresponding `ack_id` if using
        #     non-streaming pull or send the `ack_id` in a
        #     `StreamingModifyAckDeadlineRequest` if using streaming pull.
        #     The minimum custom deadline you can specify is 10 seconds.
        #     The maximum custom deadline you can specify is 600 seconds (10 minutes).
        #     If this parameter is 0, a default value of 10 seconds is used.
        #
        #     For push delivery, this value is also used to set the request timeout for
        #     the call to the push endpoint.
        #
        #     If the subscriber never acknowledges the message, the Pub/Sub
        #     system will eventually redeliver the message.
        # @!attribute [rw] retain_acked_messages
        #   @return [::Boolean]
        #     Optional. Indicates whether to retain acknowledged messages. If true, then
        #     messages are not expunged from the subscription's backlog, even if they are
        #     acknowledged, until they fall out of the `message_retention_duration`
        #     window. This must be true if you would like to [`Seek` to a timestamp]
        #     (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
        #     the past to replay previously-acknowledged messages.
        # @!attribute [rw] message_retention_duration
        #   @return [::Google::Protobuf::Duration]
        #     Optional. How long to retain unacknowledged messages in the subscription's
        #     backlog, from the moment a message is published. If `retain_acked_messages`
        #     is true, then this also configures the retention of acknowledged messages,
        #     and thus configures how far back in time a `Seek` can be done. Defaults to
        #     7 days. Cannot be more than 31 days or less than 10 minutes.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. See [Creating and managing
        #     labels](https://cloud.google.com/pubsub/docs/labels).
        # @!attribute [rw] enable_message_ordering
        #   @return [::Boolean]
        #     Optional. If true, messages published with the same `ordering_key` in
        #     `PubsubMessage` will be delivered to the subscribers in the order in which
        #     they are received by the Pub/Sub system. Otherwise, they may be delivered
        #     in any order.
        # @!attribute [rw] expiration_policy
        #   @return [::Google::Cloud::PubSub::V1::ExpirationPolicy]
        #     Optional. A policy that specifies the conditions for this subscription's
        #     expiration. A subscription is considered active as long as any connected
        #     subscriber is successfully consuming messages from the subscription or is
        #     issuing operations on the subscription. If `expiration_policy` is not set,
        #     a *default policy* with `ttl` of 31 days will be used. The minimum allowed
        #     value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
        #     but `expiration_policy.ttl` is not set, the subscription never expires.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression written in the Pub/Sub [filter
        #     language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
        #     then only `PubsubMessage`s whose `attributes` field matches the filter are
        #     delivered on this subscription. If empty, then no messages are filtered
        #     out.
        # @!attribute [rw] dead_letter_policy
        #   @return [::Google::Cloud::PubSub::V1::DeadLetterPolicy]
        #     Optional. A policy that specifies the conditions for dead lettering
        #     messages in this subscription. If dead_letter_policy is not set, dead
        #     lettering is disabled.
        #
        #     The Pub/Sub service account associated with this subscriptions's
        #     parent project (i.e.,
        #     service-\\{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
        #     permission to Acknowledge() messages on this subscription.
        # @!attribute [rw] retry_policy
        #   @return [::Google::Cloud::PubSub::V1::RetryPolicy]
        #     Optional. A policy that specifies how Pub/Sub retries message delivery for
        #     this subscription.
        #
        #     If not set, the default retry policy is applied. This generally implies
        #     that messages will be retried as soon as possible for healthy subscribers.
        #     RetryPolicy will be triggered on NACKs or acknowledgment deadline exceeded
        #     events for a given message.
        # @!attribute [rw] detached
        #   @return [::Boolean]
        #     Optional. Indicates whether the subscription is detached from its topic.
        #     Detached subscriptions don't receive messages from their topic and don't
        #     retain any backlog. `Pull` and `StreamingPull` requests will return
        #     FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
        #     the endpoint will not be made.
        # @!attribute [rw] enable_exactly_once_delivery
        #   @return [::Boolean]
        #     Optional. If true, Pub/Sub provides the following guarantees for the
        #     delivery of a message with a given value of `message_id` on this
        #     subscription:
        #
        #     * The message sent to a subscriber is guaranteed not to be resent
        #     before the message's acknowledgment deadline expires.
        #     * An acknowledged message will not be resent to a subscriber.
        #
        #     Note that subscribers may still receive multiple copies of a message
        #     when `enable_exactly_once_delivery` is true if the message was published
        #     multiple times by a publisher client. These copies are  considered distinct
        #     by Pub/Sub and have distinct `message_id` values.
        # @!attribute [r] topic_message_retention_duration
        #   @return [::Google::Protobuf::Duration]
        #     Output only. Indicates the minimum duration for which a message is retained
        #     after it is published to the subscription's topic. If this field is set,
        #     messages published to the subscription's topic in the last
        #     `topic_message_retention_duration` are always available to subscribers. See
        #     the `message_retention_duration` field in `Topic`. This field is set only
        #     in responses from the server; it is ignored if it is set in any requests.
        # @!attribute [r] state
        #   @return [::Google::Cloud::PubSub::V1::Subscription::State]
        #     Output only. An output-only field indicating whether or not the
        #     subscription can receive messages.
        # @!attribute [r] analytics_hub_subscription_info
        #   @return [::Google::Cloud::PubSub::V1::Subscription::AnalyticsHubSubscriptionInfo]
        #     Output only. Information about the associated Analytics Hub subscription.
        #     Only set if the subscritpion is created by Analytics Hub.
        # @!attribute [rw] message_transforms
        #   @return [::Array<::Google::Cloud::PubSub::V1::MessageTransform>]
        #     Optional. Transforms to be applied to messages before they are delivered to
        #     subscribers. Transforms are applied in the order specified.
        # @!attribute [rw] tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Input only. Immutable. Tag keys/values directly bound to this
        #     resource. For example:
        #       "123/environment": "production",
        #       "123/costCenter": "marketing"
        class Subscription
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Information about an associated [Analytics Hub
          # subscription](https://cloud.google.com/bigquery/docs/analytics-hub-manage-subscriptions).
          # @!attribute [rw] listing
          #   @return [::String]
          #     Optional. The name of the associated Analytics Hub listing resource.
          #     Pattern:
          #     "projects/\\{project}/locations/\\{location}/dataExchanges/\\{data_exchange}/listings/\\{listing}"
          # @!attribute [rw] subscription
          #   @return [::String]
          #     Optional. The name of the associated Analytics Hub subscription resource.
          #     Pattern:
          #     "projects/\\{project}/locations/\\{location}/subscriptions/\\{subscription}"
          class AnalyticsHubSubscriptionInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class TagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible states for a subscription.
          module State
            # Default value. This value is unused.
            STATE_UNSPECIFIED = 0

            # The subscription can actively receive messages
            ACTIVE = 1

            # The subscription cannot receive messages because of an error with the
            # resource to which it pushes messages. See the more detailed error state
            # in the corresponding configuration.
            RESOURCE_ERROR = 2
          end
        end

        # A policy that specifies how Pub/Sub retries message delivery.
        #
        # Retry delay will be exponential based on provided minimum and maximum
        # backoffs. https://en.wikipedia.org/wiki/Exponential_backoff.
        #
        # RetryPolicy will be triggered on NACKs or acknowledgment deadline exceeded
        # events for a given message.
        #
        # Retry Policy is implemented on a best effort basis. At times, the delay
        # between consecutive deliveries may not match the configuration. That is,
        # delay can be more or less than configured backoff.
        # @!attribute [rw] minimum_backoff
        #   @return [::Google::Protobuf::Duration]
        #     Optional. The minimum delay between consecutive deliveries of a given
        #     message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
        # @!attribute [rw] maximum_backoff
        #   @return [::Google::Protobuf::Duration]
        #     Optional. The maximum delay between consecutive deliveries of a given
        #     message. Value should be between 0 and 600 seconds. Defaults to 600
        #     seconds.
        class RetryPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Dead lettering is done on a best effort basis. The same message might be
        # dead lettered multiple times.
        #
        # If validation on any of the fields fails at subscription creation/updation,
        # the create/update subscription request will fail.
        # @!attribute [rw] dead_letter_topic
        #   @return [::String]
        #     Optional. The name of the topic to which dead letter messages should be
        #     published. Format is `projects/{project}/topics/{topic}`.The Pub/Sub
        #     service account associated with the enclosing subscription's parent project
        #     (i.e., service-\\{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must
        #     have permission to Publish() to this topic.
        #
        #     The operation will fail if the topic does not exist.
        #     Users should ensure that there is a subscription attached to this topic
        #     since messages published to a topic with no subscriptions are lost.
        # @!attribute [rw] max_delivery_attempts
        #   @return [::Integer]
        #     Optional. The maximum number of delivery attempts for any message. The
        #     value must be between 5 and 100.
        #
        #     The number of delivery attempts is defined as 1 + (the sum of number of
        #     NACKs and number of times the acknowledgment deadline has been exceeded
        #     for the message).
        #
        #     A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
        #     client libraries may automatically extend ack_deadlines.
        #
        #     This field will be honored on a best effort basis.
        #
        #     If this parameter is 0, a default value of 5 is used.
        class DeadLetterPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A policy that specifies the conditions for resource expiration (i.e.,
        # automatic resource deletion).
        # @!attribute [rw] ttl
        #   @return [::Google::Protobuf::Duration]
        #     Optional. Specifies the "time-to-live" duration for an associated resource.
        #     The resource expires if it is not active for a period of `ttl`. The
        #     definition of "activity" depends on the type of the associated resource.
        #     The minimum and maximum allowed values for `ttl` depend on the type of the
        #     associated resource, as well. If `ttl` is not set, the associated resource
        #     never expires.
        class ExpirationPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for a push delivery endpoint.
        # @!attribute [rw] push_endpoint
        #   @return [::String]
        #     Optional. A URL locating the endpoint to which messages should be pushed.
        #     For example, a Webhook endpoint might use `https://example.com/push`.
        # @!attribute [rw] attributes
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Endpoint configuration attributes that can be used to control
        #     different aspects of the message delivery.
        #
        #     The only currently supported attribute is `x-goog-version`, which you can
        #     use to change the format of the pushed message. This attribute
        #     indicates the version of the data expected by the endpoint. This
        #     controls the shape of the pushed message (i.e., its fields and metadata).
        #
        #     If not present during the `CreateSubscription` call, it will default to
        #     the version of the Pub/Sub API used to make such call. If not present in a
        #     `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
        #     calls will always return a valid version, even if the subscription was
        #     created without this attribute.
        #
        #     The only supported values for the `x-goog-version` attribute are:
        #
        #     * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
        #     * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
        #
        #     For example:
        #     `attributes { "x-goog-version": "v1" }`
        # @!attribute [rw] oidc_token
        #   @return [::Google::Cloud::PubSub::V1::PushConfig::OidcToken]
        #     Optional. If specified, Pub/Sub will generate and attach an OIDC JWT
        #     token as an `Authorization` header in the HTTP request for every pushed
        #     message.
        # @!attribute [rw] pubsub_wrapper
        #   @return [::Google::Cloud::PubSub::V1::PushConfig::PubsubWrapper]
        #     Optional. When set, the payload to the push endpoint is in the form of
        #     the JSON representation of a PubsubMessage
        #     (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
        #
        #     Note: The following fields are mutually exclusive: `pubsub_wrapper`, `no_wrapper`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] no_wrapper
        #   @return [::Google::Cloud::PubSub::V1::PushConfig::NoWrapper]
        #     Optional. When set, the payload to the push endpoint is not wrapped.
        #
        #     Note: The following fields are mutually exclusive: `no_wrapper`, `pubsub_wrapper`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class PushConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Contains information needed for generating an
          # [OpenID Connect
          # token](https://developers.google.com/identity/protocols/OpenIDConnect).
          # @!attribute [rw] service_account_email
          #   @return [::String]
          #     Optional. [Service account
          #     email](https://cloud.google.com/iam/docs/service-accounts)
          #     used for generating the OIDC token. For more information
          #     on setting up authentication, see
          #     [Push subscriptions](https://cloud.google.com/pubsub/docs/push).
          # @!attribute [rw] audience
          #   @return [::String]
          #     Optional. Audience to be used when generating OIDC token. The audience
          #     claim identifies the recipients that the JWT is intended for. The
          #     audience value is a single case-sensitive string. Having multiple values
          #     (array) for the audience field is not supported. More info about the OIDC
          #     JWT token audience here:
          #     https://tools.ietf.org/html/rfc7519#section-4.1.3 Note: if not specified,
          #     the Push endpoint URL will be used.
          class OidcToken
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The payload to the push endpoint is in the form of the JSON representation
          # of a PubsubMessage
          # (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
          class PubsubWrapper
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Sets the `data` field as the HTTP body for delivery.
          # @!attribute [rw] write_metadata
          #   @return [::Boolean]
          #     Optional. When true, writes the Pub/Sub message metadata to
          #     `x-goog-pubsub-<KEY>:<VAL>` headers of the HTTP request. Writes the
          #     Pub/Sub message attributes to `<KEY>:<VAL>` headers of the HTTP request.
          class NoWrapper
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Configuration for a BigQuery subscription.
        # @!attribute [rw] table
        #   @return [::String]
        #     Optional. The name of the table to which to write data, of the form
        #     \\{projectId}.\\{datasetId}.\\{tableId}
        # @!attribute [rw] use_topic_schema
        #   @return [::Boolean]
        #     Optional. When true, use the topic's schema as the columns to write to in
        #     BigQuery, if it exists. `use_topic_schema` and `use_table_schema` cannot be
        #     enabled at the same time.
        # @!attribute [rw] write_metadata
        #   @return [::Boolean]
        #     Optional. When true, write the subscription name, message_id, publish_time,
        #     attributes, and ordering_key to additional columns in the table. The
        #     subscription name, message_id, and publish_time fields are put in their own
        #     columns while all other message properties (other than data) are written to
        #     a JSON object in the attributes column.
        # @!attribute [rw] drop_unknown_fields
        #   @return [::Boolean]
        #     Optional. When true and use_topic_schema is true, any fields that are a
        #     part of the topic schema that are not part of the BigQuery table schema are
        #     dropped when writing to BigQuery. Otherwise, the schemas must be kept in
        #     sync and any messages with extra fields are not written and remain in the
        #     subscription's backlog.
        # @!attribute [r] state
        #   @return [::Google::Cloud::PubSub::V1::BigQueryConfig::State]
        #     Output only. An output-only field that indicates whether or not the
        #     subscription can receive messages.
        # @!attribute [rw] use_table_schema
        #   @return [::Boolean]
        #     Optional. When true, use the BigQuery table's schema as the columns to
        #     write to in BigQuery. `use_table_schema` and `use_topic_schema` cannot be
        #     enabled at the same time.
        # @!attribute [rw] service_account_email
        #   @return [::String]
        #     Optional. The service account to use to write to BigQuery. The subscription
        #     creator or updater that specifies this field must have
        #     `iam.serviceAccounts.actAs` permission on the service account. If not
        #     specified, the Pub/Sub [service
        #     agent](https://cloud.google.com/iam/docs/service-agents),
        #     service-\\{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        class BigQueryConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible states for a BigQuery subscription.
          module State
            # Default value. This value is unused.
            STATE_UNSPECIFIED = 0

            # The subscription can actively send messages to BigQuery
            ACTIVE = 1

            # Cannot write to the BigQuery table because of permission denied errors.
            # This can happen if
            # - Pub/Sub SA has not been granted the [appropriate BigQuery IAM
            # permissions](https://cloud.google.com/pubsub/docs/create-subscription#assign_bigquery_service_account)
            # - bigquery.googleapis.com API is not enabled for the project
            # ([instructions](https://cloud.google.com/service-usage/docs/enable-disable))
            PERMISSION_DENIED = 2

            # Cannot write to the BigQuery table because it does not exist.
            NOT_FOUND = 3

            # Cannot write to the BigQuery table due to a schema mismatch.
            SCHEMA_MISMATCH = 4

            # Cannot write to the destination because enforce_in_transit is set to true
            # and the destination locations are not in the allowed regions.
            IN_TRANSIT_LOCATION_RESTRICTION = 5
          end
        end

        # Configuration for a Cloud Storage subscription.
        # @!attribute [rw] bucket
        #   @return [::String]
        #     Required. User-provided name for the Cloud Storage bucket.
        #     The bucket must be created by the user. The bucket name must be without
        #     any prefix like "gs://". See the [bucket naming
        #     requirements] (https://cloud.google.com/storage/docs/buckets#naming).
        # @!attribute [rw] filename_prefix
        #   @return [::String]
        #     Optional. User-provided prefix for Cloud Storage filename. See the [object
        #     naming requirements](https://cloud.google.com/storage/docs/objects#naming).
        # @!attribute [rw] filename_suffix
        #   @return [::String]
        #     Optional. User-provided suffix for Cloud Storage filename. See the [object
        #     naming requirements](https://cloud.google.com/storage/docs/objects#naming).
        #     Must not end in "/".
        # @!attribute [rw] filename_datetime_format
        #   @return [::String]
        #     Optional. User-provided format string specifying how to represent datetimes
        #     in Cloud Storage filenames. See the [datetime format
        #     guidance](https://cloud.google.com/pubsub/docs/create-cloudstorage-subscription#file_names).
        # @!attribute [rw] text_config
        #   @return [::Google::Cloud::PubSub::V1::CloudStorageConfig::TextConfig]
        #     Optional. If set, message data will be written to Cloud Storage in text
        #     format.
        #
        #     Note: The following fields are mutually exclusive: `text_config`, `avro_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] avro_config
        #   @return [::Google::Cloud::PubSub::V1::CloudStorageConfig::AvroConfig]
        #     Optional. If set, message data will be written to Cloud Storage in Avro
        #     format.
        #
        #     Note: The following fields are mutually exclusive: `avro_config`, `text_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] max_duration
        #   @return [::Google::Protobuf::Duration]
        #     Optional. The maximum duration that can elapse before a new Cloud Storage
        #     file is created. Min 1 minute, max 10 minutes, default 5 minutes. May not
        #     exceed the subscription's acknowledgment deadline.
        # @!attribute [rw] max_bytes
        #   @return [::Integer]
        #     Optional. The maximum bytes that can be written to a Cloud Storage file
        #     before a new file is created. Min 1 KB, max 10 GiB. The max_bytes limit may
        #     be exceeded in cases where messages are larger than the limit.
        # @!attribute [rw] max_messages
        #   @return [::Integer]
        #     Optional. The maximum number of messages that can be written to a Cloud
        #     Storage file before a new file is created. Min 1000 messages.
        # @!attribute [r] state
        #   @return [::Google::Cloud::PubSub::V1::CloudStorageConfig::State]
        #     Output only. An output-only field that indicates whether or not the
        #     subscription can receive messages.
        # @!attribute [rw] service_account_email
        #   @return [::String]
        #     Optional. The service account to use to write to Cloud Storage. The
        #     subscription creator or updater that specifies this field must have
        #     `iam.serviceAccounts.actAs` permission on the service account. If not
        #     specified, the Pub/Sub
        #     [service agent](https://cloud.google.com/iam/docs/service-agents),
        #     service-\\{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
        class CloudStorageConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration for writing message data in text format.
          # Message payloads will be written to files as raw text, separated by a
          # newline.
          class TextConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for writing message data in Avro format.
          # Message payloads and metadata will be written to files as an Avro binary.
          # @!attribute [rw] write_metadata
          #   @return [::Boolean]
          #     Optional. When true, write the subscription name, message_id,
          #     publish_time, attributes, and ordering_key as additional fields in the
          #     output. The subscription name, message_id, and publish_time fields are
          #     put in their own fields while all other message properties other than
          #     data (for example, an ordering_key, if present) are added as entries in
          #     the attributes map.
          # @!attribute [rw] use_topic_schema
          #   @return [::Boolean]
          #     Optional. When true, the output Cloud Storage file will be serialized
          #     using the topic schema, if it exists.
          class AvroConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible states for a Cloud Storage subscription.
          module State
            # Default value. This value is unused.
            STATE_UNSPECIFIED = 0

            # The subscription can actively send messages to Cloud Storage.
            ACTIVE = 1

            # Cannot write to the Cloud Storage bucket because of permission denied
            # errors.
            PERMISSION_DENIED = 2

            # Cannot write to the Cloud Storage bucket because it does not exist.
            NOT_FOUND = 3

            # Cannot write to the destination because enforce_in_transit is set to true
            # and the destination locations are not in the allowed regions.
            IN_TRANSIT_LOCATION_RESTRICTION = 4

            # Cannot write to the Cloud Storage bucket due to an incompatibility
            # between the topic schema and subscription settings.
            SCHEMA_MISMATCH = 5
          end
        end

        # A message and its corresponding acknowledgment ID.
        # @!attribute [rw] ack_id
        #   @return [::String]
        #     Optional. This ID can be used to acknowledge the received message.
        # @!attribute [rw] message
        #   @return [::Google::Cloud::PubSub::V1::PubsubMessage]
        #     Optional. The message.
        # @!attribute [rw] delivery_attempt
        #   @return [::Integer]
        #     Optional. The approximate number of times that Pub/Sub has attempted to
        #     deliver the associated message to a subscriber.
        #
        #     More precisely, this is 1 + (number of NACKs) +
        #     (number of ack_deadline exceeds) for this message.
        #
        #     A NACK is any call to ModifyAckDeadline with a 0 deadline. An ack_deadline
        #     exceeds event is whenever a message is not acknowledged within
        #     ack_deadline. Note that ack_deadline is initially
        #     Subscription.ackDeadlineSeconds, but may get extended automatically by
        #     the client library.
        #
        #     Upon the first delivery of a given message, `delivery_attempt` will have a
        #     value of 1. The value is calculated at best effort and is approximate.
        #
        #     If a DeadLetterPolicy is not set on the subscription, this will be 0.
        class ReceivedMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the GetSubscription method.
        # @!attribute [rw] subscription
        #   @return [::String]
        #     Required. Identifier. The name of the subscription to get.
        #     Format is `projects/{project}/subscriptions/{sub}`.
        class GetSubscriptionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the UpdateSubscription method.
        # @!attribute [rw] subscription
        #   @return [::Google::Cloud::PubSub::V1::Subscription]
        #     Required. The updated subscription object.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Indicates which fields in the provided subscription to update.
        #     Must be specified and non-empty.
        class UpdateSubscriptionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `ListSubscriptions` method.
        # @!attribute [rw] project
        #   @return [::String]
        #     Required. Identifier. The name of the project in which to list
        #     subscriptions. Format is `projects/{project-id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of subscriptions to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value returned by the last `ListSubscriptionsResponse`;
        #     indicates that this is a continuation of a prior `ListSubscriptions` call,
        #     and that the system should return the next page of data.
        class ListSubscriptionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `ListSubscriptions` method.
        # @!attribute [rw] subscriptions
        #   @return [::Array<::Google::Cloud::PubSub::V1::Subscription>]
        #     Optional. The subscriptions that match the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Optional. If not empty, indicates that there may be more subscriptions that
        #     match the request; this value should be passed in a new
        #     `ListSubscriptionsRequest` to get more subscriptions.
        class ListSubscriptionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the DeleteSubscription method.
        # @!attribute [rw] subscription
        #   @return [::String]
        #     Required. Identifier. The subscription to delete.
        #     Format is `projects/{project}/subscriptions/{sub}`.
        class DeleteSubscriptionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the ModifyPushConfig method.
        # @!attribute [rw] subscription
        #   @return [::String]
        #     Required. The name of the subscription.
        #     Format is `projects/{project}/subscriptions/{sub}`.
        # @!attribute [rw] push_config
        #   @return [::Google::Cloud::PubSub::V1::PushConfig]
        #     Required. The push configuration for future deliveries.
        #
        #     An empty `pushConfig` indicates that the Pub/Sub system should
        #     stop pushing messages from the given subscription and allow
        #     messages to be pulled and acknowledged - effectively pausing
        #     the subscription if `Pull` or `StreamingPull` is not called.
        class ModifyPushConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `Pull` method.
        # @!attribute [rw] subscription
        #   @return [::String]
        #     Required. The subscription from which messages should be pulled.
        #     Format is `projects/{project}/subscriptions/{sub}`.
        # @!attribute [rw] return_immediately
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Optional. If this field set to true, the system will respond immediately
        #     even if it there are no messages available to return in the `Pull`
        #     response. Otherwise, the system may wait (for a bounded amount of time)
        #     until at least one message is available, rather than returning no messages.
        #     Warning: setting this field to `true` is discouraged because it adversely
        #     impacts the performance of `Pull` operations. We recommend that users do
        #     not set this field.
        # @!attribute [rw] max_messages
        #   @return [::Integer]
        #     Required. The maximum number of messages to return for this request. Must
        #     be a positive integer. The Pub/Sub system may return fewer than the number
        #     specified.
        class PullRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `Pull` method.
        # @!attribute [rw] received_messages
        #   @return [::Array<::Google::Cloud::PubSub::V1::ReceivedMessage>]
        #     Optional. Received Pub/Sub messages. The list will be empty if there are no
        #     more messages available in the backlog, or if no messages could be returned
        #     before the request timeout. For JSON, the response can be entirely
        #     empty. The Pub/Sub system may return fewer than the `maxMessages` requested
        #     even if there are more messages available in the backlog.
        class PullResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the ModifyAckDeadline method.
        # @!attribute [rw] subscription
        #   @return [::String]
        #     Required. The name of the subscription.
        #     Format is `projects/{project}/subscriptions/{sub}`.
        # @!attribute [rw] ack_ids
        #   @return [::Array<::String>]
        #     Required. List of acknowledgment IDs.
        # @!attribute [rw] ack_deadline_seconds
        #   @return [::Integer]
        #     Required. The new ack deadline with respect to the time this request was
        #     sent to the Pub/Sub system. For example, if the value is 10, the new ack
        #     deadline will expire 10 seconds after the `ModifyAckDeadline` call was
        #     made. Specifying zero might immediately make the message available for
        #     delivery to another subscriber client. This typically results in an
        #     increase in the rate of message redeliveries (that is, duplicates).
        #     The minimum deadline you can specify is 0 seconds.
        #     The maximum deadline you can specify in a single request is 600 seconds
        #     (10 minutes).
        class ModifyAckDeadlineRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the Acknowledge method.
        # @!attribute [rw] subscription
        #   @return [::String]
        #     Required. The subscription whose message is being acknowledged.
        #     Format is `projects/{project}/subscriptions/{sub}`.
        # @!attribute [rw] ack_ids
        #   @return [::Array<::String>]
        #     Required. The acknowledgment ID for the messages being acknowledged that
        #     was returned by the Pub/Sub system in the `Pull` response. Must not be
        #     empty.
        class AcknowledgeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `StreamingPull` streaming RPC method. This request is used to
        # establish the initial stream as well as to stream acknowledgments and ack
        # deadline modifications from the client to the server.
        # @!attribute [rw] subscription
        #   @return [::String]
        #     Required. The subscription for which to initialize the new stream. This
        #     must be provided in the first request on the stream, and must not be set in
        #     subsequent requests from client to server.
        #     Format is `projects/{project}/subscriptions/{sub}`.
        # @!attribute [rw] ack_ids
        #   @return [::Array<::String>]
        #     Optional. List of acknowledgment IDs for acknowledging previously received
        #     messages (received on this stream or a different stream). If an ack ID has
        #     expired, the corresponding message may be redelivered later. Acknowledging
        #     a message more than once will not result in an error. If the acknowledgment
        #     ID is malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
        # @!attribute [rw] modify_deadline_seconds
        #   @return [::Array<::Integer>]
        #     Optional. The list of new ack deadlines for the IDs listed in
        #     `modify_deadline_ack_ids`. The size of this list must be the same as the
        #     size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
        #     with `INVALID_ARGUMENT`. Each element in this list is applied to the
        #     element in the same position in `modify_deadline_ack_ids`. The new ack
        #     deadline is with respect to the time this request was sent to the Pub/Sub
        #     system. Must be >= 0. For example, if the value is 10, the new ack deadline
        #     will expire 10 seconds after this request is received. If the value is 0,
        #     the message is immediately made available for another streaming or
        #     non-streaming pull request. If the value is < 0 (an error), the stream will
        #     be aborted with status `INVALID_ARGUMENT`.
        # @!attribute [rw] modify_deadline_ack_ids
        #   @return [::Array<::String>]
        #     Optional. List of acknowledgment IDs whose deadline will be modified based
        #     on the corresponding element in `modify_deadline_seconds`. This field can
        #     be used to indicate that more time is needed to process a message by the
        #     subscriber, or to make the message available for redelivery if the
        #     processing was interrupted.
        # @!attribute [rw] stream_ack_deadline_seconds
        #   @return [::Integer]
        #     Required. The ack deadline to use for the stream. This must be provided in
        #     the first request on the stream, but it can also be updated on subsequent
        #     requests from client to server. The minimum deadline you can specify is 10
        #     seconds. The maximum deadline you can specify is 600 seconds (10 minutes).
        # @!attribute [rw] client_id
        #   @return [::String]
        #     Optional. A unique identifier that is used to distinguish client instances
        #     from each other. Only needs to be provided on the initial request. When a
        #     stream disconnects and reconnects for the same stream, the client_id should
        #     be set to the same value so that state associated with the old stream can
        #     be transferred to the new stream. The same client_id should not be used for
        #     different client instances.
        # @!attribute [rw] max_outstanding_messages
        #   @return [::Integer]
        #     Optional. Flow control settings for the maximum number of outstanding
        #     messages. When there are `max_outstanding_messages` currently sent to the
        #     streaming pull client that have not yet been acked or nacked, the server
        #     stops sending more messages. The sending of messages resumes once the
        #     number of outstanding messages is less than this value. If the value is
        #     <= 0, there is no limit to the number of outstanding messages. This
        #     property can only be set on the initial StreamingPullRequest. If it is set
        #     on a subsequent request, the stream will be aborted with status
        #     `INVALID_ARGUMENT`.
        # @!attribute [rw] max_outstanding_bytes
        #   @return [::Integer]
        #     Optional. Flow control settings for the maximum number of outstanding
        #     bytes. When there are `max_outstanding_bytes` or more worth of messages
        #     currently sent to the streaming pull client that have not yet been acked or
        #     nacked, the server will stop sending more messages. The sending of messages
        #     resumes once the number of outstanding bytes is less than this value. If
        #     the value is <= 0, there is no limit to the number of outstanding bytes.
        #     This property can only be set on the initial StreamingPullRequest. If it is
        #     set on a subsequent request, the stream will be aborted with status
        #     `INVALID_ARGUMENT`.
        # @!attribute [rw] protocol_version
        #   @return [::Integer]
        #     Optional. The protocol version used by the client. This property can only
        #     be set on the initial StreamingPullRequest. If it is set on a subsequent
        #     request, the stream will be aborted with status `INVALID_ARGUMENT`.
        class StreamingPullRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `StreamingPull` method. This response is used to stream
        # messages from the server to the client.
        # @!attribute [rw] received_messages
        #   @return [::Array<::Google::Cloud::PubSub::V1::ReceivedMessage>]
        #     Optional. Received Pub/Sub messages.
        # @!attribute [rw] acknowledge_confirmation
        #   @return [::Google::Cloud::PubSub::V1::StreamingPullResponse::AcknowledgeConfirmation]
        #     Optional. This field will only be set if `enable_exactly_once_delivery` is
        #     set to `true` and is not guaranteed to be populated.
        # @!attribute [rw] modify_ack_deadline_confirmation
        #   @return [::Google::Cloud::PubSub::V1::StreamingPullResponse::ModifyAckDeadlineConfirmation]
        #     Optional. This field will only be set if `enable_exactly_once_delivery` is
        #     set to `true` and is not guaranteed to be populated.
        # @!attribute [rw] subscription_properties
        #   @return [::Google::Cloud::PubSub::V1::StreamingPullResponse::SubscriptionProperties]
        #     Optional. Properties associated with this subscription.
        class StreamingPullResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Acknowledgment IDs sent in one or more previous requests to acknowledge a
          # previously received message.
          # @!attribute [rw] ack_ids
          #   @return [::Array<::String>]
          #     Optional. Successfully processed acknowledgment IDs.
          # @!attribute [rw] invalid_ack_ids
          #   @return [::Array<::String>]
          #     Optional. List of acknowledgment IDs that were malformed or whose
          #     acknowledgment deadline has expired.
          # @!attribute [rw] unordered_ack_ids
          #   @return [::Array<::String>]
          #     Optional. List of acknowledgment IDs that were out of order.
          # @!attribute [rw] temporary_failed_ack_ids
          #   @return [::Array<::String>]
          #     Optional. List of acknowledgment IDs that failed processing with
          #     temporary issues.
          class AcknowledgeConfirmation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Acknowledgment IDs sent in one or more previous requests to modify the
          # deadline for a specific message.
          # @!attribute [rw] ack_ids
          #   @return [::Array<::String>]
          #     Optional. Successfully processed acknowledgment IDs.
          # @!attribute [rw] invalid_ack_ids
          #   @return [::Array<::String>]
          #     Optional. List of acknowledgment IDs that were malformed or whose
          #     acknowledgment deadline has expired.
          # @!attribute [rw] temporary_failed_ack_ids
          #   @return [::Array<::String>]
          #     Optional. List of acknowledgment IDs that failed processing with
          #     temporary issues.
          class ModifyAckDeadlineConfirmation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Subscription properties sent as part of the response.
          # @!attribute [rw] exactly_once_delivery_enabled
          #   @return [::Boolean]
          #     Optional. True iff exactly once delivery is enabled for this
          #     subscription.
          # @!attribute [rw] message_ordering_enabled
          #   @return [::Boolean]
          #     Optional. True iff message ordering is enabled for this subscription.
          class SubscriptionProperties
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request for the `CreateSnapshot` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Identifier. User-provided name for this snapshot. If the name is
        #     not provided in the request, the server will assign a random name for this
        #     snapshot on the same project as the subscription. Note that for REST API
        #     requests, you must specify a name.  See the [resource name
        #     rules](https://cloud.google.com/pubsub/docs/pubsub-basics#resource_names).
        #     Format is `projects/{project}/snapshots/{snap}`.
        # @!attribute [rw] subscription
        #   @return [::String]
        #     Required. The subscription whose backlog the snapshot retains.
        #     Specifically, the created snapshot is guaranteed to retain:
        #      (a) The existing backlog on the subscription. More precisely, this is
        #          defined as the messages in the subscription's backlog that are
        #          unacknowledged upon the successful completion of the
        #          `CreateSnapshot` request; as well as:
        #      (b) Any messages published to the subscription's topic following the
        #          successful completion of the CreateSnapshot request.
        #     Format is `projects/{project}/subscriptions/{sub}`.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. See [Creating and managing
        #     labels](https://cloud.google.com/pubsub/docs/labels).
        # @!attribute [rw] tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Input only. Immutable. Tag keys/values directly bound to this
        #     resource. For example:
        #       "123/environment": "production",
        #       "123/costCenter": "marketing"
        class CreateSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class TagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request for the UpdateSnapshot method.
        # @!attribute [rw] snapshot
        #   @return [::Google::Cloud::PubSub::V1::Snapshot]
        #     Required. The updated snapshot object.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Indicates which fields in the provided snapshot to update.
        #     Must be specified and non-empty.
        class UpdateSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A snapshot resource. Snapshots are used in
        # [Seek](https://cloud.google.com/pubsub/docs/replay-overview)
        # operations, which allow you to manage message acknowledgments in bulk. That
        # is, you can set the acknowledgment state of messages in an existing
        # subscription to the state captured by a snapshot.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. The name of the snapshot.
        # @!attribute [rw] topic
        #   @return [::String]
        #     Optional. The name of the topic from which this snapshot is retaining
        #     messages.
        # @!attribute [rw] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. The snapshot is guaranteed to exist up until this time.
        #     A newly-created snapshot expires no later than 7 days from the time of its
        #     creation. Its exact lifetime is determined at creation by the existing
        #     backlog in the source subscription. Specifically, the lifetime of the
        #     snapshot is `7 days - (age of oldest unacked message in the subscription)`.
        #     For example, consider a subscription whose oldest unacked message is 3 days
        #     old. If a snapshot is created from this subscription, the snapshot -- which
        #     will always capture this 3-day-old backlog as long as the snapshot
        #     exists -- will expire in 4 days. The service will refuse to create a
        #     snapshot that would expire in less than 1 hour after creation.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. See [Creating and managing labels]
        #     (https://cloud.google.com/pubsub/docs/labels).
        class Snapshot
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request for the GetSnapshot method.
        # @!attribute [rw] snapshot
        #   @return [::String]
        #     Required. Identifier. The name of the snapshot to get.
        #     Format is `projects/{project}/snapshots/{snap}`.
        class GetSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `ListSnapshots` method.
        # @!attribute [rw] project
        #   @return [::String]
        #     Required. Identifier. The name of the project in which to list snapshots.
        #     Format is `projects/{project-id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of snapshots to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value returned by the last `ListSnapshotsResponse`; indicates
        #     that this is a continuation of a prior `ListSnapshots` call, and that the
        #     system should return the next page of data.
        class ListSnapshotsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `ListSnapshots` method.
        # @!attribute [rw] snapshots
        #   @return [::Array<::Google::Cloud::PubSub::V1::Snapshot>]
        #     Optional. The resulting snapshots.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Optional. If not empty, indicates that there may be more snapshot that
        #     match the request; this value should be passed in a new
        #     `ListSnapshotsRequest`.
        class ListSnapshotsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `DeleteSnapshot` method.
        # @!attribute [rw] snapshot
        #   @return [::String]
        #     Required. Identifier. The name of the snapshot to delete.
        #     Format is `projects/{project}/snapshots/{snap}`.
        class DeleteSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `Seek` method.
        # @!attribute [rw] subscription
        #   @return [::String]
        #     Required. The subscription to affect.
        # @!attribute [rw] time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. The time to seek to.
        #     Messages retained in the subscription that were published before this
        #     time are marked as acknowledged, and messages retained in the
        #     subscription that were published after this time are marked as
        #     unacknowledged. Note that this operation affects only those messages
        #     retained in the subscription (configured by the combination of
        #     `message_retention_duration` and `retain_acked_messages`). For example,
        #     if `time` corresponds to a point before the message retention
        #     window (or to a point before the system's notion of the subscription
        #     creation time), only retained messages will be marked as unacknowledged,
        #     and already-expunged messages will not be restored.
        #
        #     Note: The following fields are mutually exclusive: `time`, `snapshot`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] snapshot
        #   @return [::String]
        #     Optional. The snapshot to seek to. The snapshot's topic must be the same
        #     as that of the provided subscription. Format is
        #     `projects/{project}/snapshots/{snap}`.
        #
        #     Note: The following fields are mutually exclusive: `snapshot`, `time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class SeekRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `Seek` method (this response is empty).
        class SeekResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
