# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/pubsub/v1/pubsub_pb"
require "google/iam/v1"

module Google
  module Cloud
    module PubSub
      module V1
        module TopicAdmin
          ##
          # Client for the TopicAdmin service.
          #
          # The service that an application uses to manipulate topics, and to send
          # messages to a topic.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "pubsub.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :topic_admin_stub

            ##
            # Configure the TopicAdmin Client class.
            #
            # See {::Google::Cloud::PubSub::V1::TopicAdmin::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all TopicAdmin clients
            #   ::Google::Cloud::PubSub::V1::TopicAdmin::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "PubSub", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_topic.timeout = 60.0
                default_config.rpcs.create_topic.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_topic.timeout = 60.0
                default_config.rpcs.update_topic.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.publish.timeout = 60.0
                default_config.rpcs.publish.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 4, retry_codes: [10, 1, 13, 8, 2, 14, 4]
                }

                default_config.rpcs.get_topic.timeout = 60.0
                default_config.rpcs.get_topic.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [2, 10, 14]
                }

                default_config.rpcs.list_topics.timeout = 60.0
                default_config.rpcs.list_topics.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [2, 10, 14]
                }

                default_config.rpcs.list_topic_subscriptions.timeout = 60.0
                default_config.rpcs.list_topic_subscriptions.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [2, 10, 14]
                }

                default_config.rpcs.list_topic_snapshots.timeout = 60.0
                default_config.rpcs.list_topic_snapshots.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [2, 10, 14]
                }

                default_config.rpcs.delete_topic.timeout = 60.0
                default_config.rpcs.delete_topic.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.detach_subscription.timeout = 60.0
                default_config.rpcs.detach_subscription.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the TopicAdmin Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::PubSub::V1::TopicAdmin::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @topic_admin_stub.universe_domain
            end

            ##
            # Create a new TopicAdmin client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::PubSub::V1::TopicAdmin::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::PubSub::V1::TopicAdmin::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the TopicAdmin client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/pubsub/v1/pubsub_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @topic_admin_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::PubSub::V1::Publisher::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @topic_admin_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @topic_admin_stub.endpoint
                config.universe_domain = @topic_admin_stub.universe_domain
                config.logger = @topic_admin_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @topic_admin_stub.logger
            end

            # Service calls

            ##
            # Creates the given topic with the given name. See the [resource name rules]
            # (https://cloud.google.com/pubsub/docs/pubsub-basics#resource_names).
            #
            # @overload create_topic(request, options = nil)
            #   Pass arguments to `create_topic` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::Topic} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::Topic, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_topic(name: nil, labels: nil, message_storage_policy: nil, kms_key_name: nil, schema_settings: nil, satisfies_pzs: nil, message_retention_duration: nil, ingestion_data_source_settings: nil, message_transforms: nil, tags: nil)
            #   Pass arguments to `create_topic` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Identifier. The name of the topic. It must have the format
            #     `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
            #     and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
            #     underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
            #     signs (`%`). It must be between 3 and 255 characters in length, and it
            #     must not start with `"goog"`.
            #   @param labels [::Hash{::String => ::String}]
            #     Optional. See [Creating and managing labels]
            #     (https://cloud.google.com/pubsub/docs/labels).
            #   @param message_storage_policy [::Google::Cloud::PubSub::V1::MessageStoragePolicy, ::Hash]
            #     Optional. Policy constraining the set of Google Cloud Platform regions
            #     where messages published to the topic may be stored. If not present, then
            #     no constraints are in effect.
            #   @param kms_key_name [::String]
            #     Optional. The resource name of the Cloud KMS CryptoKey to be used to
            #     protect access to messages published on this topic.
            #
            #     The expected format is `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
            #   @param schema_settings [::Google::Cloud::PubSub::V1::SchemaSettings, ::Hash]
            #     Optional. Settings for validating messages published against a schema.
            #   @param satisfies_pzs [::Boolean]
            #     Optional. Reserved for future use. This field is set only in responses from
            #     the server; it is ignored if it is set in any requests.
            #   @param message_retention_duration [::Google::Protobuf::Duration, ::Hash]
            #     Optional. Indicates the minimum duration to retain a message after it is
            #     published to the topic. If this field is set, messages published to the
            #     topic in the last `message_retention_duration` are always available to
            #     subscribers. For instance, it allows any attached subscription to [seek to
            #     a
            #     timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
            #     that is up to `message_retention_duration` in the past. If this field is
            #     not set, message retention is controlled by settings on individual
            #     subscriptions. Cannot be more than 31 days or less than 10 minutes.
            #   @param ingestion_data_source_settings [::Google::Cloud::PubSub::V1::IngestionDataSourceSettings, ::Hash]
            #     Optional. Settings for ingestion from a data source into this topic.
            #   @param message_transforms [::Array<::Google::Cloud::PubSub::V1::MessageTransform, ::Hash>]
            #     Optional. Transforms to be applied to messages published to the topic.
            #     Transforms are applied in the order specified.
            #   @param tags [::Hash{::String => ::String}]
            #     Optional. Input only. Immutable. Tag keys/values directly bound to this
            #     resource. For example:
            #       "123/environment": "production",
            #       "123/costCenter": "marketing"
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::Topic]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::Topic]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::TopicAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::Topic.new
            #
            #   # Call the create_topic method.
            #   result = client.create_topic request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::Topic.
            #   p result
            #
            def create_topic request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::Topic

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_topic.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_topic.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_topic.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @topic_admin_stub.call_rpc :create_topic, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an existing topic by updating the fields specified in the update
            # mask. Note that certain properties of a topic are not modifiable.
            #
            # @overload update_topic(request, options = nil)
            #   Pass arguments to `update_topic` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::UpdateTopicRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::UpdateTopicRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_topic(topic: nil, update_mask: nil)
            #   Pass arguments to `update_topic` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param topic [::Google::Cloud::PubSub::V1::Topic, ::Hash]
            #     Required. The updated topic object.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Indicates which fields in the provided topic to update. Must be
            #     specified and non-empty. Note that if `update_mask` contains
            #     "message_storage_policy" but the `message_storage_policy` is not set in
            #     the `topic` provided above, then the updated value is determined by the
            #     policy configured at the project or organization level.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::Topic]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::Topic]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::TopicAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::UpdateTopicRequest.new
            #
            #   # Call the update_topic method.
            #   result = client.update_topic request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::Topic.
            #   p result
            #
            def update_topic request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::UpdateTopicRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_topic.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.topic&.name
                header_params["topic.name"] = request.topic.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_topic.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_topic.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @topic_admin_stub.call_rpc :update_topic, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Adds one or more messages to the topic. Returns `NOT_FOUND` if the topic
            # does not exist.
            #
            # @overload publish(request, options = nil)
            #   Pass arguments to `publish` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::PublishRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::PublishRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload publish(topic: nil, messages: nil)
            #   Pass arguments to `publish` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param topic [::String]
            #     Required. Identifier. The messages in the request will be published on this
            #     topic. Format is `projects/{project}/topics/{topic}`.
            #   @param messages [::Array<::Google::Cloud::PubSub::V1::PubsubMessage, ::Hash>]
            #     Required. The messages to publish.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::PublishResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::PublishResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::TopicAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::PublishRequest.new
            #
            #   # Call the publish method.
            #   result = client.publish request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::PublishResponse.
            #   p result
            #
            def publish request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::PublishRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.publish.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.topic
                header_params["topic"] = request.topic
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.publish.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.publish.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @topic_admin_stub.call_rpc :publish, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the configuration of a topic.
            #
            # @overload get_topic(request, options = nil)
            #   Pass arguments to `get_topic` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::GetTopicRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::GetTopicRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_topic(topic: nil)
            #   Pass arguments to `get_topic` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param topic [::String]
            #     Required. Identifier. The name of the topic to get.
            #     Format is `projects/{project}/topics/{topic}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::Topic]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::Topic]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::TopicAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::GetTopicRequest.new
            #
            #   # Call the get_topic method.
            #   result = client.get_topic request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::Topic.
            #   p result
            #
            def get_topic request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::GetTopicRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_topic.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.topic
                header_params["topic"] = request.topic
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_topic.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_topic.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @topic_admin_stub.call_rpc :get_topic, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists matching topics.
            #
            # @overload list_topics(request, options = nil)
            #   Pass arguments to `list_topics` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::ListTopicsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::ListTopicsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_topics(project: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_topics` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project [::String]
            #     Required. Identifier. The name of the project in which to list topics.
            #     Format is `projects/{project-id}`.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of topics to return.
            #   @param page_token [::String]
            #     Optional. The value returned by the last `ListTopicsResponse`; indicates
            #     that this is a continuation of a prior `ListTopics` call, and that the
            #     system should return the next page of data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::PubSub::V1::Topic>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::PubSub::V1::Topic>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::TopicAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::ListTopicsRequest.new
            #
            #   # Call the list_topics method.
            #   result = client.list_topics request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::PubSub::V1::Topic.
            #     p item
            #   end
            #
            def list_topics request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::ListTopicsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_topics.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.project
                header_params["project"] = request.project
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_topics.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_topics.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @topic_admin_stub.call_rpc :list_topics, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @topic_admin_stub, :list_topics, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the names of the attached subscriptions on this topic.
            #
            # @overload list_topic_subscriptions(request, options = nil)
            #   Pass arguments to `list_topic_subscriptions` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::ListTopicSubscriptionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::ListTopicSubscriptionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_topic_subscriptions(topic: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_topic_subscriptions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param topic [::String]
            #     Required. The name of the topic that subscriptions are attached to.
            #     Format is `projects/{project}/topics/{topic}`.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of subscription names to return.
            #   @param page_token [::String]
            #     Optional. The value returned by the last `ListTopicSubscriptionsResponse`;
            #     indicates that this is a continuation of a prior `ListTopicSubscriptions`
            #     call, and that the system should return the next page of data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::ListTopicSubscriptionsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::ListTopicSubscriptionsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::TopicAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::ListTopicSubscriptionsRequest.new
            #
            #   # Call the list_topic_subscriptions method.
            #   result = client.list_topic_subscriptions request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::ListTopicSubscriptionsResponse.
            #   p result
            #
            def list_topic_subscriptions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::ListTopicSubscriptionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_topic_subscriptions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.topic
                header_params["topic"] = request.topic
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_topic_subscriptions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_topic_subscriptions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @topic_admin_stub.call_rpc :list_topic_subscriptions, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the names of the snapshots on this topic. Snapshots are used in
            # [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
            # which allow you to manage message acknowledgments in bulk. That is, you can
            # set the acknowledgment state of messages in an existing subscription to the
            # state captured by a snapshot.
            #
            # @overload list_topic_snapshots(request, options = nil)
            #   Pass arguments to `list_topic_snapshots` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::ListTopicSnapshotsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::ListTopicSnapshotsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_topic_snapshots(topic: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_topic_snapshots` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param topic [::String]
            #     Required. The name of the topic that snapshots are attached to.
            #     Format is `projects/{project}/topics/{topic}`.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of snapshot names to return.
            #   @param page_token [::String]
            #     Optional. The value returned by the last `ListTopicSnapshotsResponse`;
            #     indicates that this is a continuation of a prior `ListTopicSnapshots` call,
            #     and that the system should return the next page of data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::ListTopicSnapshotsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::ListTopicSnapshotsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::TopicAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::ListTopicSnapshotsRequest.new
            #
            #   # Call the list_topic_snapshots method.
            #   result = client.list_topic_snapshots request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::ListTopicSnapshotsResponse.
            #   p result
            #
            def list_topic_snapshots request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::ListTopicSnapshotsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_topic_snapshots.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.topic
                header_params["topic"] = request.topic
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_topic_snapshots.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_topic_snapshots.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @topic_admin_stub.call_rpc :list_topic_snapshots, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the topic with the given name. Returns `NOT_FOUND` if the topic
            # does not exist. After a topic is deleted, a new topic may be created with
            # the same name; this is an entirely new topic with none of the old
            # configuration or subscriptions. Existing subscriptions to this topic are
            # not deleted, but their `topic` field is set to `_deleted-topic_`.
            #
            # @overload delete_topic(request, options = nil)
            #   Pass arguments to `delete_topic` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::DeleteTopicRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::DeleteTopicRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_topic(topic: nil)
            #   Pass arguments to `delete_topic` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param topic [::String]
            #     Required. Identifier. Name of the topic to delete.
            #     Format is `projects/{project}/topics/{topic}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::TopicAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::DeleteTopicRequest.new
            #
            #   # Call the delete_topic method.
            #   result = client.delete_topic request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_topic request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::DeleteTopicRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_topic.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.topic
                header_params["topic"] = request.topic
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_topic.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_topic.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @topic_admin_stub.call_rpc :delete_topic, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Detaches a subscription from this topic. All messages retained in the
            # subscription are dropped. Subsequent `Pull` and `StreamingPull` requests
            # will return FAILED_PRECONDITION. If the subscription is a push
            # subscription, pushes to the endpoint will stop.
            #
            # @overload detach_subscription(request, options = nil)
            #   Pass arguments to `detach_subscription` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::DetachSubscriptionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::DetachSubscriptionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload detach_subscription(subscription: nil)
            #   Pass arguments to `detach_subscription` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param subscription [::String]
            #     Required. The subscription to detach.
            #     Format is `projects/{project}/subscriptions/{subscription}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::DetachSubscriptionResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::DetachSubscriptionResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::TopicAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::DetachSubscriptionRequest.new
            #
            #   # Call the detach_subscription method.
            #   result = client.detach_subscription request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::DetachSubscriptionResponse.
            #   p result
            #
            def detach_subscription request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::DetachSubscriptionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.detach_subscription.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.subscription
                header_params["subscription"] = request.subscription
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.detach_subscription.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.detach_subscription.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @topic_admin_stub.call_rpc :detach_subscription, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the TopicAdmin API.
            #
            # This class represents the configuration for TopicAdmin,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::PubSub::V1::TopicAdmin::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_topic to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::PubSub::V1::TopicAdmin::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_topic.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::PubSub::V1::TopicAdmin::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_topic.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::PubSub::V1::TopicAdmin::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "pubsub.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the TopicAdmin API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_topic`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_topic
                ##
                # RPC-specific configuration for `update_topic`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_topic
                ##
                # RPC-specific configuration for `publish`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :publish
                ##
                # RPC-specific configuration for `get_topic`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_topic
                ##
                # RPC-specific configuration for `list_topics`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_topics
                ##
                # RPC-specific configuration for `list_topic_subscriptions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_topic_subscriptions
                ##
                # RPC-specific configuration for `list_topic_snapshots`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_topic_snapshots
                ##
                # RPC-specific configuration for `delete_topic`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_topic
                ##
                # RPC-specific configuration for `detach_subscription`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :detach_subscription

                # @private
                def initialize parent_rpcs = nil
                  create_topic_config = parent_rpcs.create_topic if parent_rpcs.respond_to? :create_topic
                  @create_topic = ::Gapic::Config::Method.new create_topic_config
                  update_topic_config = parent_rpcs.update_topic if parent_rpcs.respond_to? :update_topic
                  @update_topic = ::Gapic::Config::Method.new update_topic_config
                  publish_config = parent_rpcs.publish if parent_rpcs.respond_to? :publish
                  @publish = ::Gapic::Config::Method.new publish_config
                  get_topic_config = parent_rpcs.get_topic if parent_rpcs.respond_to? :get_topic
                  @get_topic = ::Gapic::Config::Method.new get_topic_config
                  list_topics_config = parent_rpcs.list_topics if parent_rpcs.respond_to? :list_topics
                  @list_topics = ::Gapic::Config::Method.new list_topics_config
                  list_topic_subscriptions_config = parent_rpcs.list_topic_subscriptions if parent_rpcs.respond_to? :list_topic_subscriptions
                  @list_topic_subscriptions = ::Gapic::Config::Method.new list_topic_subscriptions_config
                  list_topic_snapshots_config = parent_rpcs.list_topic_snapshots if parent_rpcs.respond_to? :list_topic_snapshots
                  @list_topic_snapshots = ::Gapic::Config::Method.new list_topic_snapshots_config
                  delete_topic_config = parent_rpcs.delete_topic if parent_rpcs.respond_to? :delete_topic
                  @delete_topic = ::Gapic::Config::Method.new delete_topic_config
                  detach_subscription_config = parent_rpcs.detach_subscription if parent_rpcs.respond_to? :detach_subscription
                  @detach_subscription = ::Gapic::Config::Method.new detach_subscription_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
