# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/pubsub/v1/pubsub_pb"
require "google/iam/v1"

module Google
  module Cloud
    module PubSub
      module V1
        module SubscriptionAdmin
          ##
          # Client for the SubscriptionAdmin service.
          #
          # The service that an application uses to manipulate subscriptions and to
          # consume messages from a subscription via the `Pull` method or by
          # establishing a bi-directional stream using the `StreamingPull` method.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "pubsub.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :subscription_admin_stub

            ##
            # Configure the SubscriptionAdmin Client class.
            #
            # See {::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all SubscriptionAdmin clients
            #   ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "PubSub", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_subscription.timeout = 60.0
                default_config.rpcs.create_subscription.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [2, 10, 14]
                }

                default_config.rpcs.get_subscription.timeout = 60.0
                default_config.rpcs.get_subscription.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [2, 10, 14]
                }

                default_config.rpcs.update_subscription.timeout = 60.0
                default_config.rpcs.update_subscription.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_subscriptions.timeout = 60.0
                default_config.rpcs.list_subscriptions.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [2, 10, 14]
                }

                default_config.rpcs.delete_subscription.timeout = 60.0
                default_config.rpcs.delete_subscription.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.modify_ack_deadline.timeout = 60.0
                default_config.rpcs.modify_ack_deadline.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.acknowledge.timeout = 60.0
                default_config.rpcs.acknowledge.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.pull.timeout = 60.0
                default_config.rpcs.pull.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [2, 10, 14, 13]
                }

                default_config.rpcs.streaming_pull.timeout = 900.0
                default_config.rpcs.streaming_pull.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 4, retry_codes: [4, 8, 10, 13, 14]
                }

                default_config.rpcs.modify_push_config.timeout = 60.0
                default_config.rpcs.modify_push_config.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_snapshot.timeout = 60.0
                default_config.rpcs.get_snapshot.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [2, 10, 14]
                }

                default_config.rpcs.list_snapshots.timeout = 60.0
                default_config.rpcs.list_snapshots.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [2, 10, 14]
                }

                default_config.rpcs.create_snapshot.timeout = 60.0
                default_config.rpcs.create_snapshot.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_snapshot.timeout = 60.0
                default_config.rpcs.update_snapshot.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_snapshot.timeout = 60.0
                default_config.rpcs.delete_snapshot.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.seek.timeout = 60.0
                default_config.rpcs.seek.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [2, 10, 14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the SubscriptionAdmin Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @subscription_admin_stub.universe_domain
            end

            ##
            # Create a new SubscriptionAdmin client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the SubscriptionAdmin client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/pubsub/v1/pubsub_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @subscription_admin_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::PubSub::V1::Subscriber::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @subscription_admin_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @subscription_admin_stub.endpoint
                config.universe_domain = @subscription_admin_stub.universe_domain
                config.logger = @subscription_admin_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @subscription_admin_stub.logger
            end

            # Service calls

            ##
            # Creates a subscription to a given topic. See the [resource name rules]
            # (https://cloud.google.com/pubsub/docs/pubsub-basics#resource_names).
            # If the subscription already exists, returns `ALREADY_EXISTS`.
            # If the corresponding topic doesn't exist, returns `NOT_FOUND`.
            #
            # If the name is not provided in the request, the server will assign a random
            # name for this subscription on the same project as the topic, conforming
            # to the [resource name format]
            # (https://cloud.google.com/pubsub/docs/pubsub-basics#resource_names). The
            # generated name is populated in the returned Subscription object. Note that
            # for REST API requests, you must specify a name in the request.
            #
            # @overload create_subscription(request, options = nil)
            #   Pass arguments to `create_subscription` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::Subscription} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::Subscription, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_subscription(name: nil, topic: nil, push_config: nil, bigquery_config: nil, cloud_storage_config: nil, ack_deadline_seconds: nil, retain_acked_messages: nil, message_retention_duration: nil, labels: nil, enable_message_ordering: nil, expiration_policy: nil, filter: nil, dead_letter_policy: nil, retry_policy: nil, detached: nil, enable_exactly_once_delivery: nil, message_transforms: nil, tags: nil)
            #   Pass arguments to `create_subscription` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Identifier. The name of the subscription. It must have the format
            #     `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
            #     start with a letter, and contain only letters (`[A-Za-z]`), numbers
            #     (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
            #     plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
            #     in length, and it must not start with `"goog"`.
            #   @param topic [::String]
            #     Required. The name of the topic from which this subscription is receiving
            #     messages. Format is `projects/{project}/topics/{topic}`. The value of this
            #     field will be `_deleted-topic_` if the topic has been deleted.
            #   @param push_config [::Google::Cloud::PubSub::V1::PushConfig, ::Hash]
            #     Optional. If push delivery is used with this subscription, this field is
            #     used to configure it.
            #   @param bigquery_config [::Google::Cloud::PubSub::V1::BigQueryConfig, ::Hash]
            #     Optional. If delivery to BigQuery is used with this subscription, this
            #     field is used to configure it.
            #   @param cloud_storage_config [::Google::Cloud::PubSub::V1::CloudStorageConfig, ::Hash]
            #     Optional. If delivery to Google Cloud Storage is used with this
            #     subscription, this field is used to configure it.
            #   @param ack_deadline_seconds [::Integer]
            #     Optional. The approximate amount of time (on a best-effort basis) Pub/Sub
            #     waits for the subscriber to acknowledge receipt before resending the
            #     message. In the interval after the message is delivered and before it is
            #     acknowledged, it is considered to be _outstanding_. During that time
            #     period, the message will not be redelivered (on a best-effort basis).
            #
            #     For pull subscriptions, this value is used as the initial value for the ack
            #     deadline. To override this value for a given message, call
            #     `ModifyAckDeadline` with the corresponding `ack_id` if using
            #     non-streaming pull or send the `ack_id` in a
            #     `StreamingModifyAckDeadlineRequest` if using streaming pull.
            #     The minimum custom deadline you can specify is 10 seconds.
            #     The maximum custom deadline you can specify is 600 seconds (10 minutes).
            #     If this parameter is 0, a default value of 10 seconds is used.
            #
            #     For push delivery, this value is also used to set the request timeout for
            #     the call to the push endpoint.
            #
            #     If the subscriber never acknowledges the message, the Pub/Sub
            #     system will eventually redeliver the message.
            #   @param retain_acked_messages [::Boolean]
            #     Optional. Indicates whether to retain acknowledged messages. If true, then
            #     messages are not expunged from the subscription's backlog, even if they are
            #     acknowledged, until they fall out of the `message_retention_duration`
            #     window. This must be true if you would like to [`Seek` to a timestamp]
            #     (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
            #     the past to replay previously-acknowledged messages.
            #   @param message_retention_duration [::Google::Protobuf::Duration, ::Hash]
            #     Optional. How long to retain unacknowledged messages in the subscription's
            #     backlog, from the moment a message is published. If `retain_acked_messages`
            #     is true, then this also configures the retention of acknowledged messages,
            #     and thus configures how far back in time a `Seek` can be done. Defaults to
            #     7 days. Cannot be more than 31 days or less than 10 minutes.
            #   @param labels [::Hash{::String => ::String}]
            #     Optional. See [Creating and managing
            #     labels](https://cloud.google.com/pubsub/docs/labels).
            #   @param enable_message_ordering [::Boolean]
            #     Optional. If true, messages published with the same `ordering_key` in
            #     `PubsubMessage` will be delivered to the subscribers in the order in which
            #     they are received by the Pub/Sub system. Otherwise, they may be delivered
            #     in any order.
            #   @param expiration_policy [::Google::Cloud::PubSub::V1::ExpirationPolicy, ::Hash]
            #     Optional. A policy that specifies the conditions for this subscription's
            #     expiration. A subscription is considered active as long as any connected
            #     subscriber is successfully consuming messages from the subscription or is
            #     issuing operations on the subscription. If `expiration_policy` is not set,
            #     a *default policy* with `ttl` of 31 days will be used. The minimum allowed
            #     value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
            #     but `expiration_policy.ttl` is not set, the subscription never expires.
            #   @param filter [::String]
            #     Optional. An expression written in the Pub/Sub [filter
            #     language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
            #     then only `PubsubMessage`s whose `attributes` field matches the filter are
            #     delivered on this subscription. If empty, then no messages are filtered
            #     out.
            #   @param dead_letter_policy [::Google::Cloud::PubSub::V1::DeadLetterPolicy, ::Hash]
            #     Optional. A policy that specifies the conditions for dead lettering
            #     messages in this subscription. If dead_letter_policy is not set, dead
            #     lettering is disabled.
            #
            #     The Pub/Sub service account associated with this subscriptions's
            #     parent project (i.e.,
            #     service-\\{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
            #     permission to Acknowledge() messages on this subscription.
            #   @param retry_policy [::Google::Cloud::PubSub::V1::RetryPolicy, ::Hash]
            #     Optional. A policy that specifies how Pub/Sub retries message delivery for
            #     this subscription.
            #
            #     If not set, the default retry policy is applied. This generally implies
            #     that messages will be retried as soon as possible for healthy subscribers.
            #     RetryPolicy will be triggered on NACKs or acknowledgment deadline exceeded
            #     events for a given message.
            #   @param detached [::Boolean]
            #     Optional. Indicates whether the subscription is detached from its topic.
            #     Detached subscriptions don't receive messages from their topic and don't
            #     retain any backlog. `Pull` and `StreamingPull` requests will return
            #     FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
            #     the endpoint will not be made.
            #   @param enable_exactly_once_delivery [::Boolean]
            #     Optional. If true, Pub/Sub provides the following guarantees for the
            #     delivery of a message with a given value of `message_id` on this
            #     subscription:
            #
            #     * The message sent to a subscriber is guaranteed not to be resent
            #     before the message's acknowledgment deadline expires.
            #     * An acknowledged message will not be resent to a subscriber.
            #
            #     Note that subscribers may still receive multiple copies of a message
            #     when `enable_exactly_once_delivery` is true if the message was published
            #     multiple times by a publisher client. These copies are  considered distinct
            #     by Pub/Sub and have distinct `message_id` values.
            #   @param message_transforms [::Array<::Google::Cloud::PubSub::V1::MessageTransform, ::Hash>]
            #     Optional. Transforms to be applied to messages before they are delivered to
            #     subscribers. Transforms are applied in the order specified.
            #   @param tags [::Hash{::String => ::String}]
            #     Optional. Input only. Immutable. Tag keys/values directly bound to this
            #     resource. For example:
            #       "123/environment": "production",
            #       "123/costCenter": "marketing"
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::Subscription]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::Subscription]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::Subscription.new
            #
            #   # Call the create_subscription method.
            #   result = client.create_subscription request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::Subscription.
            #   p result
            #
            def create_subscription request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::Subscription

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_subscription.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_subscription.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_subscription.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @subscription_admin_stub.call_rpc :create_subscription, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the configuration details of a subscription.
            #
            # @overload get_subscription(request, options = nil)
            #   Pass arguments to `get_subscription` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::GetSubscriptionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::GetSubscriptionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_subscription(subscription: nil)
            #   Pass arguments to `get_subscription` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param subscription [::String]
            #     Required. Identifier. The name of the subscription to get.
            #     Format is `projects/{project}/subscriptions/{sub}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::Subscription]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::Subscription]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::GetSubscriptionRequest.new
            #
            #   # Call the get_subscription method.
            #   result = client.get_subscription request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::Subscription.
            #   p result
            #
            def get_subscription request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::GetSubscriptionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_subscription.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.subscription
                header_params["subscription"] = request.subscription
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_subscription.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_subscription.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @subscription_admin_stub.call_rpc :get_subscription, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an existing subscription by updating the fields specified in the
            # update mask. Note that certain properties of a subscription, such as its
            # topic, are not modifiable.
            #
            # @overload update_subscription(request, options = nil)
            #   Pass arguments to `update_subscription` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::UpdateSubscriptionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::UpdateSubscriptionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_subscription(subscription: nil, update_mask: nil)
            #   Pass arguments to `update_subscription` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param subscription [::Google::Cloud::PubSub::V1::Subscription, ::Hash]
            #     Required. The updated subscription object.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Indicates which fields in the provided subscription to update.
            #     Must be specified and non-empty.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::Subscription]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::Subscription]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::UpdateSubscriptionRequest.new
            #
            #   # Call the update_subscription method.
            #   result = client.update_subscription request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::Subscription.
            #   p result
            #
            def update_subscription request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::UpdateSubscriptionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_subscription.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.subscription&.name
                header_params["subscription.name"] = request.subscription.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_subscription.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_subscription.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @subscription_admin_stub.call_rpc :update_subscription, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists matching subscriptions.
            #
            # @overload list_subscriptions(request, options = nil)
            #   Pass arguments to `list_subscriptions` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::ListSubscriptionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::ListSubscriptionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_subscriptions(project: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_subscriptions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project [::String]
            #     Required. Identifier. The name of the project in which to list
            #     subscriptions. Format is `projects/{project-id}`.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of subscriptions to return.
            #   @param page_token [::String]
            #     Optional. The value returned by the last `ListSubscriptionsResponse`;
            #     indicates that this is a continuation of a prior `ListSubscriptions` call,
            #     and that the system should return the next page of data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::PubSub::V1::Subscription>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::PubSub::V1::Subscription>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::ListSubscriptionsRequest.new
            #
            #   # Call the list_subscriptions method.
            #   result = client.list_subscriptions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::PubSub::V1::Subscription.
            #     p item
            #   end
            #
            def list_subscriptions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::ListSubscriptionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_subscriptions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.project
                header_params["project"] = request.project
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_subscriptions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_subscriptions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @subscription_admin_stub.call_rpc :list_subscriptions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @subscription_admin_stub, :list_subscriptions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an existing subscription. All messages retained in the subscription
            # are immediately dropped. Calls to `Pull` after deletion will return
            # `NOT_FOUND`. After a subscription is deleted, a new one may be created with
            # the same name, but the new one has no association with the old
            # subscription or its topic unless the same topic is specified.
            #
            # @overload delete_subscription(request, options = nil)
            #   Pass arguments to `delete_subscription` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::DeleteSubscriptionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::DeleteSubscriptionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_subscription(subscription: nil)
            #   Pass arguments to `delete_subscription` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param subscription [::String]
            #     Required. Identifier. The subscription to delete.
            #     Format is `projects/{project}/subscriptions/{sub}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::DeleteSubscriptionRequest.new
            #
            #   # Call the delete_subscription method.
            #   result = client.delete_subscription request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_subscription request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::DeleteSubscriptionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_subscription.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.subscription
                header_params["subscription"] = request.subscription
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_subscription.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_subscription.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @subscription_admin_stub.call_rpc :delete_subscription, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Modifies the ack deadline for a specific message. This method is useful
            # to indicate that more time is needed to process a message by the
            # subscriber, or to make the message available for redelivery if the
            # processing was interrupted. Note that this does not modify the
            # subscription-level `ackDeadlineSeconds` used for subsequent messages.
            #
            # @overload modify_ack_deadline(request, options = nil)
            #   Pass arguments to `modify_ack_deadline` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::ModifyAckDeadlineRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::ModifyAckDeadlineRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload modify_ack_deadline(subscription: nil, ack_ids: nil, ack_deadline_seconds: nil)
            #   Pass arguments to `modify_ack_deadline` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param subscription [::String]
            #     Required. The name of the subscription.
            #     Format is `projects/{project}/subscriptions/{sub}`.
            #   @param ack_ids [::Array<::String>]
            #     Required. List of acknowledgment IDs.
            #   @param ack_deadline_seconds [::Integer]
            #     Required. The new ack deadline with respect to the time this request was
            #     sent to the Pub/Sub system. For example, if the value is 10, the new ack
            #     deadline will expire 10 seconds after the `ModifyAckDeadline` call was
            #     made. Specifying zero might immediately make the message available for
            #     delivery to another subscriber client. This typically results in an
            #     increase in the rate of message redeliveries (that is, duplicates).
            #     The minimum deadline you can specify is 0 seconds.
            #     The maximum deadline you can specify in a single request is 600 seconds
            #     (10 minutes).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::ModifyAckDeadlineRequest.new
            #
            #   # Call the modify_ack_deadline method.
            #   result = client.modify_ack_deadline request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def modify_ack_deadline request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::ModifyAckDeadlineRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.modify_ack_deadline.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.subscription
                header_params["subscription"] = request.subscription
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.modify_ack_deadline.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.modify_ack_deadline.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @subscription_admin_stub.call_rpc :modify_ack_deadline, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Acknowledges the messages associated with the `ack_ids` in the
            # `AcknowledgeRequest`. The Pub/Sub system can remove the relevant messages
            # from the subscription.
            #
            # Acknowledging a message whose ack deadline has expired may succeed,
            # but such a message may be redelivered later. Acknowledging a message more
            # than once will not result in an error.
            #
            # @overload acknowledge(request, options = nil)
            #   Pass arguments to `acknowledge` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::AcknowledgeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::AcknowledgeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload acknowledge(subscription: nil, ack_ids: nil)
            #   Pass arguments to `acknowledge` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param subscription [::String]
            #     Required. The subscription whose message is being acknowledged.
            #     Format is `projects/{project}/subscriptions/{sub}`.
            #   @param ack_ids [::Array<::String>]
            #     Required. The acknowledgment ID for the messages being acknowledged that
            #     was returned by the Pub/Sub system in the `Pull` response. Must not be
            #     empty.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::AcknowledgeRequest.new
            #
            #   # Call the acknowledge method.
            #   result = client.acknowledge request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def acknowledge request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::AcknowledgeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.acknowledge.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.subscription
                header_params["subscription"] = request.subscription
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.acknowledge.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.acknowledge.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @subscription_admin_stub.call_rpc :acknowledge, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Pulls messages from the server.
            #
            # @overload pull(request, options = nil)
            #   Pass arguments to `pull` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::PullRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::PullRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload pull(subscription: nil, return_immediately: nil, max_messages: nil)
            #   Pass arguments to `pull` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param subscription [::String]
            #     Required. The subscription from which messages should be pulled.
            #     Format is `projects/{project}/subscriptions/{sub}`.
            #   @param return_immediately [::Boolean]
            #     Optional. If this field set to true, the system will respond immediately
            #     even if it there are no messages available to return in the `Pull`
            #     response. Otherwise, the system may wait (for a bounded amount of time)
            #     until at least one message is available, rather than returning no messages.
            #     Warning: setting this field to `true` is discouraged because it adversely
            #     impacts the performance of `Pull` operations. We recommend that users do
            #     not set this field.
            #   @param max_messages [::Integer]
            #     Required. The maximum number of messages to return for this request. Must
            #     be a positive integer. The Pub/Sub system may return fewer than the number
            #     specified.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::PullResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::PullResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::PullRequest.new
            #
            #   # Call the pull method.
            #   result = client.pull request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::PullResponse.
            #   p result
            #
            def pull request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::PullRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.pull.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.subscription
                header_params["subscription"] = request.subscription
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.pull.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.pull.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @subscription_admin_stub.call_rpc :pull, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Establishes a stream with the server, which sends messages down to the
            # client. The client streams acknowledgments and ack deadline modifications
            # back to the server. The server will close the stream and return the status
            # on any error. The server may close the stream with status `UNAVAILABLE` to
            # reassign server-side resources, in which case, the client should
            # re-establish the stream. Flow control can be achieved by configuring the
            # underlying RPC channel.
            #
            # @param request [::Gapic::StreamInput, ::Enumerable<::Google::Cloud::PubSub::V1::StreamingPullRequest, ::Hash>]
            #   An enumerable of {::Google::Cloud::PubSub::V1::StreamingPullRequest} instances.
            # @param options [::Gapic::CallOptions, ::Hash]
            #   Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::PubSub::V1::StreamingPullResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::PubSub::V1::StreamingPullResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create an input stream.
            #   input = Gapic::StreamInput.new
            #
            #   # Call the streaming_pull method to start streaming.
            #   output = client.streaming_pull input
            #
            #   # Send requests on the stream. For each request object, set fields by
            #   # passing keyword arguments. Be sure to close the stream when done.
            #   input << Google::Cloud::PubSub::V1::StreamingPullRequest.new
            #   input << Google::Cloud::PubSub::V1::StreamingPullRequest.new
            #   input.close
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::PubSub::V1::StreamingPullResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def streaming_pull request, options = nil
              unless request.is_a? ::Enumerable
                raise ::ArgumentError, "request must be an Enumerable" unless request.respond_to? :to_enum
                request = request.to_enum
              end

              request = request.lazy.map do |req|
                ::Gapic::Protobuf.coerce req, to: ::Google::Cloud::PubSub::V1::StreamingPullRequest
              end

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.streaming_pull.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.streaming_pull.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.streaming_pull.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @subscription_admin_stub.call_rpc :streaming_pull, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Modifies the `PushConfig` for a specified subscription.
            #
            # This may be used to change a push subscription to a pull one (signified by
            # an empty `PushConfig`) or vice versa, or change the endpoint URL and other
            # attributes of a push subscription. Messages will accumulate for delivery
            # continuously through the call regardless of changes to the `PushConfig`.
            #
            # @overload modify_push_config(request, options = nil)
            #   Pass arguments to `modify_push_config` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::ModifyPushConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::ModifyPushConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload modify_push_config(subscription: nil, push_config: nil)
            #   Pass arguments to `modify_push_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param subscription [::String]
            #     Required. The name of the subscription.
            #     Format is `projects/{project}/subscriptions/{sub}`.
            #   @param push_config [::Google::Cloud::PubSub::V1::PushConfig, ::Hash]
            #     Required. The push configuration for future deliveries.
            #
            #     An empty `pushConfig` indicates that the Pub/Sub system should
            #     stop pushing messages from the given subscription and allow
            #     messages to be pulled and acknowledged - effectively pausing
            #     the subscription if `Pull` or `StreamingPull` is not called.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::ModifyPushConfigRequest.new
            #
            #   # Call the modify_push_config method.
            #   result = client.modify_push_config request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def modify_push_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::ModifyPushConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.modify_push_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.subscription
                header_params["subscription"] = request.subscription
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.modify_push_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.modify_push_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @subscription_admin_stub.call_rpc :modify_push_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the configuration details of a snapshot. Snapshots are used in
            # [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
            # which allow you to manage message acknowledgments in bulk. That is, you can
            # set the acknowledgment state of messages in an existing subscription to the
            # state captured by a snapshot.
            #
            # @overload get_snapshot(request, options = nil)
            #   Pass arguments to `get_snapshot` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::GetSnapshotRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::GetSnapshotRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_snapshot(snapshot: nil)
            #   Pass arguments to `get_snapshot` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param snapshot [::String]
            #     Required. Identifier. The name of the snapshot to get.
            #     Format is `projects/{project}/snapshots/{snap}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::Snapshot]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::Snapshot]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::GetSnapshotRequest.new
            #
            #   # Call the get_snapshot method.
            #   result = client.get_snapshot request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::Snapshot.
            #   p result
            #
            def get_snapshot request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::GetSnapshotRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_snapshot.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.snapshot
                header_params["snapshot"] = request.snapshot
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_snapshot.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_snapshot.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @subscription_admin_stub.call_rpc :get_snapshot, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the existing snapshots. Snapshots are used in [Seek](
            # https://cloud.google.com/pubsub/docs/replay-overview) operations, which
            # allow you to manage message acknowledgments in bulk. That is, you can set
            # the acknowledgment state of messages in an existing subscription to the
            # state captured by a snapshot.
            #
            # @overload list_snapshots(request, options = nil)
            #   Pass arguments to `list_snapshots` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::ListSnapshotsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::ListSnapshotsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_snapshots(project: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_snapshots` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project [::String]
            #     Required. Identifier. The name of the project in which to list snapshots.
            #     Format is `projects/{project-id}`.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of snapshots to return.
            #   @param page_token [::String]
            #     Optional. The value returned by the last `ListSnapshotsResponse`; indicates
            #     that this is a continuation of a prior `ListSnapshots` call, and that the
            #     system should return the next page of data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::PubSub::V1::Snapshot>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::PubSub::V1::Snapshot>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::ListSnapshotsRequest.new
            #
            #   # Call the list_snapshots method.
            #   result = client.list_snapshots request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::PubSub::V1::Snapshot.
            #     p item
            #   end
            #
            def list_snapshots request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::ListSnapshotsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_snapshots.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.project
                header_params["project"] = request.project
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_snapshots.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_snapshots.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @subscription_admin_stub.call_rpc :list_snapshots, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @subscription_admin_stub, :list_snapshots, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a snapshot from the requested subscription. Snapshots are used in
            # [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
            # which allow you to manage message acknowledgments in bulk. That is, you can
            # set the acknowledgment state of messages in an existing subscription to the
            # state captured by a snapshot.
            # If the snapshot already exists, returns `ALREADY_EXISTS`.
            # If the requested subscription doesn't exist, returns `NOT_FOUND`.
            # If the backlog in the subscription is too old -- and the resulting snapshot
            # would expire in less than 1 hour -- then `FAILED_PRECONDITION` is returned.
            # See also the `Snapshot.expire_time` field. If the name is not provided in
            # the request, the server will assign a random
            # name for this snapshot on the same project as the subscription, conforming
            # to the [resource name format]
            # (https://cloud.google.com/pubsub/docs/pubsub-basics#resource_names). The
            # generated name is populated in the returned Snapshot object. Note that for
            # REST API requests, you must specify a name in the request.
            #
            # @overload create_snapshot(request, options = nil)
            #   Pass arguments to `create_snapshot` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::CreateSnapshotRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::CreateSnapshotRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_snapshot(name: nil, subscription: nil, labels: nil, tags: nil)
            #   Pass arguments to `create_snapshot` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Identifier. User-provided name for this snapshot. If the name is
            #     not provided in the request, the server will assign a random name for this
            #     snapshot on the same project as the subscription. Note that for REST API
            #     requests, you must specify a name.  See the [resource name
            #     rules](https://cloud.google.com/pubsub/docs/pubsub-basics#resource_names).
            #     Format is `projects/{project}/snapshots/{snap}`.
            #   @param subscription [::String]
            #     Required. The subscription whose backlog the snapshot retains.
            #     Specifically, the created snapshot is guaranteed to retain:
            #      (a) The existing backlog on the subscription. More precisely, this is
            #          defined as the messages in the subscription's backlog that are
            #          unacknowledged upon the successful completion of the
            #          `CreateSnapshot` request; as well as:
            #      (b) Any messages published to the subscription's topic following the
            #          successful completion of the CreateSnapshot request.
            #     Format is `projects/{project}/subscriptions/{sub}`.
            #   @param labels [::Hash{::String => ::String}]
            #     Optional. See [Creating and managing
            #     labels](https://cloud.google.com/pubsub/docs/labels).
            #   @param tags [::Hash{::String => ::String}]
            #     Optional. Input only. Immutable. Tag keys/values directly bound to this
            #     resource. For example:
            #       "123/environment": "production",
            #       "123/costCenter": "marketing"
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::Snapshot]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::Snapshot]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::CreateSnapshotRequest.new
            #
            #   # Call the create_snapshot method.
            #   result = client.create_snapshot request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::Snapshot.
            #   p result
            #
            def create_snapshot request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::CreateSnapshotRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_snapshot.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_snapshot.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_snapshot.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @subscription_admin_stub.call_rpc :create_snapshot, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an existing snapshot by updating the fields specified in the update
            # mask. Snapshots are used in
            # [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
            # which allow you to manage message acknowledgments in bulk. That is, you can
            # set the acknowledgment state of messages in an existing subscription to the
            # state captured by a snapshot.
            #
            # @overload update_snapshot(request, options = nil)
            #   Pass arguments to `update_snapshot` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::UpdateSnapshotRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::UpdateSnapshotRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_snapshot(snapshot: nil, update_mask: nil)
            #   Pass arguments to `update_snapshot` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param snapshot [::Google::Cloud::PubSub::V1::Snapshot, ::Hash]
            #     Required. The updated snapshot object.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Indicates which fields in the provided snapshot to update.
            #     Must be specified and non-empty.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::Snapshot]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::Snapshot]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::UpdateSnapshotRequest.new
            #
            #   # Call the update_snapshot method.
            #   result = client.update_snapshot request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::Snapshot.
            #   p result
            #
            def update_snapshot request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::UpdateSnapshotRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_snapshot.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.snapshot&.name
                header_params["snapshot.name"] = request.snapshot.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_snapshot.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_snapshot.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @subscription_admin_stub.call_rpc :update_snapshot, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Removes an existing snapshot. Snapshots are used in [Seek]
            # (https://cloud.google.com/pubsub/docs/replay-overview) operations, which
            # allow you to manage message acknowledgments in bulk. That is, you can set
            # the acknowledgment state of messages in an existing subscription to the
            # state captured by a snapshot.
            # When the snapshot is deleted, all messages retained in the snapshot
            # are immediately dropped. After a snapshot is deleted, a new one may be
            # created with the same name, but the new one has no association with the old
            # snapshot or its subscription, unless the same subscription is specified.
            #
            # @overload delete_snapshot(request, options = nil)
            #   Pass arguments to `delete_snapshot` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::DeleteSnapshotRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::DeleteSnapshotRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_snapshot(snapshot: nil)
            #   Pass arguments to `delete_snapshot` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param snapshot [::String]
            #     Required. Identifier. The name of the snapshot to delete.
            #     Format is `projects/{project}/snapshots/{snap}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::DeleteSnapshotRequest.new
            #
            #   # Call the delete_snapshot method.
            #   result = client.delete_snapshot request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_snapshot request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::DeleteSnapshotRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_snapshot.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.snapshot
                header_params["snapshot"] = request.snapshot
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_snapshot.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_snapshot.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @subscription_admin_stub.call_rpc :delete_snapshot, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Seeks an existing subscription to a point in time or to a given snapshot,
            # whichever is provided in the request. Snapshots are used in [Seek]
            # (https://cloud.google.com/pubsub/docs/replay-overview) operations, which
            # allow you to manage message acknowledgments in bulk. That is, you can set
            # the acknowledgment state of messages in an existing subscription to the
            # state captured by a snapshot. Note that both the subscription and the
            # snapshot must be on the same topic.
            #
            # @overload seek(request, options = nil)
            #   Pass arguments to `seek` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::SeekRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::SeekRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload seek(subscription: nil, time: nil, snapshot: nil)
            #   Pass arguments to `seek` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param subscription [::String]
            #     Required. The subscription to affect.
            #   @param time [::Google::Protobuf::Timestamp, ::Hash]
            #     Optional. The time to seek to.
            #     Messages retained in the subscription that were published before this
            #     time are marked as acknowledged, and messages retained in the
            #     subscription that were published after this time are marked as
            #     unacknowledged. Note that this operation affects only those messages
            #     retained in the subscription (configured by the combination of
            #     `message_retention_duration` and `retain_acked_messages`). For example,
            #     if `time` corresponds to a point before the message retention
            #     window (or to a point before the system's notion of the subscription
            #     creation time), only retained messages will be marked as unacknowledged,
            #     and already-expunged messages will not be restored.
            #
            #     Note: The following parameters are mutually exclusive: `time`, `snapshot`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param snapshot [::String]
            #     Optional. The snapshot to seek to. The snapshot's topic must be the same
            #     as that of the provided subscription. Format is
            #     `projects/{project}/snapshots/{snap}`.
            #
            #     Note: The following parameters are mutually exclusive: `snapshot`, `time`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::SeekResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::SeekResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::SeekRequest.new
            #
            #   # Call the seek method.
            #   result = client.seek request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::SeekResponse.
            #   p result
            #
            def seek request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::SeekRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.seek.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.subscription
                header_params["subscription"] = request.subscription
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.seek.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.seek.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @subscription_admin_stub.call_rpc :seek, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the SubscriptionAdmin API.
            #
            # This class represents the configuration for SubscriptionAdmin,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_subscription to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_subscription.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_subscription.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::PubSub::V1::SubscriptionAdmin::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "pubsub.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the SubscriptionAdmin API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_subscription`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_subscription
                ##
                # RPC-specific configuration for `get_subscription`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_subscription
                ##
                # RPC-specific configuration for `update_subscription`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_subscription
                ##
                # RPC-specific configuration for `list_subscriptions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_subscriptions
                ##
                # RPC-specific configuration for `delete_subscription`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_subscription
                ##
                # RPC-specific configuration for `modify_ack_deadline`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :modify_ack_deadline
                ##
                # RPC-specific configuration for `acknowledge`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :acknowledge
                ##
                # RPC-specific configuration for `pull`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :pull
                ##
                # RPC-specific configuration for `streaming_pull`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :streaming_pull
                ##
                # RPC-specific configuration for `modify_push_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :modify_push_config
                ##
                # RPC-specific configuration for `get_snapshot`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_snapshot
                ##
                # RPC-specific configuration for `list_snapshots`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_snapshots
                ##
                # RPC-specific configuration for `create_snapshot`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_snapshot
                ##
                # RPC-specific configuration for `update_snapshot`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_snapshot
                ##
                # RPC-specific configuration for `delete_snapshot`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_snapshot
                ##
                # RPC-specific configuration for `seek`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :seek

                # @private
                def initialize parent_rpcs = nil
                  create_subscription_config = parent_rpcs.create_subscription if parent_rpcs.respond_to? :create_subscription
                  @create_subscription = ::Gapic::Config::Method.new create_subscription_config
                  get_subscription_config = parent_rpcs.get_subscription if parent_rpcs.respond_to? :get_subscription
                  @get_subscription = ::Gapic::Config::Method.new get_subscription_config
                  update_subscription_config = parent_rpcs.update_subscription if parent_rpcs.respond_to? :update_subscription
                  @update_subscription = ::Gapic::Config::Method.new update_subscription_config
                  list_subscriptions_config = parent_rpcs.list_subscriptions if parent_rpcs.respond_to? :list_subscriptions
                  @list_subscriptions = ::Gapic::Config::Method.new list_subscriptions_config
                  delete_subscription_config = parent_rpcs.delete_subscription if parent_rpcs.respond_to? :delete_subscription
                  @delete_subscription = ::Gapic::Config::Method.new delete_subscription_config
                  modify_ack_deadline_config = parent_rpcs.modify_ack_deadline if parent_rpcs.respond_to? :modify_ack_deadline
                  @modify_ack_deadline = ::Gapic::Config::Method.new modify_ack_deadline_config
                  acknowledge_config = parent_rpcs.acknowledge if parent_rpcs.respond_to? :acknowledge
                  @acknowledge = ::Gapic::Config::Method.new acknowledge_config
                  pull_config = parent_rpcs.pull if parent_rpcs.respond_to? :pull
                  @pull = ::Gapic::Config::Method.new pull_config
                  streaming_pull_config = parent_rpcs.streaming_pull if parent_rpcs.respond_to? :streaming_pull
                  @streaming_pull = ::Gapic::Config::Method.new streaming_pull_config
                  modify_push_config_config = parent_rpcs.modify_push_config if parent_rpcs.respond_to? :modify_push_config
                  @modify_push_config = ::Gapic::Config::Method.new modify_push_config_config
                  get_snapshot_config = parent_rpcs.get_snapshot if parent_rpcs.respond_to? :get_snapshot
                  @get_snapshot = ::Gapic::Config::Method.new get_snapshot_config
                  list_snapshots_config = parent_rpcs.list_snapshots if parent_rpcs.respond_to? :list_snapshots
                  @list_snapshots = ::Gapic::Config::Method.new list_snapshots_config
                  create_snapshot_config = parent_rpcs.create_snapshot if parent_rpcs.respond_to? :create_snapshot
                  @create_snapshot = ::Gapic::Config::Method.new create_snapshot_config
                  update_snapshot_config = parent_rpcs.update_snapshot if parent_rpcs.respond_to? :update_snapshot
                  @update_snapshot = ::Gapic::Config::Method.new update_snapshot_config
                  delete_snapshot_config = parent_rpcs.delete_snapshot if parent_rpcs.respond_to? :delete_snapshot
                  @delete_snapshot = ::Gapic::Config::Method.new delete_snapshot_config
                  seek_config = parent_rpcs.seek if parent_rpcs.respond_to? :seek
                  @seek = ::Gapic::Config::Method.new seek_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
