# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/pubsub/v1/schema_pb"
require "google/iam/v1"

module Google
  module Cloud
    module PubSub
      module V1
        module SchemaService
          ##
          # Client for the SchemaService service.
          #
          # Service for doing schema-related operations.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "pubsub.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :schema_service_stub

            ##
            # Configure the SchemaService Client class.
            #
            # See {::Google::Cloud::PubSub::V1::SchemaService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all SchemaService clients
            #   ::Google::Cloud::PubSub::V1::SchemaService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "PubSub", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_schema.timeout = 60.0
                default_config.rpcs.create_schema.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_schema.timeout = 60.0
                default_config.rpcs.get_schema.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_schemas.timeout = 60.0
                default_config.rpcs.list_schemas.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_schema_revisions.timeout = 60.0
                default_config.rpcs.list_schema_revisions.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.commit_schema.timeout = 60.0
                default_config.rpcs.commit_schema.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.rollback_schema.timeout = 60.0
                default_config.rpcs.rollback_schema.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_schema_revision.timeout = 60.0
                default_config.rpcs.delete_schema_revision.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_schema.timeout = 60.0
                default_config.rpcs.delete_schema.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.validate_schema.timeout = 60.0
                default_config.rpcs.validate_schema.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.validate_message.timeout = 60.0
                default_config.rpcs.validate_message.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the SchemaService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::PubSub::V1::SchemaService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @schema_service_stub.universe_domain
            end

            ##
            # Create a new SchemaService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::PubSub::V1::SchemaService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::PubSub::V1::SchemaService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the SchemaService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/pubsub/v1/schema_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @schema_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::PubSub::V1::SchemaService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @schema_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @schema_service_stub.endpoint
                config.universe_domain = @schema_service_stub.universe_domain
                config.logger = @schema_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @schema_service_stub.logger
            end

            # Service calls

            ##
            # Creates a schema.
            #
            # @overload create_schema(request, options = nil)
            #   Pass arguments to `create_schema` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::CreateSchemaRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::CreateSchemaRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_schema(parent: nil, schema: nil, schema_id: nil)
            #   Pass arguments to `create_schema` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the project in which to create the schema.
            #     Format is `projects/{project-id}`.
            #   @param schema [::Google::Cloud::PubSub::V1::Schema, ::Hash]
            #     Required. The schema object to create.
            #
            #     This schema's `name` parameter is ignored. The schema object returned
            #     by CreateSchema will have a `name` made using the given `parent` and
            #     `schema_id`.
            #   @param schema_id [::String]
            #     The ID to use for the schema, which will become the final component of
            #     the schema's resource name.
            #
            #     See https://cloud.google.com/pubsub/docs/pubsub-basics#resource_names for
            #     resource name constraints.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::Schema]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::Schema]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SchemaService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::CreateSchemaRequest.new
            #
            #   # Call the create_schema method.
            #   result = client.create_schema request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::Schema.
            #   p result
            #
            def create_schema request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::CreateSchemaRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_schema.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_schema.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_schema.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schema_service_stub.call_rpc :create_schema, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a schema.
            #
            # @overload get_schema(request, options = nil)
            #   Pass arguments to `get_schema` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::GetSchemaRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::GetSchemaRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_schema(name: nil, view: nil)
            #   Pass arguments to `get_schema` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the schema to get.
            #     Format is `projects/{project}/schemas/{schema}`.
            #   @param view [::Google::Cloud::PubSub::V1::SchemaView]
            #     The set of fields to return in the response. If not set, returns a Schema
            #     with all fields filled out. Set to `BASIC` to omit the `definition`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::Schema]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::Schema]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SchemaService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::GetSchemaRequest.new
            #
            #   # Call the get_schema method.
            #   result = client.get_schema request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::Schema.
            #   p result
            #
            def get_schema request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::GetSchemaRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_schema.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_schema.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_schema.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schema_service_stub.call_rpc :get_schema, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists schemas in a project.
            #
            # @overload list_schemas(request, options = nil)
            #   Pass arguments to `list_schemas` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::ListSchemasRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::ListSchemasRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_schemas(parent: nil, view: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_schemas` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the project in which to list schemas.
            #     Format is `projects/{project-id}`.
            #   @param view [::Google::Cloud::PubSub::V1::SchemaView]
            #     The set of Schema fields to return in the response. If not set, returns
            #     Schemas with `name` and `type`, but not `definition`. Set to `FULL` to
            #     retrieve all fields.
            #   @param page_size [::Integer]
            #     Maximum number of schemas to return.
            #   @param page_token [::String]
            #     The value returned by the last `ListSchemasResponse`; indicates that
            #     this is a continuation of a prior `ListSchemas` call, and that the
            #     system should return the next page of data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::PubSub::V1::Schema>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::PubSub::V1::Schema>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SchemaService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::ListSchemasRequest.new
            #
            #   # Call the list_schemas method.
            #   result = client.list_schemas request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::PubSub::V1::Schema.
            #     p item
            #   end
            #
            def list_schemas request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::ListSchemasRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_schemas.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_schemas.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_schemas.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schema_service_stub.call_rpc :list_schemas, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @schema_service_stub, :list_schemas, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all schema revisions for the named schema.
            #
            # @overload list_schema_revisions(request, options = nil)
            #   Pass arguments to `list_schema_revisions` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::ListSchemaRevisionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::ListSchemaRevisionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_schema_revisions(name: nil, view: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_schema_revisions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the schema to list revisions for.
            #   @param view [::Google::Cloud::PubSub::V1::SchemaView]
            #     The set of Schema fields to return in the response. If not set, returns
            #     Schemas with `name` and `type`, but not `definition`. Set to `FULL` to
            #     retrieve all fields.
            #   @param page_size [::Integer]
            #     The maximum number of revisions to return per page.
            #   @param page_token [::String]
            #     The page token, received from a previous ListSchemaRevisions call.
            #     Provide this to retrieve the subsequent page.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::PubSub::V1::Schema>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::PubSub::V1::Schema>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SchemaService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::ListSchemaRevisionsRequest.new
            #
            #   # Call the list_schema_revisions method.
            #   result = client.list_schema_revisions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::PubSub::V1::Schema.
            #     p item
            #   end
            #
            def list_schema_revisions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::ListSchemaRevisionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_schema_revisions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_schema_revisions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_schema_revisions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schema_service_stub.call_rpc :list_schema_revisions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @schema_service_stub, :list_schema_revisions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Commits a new schema revision to an existing schema.
            #
            # @overload commit_schema(request, options = nil)
            #   Pass arguments to `commit_schema` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::CommitSchemaRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::CommitSchemaRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload commit_schema(name: nil, schema: nil)
            #   Pass arguments to `commit_schema` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the schema we are revising.
            #     Format is `projects/{project}/schemas/{schema}`.
            #   @param schema [::Google::Cloud::PubSub::V1::Schema, ::Hash]
            #     Required. The schema revision to commit.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::Schema]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::Schema]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SchemaService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::CommitSchemaRequest.new
            #
            #   # Call the commit_schema method.
            #   result = client.commit_schema request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::Schema.
            #   p result
            #
            def commit_schema request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::CommitSchemaRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.commit_schema.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.commit_schema.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.commit_schema.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schema_service_stub.call_rpc :commit_schema, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new schema revision that is a copy of the provided revision_id.
            #
            # @overload rollback_schema(request, options = nil)
            #   Pass arguments to `rollback_schema` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::RollbackSchemaRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::RollbackSchemaRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload rollback_schema(name: nil, revision_id: nil)
            #   Pass arguments to `rollback_schema` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The schema being rolled back with revision id.
            #   @param revision_id [::String]
            #     Required. The revision ID to roll back to.
            #     It must be a revision of the same schema.
            #
            #       Example: c7cfa2a8
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::Schema]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::Schema]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SchemaService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::RollbackSchemaRequest.new
            #
            #   # Call the rollback_schema method.
            #   result = client.rollback_schema request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::Schema.
            #   p result
            #
            def rollback_schema request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::RollbackSchemaRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.rollback_schema.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.rollback_schema.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.rollback_schema.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schema_service_stub.call_rpc :rollback_schema, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a specific schema revision.
            #
            # @overload delete_schema_revision(request, options = nil)
            #   Pass arguments to `delete_schema_revision` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::DeleteSchemaRevisionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::DeleteSchemaRevisionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_schema_revision(name: nil, revision_id: nil)
            #   Pass arguments to `delete_schema_revision` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the schema revision to be deleted, with a revision ID
            #     explicitly included.
            #
            #     Example: `projects/123/schemas/my-schema@c7cfa2a8`
            #   @param revision_id [::String]
            #     Optional. This field is deprecated and should not be used for specifying
            #     the revision ID. The revision ID should be specified via the `name`
            #     parameter.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::Schema]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::Schema]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SchemaService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::DeleteSchemaRevisionRequest.new
            #
            #   # Call the delete_schema_revision method.
            #   result = client.delete_schema_revision request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::Schema.
            #   p result
            #
            def delete_schema_revision request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::DeleteSchemaRevisionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_schema_revision.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_schema_revision.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_schema_revision.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schema_service_stub.call_rpc :delete_schema_revision, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a schema.
            #
            # @overload delete_schema(request, options = nil)
            #   Pass arguments to `delete_schema` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::DeleteSchemaRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::DeleteSchemaRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_schema(name: nil)
            #   Pass arguments to `delete_schema` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the schema to delete.
            #     Format is `projects/{project}/schemas/{schema}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SchemaService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::DeleteSchemaRequest.new
            #
            #   # Call the delete_schema method.
            #   result = client.delete_schema request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_schema request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::DeleteSchemaRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_schema.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_schema.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_schema.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schema_service_stub.call_rpc :delete_schema, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Validates a schema.
            #
            # @overload validate_schema(request, options = nil)
            #   Pass arguments to `validate_schema` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::ValidateSchemaRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::ValidateSchemaRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload validate_schema(parent: nil, schema: nil)
            #   Pass arguments to `validate_schema` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the project in which to validate schemas.
            #     Format is `projects/{project-id}`.
            #   @param schema [::Google::Cloud::PubSub::V1::Schema, ::Hash]
            #     Required. The schema object to validate.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::ValidateSchemaResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::ValidateSchemaResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SchemaService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::ValidateSchemaRequest.new
            #
            #   # Call the validate_schema method.
            #   result = client.validate_schema request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::ValidateSchemaResponse.
            #   p result
            #
            def validate_schema request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::ValidateSchemaRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.validate_schema.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.validate_schema.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.validate_schema.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schema_service_stub.call_rpc :validate_schema, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Validates a message against a schema.
            #
            # @overload validate_message(request, options = nil)
            #   Pass arguments to `validate_message` via a request object, either of type
            #   {::Google::Cloud::PubSub::V1::ValidateMessageRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::PubSub::V1::ValidateMessageRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload validate_message(parent: nil, name: nil, schema: nil, message: nil, encoding: nil)
            #   Pass arguments to `validate_message` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the project in which to validate schemas.
            #     Format is `projects/{project-id}`.
            #   @param name [::String]
            #     Name of the schema against which to validate.
            #
            #     Format is `projects/{project}/schemas/{schema}`.
            #
            #     Note: The following parameters are mutually exclusive: `name`, `schema`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param schema [::Google::Cloud::PubSub::V1::Schema, ::Hash]
            #     Ad-hoc schema against which to validate
            #
            #     Note: The following parameters are mutually exclusive: `schema`, `name`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param message [::String]
            #     Message to validate against the provided `schema_spec`.
            #   @param encoding [::Google::Cloud::PubSub::V1::Encoding]
            #     The encoding expected for messages
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::PubSub::V1::ValidateMessageResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::PubSub::V1::ValidateMessageResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/pubsub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::PubSub::V1::SchemaService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::PubSub::V1::ValidateMessageRequest.new
            #
            #   # Call the validate_message method.
            #   result = client.validate_message request
            #
            #   # The returned object is of type Google::Cloud::PubSub::V1::ValidateMessageResponse.
            #   p result
            #
            def validate_message request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PubSub::V1::ValidateMessageRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.validate_message.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::PubSub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.validate_message.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.validate_message.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @schema_service_stub.call_rpc :validate_message, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the SchemaService API.
            #
            # This class represents the configuration for SchemaService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::PubSub::V1::SchemaService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_schema to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::PubSub::V1::SchemaService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_schema.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::PubSub::V1::SchemaService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_schema.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::PubSub::V1::SchemaService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "pubsub.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the SchemaService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_schema`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_schema
                ##
                # RPC-specific configuration for `get_schema`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_schema
                ##
                # RPC-specific configuration for `list_schemas`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_schemas
                ##
                # RPC-specific configuration for `list_schema_revisions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_schema_revisions
                ##
                # RPC-specific configuration for `commit_schema`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :commit_schema
                ##
                # RPC-specific configuration for `rollback_schema`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :rollback_schema
                ##
                # RPC-specific configuration for `delete_schema_revision`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_schema_revision
                ##
                # RPC-specific configuration for `delete_schema`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_schema
                ##
                # RPC-specific configuration for `validate_schema`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :validate_schema
                ##
                # RPC-specific configuration for `validate_message`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :validate_message

                # @private
                def initialize parent_rpcs = nil
                  create_schema_config = parent_rpcs.create_schema if parent_rpcs.respond_to? :create_schema
                  @create_schema = ::Gapic::Config::Method.new create_schema_config
                  get_schema_config = parent_rpcs.get_schema if parent_rpcs.respond_to? :get_schema
                  @get_schema = ::Gapic::Config::Method.new get_schema_config
                  list_schemas_config = parent_rpcs.list_schemas if parent_rpcs.respond_to? :list_schemas
                  @list_schemas = ::Gapic::Config::Method.new list_schemas_config
                  list_schema_revisions_config = parent_rpcs.list_schema_revisions if parent_rpcs.respond_to? :list_schema_revisions
                  @list_schema_revisions = ::Gapic::Config::Method.new list_schema_revisions_config
                  commit_schema_config = parent_rpcs.commit_schema if parent_rpcs.respond_to? :commit_schema
                  @commit_schema = ::Gapic::Config::Method.new commit_schema_config
                  rollback_schema_config = parent_rpcs.rollback_schema if parent_rpcs.respond_to? :rollback_schema
                  @rollback_schema = ::Gapic::Config::Method.new rollback_schema_config
                  delete_schema_revision_config = parent_rpcs.delete_schema_revision if parent_rpcs.respond_to? :delete_schema_revision
                  @delete_schema_revision = ::Gapic::Config::Method.new delete_schema_revision_config
                  delete_schema_config = parent_rpcs.delete_schema if parent_rpcs.respond_to? :delete_schema
                  @delete_schema = ::Gapic::Config::Method.new delete_schema_config
                  validate_schema_config = parent_rpcs.validate_schema if parent_rpcs.respond_to? :validate_schema
                  @validate_schema = ::Gapic::Config::Method.new validate_schema_config
                  validate_message_config = parent_rpcs.validate_message if parent_rpcs.respond_to? :validate_message
                  @validate_message = ::Gapic::Config::Method.new validate_message_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
