# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager_pb"
require "google/cloud/privileged_access_manager/v1/privileged_access_manager"

class ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_check_onboarding_status
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PrivilegedAccessManager::V1::CheckOnboardingStatusResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    check_onboarding_status_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :check_onboarding_status, name
      assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::CheckOnboardingStatusRequest, request
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, check_onboarding_status_client_stub do
      # Create client
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.check_onboarding_status({ parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.check_onboarding_status parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.check_onboarding_status ::Google::Cloud::PrivilegedAccessManager::V1::CheckOnboardingStatusRequest.new(parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.check_onboarding_status({ parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.check_onboarding_status(::Google::Cloud::PrivilegedAccessManager::V1::CheckOnboardingStatusRequest.new(parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, check_onboarding_status_client_stub.call_rpc_count
    end
  end

  def test_list_entitlements
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PrivilegedAccessManager::V1::ListEntitlementsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_entitlements_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_entitlements, name
      assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::ListEntitlementsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_entitlements_client_stub do
      # Create client
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_entitlements({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_entitlements parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_entitlements ::Google::Cloud::PrivilegedAccessManager::V1::ListEntitlementsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_entitlements({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_entitlements(::Google::Cloud::PrivilegedAccessManager::V1::ListEntitlementsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_entitlements_client_stub.call_rpc_count
    end
  end

  def test_search_entitlements
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PrivilegedAccessManager::V1::SearchEntitlementsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    caller_access_type = :CALLER_ACCESS_TYPE_UNSPECIFIED
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    search_entitlements_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_entitlements, name
      assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::SearchEntitlementsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal :CALLER_ACCESS_TYPE_UNSPECIFIED, request["caller_access_type"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_entitlements_client_stub do
      # Create client
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_entitlements({ parent: parent, caller_access_type: caller_access_type, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_entitlements parent: parent, caller_access_type: caller_access_type, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_entitlements ::Google::Cloud::PrivilegedAccessManager::V1::SearchEntitlementsRequest.new(parent: parent, caller_access_type: caller_access_type, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_entitlements({ parent: parent, caller_access_type: caller_access_type, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_entitlements(::Google::Cloud::PrivilegedAccessManager::V1::SearchEntitlementsRequest.new(parent: parent, caller_access_type: caller_access_type, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_entitlements_client_stub.call_rpc_count
    end
  end

  def test_get_entitlement
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PrivilegedAccessManager::V1::Entitlement.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_entitlement_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_entitlement, name
      assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::GetEntitlementRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_entitlement_client_stub do
      # Create client
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_entitlement({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_entitlement name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_entitlement ::Google::Cloud::PrivilegedAccessManager::V1::GetEntitlementRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_entitlement({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_entitlement(::Google::Cloud::PrivilegedAccessManager::V1::GetEntitlementRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_entitlement_client_stub.call_rpc_count
    end
  end

  def test_create_entitlement
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entitlement_id = "hello world"
    entitlement = {}
    request_id = "hello world"

    create_entitlement_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_entitlement, name
      assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::CreateEntitlementRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["entitlement_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::PrivilegedAccessManager::V1::Entitlement), request["entitlement"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_entitlement_client_stub do
      # Create client
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_entitlement({ parent: parent, entitlement_id: entitlement_id, entitlement: entitlement, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_entitlement parent: parent, entitlement_id: entitlement_id, entitlement: entitlement, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_entitlement ::Google::Cloud::PrivilegedAccessManager::V1::CreateEntitlementRequest.new(parent: parent, entitlement_id: entitlement_id, entitlement: entitlement, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_entitlement({ parent: parent, entitlement_id: entitlement_id, entitlement: entitlement, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_entitlement(::Google::Cloud::PrivilegedAccessManager::V1::CreateEntitlementRequest.new(parent: parent, entitlement_id: entitlement_id, entitlement: entitlement, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_entitlement_client_stub.call_rpc_count
    end
  end

  def test_delete_entitlement
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_entitlement_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_entitlement, name
      assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::DeleteEntitlementRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_entitlement_client_stub do
      # Create client
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_entitlement({ name: name, request_id: request_id, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_entitlement name: name, request_id: request_id, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_entitlement ::Google::Cloud::PrivilegedAccessManager::V1::DeleteEntitlementRequest.new(name: name, request_id: request_id, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_entitlement({ name: name, request_id: request_id, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_entitlement(::Google::Cloud::PrivilegedAccessManager::V1::DeleteEntitlementRequest.new(name: name, request_id: request_id, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_entitlement_client_stub.call_rpc_count
    end
  end

  def test_update_entitlement
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    entitlement = {}
    update_mask = {}

    update_entitlement_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_entitlement, name
      assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::UpdateEntitlementRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::PrivilegedAccessManager::V1::Entitlement), request["entitlement"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_entitlement_client_stub do
      # Create client
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_entitlement({ entitlement: entitlement, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_entitlement entitlement: entitlement, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_entitlement ::Google::Cloud::PrivilegedAccessManager::V1::UpdateEntitlementRequest.new(entitlement: entitlement, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_entitlement({ entitlement: entitlement, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_entitlement(::Google::Cloud::PrivilegedAccessManager::V1::UpdateEntitlementRequest.new(entitlement: entitlement, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_entitlement_client_stub.call_rpc_count
    end
  end

  def test_list_grants
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PrivilegedAccessManager::V1::ListGrantsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_grants_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_grants, name
      assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::ListGrantsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_grants_client_stub do
      # Create client
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_grants({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_grants parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_grants ::Google::Cloud::PrivilegedAccessManager::V1::ListGrantsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_grants({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_grants(::Google::Cloud::PrivilegedAccessManager::V1::ListGrantsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_grants_client_stub.call_rpc_count
    end
  end

  def test_search_grants
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PrivilegedAccessManager::V1::SearchGrantsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    caller_relationship = :CALLER_RELATIONSHIP_TYPE_UNSPECIFIED
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    search_grants_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_grants, name
      assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::SearchGrantsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal :CALLER_RELATIONSHIP_TYPE_UNSPECIFIED, request["caller_relationship"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_grants_client_stub do
      # Create client
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_grants({ parent: parent, caller_relationship: caller_relationship, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_grants parent: parent, caller_relationship: caller_relationship, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_grants ::Google::Cloud::PrivilegedAccessManager::V1::SearchGrantsRequest.new(parent: parent, caller_relationship: caller_relationship, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_grants({ parent: parent, caller_relationship: caller_relationship, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_grants(::Google::Cloud::PrivilegedAccessManager::V1::SearchGrantsRequest.new(parent: parent, caller_relationship: caller_relationship, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_grants_client_stub.call_rpc_count
    end
  end

  def test_get_grant
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PrivilegedAccessManager::V1::Grant.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_grant_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_grant, name
      assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::GetGrantRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_grant_client_stub do
      # Create client
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_grant({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_grant name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_grant ::Google::Cloud::PrivilegedAccessManager::V1::GetGrantRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_grant({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_grant(::Google::Cloud::PrivilegedAccessManager::V1::GetGrantRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_grant_client_stub.call_rpc_count
    end
  end

  def test_create_grant
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PrivilegedAccessManager::V1::Grant.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    grant = {}
    request_id = "hello world"

    create_grant_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_grant, name
      assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::CreateGrantRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::PrivilegedAccessManager::V1::Grant), request["grant"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_grant_client_stub do
      # Create client
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_grant({ parent: parent, grant: grant, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_grant parent: parent, grant: grant, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_grant ::Google::Cloud::PrivilegedAccessManager::V1::CreateGrantRequest.new(parent: parent, grant: grant, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_grant({ parent: parent, grant: grant, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_grant(::Google::Cloud::PrivilegedAccessManager::V1::CreateGrantRequest.new(parent: parent, grant: grant, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_grant_client_stub.call_rpc_count
    end
  end

  def test_approve_grant
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PrivilegedAccessManager::V1::Grant.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    reason = "hello world"

    approve_grant_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :approve_grant, name
      assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::ApproveGrantRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["reason"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, approve_grant_client_stub do
      # Create client
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.approve_grant({ name: name, reason: reason }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.approve_grant name: name, reason: reason do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.approve_grant ::Google::Cloud::PrivilegedAccessManager::V1::ApproveGrantRequest.new(name: name, reason: reason) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.approve_grant({ name: name, reason: reason }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.approve_grant(::Google::Cloud::PrivilegedAccessManager::V1::ApproveGrantRequest.new(name: name, reason: reason), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, approve_grant_client_stub.call_rpc_count
    end
  end

  def test_deny_grant
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::PrivilegedAccessManager::V1::Grant.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    reason = "hello world"

    deny_grant_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :deny_grant, name
      assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::DenyGrantRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["reason"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, deny_grant_client_stub do
      # Create client
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.deny_grant({ name: name, reason: reason }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.deny_grant name: name, reason: reason do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.deny_grant ::Google::Cloud::PrivilegedAccessManager::V1::DenyGrantRequest.new(name: name, reason: reason) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.deny_grant({ name: name, reason: reason }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.deny_grant(::Google::Cloud::PrivilegedAccessManager::V1::DenyGrantRequest.new(name: name, reason: reason), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, deny_grant_client_stub.call_rpc_count
    end
  end

  def test_revoke_grant
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    reason = "hello world"

    revoke_grant_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :revoke_grant, name
      assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::RevokeGrantRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["reason"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, revoke_grant_client_stub do
      # Create client
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.revoke_grant({ name: name, reason: reason }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.revoke_grant name: name, reason: reason do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.revoke_grant ::Google::Cloud::PrivilegedAccessManager::V1::RevokeGrantRequest.new(name: name, reason: reason) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.revoke_grant({ name: name, reason: reason }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.revoke_grant(::Google::Cloud::PrivilegedAccessManager::V1::RevokeGrantRequest.new(name: name, reason: reason), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, revoke_grant_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Operations, client.operations_client
  end
end
