# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module PrivilegedAccessManager
      module V1
        # Request message for `CheckOnboardingStatus` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource for which the onboarding status should be checked.
        #     Should be in one of the following formats:
        #
        #     * `projects/{project-number|project-id}/locations/{region}`
        #     * `folders/{folder-number}/locations/{region}`
        #     * `organizations/{organization-number}/locations/{region}`
        class CheckOnboardingStatusRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for `CheckOnboardingStatus` method.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     The service account that PAM uses to act on this resource.
        # @!attribute [rw] findings
        #   @return [::Array<::Google::Cloud::PrivilegedAccessManager::V1::CheckOnboardingStatusResponse::Finding>]
        #     List of issues that are preventing PAM from functioning for this resource
        #     and need to be fixed to complete onboarding. Some issues might not be
        #     detected or reported.
        class CheckOnboardingStatusResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Finding represents an issue which prevents PAM from functioning properly
          # for this resource.
          # @!attribute [rw] iam_access_denied
          #   @return [::Google::Cloud::PrivilegedAccessManager::V1::CheckOnboardingStatusResponse::Finding::IAMAccessDenied]
          #     PAM's service account is being denied access by Cloud IAM.
          class Finding
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # PAM's service account is being denied access by Cloud IAM.
            # This can be fixed by granting a role that contains the missing
            # permissions to the service account or exempting it from deny policies if
            # they are blocking the access.
            # @!attribute [rw] missing_permissions
            #   @return [::Array<::String>]
            #     List of permissions that are being denied.
            class IAMAccessDenied
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # An entitlement defines the eligibility of a set of users to obtain
        # predefined access for some time possibly after going through an approval
        # workflow.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the entitlement.
        #     Possible formats:
        #
        #     * `organizations/{organization-number}/locations/{region}/entitlements/{entitlement-id}`
        #     * `folders/{folder-number}/locations/{region}/entitlements/{entitlement-id}`
        #     * `projects/{project-id|project-number}/locations/{region}/entitlements/{entitlement-id}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time stamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update time stamp.
        # @!attribute [rw] eligible_users
        #   @return [::Array<::Google::Cloud::PrivilegedAccessManager::V1::AccessControlEntry>]
        #     Optional. Who can create grants using this entitlement. This list should
        #     contain at most one entry.
        # @!attribute [rw] approval_workflow
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::ApprovalWorkflow]
        #     Optional. The approvals needed before access are granted to a requester. No
        #     approvals are needed if this field is null.
        # @!attribute [rw] privileged_access
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccess]
        #     The access granted to a requester on successful approval.
        # @!attribute [rw] max_request_duration
        #   @return [::Google::Protobuf::Duration]
        #     Required. The maximum amount of time that access is granted for a request.
        #     A requester can ask for a duration less than this, but never more.
        # @!attribute [r] state
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Entitlement::State]
        #     Output only. Current state of this entitlement.
        # @!attribute [rw] requester_justification_config
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Entitlement::RequesterJustificationConfig]
        #     Required. The manner in which the requester should provide a justification
        #     for requesting access.
        # @!attribute [rw] additional_notification_targets
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Entitlement::AdditionalNotificationTargets]
        #     Optional. Additional email addresses to be notified based on actions taken.
        # @!attribute [rw] etag
        #   @return [::String]
        #     An `etag` is used for optimistic concurrency control as a way to prevent
        #     simultaneous updates to the same entitlement. An `etag` is returned in the
        #     response to `GetEntitlement` and the caller should put the `etag` in the
        #     request to `UpdateEntitlement` so that their change is applied on
        #     the same version. If this field is omitted or if there is a mismatch while
        #     updating an entitlement, then the server rejects the request.
        class Entitlement
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines how a requester must provide a justification when requesting
          # access.
          # @!attribute [rw] not_mandatory
          #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Entitlement::RequesterJustificationConfig::NotMandatory]
          #     This option means the requester isn't required to provide a
          #     justification.
          #
          #     Note: The following fields are mutually exclusive: `not_mandatory`, `unstructured`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] unstructured
          #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Entitlement::RequesterJustificationConfig::Unstructured]
          #     This option means the requester must provide a string as
          #     justification. If this is selected, the server allows the requester
          #     to provide a justification but doesn't validate it.
          #
          #     Note: The following fields are mutually exclusive: `unstructured`, `not_mandatory`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class RequesterJustificationConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The justification is not mandatory but can be provided in any of the
            # supported formats.
            class NotMandatory
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The requester has to provide a justification in the form of a string.
            class Unstructured
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # `AdditionalNotificationTargets` includes email addresses to be notified.
          # @!attribute [rw] admin_email_recipients
          #   @return [::Array<::String>]
          #     Optional. Additional email addresses to be notified when a principal
          #     (requester) is granted access.
          # @!attribute [rw] requester_email_recipients
          #   @return [::Array<::String>]
          #     Optional. Additional email address to be notified about an eligible
          #     entitlement.
          class AdditionalNotificationTargets
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Different states an entitlement can be in.
          module State
            # Unspecified state. This value is never returned by the server.
            STATE_UNSPECIFIED = 0

            # The entitlement is being created.
            CREATING = 1

            # The entitlement is available for requesting access.
            AVAILABLE = 2

            # The entitlement is being deleted.
            DELETING = 3

            # The entitlement has been deleted.
            DELETED = 4

            # The entitlement is being updated.
            UPDATING = 5
          end
        end

        # `AccessControlEntry` is used to control who can do some operation.
        # @!attribute [rw] principals
        #   @return [::Array<::String>]
        #     Optional. Users who are allowed for the operation. Each entry should be a
        #     valid v1 IAM principal identifier. The format for these is documented at:
        #     https://cloud.google.com/iam/docs/principal-identifiers#v1
        class AccessControlEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Different types of approval workflows that can be used to gate privileged
        # access granting.
        # @!attribute [rw] manual_approvals
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::ManualApprovals]
        #     An approval workflow where users designated as approvers review and act
        #     on the grants.
        class ApprovalWorkflow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A manual approval workflow where users who are designated as approvers
        # need to call the `ApproveGrant`/`DenyGrant` APIs for a grant. The workflow
        # can consist of multiple serial steps where each step defines who can act as
        # approver in that step and how many of those users should approve before the
        # workflow moves to the next step.
        #
        # This can be used to create approval workflows such as:
        #
        # * Require an approval from any user in a group G.
        # * Require an approval from any k number of users from a Group G.
        # * Require an approval from any user in a group G and then from a user U.
        #
        # A single user might be part of the `approvers` ACL for multiple steps in this
        # workflow, but they can only approve once and that approval is only considered
        # to satisfy the approval step at which it was granted.
        # @!attribute [rw] require_approver_justification
        #   @return [::Boolean]
        #     Optional. Do the approvers need to provide a justification for their
        #     actions?
        # @!attribute [rw] steps
        #   @return [::Array<::Google::Cloud::PrivilegedAccessManager::V1::ManualApprovals::Step>]
        #     Optional. List of approval steps in this workflow. These steps are followed
        #     in the specified order sequentially. Only 1 step is supported.
        class ManualApprovals
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Step represents a logical step in a manual approval workflow.
          # @!attribute [rw] approvers
          #   @return [::Array<::Google::Cloud::PrivilegedAccessManager::V1::AccessControlEntry>]
          #     Optional. The potential set of approvers in this step. This list must
          #     contain at most one entry.
          # @!attribute [rw] approvals_needed
          #   @return [::Integer]
          #     Required. How many users from the above list need to approve. If there
          #     aren't enough distinct users in the list, then the workflow indefinitely
          #     blocks. Should always be greater than 0. 1 is the only supported value.
          # @!attribute [rw] approver_email_recipients
          #   @return [::Array<::String>]
          #     Optional. Additional email addresses to be notified when a grant is
          #     pending approval.
          class Step
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Privileged access that this service can be used to gate.
        # @!attribute [rw] gcp_iam_access
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccess::GcpIamAccess]
        #     Access to a Google Cloud resource through IAM.
        class PrivilegedAccess
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # `GcpIamAccess` represents IAM based access control on a Google Cloud
          # resource. Refer to https://cloud.google.com/iam/docs to understand more
          # about IAM.
          # @!attribute [rw] resource_type
          #   @return [::String]
          #     Required. The type of this resource.
          # @!attribute [rw] resource
          #   @return [::String]
          #     Required. Name of the resource.
          # @!attribute [rw] role_bindings
          #   @return [::Array<::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccess::GcpIamAccess::RoleBinding>]
          #     Required. Role bindings that are created on successful grant.
          class GcpIamAccess
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # IAM role bindings that are created after a successful grant.
            # @!attribute [rw] role
            #   @return [::String]
            #     Required. IAM role to be granted.
            #     https://cloud.google.com/iam/docs/roles-overview.
            # @!attribute [rw] condition_expression
            #   @return [::String]
            #     Optional. The expression field of the IAM condition to be associated
            #     with the role. If specified, a user with an active grant for this
            #     entitlement is able to access the resource only if this condition
            #     evaluates to true for their request.
            #
            #     This field uses the same CEL format as IAM and supports all attributes
            #     that IAM supports, except tags.
            #     https://cloud.google.com/iam/docs/conditions-overview#attributes.
            class RoleBinding
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # Message for requesting list of entitlements.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent which owns the entitlement resources.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, the server picks an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListEntitlementsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing entitlements.
        # @!attribute [rw] entitlements
        #   @return [::Array<::Google::Cloud::PrivilegedAccessManager::V1::Entitlement>]
        #     The list of entitlements.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListEntitlementsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `SearchEntitlements` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent which owns the entitlement resources.
        # @!attribute [rw] caller_access_type
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::SearchEntitlementsRequest::CallerAccessType]
        #     Required. Only entitlements where the calling user has this access are
        #     returned.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Only entitlements matching this filter are returned in the
        #     response.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. The server may return fewer items than
        #     requested. If unspecified, the server picks an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        class SearchEntitlementsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Different types of access a user can have on the entitlement resource.
          module CallerAccessType
            # Unspecified access type.
            CALLER_ACCESS_TYPE_UNSPECIFIED = 0

            # The user has access to create grants using this entitlement.
            GRANT_REQUESTER = 1

            # The user has access to approve/deny grants created under this
            # entitlement.
            GRANT_APPROVER = 2
          end
        end

        # Response message for `SearchEntitlements` method.
        # @!attribute [rw] entitlements
        #   @return [::Array<::Google::Cloud::PrivilegedAccessManager::V1::Entitlement>]
        #     The list of entitlements.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class SearchEntitlementsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting an entitlement.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetEntitlementRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating an entitlement.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the parent resource for the entitlement.
        #     Possible formats:
        #
        #     * `organizations/{organization-number}/locations/{region}`
        #     * `folders/{folder-number}/locations/{region}`
        #     * `projects/{project-id|project-number}/locations/{region}`
        # @!attribute [rw] entitlement_id
        #   @return [::String]
        #     Required. The ID to use for this entitlement. This becomes the last part of
        #     the resource name.
        #
        #     This value should be 4-63 characters in length, and valid characters are
        #     "[a-z]", "[0-9]", and "-". The first character should be from [a-z].
        #
        #     This value should be unique among all other entitlements under the
        #     specified `parent`.
        # @!attribute [rw] entitlement
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Entitlement]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server knows to
        #     ignore the request if it has already been completed. The server guarantees
        #     this for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, ignores the second request and returns the
        #     previous operation's response. This prevents clients from accidentally
        #     creating duplicate entitlements.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateEntitlementRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting an entitlement.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server knows to
        #     ignore the request if it has already been completed. The server guarantees
        #     this for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, ignores the second request.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any child grant under this entitlement is also
        #     deleted. (Otherwise, the request only works if the entitlement has no child
        #     grant.)
        class DeleteEntitlementRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating an entitlement.
        # @!attribute [rw] entitlement
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Entitlement]
        #     Required. The entitlement resource that is updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update. A field is overwritten if, and only
        #     if, it is in the mask. Any immutable fields set in the mask are ignored by
        #     the server. Repeated fields and map fields are only allowed in the last
        #     position of a `paths` string and overwrite the existing values. Hence an
        #     update to a repeated field or a map should contain the entire list of
        #     values. The fields specified in the update_mask are relative to the
        #     resource and not to the request.
        #     (e.g. `MaxRequestDuration`; *not* `entitlement.MaxRequestDuration`)
        #     A value of '*' for this field refers to full replacement of the resource.
        class UpdateEntitlementRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A grant represents a request from a user for obtaining the access specified
        # in an entitlement they are eligible for.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of this grant.
        #     Possible formats:
        #
        #     * `organizations/{organization-number}/locations/{region}/entitlements/{entitlement-id}/grants/{grant-id}`
        #     * `folders/{folder-number}/locations/{region}/entitlements/{entitlement-id}/grants/{grant-id}`
        #     * `projects/{project-id|project-number}/locations/{region}/entitlements/{entitlement-id}/grants/{grant-id}`
        #
        #     The last segment of this name (`{grant-id}`) is autogenerated.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time stamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update time stamp.
        # @!attribute [r] requester
        #   @return [::String]
        #     Output only. Username of the user who created this grant.
        # @!attribute [rw] requested_duration
        #   @return [::Google::Protobuf::Duration]
        #     Required. The amount of time access is needed for. This value should be
        #     less than the `max_request_duration` value of the entitlement.
        # @!attribute [rw] justification
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Justification]
        #     Optional. Justification of why this access is needed.
        # @!attribute [r] state
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant::State]
        #     Output only. Current state of this grant.
        # @!attribute [r] timeline
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant::Timeline]
        #     Output only. Timeline of this grant.
        # @!attribute [r] privileged_access
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccess]
        #     Output only. The access that would be granted by this grant.
        # @!attribute [r] audit_trail
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant::AuditTrail]
        #     Output only. Audit trail of access provided by this grant. If unspecified
        #     then access was never granted.
        # @!attribute [rw] additional_email_recipients
        #   @return [::Array<::String>]
        #     Optional. Additional email addresses to notify for all the actions
        #     performed on the grant.
        # @!attribute [r] externally_modified
        #   @return [::Boolean]
        #     Output only. Flag set by the PAM system to indicate that policy bindings
        #     made by this grant have been modified from outside PAM.
        #
        #     After it is set, this flag remains set forever irrespective of the grant
        #     state. A `true` value here indicates that PAM no longer has any certainty
        #     on the access a user has because of this grant.
        class Grant
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Timeline of a grant describing what happened to it and when.
          # @!attribute [r] events
          #   @return [::Array<::Google::Cloud::PrivilegedAccessManager::V1::Grant::Timeline::Event>]
          #     Output only. The events that have occurred on this grant. This list
          #     contains entries in the same order as they occurred. The first entry is
          #     always be of type `Requested` and there is always at least one entry in
          #     this array.
          class Timeline
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A single operation on the grant.
            # @!attribute [rw] requested
            #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant::Timeline::Event::Requested]
            #     The grant was requested.
            #
            #     Note: The following fields are mutually exclusive: `requested`, `approved`, `denied`, `revoked`, `scheduled`, `activated`, `activation_failed`, `expired`, `ended`, `externally_modified`, `withdrawn`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] approved
            #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant::Timeline::Event::Approved]
            #     The grant was approved.
            #
            #     Note: The following fields are mutually exclusive: `approved`, `requested`, `denied`, `revoked`, `scheduled`, `activated`, `activation_failed`, `expired`, `ended`, `externally_modified`, `withdrawn`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] denied
            #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant::Timeline::Event::Denied]
            #     The grant was denied.
            #
            #     Note: The following fields are mutually exclusive: `denied`, `requested`, `approved`, `revoked`, `scheduled`, `activated`, `activation_failed`, `expired`, `ended`, `externally_modified`, `withdrawn`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] revoked
            #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant::Timeline::Event::Revoked]
            #     The grant was revoked.
            #
            #     Note: The following fields are mutually exclusive: `revoked`, `requested`, `approved`, `denied`, `scheduled`, `activated`, `activation_failed`, `expired`, `ended`, `externally_modified`, `withdrawn`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] scheduled
            #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant::Timeline::Event::Scheduled]
            #     The grant has been scheduled to give access.
            #
            #     Note: The following fields are mutually exclusive: `scheduled`, `requested`, `approved`, `denied`, `revoked`, `activated`, `activation_failed`, `expired`, `ended`, `externally_modified`, `withdrawn`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] activated
            #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant::Timeline::Event::Activated]
            #     The grant was successfully activated to give access.
            #
            #     Note: The following fields are mutually exclusive: `activated`, `requested`, `approved`, `denied`, `revoked`, `scheduled`, `activation_failed`, `expired`, `ended`, `externally_modified`, `withdrawn`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] activation_failed
            #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant::Timeline::Event::ActivationFailed]
            #     There was a non-retriable error while trying to give access.
            #
            #     Note: The following fields are mutually exclusive: `activation_failed`, `requested`, `approved`, `denied`, `revoked`, `scheduled`, `activated`, `expired`, `ended`, `externally_modified`, `withdrawn`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] expired
            #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant::Timeline::Event::Expired]
            #     The approval workflow did not complete in the necessary duration,
            #     and so the grant is expired.
            #
            #     Note: The following fields are mutually exclusive: `expired`, `requested`, `approved`, `denied`, `revoked`, `scheduled`, `activated`, `activation_failed`, `ended`, `externally_modified`, `withdrawn`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] ended
            #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant::Timeline::Event::Ended]
            #     Access given by the grant ended automatically as the approved
            #     duration was over.
            #
            #     Note: The following fields are mutually exclusive: `ended`, `requested`, `approved`, `denied`, `revoked`, `scheduled`, `activated`, `activation_failed`, `expired`, `externally_modified`, `withdrawn`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] externally_modified
            #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant::Timeline::Event::ExternallyModified]
            #     The policy bindings made by grant have been modified outside of PAM.
            #
            #     Note: The following fields are mutually exclusive: `externally_modified`, `requested`, `approved`, `denied`, `revoked`, `scheduled`, `activated`, `activation_failed`, `expired`, `ended`, `withdrawn`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] withdrawn
            #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant::Timeline::Event::Withdrawn]
            #     The grant was withdrawn.
            #
            #     Note: The following fields are mutually exclusive: `withdrawn`, `requested`, `approved`, `denied`, `revoked`, `scheduled`, `activated`, `activation_failed`, `expired`, `ended`, `externally_modified`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [r] event_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. The time (as recorded at server) when this event occurred.
            class Event
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # An event representing that a grant was requested.
              # @!attribute [r] expire_time
              #   @return [::Google::Protobuf::Timestamp]
              #     Output only. The time at which this grant expires unless the approval
              #     workflow completes. If omitted, then the request never expires.
              class Requested
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # An event representing that the grant was approved.
              # @!attribute [r] reason
              #   @return [::String]
              #     Output only. The reason provided by the approver for approving the
              #     grant.
              # @!attribute [r] actor
              #   @return [::String]
              #     Output only. Username of the user who approved the grant.
              class Approved
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # An event representing that the grant was denied.
              # @!attribute [r] reason
              #   @return [::String]
              #     Output only. The reason provided by the approver for denying the
              #     grant.
              # @!attribute [r] actor
              #   @return [::String]
              #     Output only. Username of the user who denied the grant.
              class Denied
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # An event representing that the grant was revoked.
              # @!attribute [r] reason
              #   @return [::String]
              #     Output only. The reason provided by the user for revoking the grant.
              # @!attribute [r] actor
              #   @return [::String]
              #     Output only. Username of the user who revoked the grant.
              class Revoked
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # An event representing that the grant was withdrawn.
              class Withdrawn
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # An event representing that the grant has been scheduled to be
              # activated later.
              # @!attribute [r] scheduled_activation_time
              #   @return [::Google::Protobuf::Timestamp]
              #     Output only. The time at which the access is granted.
              class Scheduled
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # An event representing that the grant was successfully
              # activated.
              class Activated
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # An event representing that the grant activation failed.
              # @!attribute [r] error
              #   @return [::Google::Rpc::Status]
              #     Output only. The error that occurred while activating the grant.
              class ActivationFailed
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # An event representing that the grant was expired.
              class Expired
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # An event representing that the grant has ended.
              class Ended
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # An event representing that the policy bindings made by this grant were
              # modified externally.
              class ExternallyModified
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end
          end

          # Audit trail for the access provided by this grant.
          # @!attribute [r] access_grant_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which access was given.
          # @!attribute [r] access_remove_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which the system removed access. This could be
          #     because of an automatic expiry or because of a revocation.
          #
          #     If unspecified, then access hasn't been removed yet.
          class AuditTrail
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Different states a grant can be in.
          module State
            # Unspecified state. This value is never returned by the server.
            STATE_UNSPECIFIED = 0

            # The entitlement had an approval workflow configured and this grant is
            # waiting for the workflow to complete.
            APPROVAL_AWAITED = 1

            # The approval workflow completed with a denied result. No access is
            # granted for this grant. This is a terminal state.
            DENIED = 3

            # The approval workflow completed successfully with an approved result or
            # none was configured. Access is provided at an appropriate time.
            SCHEDULED = 4

            # Access is being given.
            ACTIVATING = 5

            # Access was successfully given and is currently active.
            ACTIVE = 6

            # The system could not give access due to a non-retriable error. This is a
            # terminal state.
            ACTIVATION_FAILED = 7

            # Expired after waiting for the approval workflow to complete. This is a
            # terminal state.
            EXPIRED = 8

            # Access is being revoked.
            REVOKING = 9

            # Access was revoked by a user. This is a terminal state.
            REVOKED = 10

            # System took back access as the requested duration was over. This is a
            # terminal state.
            ENDED = 11

            # Access is being withdrawn.
            WITHDRAWING = 12

            # Grant was withdrawn by the grant owner. This is a terminal state.
            WITHDRAWN = 13
          end
        end

        # Justification represents a justification for requesting access.
        # @!attribute [rw] unstructured_justification
        #   @return [::String]
        #     A free form textual justification. The system only ensures that this
        #     is not empty. No other kind of validation is performed on the string.
        class Justification
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting list of grants.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource which owns the grants.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. The server may return fewer items than
        #     requested. If unspecified, the server picks an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results
        class ListGrantsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing grants.
        # @!attribute [rw] grants
        #   @return [::Array<::Google::Cloud::PrivilegedAccessManager::V1::Grant>]
        #     The list of grants.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListGrantsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `SearchGrants` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent which owns the grant resources.
        # @!attribute [rw] caller_relationship
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::SearchGrantsRequest::CallerRelationshipType]
        #     Required. Only grants which the caller is related to by this relationship
        #     are returned in the response.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Only grants matching this filter are returned in the response.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. The server may return fewer items than
        #     requested. If unspecified, server picks an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        class SearchGrantsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Different types of relationships a user can have with a grant.
          module CallerRelationshipType
            # Unspecified caller relationship type.
            CALLER_RELATIONSHIP_TYPE_UNSPECIFIED = 0

            # The user created this grant by calling `CreateGrant` earlier.
            HAD_CREATED = 1

            # The user is an approver for the entitlement that this grant is parented
            # under and can currently approve/deny it.
            CAN_APPROVE = 2

            # The caller had successfully approved/denied this grant earlier.
            HAD_APPROVED = 3
          end
        end

        # Response message for `SearchGrants` method.
        # @!attribute [rw] grants
        #   @return [::Array<::Google::Cloud::PrivilegedAccessManager::V1::Grant>]
        #     The list of grants.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class SearchGrantsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a grant.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetGrantRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `ApproveGrant` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the grant resource which is being approved.
        # @!attribute [rw] reason
        #   @return [::String]
        #     Optional. The reason for approving this grant. This is required if the
        #     `require_approver_justification` field of the `ManualApprovals` workflow
        #     used in this grant is true.
        class ApproveGrantRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `DenyGrant` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the grant resource which is being denied.
        # @!attribute [rw] reason
        #   @return [::String]
        #     Optional. The reason for denying this grant. This is required if
        #     `require_approver_justification` field of the `ManualApprovals` workflow
        #     used in this grant is true.
        class DenyGrantRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `RevokeGrant` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the grant resource which is being revoked.
        # @!attribute [rw] reason
        #   @return [::String]
        #     Optional. The reason for revoking this grant.
        class RevokeGrantRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a grant
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the parent entitlement for which this grant is being
        #     requested.
        # @!attribute [rw] grant
        #   @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server knows to
        #     ignore the request if it has already been completed. The server guarantees
        #     this for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, ignores the second request. This prevents
        #     clients from accidentally creating duplicate grants.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateGrantRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have been cancelled successfully
        #     have [Operation.error][] value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
