# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager_pb"
require "google/cloud/privileged_access_manager/v1/privileged_access_manager/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module PrivilegedAccessManager
      module V1
        module PrivilegedAccessManager
          module Rest
            ##
            # REST client for the PrivilegedAccessManager service.
            #
            # This API allows customers to manage temporary, request based privileged
            # access to their resources.
            #
            # It defines the following resource model:
            #
            # * A collection of `Entitlement` resources. An entitlement allows configuring
            #   (among other things):
            #
            #   * Some kind of privileged access that users can request.
            #   * A set of users called _requesters_ who can request this access.
            #   * A maximum duration for which the access can be requested.
            #   * An optional approval workflow which must be satisfied before access is
            #     granted.
            #
            # * A collection of `Grant` resources. A grant is a request by a requester to
            #   get the privileged access specified in an entitlement for some duration.
            #
            #   After the approval workflow as specified in the entitlement is satisfied,
            #   the specified access is given to the requester. The access is automatically
            #   taken back after the requested duration is over.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "privilegedaccessmanager.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :privileged_access_manager_stub

              ##
              # Configure the PrivilegedAccessManager Client class.
              #
              # See {::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all PrivilegedAccessManager clients
              #   ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "PrivilegedAccessManager", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the PrivilegedAccessManager Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @privileged_access_manager_stub.universe_domain
              end

              ##
              # Create a new PrivilegedAccessManager REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the PrivilegedAccessManager client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @privileged_access_manager_stub = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @privileged_access_manager_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @privileged_access_manager_stub.endpoint
                  config.universe_domain = @privileged_access_manager_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @privileged_access_manager_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @privileged_access_manager_stub.logger
              end

              # Service calls

              ##
              # `CheckOnboardingStatus` reports the onboarding status for a
              # project/folder/organization. Any findings reported by this API need to be
              # fixed before PAM can be used on the resource.
              #
              # @overload check_onboarding_status(request, options = nil)
              #   Pass arguments to `check_onboarding_status` via a request object, either of type
              #   {::Google::Cloud::PrivilegedAccessManager::V1::CheckOnboardingStatusRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::PrivilegedAccessManager::V1::CheckOnboardingStatusRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload check_onboarding_status(parent: nil)
              #   Pass arguments to `check_onboarding_status` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource for which the onboarding status should be checked.
              #     Should be in one of the following formats:
              #
              #     * `projects/{project-number|project-id}/locations/{region}`
              #     * `folders/{folder-number}/locations/{region}`
              #     * `organizations/{organization-number}/locations/{region}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::PrivilegedAccessManager::V1::CheckOnboardingStatusResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::PrivilegedAccessManager::V1::CheckOnboardingStatusResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/privileged_access_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::PrivilegedAccessManager::V1::CheckOnboardingStatusRequest.new
              #
              #   # Call the check_onboarding_status method.
              #   result = client.check_onboarding_status request
              #
              #   # The returned object is of type Google::Cloud::PrivilegedAccessManager::V1::CheckOnboardingStatusResponse.
              #   p result
              #
              def check_onboarding_status request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PrivilegedAccessManager::V1::CheckOnboardingStatusRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.check_onboarding_status.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::PrivilegedAccessManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.check_onboarding_status.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.check_onboarding_status.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @privileged_access_manager_stub.check_onboarding_status request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists entitlements in a given project/folder/organization and location.
              #
              # @overload list_entitlements(request, options = nil)
              #   Pass arguments to `list_entitlements` via a request object, either of type
              #   {::Google::Cloud::PrivilegedAccessManager::V1::ListEntitlementsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::PrivilegedAccessManager::V1::ListEntitlementsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_entitlements(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_entitlements` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent which owns the entitlement resources.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, the server picks an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. Filtering results.
              #   @param order_by [::String]
              #     Optional. Hint for how to order the results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::PrivilegedAccessManager::V1::Entitlement>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::PrivilegedAccessManager::V1::Entitlement>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/privileged_access_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::PrivilegedAccessManager::V1::ListEntitlementsRequest.new
              #
              #   # Call the list_entitlements method.
              #   result = client.list_entitlements request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::PrivilegedAccessManager::V1::Entitlement.
              #     p item
              #   end
              #
              def list_entitlements request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PrivilegedAccessManager::V1::ListEntitlementsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_entitlements.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::PrivilegedAccessManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_entitlements.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_entitlements.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @privileged_access_manager_stub.list_entitlements request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @privileged_access_manager_stub, :list_entitlements, "entitlements", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # `SearchEntitlements` returns entitlements on which the caller has the
              # specified access.
              #
              # @overload search_entitlements(request, options = nil)
              #   Pass arguments to `search_entitlements` via a request object, either of type
              #   {::Google::Cloud::PrivilegedAccessManager::V1::SearchEntitlementsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::PrivilegedAccessManager::V1::SearchEntitlementsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload search_entitlements(parent: nil, caller_access_type: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `search_entitlements` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent which owns the entitlement resources.
              #   @param caller_access_type [::Google::Cloud::PrivilegedAccessManager::V1::SearchEntitlementsRequest::CallerAccessType]
              #     Required. Only entitlements where the calling user has this access are
              #     returned.
              #   @param filter [::String]
              #     Optional. Only entitlements matching this filter are returned in the
              #     response.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. The server may return fewer items than
              #     requested. If unspecified, the server picks an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::PrivilegedAccessManager::V1::Entitlement>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::PrivilegedAccessManager::V1::Entitlement>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/privileged_access_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::PrivilegedAccessManager::V1::SearchEntitlementsRequest.new
              #
              #   # Call the search_entitlements method.
              #   result = client.search_entitlements request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::PrivilegedAccessManager::V1::Entitlement.
              #     p item
              #   end
              #
              def search_entitlements request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PrivilegedAccessManager::V1::SearchEntitlementsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.search_entitlements.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::PrivilegedAccessManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.search_entitlements.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.search_entitlements.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @privileged_access_manager_stub.search_entitlements request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @privileged_access_manager_stub, :search_entitlements, "entitlements", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single entitlement.
              #
              # @overload get_entitlement(request, options = nil)
              #   Pass arguments to `get_entitlement` via a request object, either of type
              #   {::Google::Cloud::PrivilegedAccessManager::V1::GetEntitlementRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::PrivilegedAccessManager::V1::GetEntitlementRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_entitlement(name: nil)
              #   Pass arguments to `get_entitlement` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::PrivilegedAccessManager::V1::Entitlement]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::PrivilegedAccessManager::V1::Entitlement]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/privileged_access_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::PrivilegedAccessManager::V1::GetEntitlementRequest.new
              #
              #   # Call the get_entitlement method.
              #   result = client.get_entitlement request
              #
              #   # The returned object is of type Google::Cloud::PrivilegedAccessManager::V1::Entitlement.
              #   p result
              #
              def get_entitlement request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PrivilegedAccessManager::V1::GetEntitlementRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_entitlement.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::PrivilegedAccessManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_entitlement.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_entitlement.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @privileged_access_manager_stub.get_entitlement request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new entitlement in a given project/folder/organization and
              # location.
              #
              # @overload create_entitlement(request, options = nil)
              #   Pass arguments to `create_entitlement` via a request object, either of type
              #   {::Google::Cloud::PrivilegedAccessManager::V1::CreateEntitlementRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::PrivilegedAccessManager::V1::CreateEntitlementRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_entitlement(parent: nil, entitlement_id: nil, entitlement: nil, request_id: nil)
              #   Pass arguments to `create_entitlement` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of the parent resource for the entitlement.
              #     Possible formats:
              #
              #     * `organizations/{organization-number}/locations/{region}`
              #     * `folders/{folder-number}/locations/{region}`
              #     * `projects/{project-id|project-number}/locations/{region}`
              #   @param entitlement_id [::String]
              #     Required. The ID to use for this entitlement. This becomes the last part of
              #     the resource name.
              #
              #     This value should be 4-63 characters in length, and valid characters are
              #     "[a-z]", "[0-9]", and "-". The first character should be from [a-z].
              #
              #     This value should be unique among all other entitlements under the
              #     specified `parent`.
              #   @param entitlement [::Google::Cloud::PrivilegedAccessManager::V1::Entitlement, ::Hash]
              #     Required. The resource being created
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server knows to
              #     ignore the request if it has already been completed. The server guarantees
              #     this for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, ignores the second request and returns the
              #     previous operation's response. This prevents clients from accidentally
              #     creating duplicate entitlements.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/privileged_access_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::PrivilegedAccessManager::V1::CreateEntitlementRequest.new
              #
              #   # Call the create_entitlement method.
              #   result = client.create_entitlement request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_entitlement request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PrivilegedAccessManager::V1::CreateEntitlementRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_entitlement.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::PrivilegedAccessManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_entitlement.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_entitlement.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @privileged_access_manager_stub.create_entitlement request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single entitlement. This method can only be called when there
              # are no in-progress (`ACTIVE`/`ACTIVATING`/`REVOKING`) grants under the
              # entitlement.
              #
              # @overload delete_entitlement(request, options = nil)
              #   Pass arguments to `delete_entitlement` via a request object, either of type
              #   {::Google::Cloud::PrivilegedAccessManager::V1::DeleteEntitlementRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::PrivilegedAccessManager::V1::DeleteEntitlementRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_entitlement(name: nil, request_id: nil, force: nil)
              #   Pass arguments to `delete_entitlement` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server knows to
              #     ignore the request if it has already been completed. The server guarantees
              #     this for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, ignores the second request.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param force [::Boolean]
              #     Optional. If set to true, any child grant under this entitlement is also
              #     deleted. (Otherwise, the request only works if the entitlement has no child
              #     grant.)
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/privileged_access_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::PrivilegedAccessManager::V1::DeleteEntitlementRequest.new
              #
              #   # Call the delete_entitlement method.
              #   result = client.delete_entitlement request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_entitlement request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PrivilegedAccessManager::V1::DeleteEntitlementRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_entitlement.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::PrivilegedAccessManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_entitlement.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_entitlement.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @privileged_access_manager_stub.delete_entitlement request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the entitlement specified in the request. Updated fields in the
              # entitlement need to be specified in an update mask. The changes made to an
              # entitlement are applicable only on future grants of the entitlement.
              # However, if new approvers are added or existing approvers are removed from
              # the approval workflow, the changes are effective on existing grants.
              #
              # The following fields are not supported for updates:
              #
              #  * All immutable fields
              #  * Entitlement name
              #  * Resource name
              #  * Resource type
              #  * Adding an approval workflow in an entitlement which previously had no
              #    approval workflow.
              #  * Deleting the approval workflow from an entitlement.
              #  * Adding or deleting a step in the approval workflow (only one step is
              #    supported)
              #
              # Note that updates are allowed on the list of approvers in an approval
              # workflow step.
              #
              # @overload update_entitlement(request, options = nil)
              #   Pass arguments to `update_entitlement` via a request object, either of type
              #   {::Google::Cloud::PrivilegedAccessManager::V1::UpdateEntitlementRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::PrivilegedAccessManager::V1::UpdateEntitlementRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_entitlement(entitlement: nil, update_mask: nil)
              #   Pass arguments to `update_entitlement` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param entitlement [::Google::Cloud::PrivilegedAccessManager::V1::Entitlement, ::Hash]
              #     Required. The entitlement resource that is updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to update. A field is overwritten if, and only
              #     if, it is in the mask. Any immutable fields set in the mask are ignored by
              #     the server. Repeated fields and map fields are only allowed in the last
              #     position of a `paths` string and overwrite the existing values. Hence an
              #     update to a repeated field or a map should contain the entire list of
              #     values. The fields specified in the update_mask are relative to the
              #     resource and not to the request.
              #     (e.g. `MaxRequestDuration`; *not* `entitlement.MaxRequestDuration`)
              #     A value of '*' for this field refers to full replacement of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/privileged_access_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::PrivilegedAccessManager::V1::UpdateEntitlementRequest.new
              #
              #   # Call the update_entitlement method.
              #   result = client.update_entitlement request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_entitlement request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PrivilegedAccessManager::V1::UpdateEntitlementRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_entitlement.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::PrivilegedAccessManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_entitlement.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_entitlement.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @privileged_access_manager_stub.update_entitlement request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists grants for a given entitlement.
              #
              # @overload list_grants(request, options = nil)
              #   Pass arguments to `list_grants` via a request object, either of type
              #   {::Google::Cloud::PrivilegedAccessManager::V1::ListGrantsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::PrivilegedAccessManager::V1::ListGrantsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_grants(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_grants` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource which owns the grants.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. The server may return fewer items than
              #     requested. If unspecified, the server picks an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. Filtering results.
              #   @param order_by [::String]
              #     Optional. Hint for how to order the results
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::PrivilegedAccessManager::V1::Grant>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::PrivilegedAccessManager::V1::Grant>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/privileged_access_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::PrivilegedAccessManager::V1::ListGrantsRequest.new
              #
              #   # Call the list_grants method.
              #   result = client.list_grants request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::PrivilegedAccessManager::V1::Grant.
              #     p item
              #   end
              #
              def list_grants request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PrivilegedAccessManager::V1::ListGrantsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_grants.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::PrivilegedAccessManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_grants.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_grants.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @privileged_access_manager_stub.list_grants request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @privileged_access_manager_stub, :list_grants, "grants", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # `SearchGrants` returns grants that are related to the calling user in the
              # specified way.
              #
              # @overload search_grants(request, options = nil)
              #   Pass arguments to `search_grants` via a request object, either of type
              #   {::Google::Cloud::PrivilegedAccessManager::V1::SearchGrantsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::PrivilegedAccessManager::V1::SearchGrantsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload search_grants(parent: nil, caller_relationship: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `search_grants` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent which owns the grant resources.
              #   @param caller_relationship [::Google::Cloud::PrivilegedAccessManager::V1::SearchGrantsRequest::CallerRelationshipType]
              #     Required. Only grants which the caller is related to by this relationship
              #     are returned in the response.
              #   @param filter [::String]
              #     Optional. Only grants matching this filter are returned in the response.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. The server may return fewer items than
              #     requested. If unspecified, server picks an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::PrivilegedAccessManager::V1::Grant>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::PrivilegedAccessManager::V1::Grant>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/privileged_access_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::PrivilegedAccessManager::V1::SearchGrantsRequest.new
              #
              #   # Call the search_grants method.
              #   result = client.search_grants request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::PrivilegedAccessManager::V1::Grant.
              #     p item
              #   end
              #
              def search_grants request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PrivilegedAccessManager::V1::SearchGrantsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.search_grants.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::PrivilegedAccessManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.search_grants.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.search_grants.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @privileged_access_manager_stub.search_grants request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @privileged_access_manager_stub, :search_grants, "grants", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get details of a single grant.
              #
              # @overload get_grant(request, options = nil)
              #   Pass arguments to `get_grant` via a request object, either of type
              #   {::Google::Cloud::PrivilegedAccessManager::V1::GetGrantRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::PrivilegedAccessManager::V1::GetGrantRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_grant(name: nil)
              #   Pass arguments to `get_grant` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::PrivilegedAccessManager::V1::Grant]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/privileged_access_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::PrivilegedAccessManager::V1::GetGrantRequest.new
              #
              #   # Call the get_grant method.
              #   result = client.get_grant request
              #
              #   # The returned object is of type Google::Cloud::PrivilegedAccessManager::V1::Grant.
              #   p result
              #
              def get_grant request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PrivilegedAccessManager::V1::GetGrantRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_grant.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::PrivilegedAccessManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_grant.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_grant.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @privileged_access_manager_stub.get_grant request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new grant in a given project/folder/organization and
              # location.
              #
              # @overload create_grant(request, options = nil)
              #   Pass arguments to `create_grant` via a request object, either of type
              #   {::Google::Cloud::PrivilegedAccessManager::V1::CreateGrantRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::PrivilegedAccessManager::V1::CreateGrantRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_grant(parent: nil, grant: nil, request_id: nil)
              #   Pass arguments to `create_grant` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of the parent entitlement for which this grant is being
              #     requested.
              #   @param grant [::Google::Cloud::PrivilegedAccessManager::V1::Grant, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server knows to
              #     ignore the request if it has already been completed. The server guarantees
              #     this for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, ignores the second request. This prevents
              #     clients from accidentally creating duplicate grants.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::PrivilegedAccessManager::V1::Grant]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/privileged_access_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::PrivilegedAccessManager::V1::CreateGrantRequest.new
              #
              #   # Call the create_grant method.
              #   result = client.create_grant request
              #
              #   # The returned object is of type Google::Cloud::PrivilegedAccessManager::V1::Grant.
              #   p result
              #
              def create_grant request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PrivilegedAccessManager::V1::CreateGrantRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_grant.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::PrivilegedAccessManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_grant.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_grant.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @privileged_access_manager_stub.create_grant request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # `ApproveGrant` is used to approve a grant. This method can only be called
              # on a grant when it's in the `APPROVAL_AWAITED` state. This operation can't
              # be undone.
              #
              # @overload approve_grant(request, options = nil)
              #   Pass arguments to `approve_grant` via a request object, either of type
              #   {::Google::Cloud::PrivilegedAccessManager::V1::ApproveGrantRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::PrivilegedAccessManager::V1::ApproveGrantRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload approve_grant(name: nil, reason: nil)
              #   Pass arguments to `approve_grant` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the grant resource which is being approved.
              #   @param reason [::String]
              #     Optional. The reason for approving this grant. This is required if the
              #     `require_approver_justification` field of the `ManualApprovals` workflow
              #     used in this grant is true.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::PrivilegedAccessManager::V1::Grant]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/privileged_access_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::PrivilegedAccessManager::V1::ApproveGrantRequest.new
              #
              #   # Call the approve_grant method.
              #   result = client.approve_grant request
              #
              #   # The returned object is of type Google::Cloud::PrivilegedAccessManager::V1::Grant.
              #   p result
              #
              def approve_grant request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PrivilegedAccessManager::V1::ApproveGrantRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.approve_grant.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::PrivilegedAccessManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.approve_grant.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.approve_grant.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @privileged_access_manager_stub.approve_grant request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # `DenyGrant` is used to deny a grant. This method can only be called on a
              # grant when it's in the `APPROVAL_AWAITED` state. This operation can't be
              # undone.
              #
              # @overload deny_grant(request, options = nil)
              #   Pass arguments to `deny_grant` via a request object, either of type
              #   {::Google::Cloud::PrivilegedAccessManager::V1::DenyGrantRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::PrivilegedAccessManager::V1::DenyGrantRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload deny_grant(name: nil, reason: nil)
              #   Pass arguments to `deny_grant` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the grant resource which is being denied.
              #   @param reason [::String]
              #     Optional. The reason for denying this grant. This is required if
              #     `require_approver_justification` field of the `ManualApprovals` workflow
              #     used in this grant is true.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::PrivilegedAccessManager::V1::Grant]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::PrivilegedAccessManager::V1::Grant]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/privileged_access_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::PrivilegedAccessManager::V1::DenyGrantRequest.new
              #
              #   # Call the deny_grant method.
              #   result = client.deny_grant request
              #
              #   # The returned object is of type Google::Cloud::PrivilegedAccessManager::V1::Grant.
              #   p result
              #
              def deny_grant request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PrivilegedAccessManager::V1::DenyGrantRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.deny_grant.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::PrivilegedAccessManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.deny_grant.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.deny_grant.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @privileged_access_manager_stub.deny_grant request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # `RevokeGrant` is used to immediately revoke access for a grant. This method
              # can be called when the grant is in a non-terminal state.
              #
              # @overload revoke_grant(request, options = nil)
              #   Pass arguments to `revoke_grant` via a request object, either of type
              #   {::Google::Cloud::PrivilegedAccessManager::V1::RevokeGrantRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::PrivilegedAccessManager::V1::RevokeGrantRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload revoke_grant(name: nil, reason: nil)
              #   Pass arguments to `revoke_grant` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the grant resource which is being revoked.
              #   @param reason [::String]
              #     Optional. The reason for revoking this grant.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/privileged_access_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::PrivilegedAccessManager::V1::RevokeGrantRequest.new
              #
              #   # Call the revoke_grant method.
              #   result = client.revoke_grant request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def revoke_grant request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::PrivilegedAccessManager::V1::RevokeGrantRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.revoke_grant.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::PrivilegedAccessManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.revoke_grant.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.revoke_grant.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @privileged_access_manager_stub.revoke_grant request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the PrivilegedAccessManager REST API.
              #
              # This class represents the configuration for PrivilegedAccessManager REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # check_onboarding_status to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.check_onboarding_status.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.check_onboarding_status.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "privilegedaccessmanager.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the PrivilegedAccessManager API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `check_onboarding_status`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :check_onboarding_status
                  ##
                  # RPC-specific configuration for `list_entitlements`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_entitlements
                  ##
                  # RPC-specific configuration for `search_entitlements`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_entitlements
                  ##
                  # RPC-specific configuration for `get_entitlement`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_entitlement
                  ##
                  # RPC-specific configuration for `create_entitlement`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_entitlement
                  ##
                  # RPC-specific configuration for `delete_entitlement`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_entitlement
                  ##
                  # RPC-specific configuration for `update_entitlement`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_entitlement
                  ##
                  # RPC-specific configuration for `list_grants`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_grants
                  ##
                  # RPC-specific configuration for `search_grants`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_grants
                  ##
                  # RPC-specific configuration for `get_grant`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_grant
                  ##
                  # RPC-specific configuration for `create_grant`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_grant
                  ##
                  # RPC-specific configuration for `approve_grant`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :approve_grant
                  ##
                  # RPC-specific configuration for `deny_grant`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :deny_grant
                  ##
                  # RPC-specific configuration for `revoke_grant`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :revoke_grant

                  # @private
                  def initialize parent_rpcs = nil
                    check_onboarding_status_config = parent_rpcs.check_onboarding_status if parent_rpcs.respond_to? :check_onboarding_status
                    @check_onboarding_status = ::Gapic::Config::Method.new check_onboarding_status_config
                    list_entitlements_config = parent_rpcs.list_entitlements if parent_rpcs.respond_to? :list_entitlements
                    @list_entitlements = ::Gapic::Config::Method.new list_entitlements_config
                    search_entitlements_config = parent_rpcs.search_entitlements if parent_rpcs.respond_to? :search_entitlements
                    @search_entitlements = ::Gapic::Config::Method.new search_entitlements_config
                    get_entitlement_config = parent_rpcs.get_entitlement if parent_rpcs.respond_to? :get_entitlement
                    @get_entitlement = ::Gapic::Config::Method.new get_entitlement_config
                    create_entitlement_config = parent_rpcs.create_entitlement if parent_rpcs.respond_to? :create_entitlement
                    @create_entitlement = ::Gapic::Config::Method.new create_entitlement_config
                    delete_entitlement_config = parent_rpcs.delete_entitlement if parent_rpcs.respond_to? :delete_entitlement
                    @delete_entitlement = ::Gapic::Config::Method.new delete_entitlement_config
                    update_entitlement_config = parent_rpcs.update_entitlement if parent_rpcs.respond_to? :update_entitlement
                    @update_entitlement = ::Gapic::Config::Method.new update_entitlement_config
                    list_grants_config = parent_rpcs.list_grants if parent_rpcs.respond_to? :list_grants
                    @list_grants = ::Gapic::Config::Method.new list_grants_config
                    search_grants_config = parent_rpcs.search_grants if parent_rpcs.respond_to? :search_grants
                    @search_grants = ::Gapic::Config::Method.new search_grants_config
                    get_grant_config = parent_rpcs.get_grant if parent_rpcs.respond_to? :get_grant
                    @get_grant = ::Gapic::Config::Method.new get_grant_config
                    create_grant_config = parent_rpcs.create_grant if parent_rpcs.respond_to? :create_grant
                    @create_grant = ::Gapic::Config::Method.new create_grant_config
                    approve_grant_config = parent_rpcs.approve_grant if parent_rpcs.respond_to? :approve_grant
                    @approve_grant = ::Gapic::Config::Method.new approve_grant_config
                    deny_grant_config = parent_rpcs.deny_grant if parent_rpcs.respond_to? :deny_grant
                    @deny_grant = ::Gapic::Config::Method.new deny_grant_config
                    revoke_grant_config = parent_rpcs.revoke_grant if parent_rpcs.respond_to? :revoke_grant
                    @revoke_grant = ::Gapic::Config::Method.new revoke_grant_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
