# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/rest"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/privileged_access_manager/v1/version"
require "google/cloud/privileged_access_manager/v1/bindings_override"

require "google/cloud/privileged_access_manager/v1/privileged_access_manager/credentials"
require "google/cloud/privileged_access_manager/v1/privileged_access_manager/paths"
require "google/cloud/privileged_access_manager/v1/privileged_access_manager/rest/operations"
require "google/cloud/privileged_access_manager/v1/privileged_access_manager/rest/client"

module Google
  module Cloud
    module PrivilegedAccessManager
      module V1
        ##
        # This API allows customers to manage temporary, request based privileged
        # access to their resources.
        #
        # It defines the following resource model:
        #
        # * A collection of `Entitlement` resources. An entitlement allows configuring
        #   (among other things):
        #
        #   * Some kind of privileged access that users can request.
        #   * A set of users called _requesters_ who can request this access.
        #   * A maximum duration for which the access can be requested.
        #   * An optional approval workflow which must be satisfied before access is
        #     granted.
        #
        # * A collection of `Grant` resources. A grant is a request by a requester to
        #   get the privileged access specified in an entitlement for some duration.
        #
        #   After the approval workflow as specified in the entitlement is satisfied,
        #   the specified access is given to the requester. The access is automatically
        #   taken back after the requested duration is over.
        #
        # To load this service and instantiate a REST client:
        #
        #     require "google/cloud/privileged_access_manager/v1/privileged_access_manager/rest"
        #     client = ::Google::Cloud::PrivilegedAccessManager::V1::PrivilegedAccessManager::Rest::Client.new
        #
        module PrivilegedAccessManager
          # Client for the REST transport
          module Rest
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "rest", "helpers.rb"
require "google/cloud/privileged_access_manager/v1/privileged_access_manager/rest/helpers" if ::File.file? helper_path
