# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module PrivilegedAccessManager
      module V1
        module PrivilegedAccessManager
          # Path helper methods for the PrivilegedAccessManager API.
          module Paths
            ##
            # Create a fully-qualified Entitlement resource string.
            #
            # @overload entitlement_path(project:, location:, entitlement:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/entitlements/{entitlement}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param entitlement [String]
            #
            # @overload entitlement_path(folder:, location:, entitlement:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/locations/{location}/entitlements/{entitlement}`
            #
            #   @param folder [String]
            #   @param location [String]
            #   @param entitlement [String]
            #
            # @overload entitlement_path(organization:, location:, entitlement:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/entitlements/{entitlement}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param entitlement [String]
            #
            # @return [::String]
            def entitlement_path **args
              resources = {
                "entitlement:location:project" => (proc do |project:, location:, entitlement:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/entitlements/#{entitlement}"
                end),
                "entitlement:folder:location" => (proc do |folder:, location:, entitlement:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "folders/#{folder}/locations/#{location}/entitlements/#{entitlement}"
                end),
                "entitlement:location:organization" => (proc do |organization:, location:, entitlement:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/entitlements/#{entitlement}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified FolderLocation resource string.
            #
            # The resource will be in the following format:
            #
            # `folders/{folder}/locations/{location}`
            #
            # @param folder [String]
            # @param location [String]
            #
            # @return [::String]
            def folder_location_path folder:, location:
              raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"

              "folders/#{folder}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Grant resource string.
            #
            # @overload grant_path(project:, location:, entitlement:, grant:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/entitlements/{entitlement}/grants/{grant}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param entitlement [String]
            #   @param grant [String]
            #
            # @overload grant_path(folder:, location:, entitlement:, grant:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/locations/{location}/entitlements/{entitlement}/grants/{grant}`
            #
            #   @param folder [String]
            #   @param location [String]
            #   @param entitlement [String]
            #   @param grant [String]
            #
            # @overload grant_path(organization:, location:, entitlement:, grant:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/entitlements/{entitlement}/grants/{grant}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param entitlement [String]
            #   @param grant [String]
            #
            # @return [::String]
            def grant_path **args
              resources = {
                "entitlement:grant:location:project" => (proc do |project:, location:, entitlement:, grant:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "entitlement cannot contain /" if entitlement.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/entitlements/#{entitlement}/grants/#{grant}"
                end),
                "entitlement:folder:grant:location" => (proc do |folder:, location:, entitlement:, grant:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "entitlement cannot contain /" if entitlement.to_s.include? "/"

                  "folders/#{folder}/locations/#{location}/entitlements/#{entitlement}/grants/#{grant}"
                end),
                "entitlement:grant:location:organization" => (proc do |organization:, location:, entitlement:, grant:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "entitlement cannot contain /" if entitlement.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/entitlements/#{entitlement}/grants/#{grant}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified OrganizationLocation resource string.
            #
            # The resource will be in the following format:
            #
            # `organizations/{organization}/locations/{location}`
            #
            # @param organization [String]
            # @param location [String]
            #
            # @return [::String]
            def organization_location_path organization:, location:
              raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

              "organizations/#{organization}/locations/#{location}"
            end

            extend self
          end
        end
      end
    end
  end
end
