# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module PrivateCatalog
      module V1beta1
        # Request message for {::Google::Cloud::PrivateCatalog::V1beta1::PrivateCatalog::Client#search_catalogs PrivateCatalog.SearchCatalogs}.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Required. The name of the resource context. It can be in following formats:
        #
        #     * `projects/{project}`
        #     * `folders/{folder}`
        #     * `organizations/{organization}`
        # @!attribute [rw] query
        #   @return [::String]
        #     The query to filter the catalogs. The supported queries are:
        #
        #     * Get a single catalog: `name=catalogs/{catalog}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of entries that are requested.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A pagination token returned from a previous call to SearchCatalogs that
        #     indicates where this listing should continue from.
        class SearchCatalogsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for {::Google::Cloud::PrivateCatalog::V1beta1::PrivateCatalog::Client#search_catalogs PrivateCatalog.SearchCatalogs}.
        # @!attribute [rw] catalogs
        #   @return [::Array<::Google::Cloud::PrivateCatalog::V1beta1::Catalog>]
        #     The `Catalog`s computed from the resource context.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A pagination token returned from a previous call to SearchCatalogs that
        #     indicates from where listing should continue.
        class SearchCatalogsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for {::Google::Cloud::PrivateCatalog::V1beta1::PrivateCatalog::Client#search_products PrivateCatalog.SearchProducts}.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Required. The name of the resource context. See {::Google::Cloud::PrivateCatalog::V1beta1::SearchCatalogsRequest#resource SearchCatalogsRequest.resource}
        #     for details.
        # @!attribute [rw] query
        #   @return [::String]
        #     The query to filter the products.
        #
        #     The supported queries are:
        #     * List products of all catalogs: empty
        #     * List products under a catalog: `parent=catalogs/{catalog}`
        #     * Get a product by name:
        #     `name=catalogs/{catalog}/products/{product}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of entries that are requested.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A pagination token returned from a previous call to SearchProducts that
        #     indicates where this listing should continue from.
        class SearchProductsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for {::Google::Cloud::PrivateCatalog::V1beta1::PrivateCatalog::Client#search_products PrivateCatalog.SearchProducts}.
        # @!attribute [rw] products
        #   @return [::Array<::Google::Cloud::PrivateCatalog::V1beta1::Product>]
        #     The `Product` resources computed from the resource context.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A pagination token returned from a previous call to SearchProducts that
        #     indicates from where listing should continue.
        class SearchProductsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for {::Google::Cloud::PrivateCatalog::V1beta1::PrivateCatalog::Client#search_versions PrivateCatalog.SearchVersions}.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Required. The name of the resource context. See {::Google::Cloud::PrivateCatalog::V1beta1::SearchCatalogsRequest#resource SearchCatalogsRequest.resource}
        #     for details.
        # @!attribute [rw] query
        #   @return [::String]
        #     Required. The query to filter the versions.
        #
        #     The supported queries are:
        #     * List versions under a product:
        #     `parent=catalogs/{catalog}/products/{product}`
        #     * Get a version by name:
        #     `name=catalogs/{catalog}/products/{product}/versions/{version}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of entries that are requested.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A pagination token returned from a previous call to SearchVersions
        #     that indicates where this listing should continue from.
        class SearchVersionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for {::Google::Cloud::PrivateCatalog::V1beta1::PrivateCatalog::Client#search_versions PrivateCatalog.SearchVersions}.
        # @!attribute [rw] versions
        #   @return [::Array<::Google::Cloud::PrivateCatalog::V1beta1::Version>]
        #     The `Version` resources computed from the resource context.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A pagination token returned from a previous call to SearchVersions that
        #     indicates from where the listing should continue.
        class SearchVersionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The readonly representation of a catalog computed with a given resource
        # context.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the target catalog, in the format of
        #     `catalogs/{catalog}`.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The descriptive name of the catalog as it appears in UIs.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. The description of the catalog.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the catalog was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the catalog was last updated.
        class Catalog
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The readonly representation of a product computed with a given resource
        # context.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the target product, in the format of
        #     `products/[a-z][-a-z0-9]*[a-z0-9]'.
        #
        #     A unique identifier for the product under a catalog.
        # @!attribute [r] asset_type
        #   @return [::String]
        #     Output only. The type of the product asset. It can be one of the following values:
        #
        #     * `google.deploymentmanager.Template`
        #     * `google.cloudprivatecatalog.ListingOnly`
        #     * `google.cloudprivatecatalog.Terraform`
        # @!attribute [r] display_metadata
        #   @return [::Google::Protobuf::Struct]
        #     Required. Output only. The display metadata to describe the product. The JSON schema of the
        #     metadata differs by {::Google::Cloud::PrivateCatalog::V1beta1::Product#asset_type Product.asset_type}.
        #     When the type is `google.deploymentmanager.Template`, the schema is as
        #     follows:
        #
        #     ```
        #     "$schema": http://json-schema.org/draft-04/schema#
        #     type: object
        #     properties:
        #       name:
        #         type: string
        #         minLength: 1
        #         maxLength: 64
        #       description:
        #         type: string
        #         minLength: 1
        #         maxLength: 2048
        #       tagline:
        #         type: string
        #         minLength: 1
        #         maxLength: 100
        #       support_info:
        #         type: string
        #         minLength: 1
        #         maxLength: 2048
        #       creator:
        #         type: string
        #         minLength: 1
        #         maxLength: 100
        #       documentations:
        #         type: array
        #         items:
        #           type: object
        #           properties:
        #             url:
        #               type: string
        #               pattern:
        #               "^(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]"
        #             title:
        #               type: string
        #               minLength: 1
        #               maxLength: 64
        #             description:
        #               type: string
        #               minLength: 1
        #               maxLength: 2048
        #     required:
        #     - name
        #     - description
        #     additionalProperties: false
        #
        #     ```
        #
        #     When the asset type is `google.cloudprivatecatalog.ListingOnly`, the schema
        #     is as follows:
        #
        #     ```
        #     "$schema": http://json-schema.org/draft-04/schema#
        #     type: object
        #     properties:
        #       name:
        #         type: string
        #         minLength: 1
        #         maxLength: 64
        #       description:
        #         type: string
        #         minLength: 1
        #         maxLength: 2048
        #       tagline:
        #         type: string
        #         minLength: 1
        #         maxLength: 100
        #       support_info:
        #         type: string
        #         minLength: 1
        #         maxLength: 2048
        #       creator:
        #         type: string
        #         minLength: 1
        #         maxLength: 100
        #       documentations:
        #         type: array
        #         items:
        #           type: object
        #           properties:
        #             url:
        #               type: string
        #               pattern:
        #               "^(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]"
        #             title:
        #               type: string
        #               minLength: 1
        #               maxLength: 64
        #             description:
        #               type: string
        #               minLength: 1
        #               maxLength: 2048
        #       signup_url:
        #         type: string
        #         pattern:
        #         "^(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]"
        #     required:
        #     - name
        #     - description
        #     - signup_url
        #     additionalProperties: false
        #
        #     ```
        #
        #     When the asset type is `google.cloudprivatecatalog.Terraform`, the schema
        #     is as follows:
        #
        #     ```
        #     "$schema": http://json-schema.org/draft-04/schema#
        #     type: object
        #     properties:
        #       name:
        #         type: string
        #         minLength: 1
        #         maxLength: 64
        #       description:
        #         type: string
        #         minLength: 1
        #         maxLength: 2048
        #       tagline:
        #         type: string
        #         minLength: 1
        #         maxLength: 100
        #       support_info:
        #         type: string
        #         minLength: 1
        #         maxLength: 2048
        #       creator:
        #         type: string
        #         minLength: 1
        #         maxLength: 100
        #       documentations:
        #         type: array
        #         items:
        #           type: object
        #           properties:
        #             url:
        #               type: string
        #               pattern:
        #               "^(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]"
        #             title:
        #               type: string
        #               minLength: 1
        #               maxLength: 64
        #             description:
        #               type: string
        #               minLength: 1
        #               maxLength: 2048
        #     required:
        #     - name
        #     - description
        #     additionalProperties: true
        # @!attribute [r] icon_uri
        #   @return [::String]
        #     Output only. The icon URI of the product.
        # @!attribute [r] asset_references
        #   @return [::Array<::Google::Cloud::PrivateCatalog::V1beta1::AssetReference>]
        #     Output only. A collection of assets referred by a product.
        #     This field is set for Terraform Products only.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the product was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the product was last updated.
        class Product
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Defines the reference of an asset belonging to a product.
        # @!attribute [r] id
        #   @return [::String]
        #     Output only. A unique identifier among asset references in a product.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. The human-readable description of the referenced asset. Maximum 256
        #     characters in length.
        # @!attribute [r] inputs
        #   @return [::Google::Cloud::PrivateCatalog::V1beta1::Inputs]
        #     Output only. The definition of input parameters to hydrate the asset template.
        # @!attribute [r] validation_status
        #   @return [::Google::Cloud::PrivateCatalog::V1beta1::AssetReference::AssetValidationState]
        #     Output only. The current state of the asset reference.
        # @!attribute [r] validation_operation
        #   @return [::Google::Longrunning::Operation]
        #     Output only. The validation process metadata.
        # @!attribute [r] asset
        #   @return [::String]
        #     Output only. The asset resource name if an asset is hosted by Private Catalog.
        #
        #     Note: The following fields are mutually exclusive: `asset`, `gcs_path`, `git_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] gcs_path
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Output only. The cloud storage object path.
        #
        #     Note: The following fields are mutually exclusive: `gcs_path`, `asset`, `git_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] git_source
        #   @return [::Google::Cloud::PrivateCatalog::V1beta1::GitSource]
        #     Output only. The git source.
        #
        #     Note: The following fields are mutually exclusive: `git_source`, `asset`, `gcs_path`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] gcs_source
        #   @return [::Google::Cloud::PrivateCatalog::V1beta1::GcsSource]
        #     Output only. The cloud storage source.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The creation timestamp of the asset reference.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last update timestamp of the asset reference.
        # @!attribute [rw] version
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     The version of the source used for this asset reference.
        class AssetReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible validation steates of an asset reference.
          module AssetValidationState
            # Unknown state.
            ASSET_VALIDATION_STATE_UNSPECIFIED = 0

            # The validation is still in process.
            PENDING = 1

            # The validation is done and the asset reference is valid.
            VALID = 2

            # The validation is done and the asset reference is invalid.
            INVALID = 3
          end
        end

        # Defines definition of input parameters of asset templates.
        # @!attribute [r] parameters
        #   @return [::Google::Protobuf::Struct]
        #     Output only. The JSON schema defining the inputs and their formats.
        class Inputs
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Defines how to access Cloud Storage source.
        # @!attribute [r] gcs_path
        #   @return [::String]
        #     Output only. the cloud storage object path.
        # @!attribute [r] generation
        #   @return [::Integer]
        #     Output only. Generation of the object, which is set when the content of an object starts
        #     being written.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the object metadata was last changed.
        class GcsSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Defines how to access a Git Source.
        # @!attribute [rw] repo
        #   @return [::String]
        #     Location of the Git repo to build.
        # @!attribute [rw] dir
        #   @return [::String]
        #     Directory, relative to the source root, in which to run the build.
        #
        #     This must be a relative path. If a step's `dir` is specified and is an
        #     absolute path, this value is ignored for that step's execution.
        # @!attribute [rw] commit
        #   @return [::String]
        #     The revision commit to use.
        #
        #     Note: The following fields are mutually exclusive: `commit`, `branch`, `tag`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] branch
        #   @return [::String]
        #     The revision branch to use.
        #
        #     Note: The following fields are mutually exclusive: `branch`, `commit`, `tag`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tag
        #   @return [::String]
        #     The revision tag to use.
        #
        #     Note: The following fields are mutually exclusive: `tag`, `commit`, `branch`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class GitSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The consumer representation of a version which is a child resource under a
        # `Product` with asset data.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the version, in the format
        #     `catalogs/{catalog}/products/{product}/versions/[a-z][-a-z0-9]*[a-z0-9]`.
        #
        #     A unique identifier for the version under a product.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. The user-supplied description of the version. Maximum of 256
        #     characters.
        # @!attribute [r] asset
        #   @return [::Google::Protobuf::Struct]
        #     Output only. The asset which has been validated and is ready to be
        #     provisioned. See
        #     [google.cloud.privatecatalogproducer.v1beta.Version.asset][] for details.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the version was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the version was last updated.
        class Version
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
