# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/rest"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/private_catalog/v1beta1/version"

require "google/cloud/private_catalog/v1beta1/private_catalog/credentials"
require "google/cloud/private_catalog/v1beta1/private_catalog/rest/client"

module Google
  module Cloud
    module PrivateCatalog
      module V1beta1
        ##
        # `PrivateCatalog` allows catalog consumers to retrieve `Catalog`, `Product`
        # and `Version` resources under a target resource context.
        #
        # `Catalog` is computed based on the [Association][]s linked to the target
        # resource and its ancestors. Each association's
        # [google.cloud.privatecatalogproducer.v1beta.Catalog][] is transformed into a
        # `Catalog`. If multiple associations have the same parent
        # [google.cloud.privatecatalogproducer.v1beta.Catalog][], they are
        # de-duplicated into one `Catalog`. Users must have
        # `cloudprivatecatalog.catalogTargets.get` IAM permission on the resource
        # context in order to access catalogs. `Catalog` contains the resource name and
        # a subset of data of the original
        # [google.cloud.privatecatalogproducer.v1beta.Catalog][].
        #
        # `Product` is child resource of the catalog. A `Product` contains the resource
        # name and a subset of the data of the original
        # [google.cloud.privatecatalogproducer.v1beta.Product][].
        #
        # `Version` is child resource of the product. A `Version` contains the resource
        # name and a subset of the data of the original
        # [google.cloud.privatecatalogproducer.v1beta.Version][].
        #
        # To load this service and instantiate a REST client:
        #
        #     require "google/cloud/private_catalog/v1beta1/private_catalog/rest"
        #     client = ::Google::Cloud::PrivateCatalog::V1beta1::PrivateCatalog::Rest::Client.new
        #
        module PrivateCatalog
          # Client for the REST transport
          module Rest
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "rest", "helpers.rb"
require "google/cloud/private_catalog/v1beta1/private_catalog/rest/helpers" if ::File.file? helper_path
