# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Iam
    module V2
      # Data for an IAM policy.
      # @!attribute [rw] name
      #   @return [::String]
      #     Immutable. The resource name of the `Policy`, which must be unique. Format:
      #     `policies/{attachment_point}/denypolicies/{policy_id}`
      #
      #
      #     The attachment point is identified by its URL-encoded full resource name,
      #     which means that the forward-slash character, `/`, must be written as
      #     `%2F`. For example,
      #     `policies/cloudresourcemanager.googleapis.com%2Fprojects%2Fmy-project/denypolicies/my-deny-policy`.
      #
      #     For organizations and folders, use the numeric ID in the full resource
      #     name. For projects, requests can use the alphanumeric or the numeric ID.
      #     Responses always contain the numeric ID.
      # @!attribute [rw] uid
      #   @return [::String]
      #     Immutable. The globally unique ID of the `Policy`. Assigned automatically when the
      #     `Policy` is created.
      # @!attribute [r] kind
      #   @return [::String]
      #     Output only. The kind of the `Policy`. Always contains the value `DenyPolicy`.
      # @!attribute [rw] display_name
      #   @return [::String]
      #     A user-specified description of the `Policy`. This value can be up to 63
      #     characters.
      # @!attribute [rw] annotations
      #   @return [::Google::Protobuf::Map{::String => ::String}]
      #     A key-value map to store arbitrary metadata for the `Policy`. Keys
      #     can be up to 63 characters. Values can be up to 255 characters.
      # @!attribute [rw] etag
      #   @return [::String]
      #     An opaque tag that identifies the current version of the `Policy`. IAM uses
      #     this value to help manage concurrent updates, so they do not cause one
      #     update to be overwritten by another.
      #
      #     If this field is present in a [CreatePolicy][] request, the value is
      #     ignored.
      # @!attribute [r] create_time
      #   @return [::Google::Protobuf::Timestamp]
      #     Output only. The time when the `Policy` was created.
      # @!attribute [r] update_time
      #   @return [::Google::Protobuf::Timestamp]
      #     Output only. The time when the `Policy` was last updated.
      # @!attribute [r] delete_time
      #   @return [::Google::Protobuf::Timestamp]
      #     Output only. The time when the `Policy` was deleted. Empty if the policy is not deleted.
      # @!attribute [rw] rules
      #   @return [::Array<::Google::Iam::V2::PolicyRule>]
      #     A list of rules that specify the behavior of the `Policy`. All of the rules
      #     should be of the `kind` specified in the `Policy`.
      # @!attribute [rw] managing_authority
      #   @return [::String]
      #     Immutable. Specifies that this policy is managed by an authority and can only be
      #     modified by that authority. Usage is restricted.
      class Policy
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods

        # @!attribute [rw] key
        #   @return [::String]
        # @!attribute [rw] value
        #   @return [::String]
        class AnnotationsEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end

      # A single rule in a `Policy`.
      # @!attribute [rw] deny_rule
      #   @return [::Google::Iam::V2::DenyRule]
      #     A rule for a deny policy.
      # @!attribute [rw] description
      #   @return [::String]
      #     A user-specified description of the rule. This value can be up to 256
      #     characters.
      class PolicyRule
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # Request message for `ListPolicies`.
      # @!attribute [rw] parent
      #   @return [::String]
      #     Required. The resource that the policy is attached to, along with the kind of policy
      #     to list. Format:
      #     `policies/{attachment_point}/denypolicies`
      #
      #
      #     The attachment point is identified by its URL-encoded full resource name,
      #     which means that the forward-slash character, `/`, must be written as
      #     `%2F`. For example,
      #     `policies/cloudresourcemanager.googleapis.com%2Fprojects%2Fmy-project/denypolicies`.
      #
      #     For organizations and folders, use the numeric ID in the full resource
      #     name. For projects, you can use the alphanumeric or the numeric ID.
      # @!attribute [rw] page_size
      #   @return [::Integer]
      #     The maximum number of policies to return. IAM ignores this value and uses
      #     the value 1000.
      # @!attribute [rw] page_token
      #   @return [::String]
      #     A page token received in a {::Google::Iam::V2::ListPoliciesResponse ListPoliciesResponse}. Provide this token to
      #     retrieve the next page.
      class ListPoliciesRequest
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # Response message for `ListPolicies`.
      # @!attribute [rw] policies
      #   @return [::Array<::Google::Iam::V2::Policy>]
      #     Metadata for the policies that are attached to the resource.
      # @!attribute [rw] next_page_token
      #   @return [::String]
      #     A page token that you can use in a {::Google::Iam::V2::ListPoliciesRequest ListPoliciesRequest} to retrieve the
      #     next page. If this field is omitted, there are no additional pages.
      class ListPoliciesResponse
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # Request message for `GetPolicy`.
      # @!attribute [rw] name
      #   @return [::String]
      #     Required. The resource name of the policy to retrieve. Format:
      #     `policies/{attachment_point}/denypolicies/{policy_id}`
      #
      #
      #     Use the URL-encoded full resource name, which means that the forward-slash
      #     character, `/`, must be written as `%2F`. For example,
      #     `policies/cloudresourcemanager.googleapis.com%2Fprojects%2Fmy-project/denypolicies/my-policy`.
      #
      #     For organizations and folders, use the numeric ID in the full resource
      #     name. For projects, you can use the alphanumeric or the numeric ID.
      class GetPolicyRequest
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # Request message for `CreatePolicy`.
      # @!attribute [rw] parent
      #   @return [::String]
      #     Required. The resource that the policy is attached to, along with the kind of policy
      #     to create. Format: `policies/{attachment_point}/denypolicies`
      #
      #
      #     The attachment point is identified by its URL-encoded full resource name,
      #     which means that the forward-slash character, `/`, must be written as
      #     `%2F`. For example,
      #     `policies/cloudresourcemanager.googleapis.com%2Fprojects%2Fmy-project/denypolicies`.
      #
      #     For organizations and folders, use the numeric ID in the full resource
      #     name. For projects, you can use the alphanumeric or the numeric ID.
      # @!attribute [rw] policy
      #   @return [::Google::Iam::V2::Policy]
      #     Required. The policy to create.
      # @!attribute [rw] policy_id
      #   @return [::String]
      #     The ID to use for this policy, which will become the final component of
      #     the policy's resource name. The ID must contain 3 to 63 characters. It can
      #     contain lowercase letters and numbers, as well as dashes (`-`) and periods
      #     (`.`). The first character must be a lowercase letter.
      class CreatePolicyRequest
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # Request message for `UpdatePolicy`.
      # @!attribute [rw] policy
      #   @return [::Google::Iam::V2::Policy]
      #     Required. The policy to update.
      #
      #     To prevent conflicting updates, the `etag` value must match the value that
      #     is stored in IAM. If the `etag` values do not match, the request fails with
      #     a `409` error code and `ABORTED` status.
      class UpdatePolicyRequest
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # Request message for `DeletePolicy`.
      # @!attribute [rw] name
      #   @return [::String]
      #     Required. The resource name of the policy to delete. Format:
      #     `policies/{attachment_point}/denypolicies/{policy_id}`
      #
      #
      #     Use the URL-encoded full resource name, which means that the forward-slash
      #     character, `/`, must be written as `%2F`. For example,
      #     `policies/cloudresourcemanager.googleapis.com%2Fprojects%2Fmy-project/denypolicies/my-policy`.
      #
      #     For organizations and folders, use the numeric ID in the full resource
      #     name. For projects, you can use the alphanumeric or the numeric ID.
      # @!attribute [rw] etag
      #   @return [::String]
      #     Optional. The expected `etag` of the policy to delete. If the value does not match
      #     the value that is stored in IAM, the request fails with a `409` error code
      #     and `ABORTED` status.
      #
      #     If you omit this field, the policy is deleted regardless of its current
      #     `etag`.
      class DeletePolicyRequest
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # Metadata for long-running `Policy` operations.
      # @!attribute [rw] create_time
      #   @return [::Google::Protobuf::Timestamp]
      #     Timestamp when the `google.longrunning.Operation` was created.
      class PolicyOperationMetadata
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end
    end
  end
end
