# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module PolicyTroubleshooter
      module Iam
        module V3
          # Request for
          # {::Google::Cloud::PolicyTroubleshooter::Iam::V3::PolicyTroubleshooter::Client#troubleshoot_iam_policy TroubleshootIamPolicy}.
          # @!attribute [rw] access_tuple
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::AccessTuple]
          #     The information to use for checking whether a principal has a permission
          #     for a resource.
          class TroubleshootIamPolicyRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response for
          # {::Google::Cloud::PolicyTroubleshooter::Iam::V3::PolicyTroubleshooter::Client#troubleshoot_iam_policy TroubleshootIamPolicy}.
          # @!attribute [rw] overall_access_state
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::TroubleshootIamPolicyResponse::OverallAccessState]
          #     Indicates whether the principal has the specified permission for the
          #     specified resource, based on evaluating all types of the applicable IAM
          #     policies.
          # @!attribute [rw] access_tuple
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::AccessTuple]
          #     The access tuple from the request, including any provided context used to
          #     evaluate the condition.
          # @!attribute [rw] allow_policy_explanation
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::AllowPolicyExplanation]
          #     An explanation of how the applicable IAM allow policies affect the final
          #     access state.
          # @!attribute [rw] deny_policy_explanation
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyPolicyExplanation]
          #     An explanation of how the applicable IAM deny policies affect the final
          #     access state.
          class TroubleshootIamPolicyResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Whether the principal has the permission on the resource.
            module OverallAccessState
              # Not specified.
              OVERALL_ACCESS_STATE_UNSPECIFIED = 0

              # The principal has the permission.
              CAN_ACCESS = 1

              # The principal doesn't have the permission.
              CANNOT_ACCESS = 2

              # The principal might have the permission, but the sender can't access all
              # of the information needed to fully evaluate the principal's access.
              UNKNOWN_INFO = 3

              # The principal might have the permission, but Policy Troubleshooter can't
              # fully evaluate the principal's access because the sender didn't provide
              # the required context to evaluate the condition.
              UNKNOWN_CONDITIONAL = 4
            end
          end

          # Information about the principal, resource, and permission to check.
          # @!attribute [rw] principal
          #   @return [::String]
          #     Required. The email address of the principal whose access you want to
          #     check. For example, `alice@example.com` or
          #     `my-service-account@my-project.iam.gserviceaccount.com`.
          #
          #     The principal must be a Google Account or a service account. Other types of
          #     principals are not supported.
          # @!attribute [rw] full_resource_name
          #   @return [::String]
          #     Required. The full resource name that identifies the resource. For example,
          #     `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
          #
          #     For examples of full resource names for Google Cloud services, see
          #     https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
          # @!attribute [rw] permission
          #   @return [::String]
          #     Required. The IAM permission to check for, either in the `v1` permission
          #     format or the `v2` permission format.
          #
          #     For a complete list of IAM permissions in the `v1` format, see
          #     https://cloud.google.com/iam/help/permissions/reference.
          #
          #     For a list of IAM permissions in the `v2` format, see
          #     https://cloud.google.com/iam/help/deny/supported-permissions.
          #
          #     For a complete list of predefined IAM roles and the permissions in each
          #     role, see https://cloud.google.com/iam/help/roles/reference.
          # @!attribute [r] permission_fqdn
          #   @return [::String]
          #     Output only. The permission that Policy Troubleshooter checked for, in
          #     the `v2` format.
          # @!attribute [rw] condition_context
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::ConditionContext]
          #     Optional. Additional context for the request, such as the request time or
          #     IP address. This context allows Policy Troubleshooter to troubleshoot
          #     conditional role bindings and deny rules.
          class AccessTuple
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Additional context for troubleshooting conditional role bindings and deny
          # rules.
          # @!attribute [rw] resource
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::ConditionContext::Resource]
          #     Represents a target resource that is involved with a network activity.
          #     If multiple resources are involved with an activity, this must be the
          #     primary one.
          # @!attribute [rw] destination
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::ConditionContext::Peer]
          #     The destination of a network activity, such as accepting a TCP connection.
          #     In a multi-hop network activity, the destination represents the receiver of
          #     the last hop.
          # @!attribute [rw] request
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::ConditionContext::Request]
          #     Represents a network request, such as an HTTP request.
          # @!attribute [r] effective_tags
          #   @return [::Array<::Google::Cloud::PolicyTroubleshooter::Iam::V3::ConditionContext::EffectiveTag>]
          #     Output only. The effective tags on the resource. The effective tags are
          #     fetched during troubleshooting.
          class ConditionContext
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Core attributes for a resource. A resource is an
            # addressable (named) entity provided by the destination service. For
            # example, a Compute Engine instance.
            # @!attribute [rw] service
            #   @return [::String]
            #     The name of the service that this resource belongs to, such as
            #     `compute.googleapis.com`. The service name might not match the DNS
            #     hostname that actually serves the request.
            #
            #     For a full list of resource service values, see
            #     https://cloud.google.com/iam/help/conditions/resource-services
            # @!attribute [rw] name
            #   @return [::String]
            #     The stable identifier (name) of a resource on the `service`. A resource
            #     can be logically identified as `//{resource.service}/{resource.name}`.
            #     Unlike the resource URI, the resource name doesn't contain any protocol
            #     and version information.
            #
            #     For a list of full resource name formats, see
            #     https://cloud.google.com/iam/help/troubleshooter/full-resource-names
            # @!attribute [rw] type
            #   @return [::String]
            #     The type of the resource, in the format `{service}/{kind}`.
            #
            #     For a full list of resource type values, see
            #     https://cloud.google.com/iam/help/conditions/resource-types
            class Resource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # This message defines attributes for a node that handles a network request.
            # The node can be either a service or an application that sends, forwards,
            # or receives the request. Service peers should fill in
            # `principal` and `labels` as appropriate.
            # @!attribute [rw] ip
            #   @return [::String]
            #     The IPv4 or IPv6 address of the peer.
            # @!attribute [rw] port
            #   @return [::Integer]
            #     The network port of the peer.
            class Peer
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # This message defines attributes for an HTTP request. If the actual
            # request is not an HTTP request, the runtime system should try to map
            # the actual request to an equivalent HTTP request.
            # @!attribute [rw] receive_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Optional. The timestamp when the destination service receives the first
            #     byte of the request.
            class Request
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A tag that applies to a resource during policy evaluation. Tags can be
            # either directly bound to a resource or inherited from its ancestor.
            # `EffectiveTag` contains the `name` and `namespaced_name` of the tag value
            # and tag key, with additional fields of `inherited` to indicate the
            # inheritance status of the effective tag.
            # @!attribute [r] tag_value
            #   @return [::String]
            #     Output only. Resource name for TagValue in the format `tagValues/456`.
            # @!attribute [r] namespaced_tag_value
            #   @return [::String]
            #     Output only. The namespaced name of the TagValue. Can be in the form
            #     `{organization_id}/{tag_key_short_name}/{tag_value_short_name}` or
            #     `{project_id}/{tag_key_short_name}/{tag_value_short_name}` or
            #     `{project_number}/{tag_key_short_name}/{tag_value_short_name}`.
            # @!attribute [r] tag_key
            #   @return [::String]
            #     Output only. The name of the TagKey, in the format `tagKeys/{id}`, such
            #     as `tagKeys/123`.
            # @!attribute [r] namespaced_tag_key
            #   @return [::String]
            #     Output only. The namespaced name of the TagKey. Can be in the form
            #     `{organization_id}/{tag_key_short_name}` or
            #     `{project_id}/{tag_key_short_name}` or
            #     `{project_number}/{tag_key_short_name}`.
            # @!attribute [rw] tag_key_parent_name
            #   @return [::String]
            #     The parent name of the tag key.
            #     Must be in the format `organizations/{organization_id}` or
            #     `projects/{project_number}`
            # @!attribute [r] inherited
            #   @return [::Boolean]
            #     Output only. Indicates the inheritance status of a tag value
            #     attached to the given resource. If the tag value is inherited from one of
            #     the resource's ancestors, inherited will be true. If false, then the tag
            #     value is directly attached to the resource, inherited will be false.
            class EffectiveTag
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Details about how the relevant IAM allow policies affect the final access
          # state.
          # @!attribute [rw] allow_access_state
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::AllowAccessState]
          #     Indicates whether the principal has the specified permission for the
          #     specified resource, based on evaluating all applicable IAM allow policies.
          # @!attribute [rw] explained_policies
          #   @return [::Array<::Google::Cloud::PolicyTroubleshooter::Iam::V3::ExplainedAllowPolicy>]
          #     List of IAM allow policies that were evaluated to check the principal's
          #     permissions, with annotations to indicate how each policy contributed to
          #     the final result.
          #
          #     The list of policies includes the policy for the resource itself, as well
          #     as allow policies that are inherited from higher levels of the resource
          #     hierarchy, including the organization, the folder, and the project.
          #
          #     To learn more about the resource hierarchy, see
          #     https://cloud.google.com/iam/help/resource-hierarchy.
          # @!attribute [rw] relevance
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::HeuristicRelevance]
          #     The relevance of the allow policy type to the overall access state.
          class AllowPolicyExplanation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details about how a specific IAM allow policy contributed to the final access
          # state.
          # @!attribute [rw] allow_access_state
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::AllowAccessState]
          #     Required. Indicates whether _this policy_ provides the specified permission
          #     to the specified principal for the specified resource.
          #
          #     This field does _not_ indicate whether the principal actually has the
          #     permission for the resource. There might be another policy that overrides
          #     this policy. To determine whether the principal actually has the
          #     permission, use the `overall_access_state` field in the
          #     {::Google::Cloud::PolicyTroubleshooter::Iam::V3::TroubleshootIamPolicyResponse TroubleshootIamPolicyResponse}.
          # @!attribute [rw] full_resource_name
          #   @return [::String]
          #     The full resource name that identifies the resource. For example,
          #     `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
          #
          #     If the sender of the request does not have access to the policy, this field
          #     is omitted.
          #
          #     For examples of full resource names for Google Cloud services, see
          #     https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
          # @!attribute [rw] binding_explanations
          #   @return [::Array<::Google::Cloud::PolicyTroubleshooter::Iam::V3::AllowBindingExplanation>]
          #     Details about how each role binding in the policy affects the principal's
          #     ability, or inability, to use the permission for the resource. The order of
          #     the role bindings matches the role binding order in the policy.
          #
          #     If the sender of the request does not have access to the policy, this field
          #     is omitted.
          # @!attribute [rw] relevance
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::HeuristicRelevance]
          #     The relevance of this policy to the overall access state in the
          #     {::Google::Cloud::PolicyTroubleshooter::Iam::V3::TroubleshootIamPolicyResponse TroubleshootIamPolicyResponse}.
          #
          #     If the sender of the request does not have access to the policy, this field
          #     is omitted.
          # @!attribute [rw] policy
          #   @return [::Google::Iam::V1::Policy]
          #     The IAM allow policy attached to the resource.
          #
          #     If the sender of the request does not have access to the policy, this field
          #     is empty.
          class ExplainedAllowPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details about how a role binding in an allow policy affects a principal's
          # ability to use a permission.
          # @!attribute [rw] allow_access_state
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::AllowAccessState]
          #     Required. Indicates whether _this role binding_ gives the specified
          #     permission to the specified principal on the specified resource.
          #
          #     This field does _not_ indicate whether the principal actually has the
          #     permission on the resource. There might be another role binding that
          #     overrides this role binding. To determine whether the principal actually
          #     has the permission, use the `overall_access_state` field in the
          #     {::Google::Cloud::PolicyTroubleshooter::Iam::V3::TroubleshootIamPolicyResponse TroubleshootIamPolicyResponse}.
          # @!attribute [rw] role
          #   @return [::String]
          #     The role that this role binding grants. For example,
          #     `roles/compute.admin`.
          #
          #     For a complete list of predefined IAM roles, as well as the permissions in
          #     each role, see https://cloud.google.com/iam/help/roles/reference.
          # @!attribute [rw] role_permission
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::RolePermissionInclusionState]
          #     Indicates whether the role granted by this role binding contains the
          #     specified permission.
          # @!attribute [rw] role_permission_relevance
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::HeuristicRelevance]
          #     The relevance of the permission's existence, or nonexistence, in the role
          #     to the overall determination for the entire policy.
          # @!attribute [rw] combined_membership
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::AllowBindingExplanation::AnnotatedAllowMembership]
          #     The combined result of all memberships. Indicates if the principal is
          #     included in any role binding, either directly or indirectly.
          # @!attribute [rw] memberships
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::PolicyTroubleshooter::Iam::V3::AllowBindingExplanation::AnnotatedAllowMembership}]
          #     Indicates whether each role binding includes the principal specified in the
          #     request, either directly or indirectly. Each key identifies a principal in
          #     the role binding, and each value indicates whether the principal in the
          #     role binding includes the principal in the request.
          #
          #     For example, suppose that a role binding includes the following principals:
          #
          #     * `user:alice@example.com`
          #     * `group:product-eng@example.com`
          #
          #     You want to troubleshoot access for `user:bob@example.com`. This user is a
          #     member of the group `group:product-eng@example.com`.
          #
          #     For the first principal in the role binding, the key is
          #     `user:alice@example.com`, and the `membership` field in the value is set to
          #     `NOT_INCLUDED`.
          #
          #     For the second principal in the role binding, the key is
          #     `group:product-eng@example.com`, and the `membership` field in the value is
          #     set to `INCLUDED`.
          # @!attribute [rw] relevance
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::HeuristicRelevance]
          #     The relevance of this role binding to the overall determination for the
          #     entire policy.
          # @!attribute [rw] condition
          #   @return [::Google::Type::Expr]
          #     A condition expression that specifies when the role binding grants access.
          #
          #     To learn about IAM Conditions, see
          #     https://cloud.google.com/iam/help/conditions/overview.
          # @!attribute [rw] condition_explanation
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::ConditionExplanation]
          #     Condition evaluation state for this role binding.
          class AllowBindingExplanation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Details about whether the role binding includes the principal.
            # @!attribute [rw] membership
            #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::MembershipMatchingState]
            #     Indicates whether the role binding includes the principal.
            # @!attribute [rw] relevance
            #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::HeuristicRelevance]
            #     The relevance of the principal's status to the overall determination for
            #     the role binding.
            class AnnotatedAllowMembership
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::AllowBindingExplanation::AnnotatedAllowMembership]
            class MembershipsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Details about how the relevant IAM deny policies affect the final access
          # state.
          # @!attribute [rw] deny_access_state
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyAccessState]
          #     Indicates whether the principal is denied the specified permission for
          #     the specified resource, based on evaluating all applicable IAM deny
          #     policies.
          # @!attribute [rw] explained_resources
          #   @return [::Array<::Google::Cloud::PolicyTroubleshooter::Iam::V3::ExplainedDenyResource>]
          #     List of resources with IAM deny policies that were evaluated to check the
          #     principal's denied permissions, with annotations to indicate how each
          #     policy contributed to the final result.
          #
          #     The list of resources includes the policy for the resource itself, as well
          #     as policies that are inherited from higher levels of the resource
          #     hierarchy, including the organization, the folder, and the project. The
          #     order of the resources starts from the resource and climbs up the resource
          #     hierarchy.
          #
          #     To learn more about the resource hierarchy, see
          #     https://cloud.google.com/iam/help/resource-hierarchy.
          # @!attribute [rw] relevance
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::HeuristicRelevance]
          #     The relevance of the deny policy result to the overall access state.
          # @!attribute [rw] permission_deniable
          #   @return [::Boolean]
          #     Indicates whether the permission to troubleshoot is supported in deny
          #     policies.
          class DenyPolicyExplanation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details about how a specific resource contributed to the deny policy
          # evaluation.
          # @!attribute [rw] deny_access_state
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyAccessState]
          #     Required. Indicates whether any policies attached to _this resource_ deny
          #     the specific permission to the specified principal for the specified
          #     resource.
          #
          #     This field does _not_ indicate whether the principal actually has the
          #     permission for the resource. There might be another policy that overrides
          #     this policy. To determine whether the principal actually has the
          #     permission, use the `overall_access_state` field in the
          #     {::Google::Cloud::PolicyTroubleshooter::Iam::V3::TroubleshootIamPolicyResponse TroubleshootIamPolicyResponse}.
          # @!attribute [rw] full_resource_name
          #   @return [::String]
          #     The full resource name that identifies the resource. For example,
          #     `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
          #
          #     If the sender of the request does not have access to the policy, this field
          #     is omitted.
          #
          #     For examples of full resource names for Google Cloud services, see
          #     https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
          # @!attribute [rw] explained_policies
          #   @return [::Array<::Google::Cloud::PolicyTroubleshooter::Iam::V3::ExplainedDenyPolicy>]
          #     List of IAM deny policies that were evaluated to check the principal's
          #     denied permissions, with annotations to indicate how each policy
          #     contributed to the final result.
          # @!attribute [rw] relevance
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::HeuristicRelevance]
          #     The relevance of this policy to the overall access state in the
          #     {::Google::Cloud::PolicyTroubleshooter::Iam::V3::TroubleshootIamPolicyResponse TroubleshootIamPolicyResponse}.
          #
          #     If the sender of the request does not have access to the policy, this field
          #     is omitted.
          class ExplainedDenyResource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details about how a specific IAM deny policy {::Google::Iam::V2::Policy Policy}
          # contributed to the access check.
          # @!attribute [rw] deny_access_state
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyAccessState]
          #     Required. Indicates whether _this policy_ denies the specified permission
          #     to the specified principal for the specified resource.
          #
          #     This field does _not_ indicate whether the principal actually has the
          #     permission for the resource. There might be another policy that overrides
          #     this policy. To determine whether the principal actually has the
          #     permission, use the `overall_access_state` field in the
          #     {::Google::Cloud::PolicyTroubleshooter::Iam::V3::TroubleshootIamPolicyResponse TroubleshootIamPolicyResponse}.
          # @!attribute [rw] policy
          #   @return [::Google::Iam::V2::Policy]
          #     The IAM deny policy attached to the resource.
          #
          #     If the sender of the request does not have access to the policy, this field
          #     is omitted.
          # @!attribute [rw] rule_explanations
          #   @return [::Array<::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyRuleExplanation>]
          #     Details about how each rule in the policy affects the principal's inability
          #     to use the permission for the resource. The order of the deny rule matches
          #     the order of the rules in the deny policy.
          #
          #     If the sender of the request does not have access to the policy, this field
          #     is omitted.
          # @!attribute [rw] relevance
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::HeuristicRelevance]
          #     The relevance of this policy to the overall access state in the
          #     {::Google::Cloud::PolicyTroubleshooter::Iam::V3::TroubleshootIamPolicyResponse TroubleshootIamPolicyResponse}.
          #
          #     If the sender of the request does not have access to the policy, this field
          #     is omitted.
          class ExplainedDenyPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details about how a deny rule in a deny policy affects a principal's ability
          # to use a permission.
          # @!attribute [rw] deny_access_state
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyAccessState]
          #     Required. Indicates whether _this rule_ denies the specified permission to
          #     the specified principal for the specified resource.
          #
          #     This field does _not_ indicate whether the principal is actually denied on
          #     the permission for the resource. There might be another rule that overrides
          #     this rule. To determine whether the principal actually has the permission,
          #     use the `overall_access_state` field in the
          #     {::Google::Cloud::PolicyTroubleshooter::Iam::V3::TroubleshootIamPolicyResponse TroubleshootIamPolicyResponse}.
          # @!attribute [rw] combined_denied_permission
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyRuleExplanation::AnnotatedPermissionMatching]
          #     Indicates whether the permission in the request is listed as a denied
          #     permission in the deny rule.
          # @!attribute [rw] denied_permissions
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyRuleExplanation::AnnotatedPermissionMatching}]
          #     Lists all denied permissions in the deny rule and indicates whether each
          #     permission matches the permission in the request.
          #
          #     Each key identifies a denied permission in the rule, and each value
          #     indicates whether the denied permission matches the permission in the
          #     request.
          # @!attribute [rw] combined_exception_permission
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyRuleExplanation::AnnotatedPermissionMatching]
          #     Indicates whether the permission in the request is listed as an exception
          #     permission in the deny rule.
          # @!attribute [rw] exception_permissions
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyRuleExplanation::AnnotatedPermissionMatching}]
          #     Lists all exception permissions in the deny rule and indicates whether each
          #     permission matches the permission in the request.
          #
          #     Each key identifies a exception permission in the rule, and each value
          #     indicates whether the exception permission matches the permission in the
          #     request.
          # @!attribute [rw] combined_denied_principal
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyRuleExplanation::AnnotatedDenyPrincipalMatching]
          #     Indicates whether the principal is listed as a denied principal in the
          #     deny rule, either directly or through membership in a principal set.
          # @!attribute [rw] denied_principals
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyRuleExplanation::AnnotatedDenyPrincipalMatching}]
          #     Lists all denied principals in the deny rule and indicates whether each
          #     principal matches the principal in the request, either directly or through
          #     membership in a principal set.
          #
          #     Each key identifies a denied principal in the rule, and each value
          #     indicates whether the denied principal matches the principal in the
          #     request.
          # @!attribute [rw] combined_exception_principal
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyRuleExplanation::AnnotatedDenyPrincipalMatching]
          #     Indicates whether the principal is listed as an exception principal in the
          #     deny rule, either directly or through membership in a principal set.
          # @!attribute [rw] exception_principals
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyRuleExplanation::AnnotatedDenyPrincipalMatching}]
          #     Lists all exception principals in the deny rule and indicates whether each
          #     principal matches the principal in the request, either directly or through
          #     membership in a principal set.
          #
          #     Each key identifies a exception principal in the rule, and each value
          #     indicates whether the exception principal matches the principal in the
          #     request.
          # @!attribute [rw] relevance
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::HeuristicRelevance]
          #     The relevance of this role binding to the overall determination for the
          #     entire policy.
          # @!attribute [rw] condition
          #   @return [::Google::Type::Expr]
          #     A condition expression that specifies when the deny rule denies the
          #     principal access.
          #
          #     To learn about IAM Conditions, see
          #     https://cloud.google.com/iam/help/conditions/overview.
          # @!attribute [rw] condition_explanation
          #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::ConditionExplanation]
          #     Condition evaluation state for this role binding.
          class DenyRuleExplanation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Details about whether the permission in the request is denied by the
            # deny rule.
            # @!attribute [rw] permission_matching_state
            #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::PermissionPatternMatchingState]
            #     Indicates whether the permission in the request is denied by the deny
            #     rule.
            # @!attribute [rw] relevance
            #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::HeuristicRelevance]
            #     The relevance of the permission status to the overall determination for
            #     the rule.
            class AnnotatedPermissionMatching
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Details about whether the principal in the request is listed as a denied
            # principal in the deny rule, either directly or through membership in a
            # principal set.
            # @!attribute [rw] membership
            #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::MembershipMatchingState]
            #     Indicates whether the principal is listed as a denied principal in the
            #     deny rule, either directly or through membership in a principal set.
            # @!attribute [rw] relevance
            #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::HeuristicRelevance]
            #     The relevance of the principal's status to the overall determination for
            #     the role binding.
            class AnnotatedDenyPrincipalMatching
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyRuleExplanation::AnnotatedPermissionMatching]
            class DeniedPermissionsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyRuleExplanation::AnnotatedPermissionMatching]
            class ExceptionPermissionsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyRuleExplanation::AnnotatedDenyPrincipalMatching]
            class DeniedPrincipalsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::PolicyTroubleshooter::Iam::V3::DenyRuleExplanation::AnnotatedDenyPrincipalMatching]
            class ExceptionPrincipalsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Explanation for how a condition affects a principal's access
          # @!attribute [rw] value
          #   @return [::Google::Protobuf::Value]
          #     Value of the condition.
          # @!attribute [rw] errors
          #   @return [::Array<::Google::Rpc::Status>]
          #     Any errors that prevented complete evaluation of the condition expression.
          # @!attribute [rw] evaluation_states
          #   @return [::Array<::Google::Cloud::PolicyTroubleshooter::Iam::V3::ConditionExplanation::EvaluationState>]
          #     The value of each statement of the condition expression. The value can be
          #     `true`, `false`, or `null`. The value is `null` if the statement can't be
          #     evaluated.
          class ConditionExplanation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Evaluated state of a condition expression.
            # @!attribute [rw] start
            #   @return [::Integer]
            #     Start position of an expression in the condition, by character.
            # @!attribute [rw] end
            #   @return [::Integer]
            #     End position of an expression in the condition, by character,
            #     end included, for example: the end position of the first part of
            #     `a==b || c==d` would be 4.
            # @!attribute [rw] value
            #   @return [::Google::Protobuf::Value]
            #     Value of this expression.
            # @!attribute [rw] errors
            #   @return [::Array<::Google::Rpc::Status>]
            #     Any errors that prevented complete evaluation of the condition
            #     expression.
            class EvaluationState
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Whether IAM allow policies gives the principal the permission.
          module AllowAccessState
            # Not specified.
            ALLOW_ACCESS_STATE_UNSPECIFIED = 0

            # The allow policy gives the principal the permission.
            ALLOW_ACCESS_STATE_GRANTED = 1

            # The allow policy doesn't give the principal the permission.
            ALLOW_ACCESS_STATE_NOT_GRANTED = 2

            # The allow policy gives the principal the permission if a condition
            # expression evaluate to `true`. However, the sender of the request didn't
            # provide enough context for Policy Troubleshooter to evaluate the condition
            # expression.
            ALLOW_ACCESS_STATE_UNKNOWN_CONDITIONAL = 3

            # The sender of the request doesn't have access to all of the allow policies
            # that Policy Troubleshooter needs to evaluate the principal's access.
            ALLOW_ACCESS_STATE_UNKNOWN_INFO = 4
          end

          # Whether IAM deny policies deny the principal the permission.
          module DenyAccessState
            # Not specified.
            DENY_ACCESS_STATE_UNSPECIFIED = 0

            # The deny policy denies the principal the permission.
            DENY_ACCESS_STATE_DENIED = 1

            # The deny policy doesn't deny the principal the permission.
            DENY_ACCESS_STATE_NOT_DENIED = 2

            # The deny policy denies the principal the permission if a condition
            # expression evaluates to `true`. However, the sender of the request didn't
            # provide enough context for Policy Troubleshooter to evaluate the condition
            # expression.
            DENY_ACCESS_STATE_UNKNOWN_CONDITIONAL = 3

            # The sender of the request does not have access to all of the deny policies
            # that Policy Troubleshooter needs to evaluate the principal's access.
            DENY_ACCESS_STATE_UNKNOWN_INFO = 4
          end

          # Whether a role includes a specific permission.
          module RolePermissionInclusionState
            # Not specified.
            ROLE_PERMISSION_INCLUSION_STATE_UNSPECIFIED = 0

            # The permission is included in the role.
            ROLE_PERMISSION_INCLUDED = 1

            # The permission is not included in the role.
            ROLE_PERMISSION_NOT_INCLUDED = 2

            # The sender of the request is not allowed to access the role definition.
            ROLE_PERMISSION_UNKNOWN_INFO = 3
          end

          # Whether the permission in the request matches the permission in the policy.
          module PermissionPatternMatchingState
            # Not specified.
            PERMISSION_PATTERN_MATCHING_STATE_UNSPECIFIED = 0

            # The permission in the request matches the permission in the policy.
            PERMISSION_PATTERN_MATCHED = 1

            # The permission in the request matches the permission in the policy.
            PERMISSION_PATTERN_NOT_MATCHED = 2
          end

          # Whether the principal in the request matches the principal in the policy.
          module MembershipMatchingState
            # Not specified.
            MEMBERSHIP_MATCHING_STATE_UNSPECIFIED = 0

            # The principal in the request matches the principal in the policy. The
            # principal can be included directly or indirectly:
            #
            # * A principal is included directly if that principal is listed in the
            #   role binding.
            # * A principal is included indirectly if that principal is in a Google
            #   group, Google Workspace account, or Cloud Identity domain that is listed
            #   in the policy.
            MEMBERSHIP_MATCHED = 1

            # The principal in the request doesn't match the principal in the policy.
            MEMBERSHIP_NOT_MATCHED = 2

            # The principal in the policy is a group or domain, and the sender of the
            # request doesn't have permission to view whether the principal in the
            # request is a member of the group or domain.
            MEMBERSHIP_UNKNOWN_INFO = 3

            # The principal is an unsupported type.
            MEMBERSHIP_UNKNOWN_UNSUPPORTED = 4
          end

          # The extent to which a single data point contributes to an overall
          # determination.
          module HeuristicRelevance
            # Not specified.
            HEURISTIC_RELEVANCE_UNSPECIFIED = 0

            # The data point has a limited effect on the result. Changing the data point
            # is unlikely to affect the overall determination.
            HEURISTIC_RELEVANCE_NORMAL = 1

            # The data point has a strong effect on the result. Changing the data point
            # is likely to affect the overall determination.
            HEURISTIC_RELEVANCE_HIGH = 2
          end
        end
      end
    end
  end
end
