# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# Require this file early so that the version constant gets defined before
# requiring "google/cloud". This is because google-cloud-core will load the
# entrypoint (gem name) file, which in turn re-requires this file (hence
# causing a require cycle) unless the version constant is already defined.
require "google/cloud/policy_simulator/version"

require "googleauth"
gem "google-cloud-core"
require "google/cloud" unless defined? ::Google::Cloud.new
require "google/cloud/config"

# Set the default configuration
::Google::Cloud.configure.add_config! :policy_simulator do |config|
  config.add_field! :endpoint,      nil, match: ::String
  config.add_field! :credentials,   nil, match: [::String, ::Hash, ::Google::Auth::Credentials]
  config.add_field! :scope,         nil, match: [::Array, ::String]
  config.add_field! :lib_name,      nil, match: ::String
  config.add_field! :lib_version,   nil, match: ::String
  config.add_field! :interceptors,  nil, match: ::Array
  config.add_field! :timeout,       nil, match: ::Numeric
  config.add_field! :metadata,      nil, match: ::Hash
  config.add_field! :retry_policy,  nil, match: [::Hash, ::Proc]
  config.add_field! :quota_project, nil, match: ::String
  config.add_field! :universe_domain, nil, match: ::String
end

module Google
  module Cloud
    module PolicySimulator
      ##
      # Create a new client object for OrgPolicyViolationsPreviewService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::PolicySimulator::V1::OrgPolicyViolationsPreviewService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-policy_simulator-v1/latest/Google-Cloud-PolicySimulator-V1-OrgPolicyViolationsPreviewService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the OrgPolicyViolationsPreviewService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the OrgPolicyViolationsPreviewService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::PolicySimulator.org_policy_violations_preview_service_available?}.
      #
      # ## About OrgPolicyViolationsPreviewService
      #
      # Violations Preview API service for OrgPolicy.
      #
      # An
      # OrgPolicyViolationsPreview
      # is a preview of the violations that will exist as soon as a proposed
      # OrgPolicy change is submitted. To create an
      # OrgPolicyViolationsPreview,
      # the API user specifies the changes they wish to make and requests the
      # generation of a preview via [GenerateViolationsPreview][]. the OrgPolicy
      # Simulator service then scans the API user's currently existing resources to
      # determine these resources violate the newly set OrgPolicy.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.org_policy_violations_preview_service version: :v1, transport: :grpc, &block
        require "google/cloud/policy_simulator/#{version.to_s.downcase}"

        package_name = Google::Cloud::PolicySimulator
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::PolicySimulator.const_get(package_name).const_get(:OrgPolicyViolationsPreviewService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the OrgPolicyViolationsPreviewService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::PolicySimulator.org_policy_violations_preview_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the OrgPolicyViolationsPreviewService service,
      # or if the versioned client gem needs an update to support the OrgPolicyViolationsPreviewService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.org_policy_violations_preview_service_available? version: :v1, transport: :grpc
        require "google/cloud/policy_simulator/#{version.to_s.downcase}"
        package_name = Google::Cloud::PolicySimulator
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::PolicySimulator.const_get package_name
        return false unless service_module.const_defined? :OrgPolicyViolationsPreviewService
        service_module = service_module.const_get :OrgPolicyViolationsPreviewService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for Simulator.
      #
      # By default, this returns an instance of
      # [Google::Cloud::PolicySimulator::V1::Simulator::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-policy_simulator-v1/latest/Google-Cloud-PolicySimulator-V1-Simulator-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Simulator service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the Simulator service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::PolicySimulator.simulator_available?}.
      #
      # ## About Simulator
      #
      # Policy Simulator API service.
      #
      # Policy Simulator is a collection of endpoints for creating, running, and
      # viewing a Replay. A
      # Replay is a type of simulation that
      # lets you see how your principals' access to resources might change if you
      # changed your IAM policy.
      #
      # During a Replay, Policy Simulator
      # re-evaluates, or replays, past access attempts under both the current policy
      # and  your proposed policy, and compares those results to determine how your
      # principals' access might change under the proposed policy.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.simulator version: :v1, transport: :grpc, &block
        require "google/cloud/policy_simulator/#{version.to_s.downcase}"

        package_name = Google::Cloud::PolicySimulator
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::PolicySimulator.const_get(package_name).const_get(:Simulator)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Simulator service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::PolicySimulator.simulator}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Simulator service,
      # or if the versioned client gem needs an update to support the Simulator service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.simulator_available? version: :v1, transport: :grpc
        require "google/cloud/policy_simulator/#{version.to_s.downcase}"
        package_name = Google::Cloud::PolicySimulator
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::PolicySimulator.const_get package_name
        return false unless service_module.const_defined? :Simulator
        service_module = service_module.const_get :Simulator
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Configure the google-cloud-policy_simulator library.
      #
      # The following configuration parameters are supported:
      #
      # * `credentials` (*type:* `String, Hash, Google::Auth::Credentials`) -
      #   The path to the keyfile as a String, the contents of the keyfile as a
      #   Hash, or a Google::Auth::Credentials object.
      # * `lib_name` (*type:* `String`) -
      #   The library name as recorded in instrumentation and logging.
      # * `lib_version` (*type:* `String`) -
      #   The library version as recorded in instrumentation and logging.
      # * `interceptors` (*type:* `Array<GRPC::ClientInterceptor>`) -
      #   An array of interceptors that are run before calls are executed.
      # * `timeout` (*type:* `Numeric`) -
      #   Default timeout in seconds.
      # * `metadata` (*type:* `Hash{Symbol=>String}`) -
      #   Additional headers to be sent with the call.
      # * `retry_policy` (*type:* `Hash`) -
      #   The retry policy. The value is a hash with the following keys:
      #     * `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
      #     * `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
      #     * `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
      #     * `:retry_codes` (*type:* `Array<String>`) -
      #       The error codes that should trigger a retry.
      #
      # @return [::Google::Cloud::Config] The default configuration used by this library
      #
      def self.configure
        yield ::Google::Cloud.configure.policy_simulator if block_given?

        ::Google::Cloud.configure.policy_simulator
      end
    end
  end
end

helper_path = ::File.join __dir__, "policy_simulator", "helpers.rb"
require "google/cloud/policy_simulator/helpers" if ::File.file? helper_path
