# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module PolicySimulator
      module V1
        # A resource describing a `Replay`, or simulation.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the `Replay`, which has the following
        #     format:
        #
        #     `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`,
        #     where `{resource-id}` is the ID of the project, folder, or organization
        #     that owns the Replay.
        #
        #     Example:
        #     `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
        # @!attribute [r] state
        #   @return [::Google::Cloud::PolicySimulator::V1::Replay::State]
        #     Output only. The current state of the `Replay`.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::PolicySimulator::V1::ReplayConfig]
        #     Required. The configuration used for the `Replay`.
        # @!attribute [r] results_summary
        #   @return [::Google::Cloud::PolicySimulator::V1::Replay::ResultsSummary]
        #     Output only. Summary statistics about the replayed log entries.
        class Replay
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Summary statistics about the replayed log entries.
          # @!attribute [rw] log_count
          #   @return [::Integer]
          #     The total number of log entries replayed.
          # @!attribute [rw] unchanged_count
          #   @return [::Integer]
          #     The number of replayed log entries with no difference between
          #     baseline and simulated policies.
          # @!attribute [rw] difference_count
          #   @return [::Integer]
          #     The number of replayed log entries with a difference between baseline and
          #     simulated policies.
          # @!attribute [rw] error_count
          #   @return [::Integer]
          #     The number of log entries that could not be replayed.
          # @!attribute [rw] oldest_date
          #   @return [::Google::Type::Date]
          #     The date of the oldest log entry replayed.
          # @!attribute [rw] newest_date
          #   @return [::Google::Type::Date]
          #     The date of the newest log entry replayed.
          class ResultsSummary
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The current state of the {::Google::Cloud::PolicySimulator::V1::Replay Replay}.
          module State
            # Default value. This value is unused.
            STATE_UNSPECIFIED = 0

            # The `Replay` has not started yet.
            PENDING = 1

            # The `Replay` is currently running.
            RUNNING = 2

            # The `Replay` has successfully completed.
            SUCCEEDED = 3

            # The `Replay` has finished with an error.
            FAILED = 4
          end
        end

        # The result of replaying a single access tuple against a simulated state.
        # @!attribute [rw] diff
        #   @return [::Google::Cloud::PolicySimulator::V1::ReplayDiff]
        #     The difference between the principal's access under the current
        #     (baseline) policies and the principal's access under the proposed
        #     (simulated) policies.
        #
        #     This field is only included for access tuples that were successfully
        #     replayed and had different results under the current policies and the
        #     proposed policies.
        #
        #     Note: The following fields are mutually exclusive: `diff`, `error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] error
        #   @return [::Google::Rpc::Status]
        #     The error that caused the access tuple replay to fail.
        #
        #     This field is only included for access tuples that were not replayed
        #     successfully.
        #
        #     Note: The following fields are mutually exclusive: `error`, `diff`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the `ReplayResult`, in the following format:
        #
        #     `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}/results/{replay-result-id}`,
        #     where `{resource-id}` is the ID of the project, folder, or organization
        #     that owns the {::Google::Cloud::PolicySimulator::V1::Replay Replay}.
        #
        #     Example:
        #     `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36/results/1234`
        # @!attribute [rw] parent
        #   @return [::String]
        #     The {::Google::Cloud::PolicySimulator::V1::Replay Replay} that the access tuple
        #     was included in.
        # @!attribute [rw] access_tuple
        #   @return [::Google::Cloud::PolicySimulator::V1::AccessTuple]
        #     The access tuple that was replayed. This field includes information about
        #     the principal, resource, and permission that were involved in the access
        #     attempt.
        # @!attribute [rw] last_seen_date
        #   @return [::Google::Type::Date]
        #     The latest date this access tuple was seen in the logs.
        class ReplayResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::PolicySimulator::V1::Simulator::Client#create_replay Simulator.CreateReplay}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this
        #     {::Google::Cloud::PolicySimulator::V1::Replay Replay} will be created. This
        #     resource must be a project, folder, or organization with a location.
        #
        #     Example: `projects/my-example-project/locations/global`
        # @!attribute [rw] replay
        #   @return [::Google::Cloud::PolicySimulator::V1::Replay]
        #     Required. The {::Google::Cloud::PolicySimulator::V1::Replay Replay} to create.
        #     Set `Replay.ReplayConfig` to configure the replay.
        class CreateReplayRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata about a Replay operation.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when the request was received.
        class ReplayOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::PolicySimulator::V1::Simulator::Client#get_replay Simulator.GetReplay}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the {::Google::Cloud::PolicySimulator::V1::Replay Replay}
        #     to retrieve, in the following format:
        #
        #     `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`,
        #     where `{resource-id}` is the ID of the project, folder, or organization
        #     that owns the `Replay`.
        #
        #     Example:
        #     `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
        class GetReplayRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::PolicySimulator::V1::Simulator::Client#list_replay_results Simulator.ListReplayResults}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The {::Google::Cloud::PolicySimulator::V1::Replay Replay} whose
        #     results are listed, in the following format:
        #
        #     `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`
        #
        #     Example:
        #     `projects/my-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of
        #     {::Google::Cloud::PolicySimulator::V1::ReplayResult ReplayResult} objects to
        #     return. Defaults to 5000.
        #
        #     The maximum value is 5000; values above 5000 are rounded down to 5000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::PolicySimulator::V1::Simulator::Client#list_replay_results Simulator.ListReplayResults}
        #     call. Provide this token to retrieve the next page of results.
        #
        #     When paginating, all other parameters provided to
        #     [Simulator.ListReplayResults[] must match the call that provided the page
        #     token.
        class ListReplayResultsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::PolicySimulator::V1::Simulator::Client#list_replay_results Simulator.ListReplayResults}.
        # @!attribute [rw] replay_results
        #   @return [::Array<::Google::Cloud::PolicySimulator::V1::ReplayResult>]
        #     The results of running a {::Google::Cloud::PolicySimulator::V1::Replay Replay}.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that you can use to retrieve the next page of
        #     {::Google::Cloud::PolicySimulator::V1::ReplayResult ReplayResult} objects. If
        #     this field is omitted, there are no subsequent pages.
        class ListReplayResultsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The configuration used for a
        # {::Google::Cloud::PolicySimulator::V1::Replay Replay}.
        # @!attribute [rw] policy_overlay
        #   @return [::Google::Protobuf::Map{::String => ::Google::Iam::V1::Policy}]
        #     A mapping of the resources that you want to simulate policies for and the
        #     policies that you want to simulate.
        #
        #     Keys are the full resource names for the resources. For example,
        #     `//cloudresourcemanager.googleapis.com/projects/my-project`.
        #     For examples of full resource names for Google Cloud services, see
        #     https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
        #
        #     Values are [Policy][google.iam.v1.Policy] objects representing the policies
        #     that you want to simulate.
        #
        #     Replays automatically take into account any IAM policies inherited through
        #     the resource hierarchy, and any policies set on descendant resources. You
        #     do not need to include these policies in the policy overlay.
        # @!attribute [rw] log_source
        #   @return [::Google::Cloud::PolicySimulator::V1::ReplayConfig::LogSource]
        #     The logs to use as input for the
        #     {::Google::Cloud::PolicySimulator::V1::Replay Replay}.
        class ReplayConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Iam::V1::Policy]
          class PolicyOverlayEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The source of the logs to use for a
          # {::Google::Cloud::PolicySimulator::V1::Replay Replay}.
          module LogSource
            # An unspecified log source.
            # If the log source is unspecified, the
            # {::Google::Cloud::PolicySimulator::V1::Replay Replay} defaults to using
            # `RECENT_ACCESSES`.
            LOG_SOURCE_UNSPECIFIED = 0

            # All access logs from the last 90 days. These logs may not include logs
            # from the most recent 7 days.
            RECENT_ACCESSES = 1
          end
        end

        # The difference between the results of evaluating an access tuple under
        # the current (baseline) policies and under the proposed (simulated) policies.
        # This difference explains how a principal's access could change if the
        # proposed policies were applied.
        # @!attribute [rw] access_diff
        #   @return [::Google::Cloud::PolicySimulator::V1::AccessStateDiff]
        #     A summary and comparison of the principal's access under the current
        #     (baseline) policies and the proposed (simulated) policies for a single
        #     access tuple.
        #
        #     The evaluation of the principal's access is reported in the
        #     {::Google::Cloud::PolicySimulator::V1::AccessState AccessState} field.
        class ReplayDiff
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A summary and comparison of the principal's access under the current
        # (baseline) policies and the proposed (simulated) policies for a single
        # access tuple.
        # @!attribute [rw] baseline
        #   @return [::Google::Cloud::PolicySimulator::V1::ExplainedAccess]
        #     The results of evaluating the access tuple under the current (baseline)
        #     policies.
        #
        #     If the {::Google::Cloud::PolicySimulator::V1::AccessState AccessState} couldn't
        #     be fully evaluated, this field explains why.
        # @!attribute [rw] simulated
        #   @return [::Google::Cloud::PolicySimulator::V1::ExplainedAccess]
        #     The results of evaluating the access tuple under the proposed (simulated)
        #     policies.
        #
        #     If the AccessState couldn't be fully evaluated, this field explains why.
        # @!attribute [rw] access_change
        #   @return [::Google::Cloud::PolicySimulator::V1::AccessStateDiff::AccessChangeType]
        #     How the principal's access, specified in the AccessState field, changed
        #     between the current (baseline) policies and proposed (simulated) policies.
        class AccessStateDiff
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # How the principal's access, specified in the AccessState field, changed
          # between the current (baseline) policies and proposed (simulated) policies.
          module AccessChangeType
            # Default value. This value is unused.
            ACCESS_CHANGE_TYPE_UNSPECIFIED = 0

            # The principal's access did not change.
            # This includes the case where both baseline and simulated are UNKNOWN,
            # but the unknown information is equivalent.
            NO_CHANGE = 1

            # The principal's access under both the current policies and the proposed
            # policies is `UNKNOWN`, but the unknown information differs between them.
            UNKNOWN_CHANGE = 2

            # The principal had access under the current policies (`GRANTED`), but will
            # no longer have access after the proposed changes (`NOT_GRANTED`).
            ACCESS_REVOKED = 3

            # The principal did not have access under the current policies
            # (`NOT_GRANTED`), but will have access after the proposed changes
            # (`GRANTED`).
            ACCESS_GAINED = 4

            # This result can occur for the following reasons:
            #
            # * The principal had access under the current policies (`GRANTED`), but
            #   their access after the proposed changes is `UNKNOWN`.
            #
            # * The principal's access under the current policies is `UNKNOWN`, but
            # they
            #   will not have access after the proposed changes (`NOT_GRANTED`).
            ACCESS_MAYBE_REVOKED = 5

            # This result can occur for the following reasons:
            #
            # * The principal did not have access under the current policies
            #   (`NOT_GRANTED`), but their access after the proposed changes is
            #   `UNKNOWN`.
            #
            # * The principal's access under the current policies is `UNKNOWN`, but
            # they will have access after the proposed changes (`GRANTED`).
            ACCESS_MAYBE_GAINED = 6
          end
        end

        # Details about how a set of policies, listed in
        # {::Google::Cloud::PolicySimulator::V1::ExplainedPolicy ExplainedPolicy}, resulted
        # in a certain {::Google::Cloud::PolicySimulator::V1::AccessState AccessState} when
        # replaying an access tuple.
        # @!attribute [rw] access_state
        #   @return [::Google::Cloud::PolicySimulator::V1::AccessState]
        #     Whether the principal in the access tuple has permission to access the
        #     resource in the access tuple under the given policies.
        # @!attribute [rw] policies
        #   @return [::Array<::Google::Cloud::PolicySimulator::V1::ExplainedPolicy>]
        #     If the {::Google::Cloud::PolicySimulator::V1::AccessState AccessState} is
        #     `UNKNOWN`, this field contains the policies that led to that result.
        #
        #     If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
        #     omitted.
        # @!attribute [rw] errors
        #   @return [::Array<::Google::Rpc::Status>]
        #     If the {::Google::Cloud::PolicySimulator::V1::AccessState AccessState} is
        #     `UNKNOWN`, this field contains a list of errors explaining why the result
        #     is `UNKNOWN`.
        #
        #     If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
        #     omitted.
        class ExplainedAccess
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
