# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module PolicySimulator
      module V1
        module Simulator
          # Path helper methods for the Simulator API.
          module Paths
            ##
            # Create a fully-qualified Replay resource string.
            #
            # @overload replay_path(project:, location:, replay:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/replays/{replay}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param replay [String]
            #
            # @overload replay_path(folder:, location:, replay:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/locations/{location}/replays/{replay}`
            #
            #   @param folder [String]
            #   @param location [String]
            #   @param replay [String]
            #
            # @overload replay_path(organization:, location:, replay:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/replays/{replay}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param replay [String]
            #
            # @return [::String]
            def replay_path **args
              resources = {
                "location:project:replay" => (proc do |project:, location:, replay:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/replays/#{replay}"
                end),
                "folder:location:replay" => (proc do |folder:, location:, replay:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "folders/#{folder}/locations/#{location}/replays/#{replay}"
                end),
                "location:organization:replay" => (proc do |organization:, location:, replay:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/replays/#{replay}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            extend self
          end
        end
      end
    end
  end
end
