# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/parametermanager/v1/service_pb"
require "google/cloud/parameter_manager/v1/parameter_manager"

class ::Google::Cloud::ParameterManager::V1::ParameterManager::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_parameters
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ParameterManager::V1::ListParametersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_parameters_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_parameters, name
      assert_kind_of ::Google::Cloud::ParameterManager::V1::ListParametersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_parameters_client_stub do
      # Create client
      client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_parameters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_parameters parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_parameters ::Google::Cloud::ParameterManager::V1::ListParametersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_parameters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_parameters(::Google::Cloud::ParameterManager::V1::ListParametersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_parameters_client_stub.call_rpc_count
    end
  end

  def test_get_parameter
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ParameterManager::V1::Parameter.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_parameter_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_parameter, name
      assert_kind_of ::Google::Cloud::ParameterManager::V1::GetParameterRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_parameter_client_stub do
      # Create client
      client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_parameter({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_parameter name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_parameter ::Google::Cloud::ParameterManager::V1::GetParameterRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_parameter({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_parameter(::Google::Cloud::ParameterManager::V1::GetParameterRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_parameter_client_stub.call_rpc_count
    end
  end

  def test_create_parameter
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ParameterManager::V1::Parameter.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    parameter_id = "hello world"
    parameter = {}
    request_id = "hello world"

    create_parameter_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_parameter, name
      assert_kind_of ::Google::Cloud::ParameterManager::V1::CreateParameterRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["parameter_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ParameterManager::V1::Parameter), request["parameter"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_parameter_client_stub do
      # Create client
      client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_parameter({ parent: parent, parameter_id: parameter_id, parameter: parameter, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_parameter parent: parent, parameter_id: parameter_id, parameter: parameter, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_parameter ::Google::Cloud::ParameterManager::V1::CreateParameterRequest.new(parent: parent, parameter_id: parameter_id, parameter: parameter, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_parameter({ parent: parent, parameter_id: parameter_id, parameter: parameter, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_parameter(::Google::Cloud::ParameterManager::V1::CreateParameterRequest.new(parent: parent, parameter_id: parameter_id, parameter: parameter, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_parameter_client_stub.call_rpc_count
    end
  end

  def test_update_parameter
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ParameterManager::V1::Parameter.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    parameter = {}
    request_id = "hello world"

    update_parameter_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_parameter, name
      assert_kind_of ::Google::Cloud::ParameterManager::V1::UpdateParameterRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ParameterManager::V1::Parameter), request["parameter"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_parameter_client_stub do
      # Create client
      client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_parameter({ update_mask: update_mask, parameter: parameter, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_parameter update_mask: update_mask, parameter: parameter, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_parameter ::Google::Cloud::ParameterManager::V1::UpdateParameterRequest.new(update_mask: update_mask, parameter: parameter, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_parameter({ update_mask: update_mask, parameter: parameter, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_parameter(::Google::Cloud::ParameterManager::V1::UpdateParameterRequest.new(update_mask: update_mask, parameter: parameter, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_parameter_client_stub.call_rpc_count
    end
  end

  def test_delete_parameter
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_parameter_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_parameter, name
      assert_kind_of ::Google::Cloud::ParameterManager::V1::DeleteParameterRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_parameter_client_stub do
      # Create client
      client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_parameter({ name: name, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_parameter name: name, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_parameter ::Google::Cloud::ParameterManager::V1::DeleteParameterRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_parameter({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_parameter(::Google::Cloud::ParameterManager::V1::DeleteParameterRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_parameter_client_stub.call_rpc_count
    end
  end

  def test_list_parameter_versions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ParameterManager::V1::ListParameterVersionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_parameter_versions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_parameter_versions, name
      assert_kind_of ::Google::Cloud::ParameterManager::V1::ListParameterVersionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_parameter_versions_client_stub do
      # Create client
      client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_parameter_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_parameter_versions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_parameter_versions ::Google::Cloud::ParameterManager::V1::ListParameterVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_parameter_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_parameter_versions(::Google::Cloud::ParameterManager::V1::ListParameterVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_parameter_versions_client_stub.call_rpc_count
    end
  end

  def test_get_parameter_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ParameterManager::V1::ParameterVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :VIEW_UNSPECIFIED

    get_parameter_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_parameter_version, name
      assert_kind_of ::Google::Cloud::ParameterManager::V1::GetParameterVersionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_parameter_version_client_stub do
      # Create client
      client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_parameter_version({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_parameter_version name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_parameter_version ::Google::Cloud::ParameterManager::V1::GetParameterVersionRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_parameter_version({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_parameter_version(::Google::Cloud::ParameterManager::V1::GetParameterVersionRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_parameter_version_client_stub.call_rpc_count
    end
  end

  def test_render_parameter_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ParameterManager::V1::RenderParameterVersionResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    render_parameter_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :render_parameter_version, name
      assert_kind_of ::Google::Cloud::ParameterManager::V1::RenderParameterVersionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, render_parameter_version_client_stub do
      # Create client
      client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.render_parameter_version({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.render_parameter_version name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.render_parameter_version ::Google::Cloud::ParameterManager::V1::RenderParameterVersionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.render_parameter_version({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.render_parameter_version(::Google::Cloud::ParameterManager::V1::RenderParameterVersionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, render_parameter_version_client_stub.call_rpc_count
    end
  end

  def test_create_parameter_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ParameterManager::V1::ParameterVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    parameter_version_id = "hello world"
    parameter_version = {}
    request_id = "hello world"

    create_parameter_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_parameter_version, name
      assert_kind_of ::Google::Cloud::ParameterManager::V1::CreateParameterVersionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["parameter_version_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ParameterManager::V1::ParameterVersion), request["parameter_version"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_parameter_version_client_stub do
      # Create client
      client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_parameter_version({ parent: parent, parameter_version_id: parameter_version_id, parameter_version: parameter_version, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_parameter_version parent: parent, parameter_version_id: parameter_version_id, parameter_version: parameter_version, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_parameter_version ::Google::Cloud::ParameterManager::V1::CreateParameterVersionRequest.new(parent: parent, parameter_version_id: parameter_version_id, parameter_version: parameter_version, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_parameter_version({ parent: parent, parameter_version_id: parameter_version_id, parameter_version: parameter_version, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_parameter_version(::Google::Cloud::ParameterManager::V1::CreateParameterVersionRequest.new(parent: parent, parameter_version_id: parameter_version_id, parameter_version: parameter_version, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_parameter_version_client_stub.call_rpc_count
    end
  end

  def test_update_parameter_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ParameterManager::V1::ParameterVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    parameter_version = {}
    request_id = "hello world"

    update_parameter_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_parameter_version, name
      assert_kind_of ::Google::Cloud::ParameterManager::V1::UpdateParameterVersionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ParameterManager::V1::ParameterVersion), request["parameter_version"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_parameter_version_client_stub do
      # Create client
      client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_parameter_version({ update_mask: update_mask, parameter_version: parameter_version, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_parameter_version update_mask: update_mask, parameter_version: parameter_version, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_parameter_version ::Google::Cloud::ParameterManager::V1::UpdateParameterVersionRequest.new(update_mask: update_mask, parameter_version: parameter_version, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_parameter_version({ update_mask: update_mask, parameter_version: parameter_version, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_parameter_version(::Google::Cloud::ParameterManager::V1::UpdateParameterVersionRequest.new(update_mask: update_mask, parameter_version: parameter_version, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_parameter_version_client_stub.call_rpc_count
    end
  end

  def test_delete_parameter_version
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_parameter_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_parameter_version, name
      assert_kind_of ::Google::Cloud::ParameterManager::V1::DeleteParameterVersionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_parameter_version_client_stub do
      # Create client
      client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_parameter_version({ name: name, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_parameter_version name: name, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_parameter_version ::Google::Cloud::ParameterManager::V1::DeleteParameterVersionRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_parameter_version({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_parameter_version(::Google::Cloud::ParameterManager::V1::DeleteParameterVersionRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_parameter_version_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ParameterManager::V1::ParameterManager::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::ParameterManager::V1::ParameterManager::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
