# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/parametermanager/v1/service_pb"
require "google/cloud/parameter_manager/v1/parameter_manager/rest"


class ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_parameters
    # Create test objects.
    client_result = ::Google::Cloud::ParameterManager::V1::ListParametersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_parameters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::ServiceStub.stub :transcode_list_parameters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_parameters_client_stub do
        # Create client
        client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_parameters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_parameters parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_parameters ::Google::Cloud::ParameterManager::V1::ListParametersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_parameters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_parameters(::Google::Cloud::ParameterManager::V1::ListParametersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_parameters_client_stub.call_count
      end
    end
  end

  def test_get_parameter
    # Create test objects.
    client_result = ::Google::Cloud::ParameterManager::V1::Parameter.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_parameter_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::ServiceStub.stub :transcode_get_parameter_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_parameter_client_stub do
        # Create client
        client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_parameter({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_parameter name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_parameter ::Google::Cloud::ParameterManager::V1::GetParameterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_parameter({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_parameter(::Google::Cloud::ParameterManager::V1::GetParameterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_parameter_client_stub.call_count
      end
    end
  end

  def test_create_parameter
    # Create test objects.
    client_result = ::Google::Cloud::ParameterManager::V1::Parameter.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    parameter_id = "hello world"
    parameter = {}
    request_id = "hello world"

    create_parameter_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::ServiceStub.stub :transcode_create_parameter_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_parameter_client_stub do
        # Create client
        client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_parameter({ parent: parent, parameter_id: parameter_id, parameter: parameter, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_parameter parent: parent, parameter_id: parameter_id, parameter: parameter, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_parameter ::Google::Cloud::ParameterManager::V1::CreateParameterRequest.new(parent: parent, parameter_id: parameter_id, parameter: parameter, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_parameter({ parent: parent, parameter_id: parameter_id, parameter: parameter, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_parameter(::Google::Cloud::ParameterManager::V1::CreateParameterRequest.new(parent: parent, parameter_id: parameter_id, parameter: parameter, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_parameter_client_stub.call_count
      end
    end
  end

  def test_update_parameter
    # Create test objects.
    client_result = ::Google::Cloud::ParameterManager::V1::Parameter.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    parameter = {}
    request_id = "hello world"

    update_parameter_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::ServiceStub.stub :transcode_update_parameter_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_parameter_client_stub do
        # Create client
        client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_parameter({ update_mask: update_mask, parameter: parameter, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_parameter update_mask: update_mask, parameter: parameter, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_parameter ::Google::Cloud::ParameterManager::V1::UpdateParameterRequest.new(update_mask: update_mask, parameter: parameter, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_parameter({ update_mask: update_mask, parameter: parameter, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_parameter(::Google::Cloud::ParameterManager::V1::UpdateParameterRequest.new(update_mask: update_mask, parameter: parameter, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_parameter_client_stub.call_count
      end
    end
  end

  def test_delete_parameter
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_parameter_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::ServiceStub.stub :transcode_delete_parameter_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_parameter_client_stub do
        # Create client
        client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_parameter({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_parameter name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_parameter ::Google::Cloud::ParameterManager::V1::DeleteParameterRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_parameter({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_parameter(::Google::Cloud::ParameterManager::V1::DeleteParameterRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_parameter_client_stub.call_count
      end
    end
  end

  def test_list_parameter_versions
    # Create test objects.
    client_result = ::Google::Cloud::ParameterManager::V1::ListParameterVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_parameter_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::ServiceStub.stub :transcode_list_parameter_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_parameter_versions_client_stub do
        # Create client
        client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_parameter_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_parameter_versions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_parameter_versions ::Google::Cloud::ParameterManager::V1::ListParameterVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_parameter_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_parameter_versions(::Google::Cloud::ParameterManager::V1::ListParameterVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_parameter_versions_client_stub.call_count
      end
    end
  end

  def test_get_parameter_version
    # Create test objects.
    client_result = ::Google::Cloud::ParameterManager::V1::ParameterVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :VIEW_UNSPECIFIED

    get_parameter_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::ServiceStub.stub :transcode_get_parameter_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_parameter_version_client_stub do
        # Create client
        client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_parameter_version({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_parameter_version name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_parameter_version ::Google::Cloud::ParameterManager::V1::GetParameterVersionRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_parameter_version({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_parameter_version(::Google::Cloud::ParameterManager::V1::GetParameterVersionRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_parameter_version_client_stub.call_count
      end
    end
  end

  def test_render_parameter_version
    # Create test objects.
    client_result = ::Google::Cloud::ParameterManager::V1::RenderParameterVersionResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    render_parameter_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::ServiceStub.stub :transcode_render_parameter_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, render_parameter_version_client_stub do
        # Create client
        client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.render_parameter_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.render_parameter_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.render_parameter_version ::Google::Cloud::ParameterManager::V1::RenderParameterVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.render_parameter_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.render_parameter_version(::Google::Cloud::ParameterManager::V1::RenderParameterVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, render_parameter_version_client_stub.call_count
      end
    end
  end

  def test_create_parameter_version
    # Create test objects.
    client_result = ::Google::Cloud::ParameterManager::V1::ParameterVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    parameter_version_id = "hello world"
    parameter_version = {}
    request_id = "hello world"

    create_parameter_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::ServiceStub.stub :transcode_create_parameter_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_parameter_version_client_stub do
        # Create client
        client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_parameter_version({ parent: parent, parameter_version_id: parameter_version_id, parameter_version: parameter_version, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_parameter_version parent: parent, parameter_version_id: parameter_version_id, parameter_version: parameter_version, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_parameter_version ::Google::Cloud::ParameterManager::V1::CreateParameterVersionRequest.new(parent: parent, parameter_version_id: parameter_version_id, parameter_version: parameter_version, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_parameter_version({ parent: parent, parameter_version_id: parameter_version_id, parameter_version: parameter_version, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_parameter_version(::Google::Cloud::ParameterManager::V1::CreateParameterVersionRequest.new(parent: parent, parameter_version_id: parameter_version_id, parameter_version: parameter_version, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_parameter_version_client_stub.call_count
      end
    end
  end

  def test_update_parameter_version
    # Create test objects.
    client_result = ::Google::Cloud::ParameterManager::V1::ParameterVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    parameter_version = {}
    request_id = "hello world"

    update_parameter_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::ServiceStub.stub :transcode_update_parameter_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_parameter_version_client_stub do
        # Create client
        client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_parameter_version({ update_mask: update_mask, parameter_version: parameter_version, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_parameter_version update_mask: update_mask, parameter_version: parameter_version, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_parameter_version ::Google::Cloud::ParameterManager::V1::UpdateParameterVersionRequest.new(update_mask: update_mask, parameter_version: parameter_version, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_parameter_version({ update_mask: update_mask, parameter_version: parameter_version, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_parameter_version(::Google::Cloud::ParameterManager::V1::UpdateParameterVersionRequest.new(update_mask: update_mask, parameter_version: parameter_version, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_parameter_version_client_stub.call_count
      end
    end
  end

  def test_delete_parameter_version
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_parameter_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::ServiceStub.stub :transcode_delete_parameter_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_parameter_version_client_stub do
        # Create client
        client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_parameter_version({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_parameter_version name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_parameter_version ::Google::Cloud::ParameterManager::V1::DeleteParameterVersionRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_parameter_version({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_parameter_version(::Google::Cloud::ParameterManager::V1::DeleteParameterVersionRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_parameter_version_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ParameterManager::V1::ParameterManager::Rest::Client::Configuration, config
  end
end
