# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ParameterManager
      module V1
        module ParameterManager
          # Path helper methods for the ParameterManager API.
          module Paths
            ##
            # Create a fully-qualified CryptoKey resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`
            #
            # @param project [String]
            # @param location [String]
            # @param key_ring [String]
            # @param crypto_key [String]
            #
            # @return [::String]
            def crypto_key_path project:, location:, key_ring:, crypto_key:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "key_ring cannot contain /" if key_ring.to_s.include? "/"

              "projects/#{project}/locations/#{location}/keyRings/#{key_ring}/cryptoKeys/#{crypto_key}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Parameter resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/parameters/{parameter}`
            #
            # @param project [String]
            # @param location [String]
            # @param parameter [String]
            #
            # @return [::String]
            def parameter_path project:, location:, parameter:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/parameters/#{parameter}"
            end

            ##
            # Create a fully-qualified ParameterVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/parameters/{parameter}/versions/{parameter_version}`
            #
            # @param project [String]
            # @param location [String]
            # @param parameter [String]
            # @param parameter_version [String]
            #
            # @return [::String]
            def parameter_version_path project:, location:, parameter:, parameter_version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "parameter cannot contain /" if parameter.to_s.include? "/"

              "projects/#{project}/locations/#{location}/parameters/#{parameter}/versions/#{parameter_version}"
            end

            extend self
          end
        end
      end
    end
  end
end
