# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/rest"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/parallelstore/v1beta/version"
require "google/cloud/parallelstore/v1beta/bindings_override"

require "google/cloud/parallelstore/v1beta/parallelstore/credentials"
require "google/cloud/parallelstore/v1beta/parallelstore/paths"
require "google/cloud/parallelstore/v1beta/parallelstore/rest/operations"
require "google/cloud/parallelstore/v1beta/parallelstore/rest/client"

module Google
  module Cloud
    module Parallelstore
      module V1beta
        ##
        # Service describing handlers for resources
        # Configures and manages parallelstore resources.
        #
        # Parallelstore service.
        #
        # The `parallelstore.googleapis.com` service implements the parallelstore API
        # and defines the following resource model for managing instances:
        # * The service works with a collection of cloud projects, named: `/projects/*`
        # * Each project has a collection of available locations, named: `/locations/*`
        # * Each location has a collection of instances named `/instances/*`.
        # * Parallelstore instances are resources of the form:
        #   `/projects/{project_id}/locations/{location_id}/instances/{instance_id}`
        #
        # Note that location_id must be a Google Cloud `zone`; for example:
        # * `projects/12345/locations/us-central1-c/instances/my-parallelstore-share`
        #
        # To load this service and instantiate a REST client:
        #
        #     require "google/cloud/parallelstore/v1beta/parallelstore/rest"
        #     client = ::Google::Cloud::Parallelstore::V1beta::Parallelstore::Rest::Client.new
        #
        module Parallelstore
          # Client for the REST transport
          module Rest
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "rest", "helpers.rb"
require "google/cloud/parallelstore/v1beta/parallelstore/rest/helpers" if ::File.file? helper_path
