# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OsConfig
      module V1alpha
        # This API resource represents the OS policies compliance data for a Compute
        # Engine virtual machine (VM) instance at a given point in time.
        #
        # A Compute Engine VM can have multiple OS policy assignments, and each
        # assignment can have multiple OS policies. As a result, multiple OS policies
        # could be applied to a single VM.
        #
        # You can use this API resource to determine both the compliance state of your
        # VM as well as the compliance state of an individual OS policy.
        #
        # For more information, see [View
        # compliance](https://cloud.google.com/compute/docs/os-configuration-management/view-compliance).
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The `InstanceOSPoliciesCompliance` API resource name.
        #
        #     Format:
        #     `projects/{project_number}/locations/{location}/instanceOSPoliciesCompliances/{instance_id}`
        # @!attribute [r] instance
        #   @return [::String]
        #     Output only. The Compute Engine VM instance name.
        # @!attribute [r] state
        #   @return [::Google::Cloud::OsConfig::V1alpha::OSPolicyComplianceState]
        #     Output only. Compliance state of the VM.
        # @!attribute [r] detailed_state
        #   @return [::String]
        #     Output only. Detailed compliance state of the VM.
        #     This field is populated only when compliance state is `UNKNOWN`.
        #
        #     It may contain one of the following values:
        #
        #     * `no-compliance-data`: Compliance data is not available for this VM.
        #     * `no-agent-detected`: OS Config agent is not detected for this VM.
        #     * `config-not-supported-by-agent`: The version of the OS Config agent
        #     running on this VM does not support configuration management.
        #     * `inactive`: VM is not running.
        #     * `internal-service-errors`: There were internal service errors encountered
        #     while enforcing compliance.
        #     * `agent-errors`: OS config agent encountered errors while enforcing
        #     compliance.
        # @!attribute [r] detailed_state_reason
        #   @return [::String]
        #     Output only. The reason for the `detailed_state` of the VM (if any).
        # @!attribute [r] os_policy_compliances
        #   @return [::Array<::Google::Cloud::OsConfig::V1alpha::InstanceOSPoliciesCompliance::OSPolicyCompliance>]
        #     Output only. Compliance data for each `OSPolicy` that is applied to the VM.
        # @!attribute [r] last_compliance_check_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp of the last compliance check for the VM.
        # @!attribute [r] last_compliance_run_id
        #   @return [::String]
        #     Output only. Unique identifier for the last compliance run.
        #     This id will be logged by the OS config agent during a compliance run and
        #     can be used for debugging and tracing purpose.
        class InstanceOSPoliciesCompliance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Compliance data for an OS policy
          # @deprecated This message is deprecated and may be removed in the next major version update.
          # @!attribute [rw] os_policy_id
          #   @return [::String]
          #     The OS policy id
          # @!attribute [rw] os_policy_assignment
          #   @return [::String]
          #     Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
          #     belongs to.
          #
          #     Format:
          #     `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id@revision_id}`
          # @!attribute [rw] state
          #   @return [::Google::Cloud::OsConfig::V1alpha::OSPolicyComplianceState]
          #     Compliance state of the OS policy.
          # @!attribute [rw] os_policy_resource_compliances
          #   @return [::Array<::Google::Cloud::OsConfig::V1alpha::OSPolicyResourceCompliance>]
          #     Compliance data for each `OSPolicyResource` that is applied to the
          #     VM.
          class OSPolicyCompliance
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A request message for getting OS policies compliance data for the given
        # Compute Engine VM instance.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. API resource name for instance OS policies compliance resource.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/instanceOSPoliciesCompliances/{instance}`
        #
        #     For `{project}`, either Compute Engine project-number or project-id can be
        #     provided.
        #     For `{instance}`, either Compute Engine VM instance-id or instance-name can
        #     be provided.
        class GetInstanceOSPoliciesComplianceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for listing OS policies compliance data for all Compute
        # Engine VMs in the given location.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name.
        #
        #     Format: `projects/{project}/locations/{location}`
        #
        #     For `{project}`, either Compute Engine project-number or project-id can be
        #     provided.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A pagination token returned from a previous call to
        #     `ListInstanceOSPoliciesCompliances` that indicates where this listing
        #     should continue from.
        # @!attribute [rw] filter
        #   @return [::String]
        #     If provided, this field specifies the criteria that must be met by a
        #     `InstanceOSPoliciesCompliance` API resource to be included in the response.
        class ListInstanceOSPoliciesCompliancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response message for listing OS policies compliance data for all Compute
        # Engine VMs in the given location.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] instance_os_policies_compliances
        #   @return [::Array<::Google::Cloud::OsConfig::V1alpha::InstanceOSPoliciesCompliance>]
        #     List of instance OS policies compliance objects.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The pagination token to retrieve the next page of instance OS policies
        #     compliance objects.
        class ListInstanceOSPoliciesCompliancesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
