# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OsConfig
      module V1alpha
        # Step performed by the OS Config agent for configuring an `OSPolicyResource`
        # to its desired state.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::OsConfig::V1alpha::OSPolicyResourceConfigStep::Type]
        #     Configuration step type.
        # @!attribute [rw] outcome
        #   @return [::Google::Cloud::OsConfig::V1alpha::OSPolicyResourceConfigStep::Outcome]
        #     Outcome of the configuration step.
        # @!attribute [rw] error_message
        #   @return [::String]
        #     An error message recorded during the execution of this step.
        #     Only populated when outcome is FAILED.
        class OSPolicyResourceConfigStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Supported configuration step types
          # @deprecated This enum is deprecated and may be removed in the next major version update.
          module Type
            # Default value. This value is unused.
            TYPE_UNSPECIFIED = 0

            # Validation to detect resource conflicts, schema errors, etc.
            VALIDATION = 1

            # Check the current desired state status of the resource.
            DESIRED_STATE_CHECK = 2

            # Enforce the desired state for a resource that is not in desired state.
            DESIRED_STATE_ENFORCEMENT = 3

            # Re-check desired state status for a resource after enforcement of all
            # resources in the current configuration run.
            #
            # This step is used to determine the final desired state status for the
            # resource. It accounts for any resources that might have drifted from
            # their desired state due to side effects from configuring other resources
            # during the current configuration run.
            DESIRED_STATE_CHECK_POST_ENFORCEMENT = 4
          end

          # Supported outcomes for a configuration step.
          # @deprecated This enum is deprecated and may be removed in the next major version update.
          module Outcome
            # Default value. This value is unused.
            OUTCOME_UNSPECIFIED = 0

            # The step succeeded.
            SUCCEEDED = 1

            # The step failed.
            FAILED = 2
          end
        end

        # Compliance data for an OS policy resource.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] os_policy_resource_id
        #   @return [::String]
        #     The id of the OS policy resource.
        # @!attribute [rw] config_steps
        #   @return [::Array<::Google::Cloud::OsConfig::V1alpha::OSPolicyResourceConfigStep>]
        #     Ordered list of configuration steps taken by the agent for the OS policy
        #     resource.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::OsConfig::V1alpha::OSPolicyComplianceState]
        #     Compliance state of the OS policy resource.
        # @!attribute [rw] exec_resource_output
        #   @return [::Google::Cloud::OsConfig::V1alpha::OSPolicyResourceCompliance::ExecResourceOutput]
        #     ExecResource specific output.
        class OSPolicyResourceCompliance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # ExecResource specific output.
          # @deprecated This message is deprecated and may be removed in the next major version update.
          # @!attribute [rw] enforcement_output
          #   @return [::String]
          #     Output from Enforcement phase output file (if run).
          #     Output size is limited to 100K bytes.
          class ExecResourceOutput
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Supported OSPolicy compliance states.
        # @deprecated This enum is deprecated and may be removed in the next major version update.
        module OSPolicyComplianceState
          # Default value. This value is unused.
          OS_POLICY_COMPLIANCE_STATE_UNSPECIFIED = 0

          # Compliant state.
          COMPLIANT = 1

          # Non-compliant state
          NON_COMPLIANT = 2

          # Unknown compliance state.
          UNKNOWN = 3

          # No applicable OS policies were found for the instance.
          # This state is only applicable to the instance.
          NO_OS_POLICIES_APPLICABLE = 4
        end
      end
    end
  end
end
