# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/osconfig/v1alpha/osconfig_zonal_service_pb"

module Google
  module Cloud
    module OsConfig
      module V1alpha
        module OsConfigZonalService
          ##
          # Client for the OsConfigZonalService service.
          #
          # Zonal OS Config API
          #
          # The OS Config service is the server-side component that allows users to
          # manage package installations and patch jobs for Compute Engine VM instances.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "osconfig.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :os_config_zonal_service_stub

            ##
            # Configure the OsConfigZonalService Client class.
            #
            # See {::Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all OsConfigZonalService clients
            #   ::Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "OsConfig", "V1alpha"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0
                default_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the OsConfigZonalService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @os_config_zonal_service_stub.universe_domain
            end

            ##
            # Create a new OsConfigZonalService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the OsConfigZonalService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/osconfig/v1alpha/osconfig_zonal_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @os_config_zonal_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @os_config_zonal_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Operations]
            #
            attr_reader :operations_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @os_config_zonal_service_stub.logger
            end

            # Service calls

            ##
            # Create an OS policy assignment.
            #
            # This method also creates the first revision of the OS policy assignment.
            #
            # This method returns a long running operation (LRO) that contains the
            # rollout details. The rollout can be cancelled by cancelling the LRO.
            #
            # For more information, see [Method:
            # projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1alpha/projects.locations.osPolicyAssignments.operations/cancel).
            #
            # @overload create_os_policy_assignment(request, options = nil)
            #   Pass arguments to `create_os_policy_assignment` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1alpha::CreateOSPolicyAssignmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1alpha::CreateOSPolicyAssignmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_os_policy_assignment(parent: nil, os_policy_assignment: nil, os_policy_assignment_id: nil)
            #   Pass arguments to `create_os_policy_assignment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource name in the form:
            #     projects/\\{project}/locations/\\{location}
            #   @param os_policy_assignment [::Google::Cloud::OsConfig::V1alpha::OSPolicyAssignment, ::Hash]
            #     Required. The OS policy assignment to be created.
            #   @param os_policy_assignment_id [::String]
            #     Required. The logical name of the OS policy assignment in the project
            #     with the following restrictions:
            #
            #     * Must contain only lowercase letters, numbers, and hyphens.
            #     * Must start with a letter.
            #     * Must be between 1-63 characters.
            #     * Must end with a number or a letter.
            #     * Must be unique within the project.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1alpha::CreateOSPolicyAssignmentRequest.new
            #
            #   # Call the create_os_policy_assignment method.
            #   result = client.create_os_policy_assignment request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_os_policy_assignment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1alpha::CreateOSPolicyAssignmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_os_policy_assignment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_os_policy_assignment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_os_policy_assignment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_zonal_service_stub.call_rpc :create_os_policy_assignment, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update an existing OS policy assignment.
            #
            # This method creates a new revision of the OS policy assignment.
            #
            # This method returns a long running operation (LRO) that contains the
            # rollout details. The rollout can be cancelled by cancelling the LRO.
            #
            # For more information, see [Method:
            # projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1alpha/projects.locations.osPolicyAssignments.operations/cancel).
            #
            # @overload update_os_policy_assignment(request, options = nil)
            #   Pass arguments to `update_os_policy_assignment` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1alpha::UpdateOSPolicyAssignmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1alpha::UpdateOSPolicyAssignmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_os_policy_assignment(os_policy_assignment: nil, update_mask: nil)
            #   Pass arguments to `update_os_policy_assignment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param os_policy_assignment [::Google::Cloud::OsConfig::V1alpha::OSPolicyAssignment, ::Hash]
            #     Required. The updated OS policy assignment.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask that controls which fields of the assignment should be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1alpha::UpdateOSPolicyAssignmentRequest.new
            #
            #   # Call the update_os_policy_assignment method.
            #   result = client.update_os_policy_assignment request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_os_policy_assignment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1alpha::UpdateOSPolicyAssignmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_os_policy_assignment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.os_policy_assignment&.name
                header_params["os_policy_assignment.name"] = request.os_policy_assignment.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_os_policy_assignment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_os_policy_assignment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_zonal_service_stub.call_rpc :update_os_policy_assignment, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieve an existing OS policy assignment.
            #
            # This method always returns the latest revision. In order to retrieve a
            # previous revision of the assignment, also provide the revision ID in the
            # `name` parameter.
            #
            # @overload get_os_policy_assignment(request, options = nil)
            #   Pass arguments to `get_os_policy_assignment` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1alpha::GetOSPolicyAssignmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1alpha::GetOSPolicyAssignmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_os_policy_assignment(name: nil)
            #   Pass arguments to `get_os_policy_assignment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of OS policy assignment.
            #
            #     Format:
            #     `projects/{project}/locations/{location}/osPolicyAssignments/{os_policy_assignment}@{revisionId}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::OsConfig::V1alpha::OSPolicyAssignment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::OsConfig::V1alpha::OSPolicyAssignment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1alpha::GetOSPolicyAssignmentRequest.new
            #
            #   # Call the get_os_policy_assignment method.
            #   result = client.get_os_policy_assignment request
            #
            #   # The returned object is of type Google::Cloud::OsConfig::V1alpha::OSPolicyAssignment.
            #   p result
            #
            def get_os_policy_assignment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1alpha::GetOSPolicyAssignmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_os_policy_assignment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_os_policy_assignment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_os_policy_assignment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_zonal_service_stub.call_rpc :get_os_policy_assignment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List the OS policy assignments under the parent resource.
            #
            # For each OS policy assignment, the latest revision is returned.
            #
            # @overload list_os_policy_assignments(request, options = nil)
            #   Pass arguments to `list_os_policy_assignments` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1alpha::ListOSPolicyAssignmentsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1alpha::ListOSPolicyAssignmentsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_os_policy_assignments(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_os_policy_assignments` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource name.
            #   @param page_size [::Integer]
            #     The maximum number of assignments to return.
            #   @param page_token [::String]
            #     A pagination token returned from a previous call to
            #     `ListOSPolicyAssignments` that indicates where this listing should continue
            #     from.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1alpha::OSPolicyAssignment>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1alpha::OSPolicyAssignment>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1alpha::ListOSPolicyAssignmentsRequest.new
            #
            #   # Call the list_os_policy_assignments method.
            #   result = client.list_os_policy_assignments request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::OsConfig::V1alpha::OSPolicyAssignment.
            #     p item
            #   end
            #
            def list_os_policy_assignments request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1alpha::ListOSPolicyAssignmentsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_os_policy_assignments.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_os_policy_assignments.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_os_policy_assignments.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_zonal_service_stub.call_rpc :list_os_policy_assignments, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @os_config_zonal_service_stub, :list_os_policy_assignments, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List the OS policy assignment revisions for a given OS policy assignment.
            #
            # @overload list_os_policy_assignment_revisions(request, options = nil)
            #   Pass arguments to `list_os_policy_assignment_revisions` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1alpha::ListOSPolicyAssignmentRevisionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1alpha::ListOSPolicyAssignmentRevisionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_os_policy_assignment_revisions(name: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_os_policy_assignment_revisions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the OS policy assignment to list revisions for.
            #   @param page_size [::Integer]
            #     The maximum number of revisions to return.
            #   @param page_token [::String]
            #     A pagination token returned from a previous call to
            #     `ListOSPolicyAssignmentRevisions` that indicates where this listing should
            #     continue from.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1alpha::OSPolicyAssignment>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1alpha::OSPolicyAssignment>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1alpha::ListOSPolicyAssignmentRevisionsRequest.new
            #
            #   # Call the list_os_policy_assignment_revisions method.
            #   result = client.list_os_policy_assignment_revisions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::OsConfig::V1alpha::OSPolicyAssignment.
            #     p item
            #   end
            #
            def list_os_policy_assignment_revisions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1alpha::ListOSPolicyAssignmentRevisionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_os_policy_assignment_revisions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_os_policy_assignment_revisions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_os_policy_assignment_revisions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_zonal_service_stub.call_rpc :list_os_policy_assignment_revisions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @os_config_zonal_service_stub, :list_os_policy_assignment_revisions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Delete the OS policy assignment.
            #
            # This method creates a new revision of the OS policy assignment.
            #
            # This method returns a long running operation (LRO) that contains the
            # rollout details. The rollout can be cancelled by cancelling the LRO.
            #
            # If the LRO completes and is not cancelled, all revisions associated with
            # the OS policy assignment are deleted.
            #
            # For more information, see [Method:
            # projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1alpha/projects.locations.osPolicyAssignments.operations/cancel).
            #
            # @overload delete_os_policy_assignment(request, options = nil)
            #   Pass arguments to `delete_os_policy_assignment` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1alpha::DeleteOSPolicyAssignmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1alpha::DeleteOSPolicyAssignmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_os_policy_assignment(name: nil)
            #   Pass arguments to `delete_os_policy_assignment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the OS policy assignment to be deleted
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1alpha::DeleteOSPolicyAssignmentRequest.new
            #
            #   # Call the delete_os_policy_assignment method.
            #   result = client.delete_os_policy_assignment request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_os_policy_assignment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1alpha::DeleteOSPolicyAssignmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_os_policy_assignment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_os_policy_assignment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_os_policy_assignment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_zonal_service_stub.call_rpc :delete_os_policy_assignment, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get OS policies compliance data for the specified Compute Engine VM
            # instance.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload get_instance_os_policies_compliance(request, options = nil)
            #   Pass arguments to `get_instance_os_policies_compliance` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1alpha::GetInstanceOSPoliciesComplianceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1alpha::GetInstanceOSPoliciesComplianceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_instance_os_policies_compliance(name: nil)
            #   Pass arguments to `get_instance_os_policies_compliance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. API resource name for instance OS policies compliance resource.
            #
            #     Format:
            #     `projects/{project}/locations/{location}/instanceOSPoliciesCompliances/{instance}`
            #
            #     For `{project}`, either Compute Engine project-number or project-id can be
            #     provided.
            #     For `{instance}`, either Compute Engine VM instance-id or instance-name can
            #     be provided.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::OsConfig::V1alpha::InstanceOSPoliciesCompliance]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::OsConfig::V1alpha::InstanceOSPoliciesCompliance]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1alpha::GetInstanceOSPoliciesComplianceRequest.new
            #
            #   # Call the get_instance_os_policies_compliance method.
            #   result = client.get_instance_os_policies_compliance request
            #
            #   # The returned object is of type Google::Cloud::OsConfig::V1alpha::InstanceOSPoliciesCompliance.
            #   p result
            #
            def get_instance_os_policies_compliance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1alpha::GetInstanceOSPoliciesComplianceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_instance_os_policies_compliance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_instance_os_policies_compliance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_instance_os_policies_compliance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_zonal_service_stub.call_rpc :get_instance_os_policies_compliance, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List OS policies compliance data for all Compute Engine VM instances in the
            # specified zone.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload list_instance_os_policies_compliances(request, options = nil)
            #   Pass arguments to `list_instance_os_policies_compliances` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1alpha::ListInstanceOSPoliciesCompliancesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1alpha::ListInstanceOSPoliciesCompliancesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_instance_os_policies_compliances(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_instance_os_policies_compliances` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource name.
            #
            #     Format: `projects/{project}/locations/{location}`
            #
            #     For `{project}`, either Compute Engine project-number or project-id can be
            #     provided.
            #   @param page_size [::Integer]
            #     The maximum number of results to return.
            #   @param page_token [::String]
            #     A pagination token returned from a previous call to
            #     `ListInstanceOSPoliciesCompliances` that indicates where this listing
            #     should continue from.
            #   @param filter [::String]
            #     If provided, this field specifies the criteria that must be met by a
            #     `InstanceOSPoliciesCompliance` API resource to be included in the response.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1alpha::InstanceOSPoliciesCompliance>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1alpha::InstanceOSPoliciesCompliance>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1alpha::ListInstanceOSPoliciesCompliancesRequest.new
            #
            #   # Call the list_instance_os_policies_compliances method.
            #   result = client.list_instance_os_policies_compliances request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::OsConfig::V1alpha::InstanceOSPoliciesCompliance.
            #     p item
            #   end
            #
            def list_instance_os_policies_compliances request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1alpha::ListInstanceOSPoliciesCompliancesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_instance_os_policies_compliances.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_instance_os_policies_compliances.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_instance_os_policies_compliances.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_zonal_service_stub.call_rpc :list_instance_os_policies_compliances, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @os_config_zonal_service_stub, :list_instance_os_policies_compliances, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get the OS policy asssignment report for the specified Compute Engine VM
            # instance.
            #
            # @overload get_os_policy_assignment_report(request, options = nil)
            #   Pass arguments to `get_os_policy_assignment_report` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1alpha::GetOSPolicyAssignmentReportRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1alpha::GetOSPolicyAssignmentReportRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_os_policy_assignment_report(name: nil)
            #   Pass arguments to `get_os_policy_assignment_report` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. API resource name for OS policy assignment report.
            #
            #     Format:
            #     `/projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/report`
            #
            #     For `{project}`, either `project-number` or `project-id` can be provided.
            #     For `{instance_id}`, either Compute Engine `instance-id` or `instance-name`
            #     can be provided.
            #     For `{assignment_id}`, the OSPolicyAssignment id must be provided.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::OsConfig::V1alpha::OSPolicyAssignmentReport]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::OsConfig::V1alpha::OSPolicyAssignmentReport]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1alpha::GetOSPolicyAssignmentReportRequest.new
            #
            #   # Call the get_os_policy_assignment_report method.
            #   result = client.get_os_policy_assignment_report request
            #
            #   # The returned object is of type Google::Cloud::OsConfig::V1alpha::OSPolicyAssignmentReport.
            #   p result
            #
            def get_os_policy_assignment_report request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1alpha::GetOSPolicyAssignmentReportRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_os_policy_assignment_report.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_os_policy_assignment_report.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_os_policy_assignment_report.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_zonal_service_stub.call_rpc :get_os_policy_assignment_report, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List OS policy asssignment reports for all Compute Engine VM instances in
            # the specified zone.
            #
            # @overload list_os_policy_assignment_reports(request, options = nil)
            #   Pass arguments to `list_os_policy_assignment_reports` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1alpha::ListOSPolicyAssignmentReportsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1alpha::ListOSPolicyAssignmentReportsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_os_policy_assignment_reports(parent: nil, page_size: nil, filter: nil, page_token: nil)
            #   Pass arguments to `list_os_policy_assignment_reports` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource name.
            #
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
            #
            #     For `{project}`, either `project-number` or `project-id` can be provided.
            #     For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
            #     provided. If '-' is provided, the response will include
            #     OSPolicyAssignmentReports for all instances in the project/location.
            #     For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
            #     is provided, the response will include OSPolicyAssignmentReports for all
            #     OSPolicyAssignments in the project/location.
            #     Either \\{instance} or \\{assignment} must be `-`.
            #
            #     For example:
            #     `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
            #      returns all reports for the instance
            #     `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
            #      returns all the reports for the given assignment across all instances.
            #     `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
            #      returns all the reports for all assignments across all instances.
            #   @param page_size [::Integer]
            #     The maximum number of results to return.
            #   @param filter [::String]
            #     If provided, this field specifies the criteria that must be met by the
            #     `OSPolicyAssignmentReport` API resource that is included in the response.
            #   @param page_token [::String]
            #     A pagination token returned from a previous call to the
            #     `ListOSPolicyAssignmentReports` method that indicates where this listing
            #     should continue from.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1alpha::OSPolicyAssignmentReport>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1alpha::OSPolicyAssignmentReport>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1alpha::ListOSPolicyAssignmentReportsRequest.new
            #
            #   # Call the list_os_policy_assignment_reports method.
            #   result = client.list_os_policy_assignment_reports request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::OsConfig::V1alpha::OSPolicyAssignmentReport.
            #     p item
            #   end
            #
            def list_os_policy_assignment_reports request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1alpha::ListOSPolicyAssignmentReportsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_os_policy_assignment_reports.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_os_policy_assignment_reports.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_os_policy_assignment_reports.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_zonal_service_stub.call_rpc :list_os_policy_assignment_reports, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @os_config_zonal_service_stub, :list_os_policy_assignment_reports, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get inventory data for the specified VM instance. If the VM has no
            # associated inventory, the message `NOT_FOUND` is returned.
            #
            # @overload get_inventory(request, options = nil)
            #   Pass arguments to `get_inventory` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1alpha::GetInventoryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1alpha::GetInventoryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_inventory(name: nil, view: nil)
            #   Pass arguments to `get_inventory` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. API resource name for inventory resource.
            #
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/inventory`
            #
            #     For `{project}`, either `project-number` or `project-id` can be provided.
            #     For `{instance}`, either Compute Engine  `instance-id` or `instance-name`
            #     can be provided.
            #   @param view [::Google::Cloud::OsConfig::V1alpha::InventoryView]
            #     Inventory view indicating what information should be included in the
            #     inventory resource. If unspecified, the default view is BASIC.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::OsConfig::V1alpha::Inventory]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::OsConfig::V1alpha::Inventory]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1alpha::GetInventoryRequest.new
            #
            #   # Call the get_inventory method.
            #   result = client.get_inventory request
            #
            #   # The returned object is of type Google::Cloud::OsConfig::V1alpha::Inventory.
            #   p result
            #
            def get_inventory request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1alpha::GetInventoryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_inventory.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_inventory.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_inventory.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_zonal_service_stub.call_rpc :get_inventory, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List inventory data for all VM instances in the specified zone.
            #
            # @overload list_inventories(request, options = nil)
            #   Pass arguments to `list_inventories` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1alpha::ListInventoriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1alpha::ListInventoriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_inventories(parent: nil, view: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_inventories` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource name.
            #
            #     Format: `projects/{project}/locations/{location}/instances/-`
            #
            #     For `{project}`, either `project-number` or `project-id` can be provided.
            #   @param view [::Google::Cloud::OsConfig::V1alpha::InventoryView]
            #     Inventory view indicating what information should be included in the
            #     inventory resource. If unspecified, the default view is BASIC.
            #   @param page_size [::Integer]
            #     The maximum number of results to return.
            #   @param page_token [::String]
            #     A pagination token returned from a previous call to
            #     `ListInventories` that indicates where this listing
            #     should continue from.
            #   @param filter [::String]
            #     If provided, this field specifies the criteria that must be met by a
            #     `Inventory` API resource to be included in the response.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1alpha::Inventory>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1alpha::Inventory>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1alpha::ListInventoriesRequest.new
            #
            #   # Call the list_inventories method.
            #   result = client.list_inventories request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::OsConfig::V1alpha::Inventory.
            #     p item
            #   end
            #
            def list_inventories request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1alpha::ListInventoriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_inventories.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_inventories.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_inventories.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_zonal_service_stub.call_rpc :list_inventories, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @os_config_zonal_service_stub, :list_inventories, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the vulnerability report for the specified VM instance. Only VMs with
            # inventory data have vulnerability reports associated with them.
            #
            # @overload get_vulnerability_report(request, options = nil)
            #   Pass arguments to `get_vulnerability_report` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1alpha::GetVulnerabilityReportRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1alpha::GetVulnerabilityReportRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_vulnerability_report(name: nil)
            #   Pass arguments to `get_vulnerability_report` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. API resource name for vulnerability resource.
            #
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/vulnerabilityReport`
            #
            #     For `{project}`, either `project-number` or `project-id` can be provided.
            #     For `{instance}`, either Compute Engine `instance-id` or `instance-name`
            #     can be provided.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::OsConfig::V1alpha::VulnerabilityReport]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::OsConfig::V1alpha::VulnerabilityReport]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1alpha::GetVulnerabilityReportRequest.new
            #
            #   # Call the get_vulnerability_report method.
            #   result = client.get_vulnerability_report request
            #
            #   # The returned object is of type Google::Cloud::OsConfig::V1alpha::VulnerabilityReport.
            #   p result
            #
            def get_vulnerability_report request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1alpha::GetVulnerabilityReportRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_vulnerability_report.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_vulnerability_report.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_vulnerability_report.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_zonal_service_stub.call_rpc :get_vulnerability_report, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List vulnerability reports for all VM instances in the specified zone.
            #
            # @overload list_vulnerability_reports(request, options = nil)
            #   Pass arguments to `list_vulnerability_reports` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1alpha::ListVulnerabilityReportsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1alpha::ListVulnerabilityReportsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_vulnerability_reports(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_vulnerability_reports` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource name.
            #
            #     Format: `projects/{project}/locations/{location}/instances/-`
            #
            #     For `{project}`, either `project-number` or `project-id` can be provided.
            #   @param page_size [::Integer]
            #     The maximum number of results to return.
            #   @param page_token [::String]
            #     A pagination token returned from a previous call to
            #     `ListVulnerabilityReports` that indicates where this listing
            #     should continue from.
            #   @param filter [::String]
            #     If provided, this field specifies the criteria that must be met by a
            #     `vulnerabilityReport` API resource to be included in the response.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1alpha::VulnerabilityReport>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1alpha::VulnerabilityReport>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1alpha"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1alpha::ListVulnerabilityReportsRequest.new
            #
            #   # Call the list_vulnerability_reports method.
            #   result = client.list_vulnerability_reports request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::OsConfig::V1alpha::VulnerabilityReport.
            #     p item
            #   end
            #
            def list_vulnerability_reports request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1alpha::ListVulnerabilityReportsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_vulnerability_reports.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1alpha::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_vulnerability_reports.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_vulnerability_reports.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_zonal_service_stub.call_rpc :list_vulnerability_reports, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @os_config_zonal_service_stub, :list_vulnerability_reports, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the OsConfigZonalService API.
            #
            # This class represents the configuration for OsConfigZonalService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_os_policy_assignment to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_os_policy_assignment.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_os_policy_assignment.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "osconfig.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the OsConfigZonalService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_os_policy_assignment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_os_policy_assignment
                ##
                # RPC-specific configuration for `update_os_policy_assignment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_os_policy_assignment
                ##
                # RPC-specific configuration for `get_os_policy_assignment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_os_policy_assignment
                ##
                # RPC-specific configuration for `list_os_policy_assignments`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_os_policy_assignments
                ##
                # RPC-specific configuration for `list_os_policy_assignment_revisions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_os_policy_assignment_revisions
                ##
                # RPC-specific configuration for `delete_os_policy_assignment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_os_policy_assignment
                ##
                # RPC-specific configuration for `get_instance_os_policies_compliance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_instance_os_policies_compliance
                ##
                # RPC-specific configuration for `list_instance_os_policies_compliances`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_instance_os_policies_compliances
                ##
                # RPC-specific configuration for `get_os_policy_assignment_report`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_os_policy_assignment_report
                ##
                # RPC-specific configuration for `list_os_policy_assignment_reports`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_os_policy_assignment_reports
                ##
                # RPC-specific configuration for `get_inventory`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_inventory
                ##
                # RPC-specific configuration for `list_inventories`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_inventories
                ##
                # RPC-specific configuration for `get_vulnerability_report`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_vulnerability_report
                ##
                # RPC-specific configuration for `list_vulnerability_reports`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_vulnerability_reports

                # @private
                def initialize parent_rpcs = nil
                  create_os_policy_assignment_config = parent_rpcs.create_os_policy_assignment if parent_rpcs.respond_to? :create_os_policy_assignment
                  @create_os_policy_assignment = ::Gapic::Config::Method.new create_os_policy_assignment_config
                  update_os_policy_assignment_config = parent_rpcs.update_os_policy_assignment if parent_rpcs.respond_to? :update_os_policy_assignment
                  @update_os_policy_assignment = ::Gapic::Config::Method.new update_os_policy_assignment_config
                  get_os_policy_assignment_config = parent_rpcs.get_os_policy_assignment if parent_rpcs.respond_to? :get_os_policy_assignment
                  @get_os_policy_assignment = ::Gapic::Config::Method.new get_os_policy_assignment_config
                  list_os_policy_assignments_config = parent_rpcs.list_os_policy_assignments if parent_rpcs.respond_to? :list_os_policy_assignments
                  @list_os_policy_assignments = ::Gapic::Config::Method.new list_os_policy_assignments_config
                  list_os_policy_assignment_revisions_config = parent_rpcs.list_os_policy_assignment_revisions if parent_rpcs.respond_to? :list_os_policy_assignment_revisions
                  @list_os_policy_assignment_revisions = ::Gapic::Config::Method.new list_os_policy_assignment_revisions_config
                  delete_os_policy_assignment_config = parent_rpcs.delete_os_policy_assignment if parent_rpcs.respond_to? :delete_os_policy_assignment
                  @delete_os_policy_assignment = ::Gapic::Config::Method.new delete_os_policy_assignment_config
                  get_instance_os_policies_compliance_config = parent_rpcs.get_instance_os_policies_compliance if parent_rpcs.respond_to? :get_instance_os_policies_compliance
                  @get_instance_os_policies_compliance = ::Gapic::Config::Method.new get_instance_os_policies_compliance_config
                  list_instance_os_policies_compliances_config = parent_rpcs.list_instance_os_policies_compliances if parent_rpcs.respond_to? :list_instance_os_policies_compliances
                  @list_instance_os_policies_compliances = ::Gapic::Config::Method.new list_instance_os_policies_compliances_config
                  get_os_policy_assignment_report_config = parent_rpcs.get_os_policy_assignment_report if parent_rpcs.respond_to? :get_os_policy_assignment_report
                  @get_os_policy_assignment_report = ::Gapic::Config::Method.new get_os_policy_assignment_report_config
                  list_os_policy_assignment_reports_config = parent_rpcs.list_os_policy_assignment_reports if parent_rpcs.respond_to? :list_os_policy_assignment_reports
                  @list_os_policy_assignment_reports = ::Gapic::Config::Method.new list_os_policy_assignment_reports_config
                  get_inventory_config = parent_rpcs.get_inventory if parent_rpcs.respond_to? :get_inventory
                  @get_inventory = ::Gapic::Config::Method.new get_inventory_config
                  list_inventories_config = parent_rpcs.list_inventories if parent_rpcs.respond_to? :list_inventories
                  @list_inventories = ::Gapic::Config::Method.new list_inventories_config
                  get_vulnerability_report_config = parent_rpcs.get_vulnerability_report if parent_rpcs.respond_to? :get_vulnerability_report
                  @get_vulnerability_report = ::Gapic::Config::Method.new get_vulnerability_report_config
                  list_vulnerability_reports_config = parent_rpcs.list_vulnerability_reports if parent_rpcs.respond_to? :list_vulnerability_reports
                  @list_vulnerability_reports = ::Gapic::Config::Method.new list_vulnerability_reports_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
