# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/os_config/v1alpha/version"

require "google/cloud/os_config/v1alpha/os_config_zonal_service/credentials"
require "google/cloud/os_config/v1alpha/os_config_zonal_service/paths"
require "google/cloud/os_config/v1alpha/os_config_zonal_service/operations"
require "google/cloud/os_config/v1alpha/os_config_zonal_service/client"
require "google/cloud/os_config/v1alpha/os_config_zonal_service/rest"

module Google
  module Cloud
    module OsConfig
      module V1alpha
        ##
        # Zonal OS Config API
        #
        # The OS Config service is the server-side component that allows users to
        # manage package installations and patch jobs for Compute Engine VM instances.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/os_config/v1alpha/os_config_zonal_service"
        #     client = ::Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/os_config/v1alpha/os_config_zonal_service/rest"
        #     client = ::Google::Cloud::OsConfig::V1alpha::OsConfigZonalService::Rest::Client.new
        #
        module OsConfigZonalService
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "os_config_zonal_service", "helpers.rb"
require "google/cloud/os_config/v1alpha/os_config_zonal_service/helpers" if ::File.file? helper_path
