# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/osconfig/v1/osconfig_zonal_service_pb"
require "google/cloud/os_config/v1/os_config_zonal_service"

class ::Google::Cloud::OsConfig::V1::OsConfigZonalService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_os_policy_assignment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    os_policy_assignment = {}
    os_policy_assignment_id = "hello world"

    create_os_policy_assignment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_os_policy_assignment, name
      assert_kind_of ::Google::Cloud::OsConfig::V1::CreateOSPolicyAssignmentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::OsConfig::V1::OSPolicyAssignment), request["os_policy_assignment"]
      assert_equal "hello world", request["os_policy_assignment_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_os_policy_assignment_client_stub do
      # Create client
      client = ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_os_policy_assignment({ parent: parent, os_policy_assignment: os_policy_assignment, os_policy_assignment_id: os_policy_assignment_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_os_policy_assignment parent: parent, os_policy_assignment: os_policy_assignment, os_policy_assignment_id: os_policy_assignment_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_os_policy_assignment ::Google::Cloud::OsConfig::V1::CreateOSPolicyAssignmentRequest.new(parent: parent, os_policy_assignment: os_policy_assignment, os_policy_assignment_id: os_policy_assignment_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_os_policy_assignment({ parent: parent, os_policy_assignment: os_policy_assignment, os_policy_assignment_id: os_policy_assignment_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_os_policy_assignment(::Google::Cloud::OsConfig::V1::CreateOSPolicyAssignmentRequest.new(parent: parent, os_policy_assignment: os_policy_assignment, os_policy_assignment_id: os_policy_assignment_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_os_policy_assignment_client_stub.call_rpc_count
    end
  end

  def test_update_os_policy_assignment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    os_policy_assignment = {}
    update_mask = {}

    update_os_policy_assignment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_os_policy_assignment, name
      assert_kind_of ::Google::Cloud::OsConfig::V1::UpdateOSPolicyAssignmentRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::OsConfig::V1::OSPolicyAssignment), request["os_policy_assignment"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_os_policy_assignment_client_stub do
      # Create client
      client = ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_os_policy_assignment({ os_policy_assignment: os_policy_assignment, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_os_policy_assignment os_policy_assignment: os_policy_assignment, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_os_policy_assignment ::Google::Cloud::OsConfig::V1::UpdateOSPolicyAssignmentRequest.new(os_policy_assignment: os_policy_assignment, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_os_policy_assignment({ os_policy_assignment: os_policy_assignment, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_os_policy_assignment(::Google::Cloud::OsConfig::V1::UpdateOSPolicyAssignmentRequest.new(os_policy_assignment: os_policy_assignment, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_os_policy_assignment_client_stub.call_rpc_count
    end
  end

  def test_get_os_policy_assignment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OsConfig::V1::OSPolicyAssignment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_os_policy_assignment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_os_policy_assignment, name
      assert_kind_of ::Google::Cloud::OsConfig::V1::GetOSPolicyAssignmentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_os_policy_assignment_client_stub do
      # Create client
      client = ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_os_policy_assignment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_os_policy_assignment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_os_policy_assignment ::Google::Cloud::OsConfig::V1::GetOSPolicyAssignmentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_os_policy_assignment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_os_policy_assignment(::Google::Cloud::OsConfig::V1::GetOSPolicyAssignmentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_os_policy_assignment_client_stub.call_rpc_count
    end
  end

  def test_list_os_policy_assignments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OsConfig::V1::ListOSPolicyAssignmentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_os_policy_assignments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_os_policy_assignments, name
      assert_kind_of ::Google::Cloud::OsConfig::V1::ListOSPolicyAssignmentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_os_policy_assignments_client_stub do
      # Create client
      client = ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_os_policy_assignments({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_os_policy_assignments parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_os_policy_assignments ::Google::Cloud::OsConfig::V1::ListOSPolicyAssignmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_os_policy_assignments({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_os_policy_assignments(::Google::Cloud::OsConfig::V1::ListOSPolicyAssignmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_os_policy_assignments_client_stub.call_rpc_count
    end
  end

  def test_list_os_policy_assignment_revisions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OsConfig::V1::ListOSPolicyAssignmentRevisionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    list_os_policy_assignment_revisions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_os_policy_assignment_revisions, name
      assert_kind_of ::Google::Cloud::OsConfig::V1::ListOSPolicyAssignmentRevisionsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_os_policy_assignment_revisions_client_stub do
      # Create client
      client = ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_os_policy_assignment_revisions({ name: name, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_os_policy_assignment_revisions name: name, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_os_policy_assignment_revisions ::Google::Cloud::OsConfig::V1::ListOSPolicyAssignmentRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_os_policy_assignment_revisions({ name: name, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_os_policy_assignment_revisions(::Google::Cloud::OsConfig::V1::ListOSPolicyAssignmentRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_os_policy_assignment_revisions_client_stub.call_rpc_count
    end
  end

  def test_delete_os_policy_assignment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_os_policy_assignment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_os_policy_assignment, name
      assert_kind_of ::Google::Cloud::OsConfig::V1::DeleteOSPolicyAssignmentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_os_policy_assignment_client_stub do
      # Create client
      client = ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_os_policy_assignment({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_os_policy_assignment name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_os_policy_assignment ::Google::Cloud::OsConfig::V1::DeleteOSPolicyAssignmentRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_os_policy_assignment({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_os_policy_assignment(::Google::Cloud::OsConfig::V1::DeleteOSPolicyAssignmentRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_os_policy_assignment_client_stub.call_rpc_count
    end
  end

  def test_get_os_policy_assignment_report
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OsConfig::V1::OSPolicyAssignmentReport.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_os_policy_assignment_report_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_os_policy_assignment_report, name
      assert_kind_of ::Google::Cloud::OsConfig::V1::GetOSPolicyAssignmentReportRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_os_policy_assignment_report_client_stub do
      # Create client
      client = ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_os_policy_assignment_report({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_os_policy_assignment_report name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_os_policy_assignment_report ::Google::Cloud::OsConfig::V1::GetOSPolicyAssignmentReportRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_os_policy_assignment_report({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_os_policy_assignment_report(::Google::Cloud::OsConfig::V1::GetOSPolicyAssignmentReportRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_os_policy_assignment_report_client_stub.call_rpc_count
    end
  end

  def test_list_os_policy_assignment_reports
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OsConfig::V1::ListOSPolicyAssignmentReportsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    filter = "hello world"
    page_token = "hello world"

    list_os_policy_assignment_reports_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_os_policy_assignment_reports, name
      assert_kind_of ::Google::Cloud::OsConfig::V1::ListOSPolicyAssignmentReportsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_os_policy_assignment_reports_client_stub do
      # Create client
      client = ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_os_policy_assignment_reports({ parent: parent, page_size: page_size, filter: filter, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_os_policy_assignment_reports parent: parent, page_size: page_size, filter: filter, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_os_policy_assignment_reports ::Google::Cloud::OsConfig::V1::ListOSPolicyAssignmentReportsRequest.new(parent: parent, page_size: page_size, filter: filter, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_os_policy_assignment_reports({ parent: parent, page_size: page_size, filter: filter, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_os_policy_assignment_reports(::Google::Cloud::OsConfig::V1::ListOSPolicyAssignmentReportsRequest.new(parent: parent, page_size: page_size, filter: filter, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_os_policy_assignment_reports_client_stub.call_rpc_count
    end
  end

  def test_get_inventory
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OsConfig::V1::Inventory.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :INVENTORY_VIEW_UNSPECIFIED

    get_inventory_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_inventory, name
      assert_kind_of ::Google::Cloud::OsConfig::V1::GetInventoryRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :INVENTORY_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_inventory_client_stub do
      # Create client
      client = ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_inventory({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_inventory name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_inventory ::Google::Cloud::OsConfig::V1::GetInventoryRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_inventory({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_inventory(::Google::Cloud::OsConfig::V1::GetInventoryRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_inventory_client_stub.call_rpc_count
    end
  end

  def test_list_inventories
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OsConfig::V1::ListInventoriesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    view = :INVENTORY_VIEW_UNSPECIFIED
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_inventories_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_inventories, name
      assert_kind_of ::Google::Cloud::OsConfig::V1::ListInventoriesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal :INVENTORY_VIEW_UNSPECIFIED, request["view"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_inventories_client_stub do
      # Create client
      client = ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_inventories({ parent: parent, view: view, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_inventories parent: parent, view: view, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_inventories ::Google::Cloud::OsConfig::V1::ListInventoriesRequest.new(parent: parent, view: view, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_inventories({ parent: parent, view: view, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_inventories(::Google::Cloud::OsConfig::V1::ListInventoriesRequest.new(parent: parent, view: view, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_inventories_client_stub.call_rpc_count
    end
  end

  def test_get_vulnerability_report
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OsConfig::V1::VulnerabilityReport.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_vulnerability_report_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_vulnerability_report, name
      assert_kind_of ::Google::Cloud::OsConfig::V1::GetVulnerabilityReportRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_vulnerability_report_client_stub do
      # Create client
      client = ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_vulnerability_report({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_vulnerability_report name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_vulnerability_report ::Google::Cloud::OsConfig::V1::GetVulnerabilityReportRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_vulnerability_report({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_vulnerability_report(::Google::Cloud::OsConfig::V1::GetVulnerabilityReportRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_vulnerability_report_client_stub.call_rpc_count
    end
  end

  def test_list_vulnerability_reports
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OsConfig::V1::ListVulnerabilityReportsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_vulnerability_reports_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_vulnerability_reports, name
      assert_kind_of ::Google::Cloud::OsConfig::V1::ListVulnerabilityReportsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_vulnerability_reports_client_stub do
      # Create client
      client = ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_vulnerability_reports({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_vulnerability_reports parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_vulnerability_reports ::Google::Cloud::OsConfig::V1::ListVulnerabilityReportsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_vulnerability_reports({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_vulnerability_reports(::Google::Cloud::OsConfig::V1::ListVulnerabilityReportsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_vulnerability_reports_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::OsConfig::V1::OsConfigZonalService::Operations, client.operations_client
  end
end
