# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OsConfig
      module V1
        # This API resource represents the vulnerability report for a specified
        # Compute Engine virtual machine (VM) instance at a given point in time.
        #
        # For more information, see [Vulnerability
        # reports](https://cloud.google.com/compute/docs/instances/os-inventory-management#vulnerability-reports).
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The `vulnerabilityReport` API resource name.
        #
        #     Format:
        #     `projects/{project_number}/locations/{location}/instances/{instance_id}/vulnerabilityReport`
        # @!attribute [r] vulnerabilities
        #   @return [::Array<::Google::Cloud::OsConfig::V1::VulnerabilityReport::Vulnerability>]
        #     Output only. List of vulnerabilities affecting the VM.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp for when the last vulnerability report was
        #     generated for the VM.
        # @!attribute [r] highest_upgradable_cve_severity
        #   @return [::Google::Cloud::OsConfig::V1::VulnerabilityReport::VulnerabilitySeverityLevel]
        #     Output only. Highest level of severity among all the upgradable
        #     vulnerabilities with CVEs attached.
        class VulnerabilityReport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A vulnerability affecting the VM instance.
          # @!attribute [rw] details
          #   @return [::Google::Cloud::OsConfig::V1::VulnerabilityReport::Vulnerability::Details]
          #     Contains metadata as per the upstream feed of the operating system and
          #     NVD.
          # @!attribute [rw] installed_inventory_item_ids
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Array<::String>]
          #     Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
          #     This field displays the inventory items affected by this vulnerability.
          #     If the vulnerability report was not updated after the VM inventory
          #     update, these values might not display in VM inventory. For some distros,
          #     this field may be empty.
          # @!attribute [rw] available_inventory_item_ids
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Array<::String>]
          #     Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
          #     If the vulnerability report was not updated after the VM inventory
          #     update, these values might not display in VM inventory. If there is no
          #     available fix, the field is empty. The `inventory_item` value specifies
          #     the latest `SoftwarePackage` available to the VM that fixes the
          #     vulnerability.
          # @!attribute [rw] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The timestamp for when the vulnerability was first detected.
          # @!attribute [rw] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The timestamp for when the vulnerability was last modified.
          # @!attribute [rw] items
          #   @return [::Array<::Google::Cloud::OsConfig::V1::VulnerabilityReport::Vulnerability::Item>]
          #     List of items affected by the vulnerability.
          class Vulnerability
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Contains metadata information for the vulnerability. This information is
            # collected from the upstream feed of the operating system.
            # @!attribute [rw] cve
            #   @return [::String]
            #     The CVE of the vulnerability. CVE cannot be
            #     empty and the combination of <cve, classification> should be unique
            #     across vulnerabilities for a VM.
            # @!attribute [rw] cvss_v2_score
            #   @return [::Float]
            #     The CVSS V2 score of this vulnerability. CVSS V2 score is on a scale of
            #     0 - 10 where 0 indicates low severity and 10 indicates high severity.
            # @!attribute [rw] cvss_v3
            #   @return [::Google::Cloud::OsConfig::V1::CVSSv3]
            #     The full description of the CVSSv3 for this vulnerability from NVD.
            # @!attribute [rw] severity
            #   @return [::String]
            #     Assigned severity/impact ranking from the distro.
            # @!attribute [rw] description
            #   @return [::String]
            #     The note or description describing the vulnerability from the distro.
            # @!attribute [rw] references
            #   @return [::Array<::Google::Cloud::OsConfig::V1::VulnerabilityReport::Vulnerability::Details::Reference>]
            #     Corresponds to the references attached to the `VulnerabilityDetails`.
            class Details
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # A reference for this vulnerability.
              # @!attribute [rw] url
              #   @return [::String]
              #     The url of the reference.
              # @!attribute [rw] source
              #   @return [::String]
              #     The source of the reference e.g. NVD.
              class Reference
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # OS inventory item that is affected by a vulnerability or fixed as a
            # result of a vulnerability.
            # @!attribute [rw] installed_inventory_item_id
            #   @return [::String]
            #     Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
            #     This field displays the inventory items affected by this vulnerability.
            #     If the vulnerability report was not updated after the VM inventory
            #     update, these values might not display in VM inventory. For some
            #     operating systems, this field might be empty.
            # @!attribute [rw] available_inventory_item_id
            #   @return [::String]
            #     Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
            #     If the vulnerability report was not updated after the VM inventory
            #     update, these values might not display in VM inventory. If there is no
            #     available fix, the field is empty. The `inventory_item` value specifies
            #     the latest `SoftwarePackage` available to the VM that fixes the
            #     vulnerability.
            # @!attribute [rw] fixed_cpe_uri
            #   @return [::String]
            #     The recommended [CPE URI](https://cpe.mitre.org/specification/) update
            #     that contains a fix for this vulnerability.
            # @!attribute [rw] upstream_fix
            #   @return [::String]
            #     The upstream OS patch, packages or KB that fixes the vulnerability.
            class Item
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Severity levels for vulnerabilities.
          module VulnerabilitySeverityLevel
            # Default SeverityLevel. This value is unused.
            VULNERABILITY_SEVERITY_LEVEL_UNSPECIFIED = 0

            # Vulnerability has no severity level.
            NONE = 1

            # Vulnerability severity level is minimal. This is level below the low
            # severity level.
            MINIMAL = 2

            # Vulnerability severity level is low. This is level below the medium
            # severity level.
            LOW = 3

            # Vulnerability severity level is medium. This is level below the high
            # severity level.
            MEDIUM = 4

            # Vulnerability severity level is high. This is level below the critical
            # severity level.
            HIGH = 5

            # Vulnerability severity level is critical. This is the highest severity
            # level.
            CRITICAL = 6
          end
        end

        # A request message for getting the vulnerability report for the specified VM.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. API resource name for vulnerability resource.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/vulnerabilityReport`
        #
        #     For `{project}`, either `project-number` or `project-id` can be provided.
        #     For `{instance}`, either Compute Engine `instance-id` or `instance-name`
        #     can be provided.
        class GetVulnerabilityReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for listing vulnerability reports for all VM instances in
        # the specified location.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name.
        #
        #     Format: `projects/{project}/locations/{location}/instances/-`
        #
        #     For `{project}`, either `project-number` or `project-id` can be provided.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A pagination token returned from a previous call to
        #     `ListVulnerabilityReports` that indicates where this listing
        #     should continue from.
        # @!attribute [rw] filter
        #   @return [::String]
        #     This field supports filtering by the severity level for the vulnerability.
        #     For a list of severity levels, see [Severity levels for
        #     vulnerabilities](https://cloud.google.com/container-analysis/docs/container-scanning-overview#severity_levels_for_vulnerabilities).
        #
        #     The filter field follows the rules described in the
        #     [AIP-160](https://google.aip.dev/160) guidelines as follows:
        #
        #     + **Filter for a specific severity type**:  you can list reports that
        #     contain
        #     vulnerabilities that are classified as medium by specifying
        #     `vulnerabilities.details.severity:MEDIUM`.
        #
        #     + **Filter for a range of severities** : you can list reports that have
        #     vulnerabilities that are classified as critical or high by specifying
        #     `vulnerabilities.details.severity:HIGH OR
        #     vulnerabilities.details.severity:CRITICAL`
        class ListVulnerabilityReportsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response message for listing vulnerability reports for all VM instances in
        # the specified location.
        # @!attribute [rw] vulnerability_reports
        #   @return [::Array<::Google::Cloud::OsConfig::V1::VulnerabilityReport>]
        #     List of vulnerabilityReport objects.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The pagination token to retrieve the next page of vulnerabilityReports
        #     object.
        class ListVulnerabilityReportsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Common Vulnerability Scoring System version 3.
        # For details, see https://www.first.org/cvss/specification-document
        # @!attribute [rw] base_score
        #   @return [::Float]
        #     The base score is a function of the base metric scores.
        #     https://www.first.org/cvss/specification-document#Base-Metrics
        # @!attribute [rw] exploitability_score
        #   @return [::Float]
        #     The Exploitability sub-score equation is derived from the Base
        #     Exploitability metrics.
        #     https://www.first.org/cvss/specification-document#2-1-Exploitability-Metrics
        # @!attribute [rw] impact_score
        #   @return [::Float]
        #     The Impact sub-score equation is derived from the Base Impact metrics.
        # @!attribute [rw] attack_vector
        #   @return [::Google::Cloud::OsConfig::V1::CVSSv3::AttackVector]
        #     This metric reflects the context by which vulnerability exploitation is
        #     possible.
        # @!attribute [rw] attack_complexity
        #   @return [::Google::Cloud::OsConfig::V1::CVSSv3::AttackComplexity]
        #     This metric describes the conditions beyond the attacker's control that
        #     must exist in order to exploit the vulnerability.
        # @!attribute [rw] privileges_required
        #   @return [::Google::Cloud::OsConfig::V1::CVSSv3::PrivilegesRequired]
        #     This metric describes the level of privileges an attacker must possess
        #     before successfully exploiting the vulnerability.
        # @!attribute [rw] user_interaction
        #   @return [::Google::Cloud::OsConfig::V1::CVSSv3::UserInteraction]
        #     This metric captures the requirement for a human user, other than the
        #     attacker, to participate in the successful compromise of the vulnerable
        #     component.
        # @!attribute [rw] scope
        #   @return [::Google::Cloud::OsConfig::V1::CVSSv3::Scope]
        #     The Scope metric captures whether a vulnerability in one vulnerable
        #     component impacts resources in components beyond its security scope.
        # @!attribute [rw] confidentiality_impact
        #   @return [::Google::Cloud::OsConfig::V1::CVSSv3::Impact]
        #     This metric measures the impact to the confidentiality of the information
        #     resources managed by a software component due to a successfully exploited
        #     vulnerability.
        # @!attribute [rw] integrity_impact
        #   @return [::Google::Cloud::OsConfig::V1::CVSSv3::Impact]
        #     This metric measures the impact to integrity of a successfully exploited
        #     vulnerability.
        # @!attribute [rw] availability_impact
        #   @return [::Google::Cloud::OsConfig::V1::CVSSv3::Impact]
        #     This metric measures the impact to the availability of the impacted
        #     component resulting from a successfully exploited vulnerability.
        class CVSSv3
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # This metric reflects the context by which vulnerability exploitation is
          # possible.
          module AttackVector
            # Invalid value.
            ATTACK_VECTOR_UNSPECIFIED = 0

            # The vulnerable component is bound to the network stack and the set of
            # possible attackers extends beyond the other options listed below, up to
            # and including the entire Internet.
            ATTACK_VECTOR_NETWORK = 1

            # The vulnerable component is bound to the network stack, but the attack is
            # limited at the protocol level to a logically adjacent topology.
            ATTACK_VECTOR_ADJACENT = 2

            # The vulnerable component is not bound to the network stack and the
            # attacker's path is via read/write/execute capabilities.
            ATTACK_VECTOR_LOCAL = 3

            # The attack requires the attacker to physically touch or manipulate the
            # vulnerable component.
            ATTACK_VECTOR_PHYSICAL = 4
          end

          # This metric describes the conditions beyond the attacker's control that
          # must exist in order to exploit the vulnerability.
          module AttackComplexity
            # Invalid value.
            ATTACK_COMPLEXITY_UNSPECIFIED = 0

            # Specialized access conditions or extenuating circumstances do not exist.
            # An attacker can expect repeatable success when attacking the vulnerable
            # component.
            ATTACK_COMPLEXITY_LOW = 1

            # A successful attack depends on conditions beyond the attacker's control.
            # That is, a successful attack cannot be accomplished at will, but requires
            # the attacker to invest in some measurable amount of effort in preparation
            # or execution against the vulnerable component before a successful attack
            # can be expected.
            ATTACK_COMPLEXITY_HIGH = 2
          end

          # This metric describes the level of privileges an attacker must possess
          # before successfully exploiting the vulnerability.
          module PrivilegesRequired
            # Invalid value.
            PRIVILEGES_REQUIRED_UNSPECIFIED = 0

            # The attacker is unauthorized prior to attack, and therefore does not
            # require any access to settings or files of the vulnerable system to
            # carry out an attack.
            PRIVILEGES_REQUIRED_NONE = 1

            # The attacker requires privileges that provide basic user capabilities
            # that could normally affect only settings and files owned by a user.
            # Alternatively, an attacker with Low privileges has the ability to access
            # only non-sensitive resources.
            PRIVILEGES_REQUIRED_LOW = 2

            # The attacker requires privileges that provide significant (e.g.,
            # administrative) control over the vulnerable component allowing access to
            # component-wide settings and files.
            PRIVILEGES_REQUIRED_HIGH = 3
          end

          # This metric captures the requirement for a human user, other than the
          # attacker, to participate in the successful compromise of the vulnerable
          # component.
          module UserInteraction
            # Invalid value.
            USER_INTERACTION_UNSPECIFIED = 0

            # The vulnerable system can be exploited without interaction from any user.
            USER_INTERACTION_NONE = 1

            # Successful exploitation of this vulnerability requires a user to take
            # some action before the vulnerability can be exploited.
            USER_INTERACTION_REQUIRED = 2
          end

          # The Scope metric captures whether a vulnerability in one vulnerable
          # component impacts resources in components beyond its security scope.
          module Scope
            # Invalid value.
            SCOPE_UNSPECIFIED = 0

            # An exploited vulnerability can only affect resources managed by the same
            # security authority.
            SCOPE_UNCHANGED = 1

            # An exploited vulnerability can affect resources beyond the security scope
            # managed by the security authority of the vulnerable component.
            SCOPE_CHANGED = 2
          end

          # The Impact metrics capture the effects of a successfully exploited
          # vulnerability on the component that suffers the worst outcome that is most
          # directly and predictably associated with the attack.
          module Impact
            # Invalid value.
            IMPACT_UNSPECIFIED = 0

            # High impact.
            IMPACT_HIGH = 1

            # Low impact.
            IMPACT_LOW = 2

            # No impact.
            IMPACT_NONE = 3
          end
        end
      end
    end
  end
end
