# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OsConfig
      module V1
        # OS policy assignment is an API resource that is used to
        # apply a set of OS policies to a dynamically targeted group of Compute Engine
        # VM instances.
        #
        # An OS policy is used to define the desired state configuration for a
        # Compute Engine VM instance through a set of configuration resources that
        # provide capabilities such as installing or removing software packages, or
        # executing a script.
        #
        # For more information, see [OS policy and OS policy
        # assignment](https://cloud.google.com/compute/docs/os-configuration-management/working-with-os-policies).
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource name.
        #
        #     Format:
        #     `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id}`
        #
        #     This field is ignored when you create an OS policy assignment.
        # @!attribute [rw] description
        #   @return [::String]
        #     OS policy assignment description.
        #     Length of the description is limited to 1024 characters.
        # @!attribute [rw] os_policies
        #   @return [::Array<::Google::Cloud::OsConfig::V1::OSPolicy>]
        #     Required. List of OS policies to be applied to the VMs.
        # @!attribute [rw] instance_filter
        #   @return [::Google::Cloud::OsConfig::V1::OSPolicyAssignment::InstanceFilter]
        #     Required. Filter to select VMs.
        # @!attribute [rw] rollout
        #   @return [::Google::Cloud::OsConfig::V1::OSPolicyAssignment::Rollout]
        #     Required. Rollout to deploy the OS policy assignment.
        #     A rollout is triggered in the following situations:
        #     1) OSPolicyAssignment is created.
        #     2) OSPolicyAssignment is updated and the update contains changes to one of
        #     the following fields:
        #        - instance_filter
        #        - os_policies
        #     3) OSPolicyAssignment is deleted.
        # @!attribute [r] revision_id
        #   @return [::String]
        #     Output only. The assignment revision ID
        #     A new revision is committed whenever a rollout is triggered for a OS policy
        #     assignment
        # @!attribute [r] revision_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp that the revision was created.
        # @!attribute [rw] etag
        #   @return [::String]
        #     The etag for this OS policy assignment.
        #     If this is provided on update, it must match the server's etag.
        # @!attribute [r] rollout_state
        #   @return [::Google::Cloud::OsConfig::V1::OSPolicyAssignment::RolloutState]
        #     Output only. OS policy assignment rollout state
        # @!attribute [r] baseline
        #   @return [::Boolean]
        #     Output only. Indicates that this revision has been successfully rolled out
        #     in this zone and new VMs will be assigned OS policies from this revision.
        #
        #     For a given OS policy assignment, there is only one revision with a value
        #     of `true` for this field.
        # @!attribute [r] deleted
        #   @return [::Boolean]
        #     Output only. Indicates that this revision deletes the OS policy assignment.
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Indicates that reconciliation is in progress for the revision.
        #     This value is `true` when the `rollout_state` is one of:
        #     * IN_PROGRESS
        #     * CANCELLING
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Server generated unique id for the OS policy assignment
        #     resource.
        class OSPolicyAssignment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Message representing label set.
          # * A label is a key value pair set for a VM.
          # * A LabelSet is a set of labels.
          # * Labels within a LabelSet are ANDed. In other words, a LabelSet is
          #   applicable for a VM only if it matches all the labels in the
          #   LabelSet.
          # * Example: A LabelSet with 2 labels: `env=prod` and `type=webserver` will
          #            only be applicable for those VMs with both labels
          #            present.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Labels are identified by key/value pairs in this map.
          #     A VM should contain all the key/value pairs specified in this
          #     map to be selected.
          class LabelSet
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Filters to select target VMs for an assignment.
          #
          # If more than one filter criteria is specified below, a VM will be selected
          # if and only if it satisfies all of them.
          # @!attribute [rw] all
          #   @return [::Boolean]
          #     Target all VMs in the project. If true, no other criteria is
          #     permitted.
          # @!attribute [rw] inclusion_labels
          #   @return [::Array<::Google::Cloud::OsConfig::V1::OSPolicyAssignment::LabelSet>]
          #     List of label sets used for VM inclusion.
          #
          #     If the list has more than one `LabelSet`, the VM is included if any
          #     of the label sets are applicable for the VM.
          # @!attribute [rw] exclusion_labels
          #   @return [::Array<::Google::Cloud::OsConfig::V1::OSPolicyAssignment::LabelSet>]
          #     List of label sets used for VM exclusion.
          #
          #     If the list has more than one label set, the VM is excluded if any
          #     of the label sets are applicable for the VM.
          # @!attribute [rw] inventories
          #   @return [::Array<::Google::Cloud::OsConfig::V1::OSPolicyAssignment::InstanceFilter::Inventory>]
          #     List of inventories to select VMs.
          #
          #     A VM is selected if its inventory data matches at least one of the
          #     following inventories.
          class InstanceFilter
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # VM inventory details.
            # @!attribute [rw] os_short_name
            #   @return [::String]
            #     Required. The OS short name
            # @!attribute [rw] os_version
            #   @return [::String]
            #     The OS version
            #
            #     Prefix matches are supported if asterisk(*) is provided as the
            #     last character. For example, to match all versions with a major
            #     version of `7`, specify the following value for this field `7.*`
            #
            #     An empty string matches all OS versions.
            class Inventory
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Message to configure the rollout at the zonal level for the OS policy
          # assignment.
          # @!attribute [rw] disruption_budget
          #   @return [::Google::Cloud::OsConfig::V1::FixedOrPercent]
          #     Required. The maximum number (or percentage) of VMs per zone to disrupt
          #     at any given moment.
          # @!attribute [rw] min_wait_duration
          #   @return [::Google::Protobuf::Duration]
          #     Required. This determines the minimum duration of time to wait after the
          #     configuration changes are applied through the current rollout. A
          #     VM continues to count towards the `disruption_budget` at least
          #     until this duration of time has passed after configuration changes are
          #     applied.
          class Rollout
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # OS policy assignment rollout state
          module RolloutState
            # Invalid value
            ROLLOUT_STATE_UNSPECIFIED = 0

            # The rollout is in progress.
            IN_PROGRESS = 1

            # The rollout is being cancelled.
            CANCELLING = 2

            # The rollout is cancelled.
            CANCELLED = 3

            # The rollout has completed successfully.
            SUCCEEDED = 4
          end
        end

        # OS policy assignment operation metadata provided by OS policy assignment API
        # methods that return long running operations.
        # @!attribute [rw] os_policy_assignment
        #   @return [::String]
        #     Reference to the `OSPolicyAssignment` API resource.
        #
        #     Format:
        #     `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id@revision_id}`
        # @!attribute [rw] api_method
        #   @return [::Google::Cloud::OsConfig::V1::OSPolicyAssignmentOperationMetadata::APIMethod]
        #     The OS policy assignment API method.
        # @!attribute [rw] rollout_state
        #   @return [::Google::Cloud::OsConfig::V1::OSPolicyAssignmentOperationMetadata::RolloutState]
        #     State of the rollout
        # @!attribute [rw] rollout_start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Rollout start time
        # @!attribute [rw] rollout_update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Rollout update time
        class OSPolicyAssignmentOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The OS policy assignment API method.
          module APIMethod
            # Invalid value
            API_METHOD_UNSPECIFIED = 0

            # Create OS policy assignment API method
            CREATE = 1

            # Update OS policy assignment API method
            UPDATE = 2

            # Delete OS policy assignment API method
            DELETE = 3
          end

          # State of the rollout
          module RolloutState
            # Invalid value
            ROLLOUT_STATE_UNSPECIFIED = 0

            # The rollout is in progress.
            IN_PROGRESS = 1

            # The rollout is being cancelled.
            CANCELLING = 2

            # The rollout is cancelled.
            CANCELLED = 3

            # The rollout has completed successfully.
            SUCCEEDED = 4
          end
        end

        # A request message to create an OS policy assignment
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name in the form:
        #     projects/\\{project}/locations/\\{location}
        # @!attribute [rw] os_policy_assignment
        #   @return [::Google::Cloud::OsConfig::V1::OSPolicyAssignment]
        #     Required. The OS policy assignment to be created.
        # @!attribute [rw] os_policy_assignment_id
        #   @return [::String]
        #     Required. The logical name of the OS policy assignment in the project
        #     with the following restrictions:
        #
        #     * Must contain only lowercase letters, numbers, and hyphens.
        #     * Must start with a letter.
        #     * Must be between 1-63 characters.
        #     * Must end with a number or a letter.
        #     * Must be unique within the project.
        class CreateOSPolicyAssignmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message to update an OS policy assignment
        # @!attribute [rw] os_policy_assignment
        #   @return [::Google::Cloud::OsConfig::V1::OSPolicyAssignment]
        #     Required. The updated OS policy assignment.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask that controls which fields of the assignment should be
        #     updated.
        class UpdateOSPolicyAssignmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message to get an OS policy assignment
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of OS policy assignment.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/osPolicyAssignments/{os_policy_assignment}@{revisionId}`
        class GetOSPolicyAssignmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message to list OS policy assignments for a parent resource
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of assignments to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A pagination token returned from a previous call to
        #     `ListOSPolicyAssignments` that indicates where this listing should continue
        #     from.
        class ListOSPolicyAssignmentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response message for listing all assignments under given parent.
        # @!attribute [rw] os_policy_assignments
        #   @return [::Array<::Google::Cloud::OsConfig::V1::OSPolicyAssignment>]
        #     The list of assignments
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The pagination token to retrieve the next page of OS policy assignments.
        class ListOSPolicyAssignmentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message to list revisions for a OS policy assignment
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the OS policy assignment to list revisions for.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of revisions to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A pagination token returned from a previous call to
        #     `ListOSPolicyAssignmentRevisions` that indicates where this listing should
        #     continue from.
        class ListOSPolicyAssignmentRevisionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response message for listing all revisions for a OS policy assignment.
        # @!attribute [rw] os_policy_assignments
        #   @return [::Array<::Google::Cloud::OsConfig::V1::OSPolicyAssignment>]
        #     The OS policy assignment revisions
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The pagination token to retrieve the next page of OS policy assignment
        #     revisions.
        class ListOSPolicyAssignmentRevisionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for deleting a OS policy assignment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the OS policy assignment to be deleted
        class DeleteOSPolicyAssignmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
