# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OsConfig
      module V1
        # Get a report of the OS policy assignment for a VM instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. API resource name for OS policy assignment report.
        #
        #     Format:
        #     `/projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/report`
        #
        #     For `{project}`, either `project-number` or `project-id` can be provided.
        #     For `{instance_id}`, either Compute Engine `instance-id` or `instance-name`
        #     can be provided.
        #     For `{assignment_id}`, the OSPolicyAssignment id must be provided.
        class GetOSPolicyAssignmentReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List the OS policy assignment reports for VM instances.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
        #
        #     For `{project}`, either `project-number` or `project-id` can be provided.
        #     For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
        #     provided. If '-' is provided, the response will include
        #     OSPolicyAssignmentReports for all instances in the project/location.
        #     For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
        #     is provided, the response will include OSPolicyAssignmentReports for all
        #     OSPolicyAssignments in the project/location.
        #     Either \\{instance} or \\{assignment} must be `-`.
        #
        #     For example:
        #     `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
        #      returns all reports for the instance
        #     `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
        #      returns all the reports for the given assignment across all instances.
        #     `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
        #      returns all the reports for all assignments across all instances.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     If provided, this field specifies the criteria that must be met by the
        #     `OSPolicyAssignmentReport` API resource that is included in the response.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A pagination token returned from a previous call to the
        #     `ListOSPolicyAssignmentReports` method that indicates where this listing
        #     should continue from.
        class ListOSPolicyAssignmentReportsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response message for listing OS Policy assignment reports including the
        # page of results and page token.
        # @!attribute [rw] os_policy_assignment_reports
        #   @return [::Array<::Google::Cloud::OsConfig::V1::OSPolicyAssignmentReport>]
        #     List of OS policy assignment reports.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The pagination token to retrieve the next page of OS policy assignment
        #     report objects.
        class ListOSPolicyAssignmentReportsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A report of the OS policy assignment status for a given instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     The `OSPolicyAssignmentReport` API resource name.
        #
        #     Format:
        #     `projects/{project_number}/locations/{location}/instances/{instance_id}/osPolicyAssignments/{os_policy_assignment_id}/report`
        # @!attribute [rw] instance
        #   @return [::String]
        #     The Compute Engine VM instance name.
        # @!attribute [rw] os_policy_assignment
        #   @return [::String]
        #     Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
        #     belongs to.
        #
        #     Format:
        #     `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id@revision_id}`
        # @!attribute [rw] os_policy_compliances
        #   @return [::Array<::Google::Cloud::OsConfig::V1::OSPolicyAssignmentReport::OSPolicyCompliance>]
        #     Compliance data for each `OSPolicy` that is applied to the VM.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Timestamp for when the report was last generated.
        # @!attribute [rw] last_run_id
        #   @return [::String]
        #     Unique identifier of the last attempted run to apply the OS policies
        #     associated with this assignment on the VM.
        #
        #     This ID is logged by the OS Config agent while applying the OS
        #     policies associated with this assignment on the VM.
        #     NOTE: If the service is unable to successfully connect to the agent for
        #     this run, then this id will not be available in the agent logs.
        class OSPolicyAssignmentReport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Compliance data for an OS policy
          # @!attribute [rw] os_policy_id
          #   @return [::String]
          #     The OS policy id
          # @!attribute [rw] compliance_state
          #   @return [::Google::Cloud::OsConfig::V1::OSPolicyAssignmentReport::OSPolicyCompliance::ComplianceState]
          #     The compliance state of the OS policy.
          # @!attribute [rw] compliance_state_reason
          #   @return [::String]
          #     The reason for the OS policy to be in an unknown compliance state.
          #     This field is always populated when `compliance_state` is `UNKNOWN`.
          #
          #     If populated, the field can contain one of the following values:
          #
          #     * `vm-not-running`: The VM was not running.
          #     * `os-policies-not-supported-by-agent`: The version of the OS Config
          #     agent running on the VM does not support running OS policies.
          #     * `no-agent-detected`: The OS Config agent is not detected for the VM.
          #     * `resource-execution-errors`: The OS Config agent encountered errors
          #     while executing one or more resources in the policy. See
          #     `os_policy_resource_compliances` for details.
          #     * `task-timeout`: The task sent to the agent to apply the policy timed
          #     out.
          #     * `unexpected-agent-state`: The OS Config agent did not report the final
          #     status of the task that attempted to apply the policy. Instead, the agent
          #     unexpectedly started working on a different task. This mostly happens
          #     when the agent or VM unexpectedly restarts while applying OS policies.
          #     * `internal-service-errors`: Internal service errors were encountered
          #     while attempting to apply the policy.
          # @!attribute [rw] os_policy_resource_compliances
          #   @return [::Array<::Google::Cloud::OsConfig::V1::OSPolicyAssignmentReport::OSPolicyCompliance::OSPolicyResourceCompliance>]
          #     Compliance data for each resource within the policy that is applied to
          #     the VM.
          class OSPolicyCompliance
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Compliance data for an OS policy resource.
            # @!attribute [rw] os_policy_resource_id
            #   @return [::String]
            #     The ID of the OS policy resource.
            # @!attribute [rw] config_steps
            #   @return [::Array<::Google::Cloud::OsConfig::V1::OSPolicyAssignmentReport::OSPolicyCompliance::OSPolicyResourceCompliance::OSPolicyResourceConfigStep>]
            #     Ordered list of configuration completed by the agent for the OS policy
            #     resource.
            # @!attribute [rw] compliance_state
            #   @return [::Google::Cloud::OsConfig::V1::OSPolicyAssignmentReport::OSPolicyCompliance::OSPolicyResourceCompliance::ComplianceState]
            #     The compliance state of the resource.
            # @!attribute [rw] compliance_state_reason
            #   @return [::String]
            #     A reason for the resource to be in the given compliance state.
            #     This field is always populated when `compliance_state` is `UNKNOWN`.
            #
            #     The following values are supported when `compliance_state == UNKNOWN`
            #
            #     * `execution-errors`: Errors were encountered by the agent while
            #     executing the resource and the compliance state couldn't be
            #     determined.
            #     * `execution-skipped-by-agent`: Resource execution was skipped by the
            #     agent because errors were encountered while executing prior resources
            #     in the OS policy.
            #     * `os-policy-execution-attempt-failed`: The execution of the OS policy
            #     containing this resource failed and the compliance state couldn't be
            #     determined.
            # @!attribute [rw] exec_resource_output
            #   @return [::Google::Cloud::OsConfig::V1::OSPolicyAssignmentReport::OSPolicyCompliance::OSPolicyResourceCompliance::ExecResourceOutput]
            #     ExecResource specific output.
            class OSPolicyResourceCompliance
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Step performed by the OS Config agent for configuring an
              # `OSPolicy` resource to its desired state.
              # @!attribute [rw] type
              #   @return [::Google::Cloud::OsConfig::V1::OSPolicyAssignmentReport::OSPolicyCompliance::OSPolicyResourceCompliance::OSPolicyResourceConfigStep::Type]
              #     Configuration step type.
              # @!attribute [rw] error_message
              #   @return [::String]
              #     An error message recorded during the execution of this step.
              #     Only populated if errors were encountered during this step execution.
              class OSPolicyResourceConfigStep
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # Supported configuration step types
                module Type
                  # Default value. This value is unused.
                  TYPE_UNSPECIFIED = 0

                  # Checks for resource conflicts such as schema errors.
                  VALIDATION = 1

                  # Checks the current status of the desired state for a resource.
                  DESIRED_STATE_CHECK = 2

                  # Enforces the desired state for a resource that is not in desired
                  # state.
                  DESIRED_STATE_ENFORCEMENT = 3

                  # Re-checks the status of the desired state. This check is done
                  # for a resource after the enforcement of all OS policies.
                  #
                  # This step is used to determine the final desired state status for
                  # the resource. It accounts for any resources that might have drifted
                  # from their desired state due to side effects from executing other
                  # resources.
                  DESIRED_STATE_CHECK_POST_ENFORCEMENT = 4
                end
              end

              # ExecResource specific output.
              # @!attribute [rw] enforcement_output
              #   @return [::String]
              #     Output from enforcement phase output file (if run).
              #     Output size is limited to 100K bytes.
              class ExecResourceOutput
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # Possible compliance states for a resource.
              module ComplianceState
                # The resource is in an unknown compliance state.
                #
                # To get more details about why the policy is in this state, review
                # the output of the `compliance_state_reason` field.
                UNKNOWN = 0

                # Resource is compliant.
                COMPLIANT = 1

                # Resource is non-compliant.
                NON_COMPLIANT = 2
              end
            end

            # Possible compliance states for an os policy.
            module ComplianceState
              # The policy is in an unknown compliance state.
              #
              # Refer to the field `compliance_state_reason` to learn the exact reason
              # for the policy to be in this compliance state.
              UNKNOWN = 0

              # Policy is compliant.
              #
              # The policy is compliant if all the underlying resources are also
              # compliant.
              COMPLIANT = 1

              # Policy is non-compliant.
              #
              # The policy is non-compliant if one or more underlying resources are
              # non-compliant.
              NON_COMPLIANT = 2
            end
          end
        end
      end
    end
  end
end
