# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/osconfig/v1/osconfig_service.proto for package 'Google.Cloud.OsConfig.V1'
# Original file comments:
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/osconfig/v1/osconfig_service_pb'

module Google
  module Cloud
    module OsConfig
      module V1
        module OsConfigService
          # OS Config API
          #
          # The OS Config service is a server-side component that you can use to
          # manage package installations and patch jobs for virtual machine instances.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.osconfig.v1.OsConfigService'

            # Patch VM instances by creating and running a patch job.
            rpc :ExecutePatchJob, ::Google::Cloud::OsConfig::V1::ExecutePatchJobRequest, ::Google::Cloud::OsConfig::V1::PatchJob
            # Get the patch job. This can be used to track the progress of an
            # ongoing patch job or review the details of completed jobs.
            rpc :GetPatchJob, ::Google::Cloud::OsConfig::V1::GetPatchJobRequest, ::Google::Cloud::OsConfig::V1::PatchJob
            # Cancel a patch job. The patch job must be active. Canceled patch jobs
            # cannot be restarted.
            rpc :CancelPatchJob, ::Google::Cloud::OsConfig::V1::CancelPatchJobRequest, ::Google::Cloud::OsConfig::V1::PatchJob
            # Get a list of patch jobs.
            rpc :ListPatchJobs, ::Google::Cloud::OsConfig::V1::ListPatchJobsRequest, ::Google::Cloud::OsConfig::V1::ListPatchJobsResponse
            # Get a list of instance details for a given patch job.
            rpc :ListPatchJobInstanceDetails, ::Google::Cloud::OsConfig::V1::ListPatchJobInstanceDetailsRequest, ::Google::Cloud::OsConfig::V1::ListPatchJobInstanceDetailsResponse
            # Create an OS Config patch deployment.
            rpc :CreatePatchDeployment, ::Google::Cloud::OsConfig::V1::CreatePatchDeploymentRequest, ::Google::Cloud::OsConfig::V1::PatchDeployment
            # Get an OS Config patch deployment.
            rpc :GetPatchDeployment, ::Google::Cloud::OsConfig::V1::GetPatchDeploymentRequest, ::Google::Cloud::OsConfig::V1::PatchDeployment
            # Get a page of OS Config patch deployments.
            rpc :ListPatchDeployments, ::Google::Cloud::OsConfig::V1::ListPatchDeploymentsRequest, ::Google::Cloud::OsConfig::V1::ListPatchDeploymentsResponse
            # Delete an OS Config patch deployment.
            rpc :DeletePatchDeployment, ::Google::Cloud::OsConfig::V1::DeletePatchDeploymentRequest, ::Google::Protobuf::Empty
            # Update an OS Config patch deployment.
            rpc :UpdatePatchDeployment, ::Google::Cloud::OsConfig::V1::UpdatePatchDeploymentRequest, ::Google::Cloud::OsConfig::V1::PatchDeployment
            # Change state of patch deployment to "PAUSED".
            # Patch deployment in paused state doesn't generate patch jobs.
            rpc :PausePatchDeployment, ::Google::Cloud::OsConfig::V1::PausePatchDeploymentRequest, ::Google::Cloud::OsConfig::V1::PatchDeployment
            # Change state of patch deployment back to "ACTIVE".
            # Patch deployment in active state continues to generate patch jobs.
            rpc :ResumePatchDeployment, ::Google::Cloud::OsConfig::V1::ResumePatchDeploymentRequest, ::Google::Cloud::OsConfig::V1::PatchDeployment
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
