# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OsConfig
      module V1
        module OsConfigService
          # Path helper methods for the OsConfigService API.
          module Paths
            ##
            # Create a fully-qualified PatchDeployment resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/patchDeployments/{patch_deployment}`
            #
            # @param project [String]
            # @param patch_deployment [String]
            #
            # @return [::String]
            def patch_deployment_path project:, patch_deployment:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/patchDeployments/#{patch_deployment}"
            end

            ##
            # Create a fully-qualified PatchJob resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/patchJobs/{patch_job}`
            #
            # @param project [String]
            # @param patch_job [String]
            #
            # @return [::String]
            def patch_job_path project:, patch_job:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/patchJobs/#{patch_job}"
            end

            ##
            # Create a fully-qualified Project resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}`
            #
            # @param project [String]
            #
            # @return [::String]
            def project_path project:
              "projects/#{project}"
            end

            extend self
          end
        end
      end
    end
  end
end
