# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/osconfig/v1/osconfig_service_pb"

module Google
  module Cloud
    module OsConfig
      module V1
        module OsConfigService
          ##
          # Client for the OsConfigService service.
          #
          # OS Config API
          #
          # The OS Config service is a server-side component that you can use to
          # manage package installations and patch jobs for virtual machine instances.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "osconfig.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :os_config_service_stub

            ##
            # Configure the OsConfigService Client class.
            #
            # See {::Google::Cloud::OsConfig::V1::OsConfigService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all OsConfigService clients
            #   ::Google::Cloud::OsConfig::V1::OsConfigService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "OsConfig", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0
                default_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the OsConfigService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::OsConfig::V1::OsConfigService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @os_config_service_stub.universe_domain
            end

            ##
            # Create a new OsConfigService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::OsConfig::V1::OsConfigService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::OsConfig::V1::OsConfigService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the OsConfigService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/osconfig/v1/osconfig_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @os_config_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::OsConfig::V1::OsConfigService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @os_config_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @os_config_service_stub.logger
            end

            # Service calls

            ##
            # Patch VM instances by creating and running a patch job.
            #
            # @overload execute_patch_job(request, options = nil)
            #   Pass arguments to `execute_patch_job` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1::ExecutePatchJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1::ExecutePatchJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload execute_patch_job(parent: nil, description: nil, instance_filter: nil, patch_config: nil, duration: nil, dry_run: nil, display_name: nil, rollout: nil)
            #   Pass arguments to `execute_patch_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project in which to run this patch in the form `projects/*`
            #   @param description [::String]
            #     Description of the patch job. Length of the description is limited
            #     to 1024 characters.
            #   @param instance_filter [::Google::Cloud::OsConfig::V1::PatchInstanceFilter, ::Hash]
            #     Required. Instances to patch, either explicitly or filtered by some
            #     criteria such as zone or labels.
            #   @param patch_config [::Google::Cloud::OsConfig::V1::PatchConfig, ::Hash]
            #     Patch configuration being applied. If omitted, instances are
            #     patched using the default configurations.
            #   @param duration [::Google::Protobuf::Duration, ::Hash]
            #     Duration of the patch job. After the duration ends, the patch job
            #     times out.
            #   @param dry_run [::Boolean]
            #     If this patch is a dry-run only, instances are contacted but
            #     will do nothing.
            #   @param display_name [::String]
            #     Display name for this patch job. This does not have to be unique.
            #   @param rollout [::Google::Cloud::OsConfig::V1::PatchRollout, ::Hash]
            #     Rollout strategy of the patch job.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::OsConfig::V1::PatchJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::OsConfig::V1::PatchJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1::OsConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1::ExecutePatchJobRequest.new
            #
            #   # Call the execute_patch_job method.
            #   result = client.execute_patch_job request
            #
            #   # The returned object is of type Google::Cloud::OsConfig::V1::PatchJob.
            #   p result
            #
            def execute_patch_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1::ExecutePatchJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.execute_patch_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.execute_patch_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.execute_patch_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_service_stub.call_rpc :execute_patch_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get the patch job. This can be used to track the progress of an
            # ongoing patch job or review the details of completed jobs.
            #
            # @overload get_patch_job(request, options = nil)
            #   Pass arguments to `get_patch_job` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1::GetPatchJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1::GetPatchJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_patch_job(name: nil)
            #   Pass arguments to `get_patch_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the patch in the form `projects/*/patchJobs/*`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::OsConfig::V1::PatchJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::OsConfig::V1::PatchJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1::OsConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1::GetPatchJobRequest.new
            #
            #   # Call the get_patch_job method.
            #   result = client.get_patch_job request
            #
            #   # The returned object is of type Google::Cloud::OsConfig::V1::PatchJob.
            #   p result
            #
            def get_patch_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1::GetPatchJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_patch_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_patch_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_patch_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_service_stub.call_rpc :get_patch_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Cancel a patch job. The patch job must be active. Canceled patch jobs
            # cannot be restarted.
            #
            # @overload cancel_patch_job(request, options = nil)
            #   Pass arguments to `cancel_patch_job` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1::CancelPatchJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1::CancelPatchJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload cancel_patch_job(name: nil)
            #   Pass arguments to `cancel_patch_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the patch in the form `projects/*/patchJobs/*`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::OsConfig::V1::PatchJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::OsConfig::V1::PatchJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1::OsConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1::CancelPatchJobRequest.new
            #
            #   # Call the cancel_patch_job method.
            #   result = client.cancel_patch_job request
            #
            #   # The returned object is of type Google::Cloud::OsConfig::V1::PatchJob.
            #   p result
            #
            def cancel_patch_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1::CancelPatchJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.cancel_patch_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.cancel_patch_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.cancel_patch_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_service_stub.call_rpc :cancel_patch_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a list of patch jobs.
            #
            # @overload list_patch_jobs(request, options = nil)
            #   Pass arguments to `list_patch_jobs` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1::ListPatchJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1::ListPatchJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_patch_jobs(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_patch_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. In the form of `projects/*`
            #   @param page_size [::Integer]
            #     The maximum number of instance status to return.
            #   @param page_token [::String]
            #     A pagination token returned from a previous call
            #     that indicates where this listing should continue from.
            #   @param filter [::String]
            #     If provided, this field specifies the criteria that must be met by patch
            #     jobs to be included in the response.
            #     Currently, filtering is only available on the patch_deployment field.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1::PatchJob>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1::PatchJob>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1::OsConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1::ListPatchJobsRequest.new
            #
            #   # Call the list_patch_jobs method.
            #   result = client.list_patch_jobs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::OsConfig::V1::PatchJob.
            #     p item
            #   end
            #
            def list_patch_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1::ListPatchJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_patch_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_patch_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_patch_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_service_stub.call_rpc :list_patch_jobs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @os_config_service_stub, :list_patch_jobs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a list of instance details for a given patch job.
            #
            # @overload list_patch_job_instance_details(request, options = nil)
            #   Pass arguments to `list_patch_job_instance_details` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1::ListPatchJobInstanceDetailsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1::ListPatchJobInstanceDetailsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_patch_job_instance_details(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_patch_job_instance_details` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent for the instances are in the form of
            #     `projects/*/patchJobs/*`.
            #   @param page_size [::Integer]
            #     The maximum number of instance details records to return.  Default is 100.
            #   @param page_token [::String]
            #     A pagination token returned from a previous call
            #     that indicates where this listing should continue from.
            #   @param filter [::String]
            #     A filter expression that filters results listed in the response. This
            #     field supports filtering results by instance zone, name, state, or
            #     `failure_reason`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1::PatchJobInstanceDetails>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1::PatchJobInstanceDetails>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1::OsConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1::ListPatchJobInstanceDetailsRequest.new
            #
            #   # Call the list_patch_job_instance_details method.
            #   result = client.list_patch_job_instance_details request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::OsConfig::V1::PatchJobInstanceDetails.
            #     p item
            #   end
            #
            def list_patch_job_instance_details request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1::ListPatchJobInstanceDetailsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_patch_job_instance_details.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_patch_job_instance_details.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_patch_job_instance_details.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_service_stub.call_rpc :list_patch_job_instance_details, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @os_config_service_stub, :list_patch_job_instance_details, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create an OS Config patch deployment.
            #
            # @overload create_patch_deployment(request, options = nil)
            #   Pass arguments to `create_patch_deployment` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1::CreatePatchDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1::CreatePatchDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_patch_deployment(parent: nil, patch_deployment_id: nil, patch_deployment: nil)
            #   Pass arguments to `create_patch_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project to apply this patch deployment to in the form
            #     `projects/*`.
            #   @param patch_deployment_id [::String]
            #     Required. A name for the patch deployment in the project. When creating a
            #     name the following rules apply:
            #     * Must contain only lowercase letters, numbers, and hyphens.
            #     * Must start with a letter.
            #     * Must be between 1-63 characters.
            #     * Must end with a number or a letter.
            #     * Must be unique within the project.
            #   @param patch_deployment [::Google::Cloud::OsConfig::V1::PatchDeployment, ::Hash]
            #     Required. The patch deployment to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::OsConfig::V1::PatchDeployment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::OsConfig::V1::PatchDeployment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1::OsConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1::CreatePatchDeploymentRequest.new
            #
            #   # Call the create_patch_deployment method.
            #   result = client.create_patch_deployment request
            #
            #   # The returned object is of type Google::Cloud::OsConfig::V1::PatchDeployment.
            #   p result
            #
            def create_patch_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1::CreatePatchDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_patch_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_patch_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_patch_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_service_stub.call_rpc :create_patch_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get an OS Config patch deployment.
            #
            # @overload get_patch_deployment(request, options = nil)
            #   Pass arguments to `get_patch_deployment` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1::GetPatchDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1::GetPatchDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_patch_deployment(name: nil)
            #   Pass arguments to `get_patch_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the patch deployment in the form
            #     `projects/*/patchDeployments/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::OsConfig::V1::PatchDeployment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::OsConfig::V1::PatchDeployment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1::OsConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1::GetPatchDeploymentRequest.new
            #
            #   # Call the get_patch_deployment method.
            #   result = client.get_patch_deployment request
            #
            #   # The returned object is of type Google::Cloud::OsConfig::V1::PatchDeployment.
            #   p result
            #
            def get_patch_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1::GetPatchDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_patch_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_patch_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_patch_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_service_stub.call_rpc :get_patch_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a page of OS Config patch deployments.
            #
            # @overload list_patch_deployments(request, options = nil)
            #   Pass arguments to `list_patch_deployments` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1::ListPatchDeploymentsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1::ListPatchDeploymentsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_patch_deployments(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_patch_deployments` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the parent in the form `projects/*`.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of patch deployments to return. Default is
            #     100.
            #   @param page_token [::String]
            #     Optional. A pagination token returned from a previous call to
            #     ListPatchDeployments that indicates where this listing should continue
            #     from.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1::PatchDeployment>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::OsConfig::V1::PatchDeployment>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1::OsConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1::ListPatchDeploymentsRequest.new
            #
            #   # Call the list_patch_deployments method.
            #   result = client.list_patch_deployments request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::OsConfig::V1::PatchDeployment.
            #     p item
            #   end
            #
            def list_patch_deployments request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1::ListPatchDeploymentsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_patch_deployments.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_patch_deployments.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_patch_deployments.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_service_stub.call_rpc :list_patch_deployments, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @os_config_service_stub, :list_patch_deployments, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Delete an OS Config patch deployment.
            #
            # @overload delete_patch_deployment(request, options = nil)
            #   Pass arguments to `delete_patch_deployment` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1::DeletePatchDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1::DeletePatchDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_patch_deployment(name: nil)
            #   Pass arguments to `delete_patch_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the patch deployment in the form
            #     `projects/*/patchDeployments/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1::OsConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1::DeletePatchDeploymentRequest.new
            #
            #   # Call the delete_patch_deployment method.
            #   result = client.delete_patch_deployment request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_patch_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1::DeletePatchDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_patch_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_patch_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_patch_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_service_stub.call_rpc :delete_patch_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update an OS Config patch deployment.
            #
            # @overload update_patch_deployment(request, options = nil)
            #   Pass arguments to `update_patch_deployment` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1::UpdatePatchDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1::UpdatePatchDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_patch_deployment(patch_deployment: nil, update_mask: nil)
            #   Pass arguments to `update_patch_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param patch_deployment [::Google::Cloud::OsConfig::V1::PatchDeployment, ::Hash]
            #     Required. The patch deployment to Update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask that controls which fields of the patch deployment
            #     should be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::OsConfig::V1::PatchDeployment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::OsConfig::V1::PatchDeployment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1::OsConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1::UpdatePatchDeploymentRequest.new
            #
            #   # Call the update_patch_deployment method.
            #   result = client.update_patch_deployment request
            #
            #   # The returned object is of type Google::Cloud::OsConfig::V1::PatchDeployment.
            #   p result
            #
            def update_patch_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1::UpdatePatchDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_patch_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.patch_deployment&.name
                header_params["patch_deployment.name"] = request.patch_deployment.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_patch_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_patch_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_service_stub.call_rpc :update_patch_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Change state of patch deployment to "PAUSED".
            # Patch deployment in paused state doesn't generate patch jobs.
            #
            # @overload pause_patch_deployment(request, options = nil)
            #   Pass arguments to `pause_patch_deployment` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1::PausePatchDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1::PausePatchDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload pause_patch_deployment(name: nil)
            #   Pass arguments to `pause_patch_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the patch deployment in the form
            #     `projects/*/patchDeployments/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::OsConfig::V1::PatchDeployment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::OsConfig::V1::PatchDeployment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1::OsConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1::PausePatchDeploymentRequest.new
            #
            #   # Call the pause_patch_deployment method.
            #   result = client.pause_patch_deployment request
            #
            #   # The returned object is of type Google::Cloud::OsConfig::V1::PatchDeployment.
            #   p result
            #
            def pause_patch_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1::PausePatchDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.pause_patch_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.pause_patch_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.pause_patch_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_service_stub.call_rpc :pause_patch_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Change state of patch deployment back to "ACTIVE".
            # Patch deployment in active state continues to generate patch jobs.
            #
            # @overload resume_patch_deployment(request, options = nil)
            #   Pass arguments to `resume_patch_deployment` via a request object, either of type
            #   {::Google::Cloud::OsConfig::V1::ResumePatchDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::OsConfig::V1::ResumePatchDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload resume_patch_deployment(name: nil)
            #   Pass arguments to `resume_patch_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the patch deployment in the form
            #     `projects/*/patchDeployments/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::OsConfig::V1::PatchDeployment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::OsConfig::V1::PatchDeployment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/os_config/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::OsConfig::V1::OsConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::OsConfig::V1::ResumePatchDeploymentRequest.new
            #
            #   # Call the resume_patch_deployment method.
            #   result = client.resume_patch_deployment request
            #
            #   # The returned object is of type Google::Cloud::OsConfig::V1::PatchDeployment.
            #   p result
            #
            def resume_patch_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OsConfig::V1::ResumePatchDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.resume_patch_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::OsConfig::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.resume_patch_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.resume_patch_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @os_config_service_stub.call_rpc :resume_patch_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the OsConfigService API.
            #
            # This class represents the configuration for OsConfigService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::OsConfig::V1::OsConfigService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # execute_patch_job to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::OsConfig::V1::OsConfigService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.execute_patch_job.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::OsConfig::V1::OsConfigService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.execute_patch_job.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::OsConfig::V1::OsConfigService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "osconfig.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the OsConfigService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `execute_patch_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :execute_patch_job
                ##
                # RPC-specific configuration for `get_patch_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_patch_job
                ##
                # RPC-specific configuration for `cancel_patch_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :cancel_patch_job
                ##
                # RPC-specific configuration for `list_patch_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_patch_jobs
                ##
                # RPC-specific configuration for `list_patch_job_instance_details`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_patch_job_instance_details
                ##
                # RPC-specific configuration for `create_patch_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_patch_deployment
                ##
                # RPC-specific configuration for `get_patch_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_patch_deployment
                ##
                # RPC-specific configuration for `list_patch_deployments`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_patch_deployments
                ##
                # RPC-specific configuration for `delete_patch_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_patch_deployment
                ##
                # RPC-specific configuration for `update_patch_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_patch_deployment
                ##
                # RPC-specific configuration for `pause_patch_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :pause_patch_deployment
                ##
                # RPC-specific configuration for `resume_patch_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :resume_patch_deployment

                # @private
                def initialize parent_rpcs = nil
                  execute_patch_job_config = parent_rpcs.execute_patch_job if parent_rpcs.respond_to? :execute_patch_job
                  @execute_patch_job = ::Gapic::Config::Method.new execute_patch_job_config
                  get_patch_job_config = parent_rpcs.get_patch_job if parent_rpcs.respond_to? :get_patch_job
                  @get_patch_job = ::Gapic::Config::Method.new get_patch_job_config
                  cancel_patch_job_config = parent_rpcs.cancel_patch_job if parent_rpcs.respond_to? :cancel_patch_job
                  @cancel_patch_job = ::Gapic::Config::Method.new cancel_patch_job_config
                  list_patch_jobs_config = parent_rpcs.list_patch_jobs if parent_rpcs.respond_to? :list_patch_jobs
                  @list_patch_jobs = ::Gapic::Config::Method.new list_patch_jobs_config
                  list_patch_job_instance_details_config = parent_rpcs.list_patch_job_instance_details if parent_rpcs.respond_to? :list_patch_job_instance_details
                  @list_patch_job_instance_details = ::Gapic::Config::Method.new list_patch_job_instance_details_config
                  create_patch_deployment_config = parent_rpcs.create_patch_deployment if parent_rpcs.respond_to? :create_patch_deployment
                  @create_patch_deployment = ::Gapic::Config::Method.new create_patch_deployment_config
                  get_patch_deployment_config = parent_rpcs.get_patch_deployment if parent_rpcs.respond_to? :get_patch_deployment
                  @get_patch_deployment = ::Gapic::Config::Method.new get_patch_deployment_config
                  list_patch_deployments_config = parent_rpcs.list_patch_deployments if parent_rpcs.respond_to? :list_patch_deployments
                  @list_patch_deployments = ::Gapic::Config::Method.new list_patch_deployments_config
                  delete_patch_deployment_config = parent_rpcs.delete_patch_deployment if parent_rpcs.respond_to? :delete_patch_deployment
                  @delete_patch_deployment = ::Gapic::Config::Method.new delete_patch_deployment_config
                  update_patch_deployment_config = parent_rpcs.update_patch_deployment if parent_rpcs.respond_to? :update_patch_deployment
                  @update_patch_deployment = ::Gapic::Config::Method.new update_patch_deployment_config
                  pause_patch_deployment_config = parent_rpcs.pause_patch_deployment if parent_rpcs.respond_to? :pause_patch_deployment
                  @pause_patch_deployment = ::Gapic::Config::Method.new pause_patch_deployment_config
                  resume_patch_deployment_config = parent_rpcs.resume_patch_deployment if parent_rpcs.respond_to? :resume_patch_deployment
                  @resume_patch_deployment = ::Gapic::Config::Method.new resume_patch_deployment_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
