# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/orgpolicy/v2/orgpolicy_pb"
require "google/cloud/org_policy/v2/org_policy"

class ::Google::Cloud::OrgPolicy::V2::OrgPolicy::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_constraints
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OrgPolicy::V2::ListConstraintsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_constraints_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_constraints, name
      assert_kind_of ::Google::Cloud::OrgPolicy::V2::ListConstraintsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_constraints_client_stub do
      # Create client
      client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_constraints({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_constraints parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_constraints ::Google::Cloud::OrgPolicy::V2::ListConstraintsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_constraints({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_constraints(::Google::Cloud::OrgPolicy::V2::ListConstraintsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_constraints_client_stub.call_rpc_count
    end
  end

  def test_list_policies
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OrgPolicy::V2::ListPoliciesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_policies_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_policies, name
      assert_kind_of ::Google::Cloud::OrgPolicy::V2::ListPoliciesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_policies_client_stub do
      # Create client
      client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_policies({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_policies parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_policies ::Google::Cloud::OrgPolicy::V2::ListPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_policies({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_policies(::Google::Cloud::OrgPolicy::V2::ListPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_policies_client_stub.call_rpc_count
    end
  end

  def test_get_policy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OrgPolicy::V2::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_policy, name
      assert_kind_of ::Google::Cloud::OrgPolicy::V2::GetPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_policy_client_stub do
      # Create client
      client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_policy ::Google::Cloud::OrgPolicy::V2::GetPolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_policy(::Google::Cloud::OrgPolicy::V2::GetPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_policy_client_stub.call_rpc_count
    end
  end

  def test_get_effective_policy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OrgPolicy::V2::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_effective_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_effective_policy, name
      assert_kind_of ::Google::Cloud::OrgPolicy::V2::GetEffectivePolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_effective_policy_client_stub do
      # Create client
      client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_effective_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_effective_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_effective_policy ::Google::Cloud::OrgPolicy::V2::GetEffectivePolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_effective_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_effective_policy(::Google::Cloud::OrgPolicy::V2::GetEffectivePolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_effective_policy_client_stub.call_rpc_count
    end
  end

  def test_create_policy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OrgPolicy::V2::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    policy = {}

    create_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_policy, name
      assert_kind_of ::Google::Cloud::OrgPolicy::V2::CreatePolicyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::OrgPolicy::V2::Policy), request["policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_policy_client_stub do
      # Create client
      client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_policy({ parent: parent, policy: policy }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_policy parent: parent, policy: policy do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_policy ::Google::Cloud::OrgPolicy::V2::CreatePolicyRequest.new(parent: parent, policy: policy) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_policy({ parent: parent, policy: policy }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_policy(::Google::Cloud::OrgPolicy::V2::CreatePolicyRequest.new(parent: parent, policy: policy), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_policy_client_stub.call_rpc_count
    end
  end

  def test_update_policy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OrgPolicy::V2::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    policy = {}
    update_mask = {}

    update_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_policy, name
      assert_kind_of ::Google::Cloud::OrgPolicy::V2::UpdatePolicyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::OrgPolicy::V2::Policy), request["policy"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_policy_client_stub do
      # Create client
      client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_policy({ policy: policy, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_policy policy: policy, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_policy ::Google::Cloud::OrgPolicy::V2::UpdatePolicyRequest.new(policy: policy, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_policy({ policy: policy, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_policy(::Google::Cloud::OrgPolicy::V2::UpdatePolicyRequest.new(policy: policy, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_policy_client_stub.call_rpc_count
    end
  end

  def test_delete_policy
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_policy, name
      assert_kind_of ::Google::Cloud::OrgPolicy::V2::DeletePolicyRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_policy_client_stub do
      # Create client
      client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_policy({ name: name, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_policy name: name, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_policy ::Google::Cloud::OrgPolicy::V2::DeletePolicyRequest.new(name: name, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_policy({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_policy(::Google::Cloud::OrgPolicy::V2::DeletePolicyRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_policy_client_stub.call_rpc_count
    end
  end

  def test_create_custom_constraint
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OrgPolicy::V2::CustomConstraint.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    custom_constraint = {}

    create_custom_constraint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_custom_constraint, name
      assert_kind_of ::Google::Cloud::OrgPolicy::V2::CreateCustomConstraintRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::OrgPolicy::V2::CustomConstraint), request["custom_constraint"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_custom_constraint_client_stub do
      # Create client
      client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_custom_constraint({ parent: parent, custom_constraint: custom_constraint }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_custom_constraint parent: parent, custom_constraint: custom_constraint do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_custom_constraint ::Google::Cloud::OrgPolicy::V2::CreateCustomConstraintRequest.new(parent: parent, custom_constraint: custom_constraint) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_custom_constraint({ parent: parent, custom_constraint: custom_constraint }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_custom_constraint(::Google::Cloud::OrgPolicy::V2::CreateCustomConstraintRequest.new(parent: parent, custom_constraint: custom_constraint), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_custom_constraint_client_stub.call_rpc_count
    end
  end

  def test_update_custom_constraint
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OrgPolicy::V2::CustomConstraint.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    custom_constraint = {}

    update_custom_constraint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_custom_constraint, name
      assert_kind_of ::Google::Cloud::OrgPolicy::V2::UpdateCustomConstraintRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::OrgPolicy::V2::CustomConstraint), request["custom_constraint"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_custom_constraint_client_stub do
      # Create client
      client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_custom_constraint({ custom_constraint: custom_constraint }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_custom_constraint custom_constraint: custom_constraint do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_custom_constraint ::Google::Cloud::OrgPolicy::V2::UpdateCustomConstraintRequest.new(custom_constraint: custom_constraint) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_custom_constraint({ custom_constraint: custom_constraint }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_custom_constraint(::Google::Cloud::OrgPolicy::V2::UpdateCustomConstraintRequest.new(custom_constraint: custom_constraint), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_custom_constraint_client_stub.call_rpc_count
    end
  end

  def test_get_custom_constraint
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OrgPolicy::V2::CustomConstraint.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_custom_constraint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_custom_constraint, name
      assert_kind_of ::Google::Cloud::OrgPolicy::V2::GetCustomConstraintRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_custom_constraint_client_stub do
      # Create client
      client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_custom_constraint({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_custom_constraint name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_custom_constraint ::Google::Cloud::OrgPolicy::V2::GetCustomConstraintRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_custom_constraint({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_custom_constraint(::Google::Cloud::OrgPolicy::V2::GetCustomConstraintRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_custom_constraint_client_stub.call_rpc_count
    end
  end

  def test_list_custom_constraints
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::OrgPolicy::V2::ListCustomConstraintsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_custom_constraints_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_custom_constraints, name
      assert_kind_of ::Google::Cloud::OrgPolicy::V2::ListCustomConstraintsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_custom_constraints_client_stub do
      # Create client
      client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_custom_constraints({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_custom_constraints parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_custom_constraints ::Google::Cloud::OrgPolicy::V2::ListCustomConstraintsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_custom_constraints({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_custom_constraints(::Google::Cloud::OrgPolicy::V2::ListCustomConstraintsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_custom_constraints_client_stub.call_rpc_count
    end
  end

  def test_delete_custom_constraint
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_custom_constraint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_custom_constraint, name
      assert_kind_of ::Google::Cloud::OrgPolicy::V2::DeleteCustomConstraintRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_custom_constraint_client_stub do
      # Create client
      client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_custom_constraint({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_custom_constraint name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_custom_constraint ::Google::Cloud::OrgPolicy::V2::DeleteCustomConstraintRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_custom_constraint({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_custom_constraint(::Google::Cloud::OrgPolicy::V2::DeleteCustomConstraintRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_custom_constraint_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
