# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/orgpolicy/v2/orgpolicy_pb"
require "google/cloud/org_policy/v2/org_policy/rest/service_stub"

module Google
  module Cloud
    module OrgPolicy
      module V2
        module OrgPolicy
          module Rest
            ##
            # REST client for the OrgPolicy service.
            #
            # An interface for managing organization policies.
            #
            # The Organization Policy Service provides a simple mechanism for
            # organizations to restrict the allowed configurations across their entire
            # resource hierarchy.
            #
            # You can use a policy to configure restrictions on resources. For
            # example, you can enforce a policy that restricts which Google
            # Cloud APIs can be activated in a certain part of your resource
            # hierarchy, or prevents serial port access to VM instances in a
            # particular folder.
            #
            # Policies are inherited down through the resource hierarchy. A policy
            # applied to a parent resource automatically applies to all its child resources
            # unless overridden with a policy lower in the hierarchy.
            #
            # A constraint defines an aspect of a resource's configuration that can be
            # controlled by an organization's policy administrator. Policies are a
            # collection of constraints that defines their allowable configuration on a
            # particular resource and its child resources.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "orgpolicy.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :org_policy_stub

              ##
              # Configure the OrgPolicy Client class.
              #
              # See {::Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all OrgPolicy clients
              #   ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "OrgPolicy", "V2"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.list_constraints.timeout = 60.0
                  default_config.rpcs.list_constraints.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_policies.timeout = 60.0
                  default_config.rpcs.list_policies.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_policy.timeout = 60.0
                  default_config.rpcs.get_policy.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_effective_policy.timeout = 60.0
                  default_config.rpcs.get_effective_policy.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.create_policy.timeout = 60.0
                  default_config.rpcs.create_policy.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.update_policy.timeout = 60.0
                  default_config.rpcs.update_policy.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_policy.timeout = 60.0
                  default_config.rpcs.delete_policy.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.create_custom_constraint.timeout = 60.0
                  default_config.rpcs.create_custom_constraint.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.update_custom_constraint.timeout = 60.0
                  default_config.rpcs.update_custom_constraint.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_custom_constraint.timeout = 60.0
                  default_config.rpcs.get_custom_constraint.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_custom_constraints.timeout = 60.0
                  default_config.rpcs.list_custom_constraints.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_custom_constraint.timeout = 60.0
                  default_config.rpcs.delete_custom_constraint.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the OrgPolicy Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @org_policy_stub.universe_domain
              end

              ##
              # Create a new OrgPolicy REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the OrgPolicy client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @org_policy_stub = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @org_policy_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @org_policy_stub.logger
              end

              # Service calls

              ##
              # Lists constraints that could be applied on the specified resource.
              #
              # @overload list_constraints(request, options = nil)
              #   Pass arguments to `list_constraints` via a request object, either of type
              #   {::Google::Cloud::OrgPolicy::V2::ListConstraintsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OrgPolicy::V2::ListConstraintsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_constraints(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_constraints` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The Google Cloud resource that parents the constraint. Must be in
              #     one of the following forms:
              #
              #     * `projects/{project_number}`
              #     * `projects/{project_id}`
              #     * `folders/{folder_id}`
              #     * `organizations/{organization_id}`
              #   @param page_size [::Integer]
              #     Size of the pages to be returned. This is currently unsupported and will
              #     be ignored. The server may at any point start using this field to limit
              #     page size.
              #   @param page_token [::String]
              #     Page token used to retrieve the next page. This is currently unsupported
              #     and will be ignored. The server may at any point start using this field.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OrgPolicy::V2::Constraint>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OrgPolicy::V2::Constraint>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/org_policy/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OrgPolicy::V2::ListConstraintsRequest.new
              #
              #   # Call the list_constraints method.
              #   result = client.list_constraints request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OrgPolicy::V2::Constraint.
              #     p item
              #   end
              #
              def list_constraints request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OrgPolicy::V2::ListConstraintsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_constraints.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OrgPolicy::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_constraints.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_constraints.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @org_policy_stub.list_constraints request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @org_policy_stub, :list_constraints, "constraints", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves all of the policies that exist on a particular resource.
              #
              # @overload list_policies(request, options = nil)
              #   Pass arguments to `list_policies` via a request object, either of type
              #   {::Google::Cloud::OrgPolicy::V2::ListPoliciesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OrgPolicy::V2::ListPoliciesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_policies(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_policies` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The target Google Cloud resource that parents the set of
              #     constraints and policies that will be returned from this call. Must be in
              #     one of the following forms:
              #
              #     * `projects/{project_number}`
              #     * `projects/{project_id}`
              #     * `folders/{folder_id}`
              #     * `organizations/{organization_id}`
              #   @param page_size [::Integer]
              #     Size of the pages to be returned. This is currently unsupported and will
              #     be ignored. The server may at any point start using this field to limit
              #     page size.
              #   @param page_token [::String]
              #     Page token used to retrieve the next page. This is currently unsupported
              #     and will be ignored. The server may at any point start using this field.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OrgPolicy::V2::Policy>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OrgPolicy::V2::Policy>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/org_policy/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OrgPolicy::V2::ListPoliciesRequest.new
              #
              #   # Call the list_policies method.
              #   result = client.list_policies request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OrgPolicy::V2::Policy.
              #     p item
              #   end
              #
              def list_policies request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OrgPolicy::V2::ListPoliciesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_policies.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OrgPolicy::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_policies.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_policies.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @org_policy_stub.list_policies request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @org_policy_stub, :list_policies, "policies", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a policy on a resource.
              #
              # If no policy is set on the resource, `NOT_FOUND` is returned. The
              # `etag` value can be used with `UpdatePolicy()` to update a
              # policy during read-modify-write.
              #
              # @overload get_policy(request, options = nil)
              #   Pass arguments to `get_policy` via a request object, either of type
              #   {::Google::Cloud::OrgPolicy::V2::GetPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OrgPolicy::V2::GetPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_policy(name: nil)
              #   Pass arguments to `get_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the policy. See
              #     {::Google::Cloud::OrgPolicy::V2::Policy Policy} for naming requirements.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OrgPolicy::V2::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OrgPolicy::V2::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/org_policy/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OrgPolicy::V2::GetPolicyRequest.new
              #
              #   # Call the get_policy method.
              #   result = client.get_policy request
              #
              #   # The returned object is of type Google::Cloud::OrgPolicy::V2::Policy.
              #   p result
              #
              def get_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OrgPolicy::V2::GetPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OrgPolicy::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @org_policy_stub.get_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the effective policy on a resource. This is the result of merging
              # policies in the resource hierarchy and evaluating conditions. The
              # returned policy will not have an `etag` or `condition` set because it is
              # an evaluated policy across multiple resources.
              # Subtrees of Resource Manager resource hierarchy with 'under:' prefix will
              # not be expanded.
              #
              # @overload get_effective_policy(request, options = nil)
              #   Pass arguments to `get_effective_policy` via a request object, either of type
              #   {::Google::Cloud::OrgPolicy::V2::GetEffectivePolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OrgPolicy::V2::GetEffectivePolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_effective_policy(name: nil)
              #   Pass arguments to `get_effective_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The effective policy to compute. See
              #     {::Google::Cloud::OrgPolicy::V2::Policy Policy} for naming requirements.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OrgPolicy::V2::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OrgPolicy::V2::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/org_policy/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OrgPolicy::V2::GetEffectivePolicyRequest.new
              #
              #   # Call the get_effective_policy method.
              #   result = client.get_effective_policy request
              #
              #   # The returned object is of type Google::Cloud::OrgPolicy::V2::Policy.
              #   p result
              #
              def get_effective_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OrgPolicy::V2::GetEffectivePolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_effective_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OrgPolicy::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_effective_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_effective_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @org_policy_stub.get_effective_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a policy.
              #
              # Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
              # constraint does not exist.
              # Returns a `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the
              # policy already exists on the given Google Cloud resource.
              #
              # @overload create_policy(request, options = nil)
              #   Pass arguments to `create_policy` via a request object, either of type
              #   {::Google::Cloud::OrgPolicy::V2::CreatePolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OrgPolicy::V2::CreatePolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_policy(parent: nil, policy: nil)
              #   Pass arguments to `create_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The Google Cloud resource that will parent the new policy. Must
              #     be in one of the following forms:
              #
              #     * `projects/{project_number}`
              #     * `projects/{project_id}`
              #     * `folders/{folder_id}`
              #     * `organizations/{organization_id}`
              #   @param policy [::Google::Cloud::OrgPolicy::V2::Policy, ::Hash]
              #     Required. Policy to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OrgPolicy::V2::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OrgPolicy::V2::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/org_policy/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OrgPolicy::V2::CreatePolicyRequest.new
              #
              #   # Call the create_policy method.
              #   result = client.create_policy request
              #
              #   # The returned object is of type Google::Cloud::OrgPolicy::V2::Policy.
              #   p result
              #
              def create_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OrgPolicy::V2::CreatePolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OrgPolicy::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @org_policy_stub.create_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a policy.
              #
              # Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
              # constraint or the policy do not exist.
              # Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag
              # supplied in the request does not match the persisted etag of the policy
              #
              # Note: the supplied policy will perform a full overwrite of all
              # fields.
              #
              # @overload update_policy(request, options = nil)
              #   Pass arguments to `update_policy` via a request object, either of type
              #   {::Google::Cloud::OrgPolicy::V2::UpdatePolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OrgPolicy::V2::UpdatePolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_policy(policy: nil, update_mask: nil)
              #   Pass arguments to `update_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param policy [::Google::Cloud::OrgPolicy::V2::Policy, ::Hash]
              #     Required. Policy to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Field mask used to specify the fields to be overwritten in the policy
              #     by the set. The fields specified in the update_mask are relative to the
              #     policy, not the full request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OrgPolicy::V2::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OrgPolicy::V2::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/org_policy/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OrgPolicy::V2::UpdatePolicyRequest.new
              #
              #   # Call the update_policy method.
              #   result = client.update_policy request
              #
              #   # The returned object is of type Google::Cloud::OrgPolicy::V2::Policy.
              #   p result
              #
              def update_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OrgPolicy::V2::UpdatePolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OrgPolicy::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @org_policy_stub.update_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a policy.
              #
              # Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
              # constraint or organization policy does not exist.
              #
              # @overload delete_policy(request, options = nil)
              #   Pass arguments to `delete_policy` via a request object, either of type
              #   {::Google::Cloud::OrgPolicy::V2::DeletePolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OrgPolicy::V2::DeletePolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_policy(name: nil, etag: nil)
              #   Pass arguments to `delete_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the policy to delete.
              #     See the policy entry for naming rules.
              #   @param etag [::String]
              #     Optional. The current etag of policy. If an etag is provided and does not
              #     match the current etag of the policy, deletion will be blocked and an
              #     ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/org_policy/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OrgPolicy::V2::DeletePolicyRequest.new
              #
              #   # Call the delete_policy method.
              #   result = client.delete_policy request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OrgPolicy::V2::DeletePolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OrgPolicy::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @org_policy_stub.delete_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a custom constraint.
              #
              # Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
              # organization does not exist.
              # Returns a `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the
              # constraint already exists on the given organization.
              #
              # @overload create_custom_constraint(request, options = nil)
              #   Pass arguments to `create_custom_constraint` via a request object, either of type
              #   {::Google::Cloud::OrgPolicy::V2::CreateCustomConstraintRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OrgPolicy::V2::CreateCustomConstraintRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_custom_constraint(parent: nil, custom_constraint: nil)
              #   Pass arguments to `create_custom_constraint` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Must be in the following form:
              #
              #     * `organizations/{organization_id}`
              #   @param custom_constraint [::Google::Cloud::OrgPolicy::V2::CustomConstraint, ::Hash]
              #     Required. Custom constraint to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OrgPolicy::V2::CustomConstraint]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OrgPolicy::V2::CustomConstraint]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/org_policy/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OrgPolicy::V2::CreateCustomConstraintRequest.new
              #
              #   # Call the create_custom_constraint method.
              #   result = client.create_custom_constraint request
              #
              #   # The returned object is of type Google::Cloud::OrgPolicy::V2::CustomConstraint.
              #   p result
              #
              def create_custom_constraint request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OrgPolicy::V2::CreateCustomConstraintRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_custom_constraint.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OrgPolicy::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_custom_constraint.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_custom_constraint.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @org_policy_stub.create_custom_constraint request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a custom constraint.
              #
              # Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
              # constraint does not exist.
              #
              # Note: the supplied policy will perform a full overwrite of all
              # fields.
              #
              # @overload update_custom_constraint(request, options = nil)
              #   Pass arguments to `update_custom_constraint` via a request object, either of type
              #   {::Google::Cloud::OrgPolicy::V2::UpdateCustomConstraintRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OrgPolicy::V2::UpdateCustomConstraintRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_custom_constraint(custom_constraint: nil)
              #   Pass arguments to `update_custom_constraint` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param custom_constraint [::Google::Cloud::OrgPolicy::V2::CustomConstraint, ::Hash]
              #     Required. `CustomConstraint` to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OrgPolicy::V2::CustomConstraint]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OrgPolicy::V2::CustomConstraint]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/org_policy/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OrgPolicy::V2::UpdateCustomConstraintRequest.new
              #
              #   # Call the update_custom_constraint method.
              #   result = client.update_custom_constraint request
              #
              #   # The returned object is of type Google::Cloud::OrgPolicy::V2::CustomConstraint.
              #   p result
              #
              def update_custom_constraint request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OrgPolicy::V2::UpdateCustomConstraintRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_custom_constraint.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OrgPolicy::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_custom_constraint.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_custom_constraint.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @org_policy_stub.update_custom_constraint request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a custom or managed constraint.
              #
              # Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
              # custom or managed constraint does not exist.
              #
              # @overload get_custom_constraint(request, options = nil)
              #   Pass arguments to `get_custom_constraint` via a request object, either of type
              #   {::Google::Cloud::OrgPolicy::V2::GetCustomConstraintRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OrgPolicy::V2::GetCustomConstraintRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_custom_constraint(name: nil)
              #   Pass arguments to `get_custom_constraint` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the custom or managed constraint. See the custom
              #     constraint entry for naming requirements.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OrgPolicy::V2::CustomConstraint]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OrgPolicy::V2::CustomConstraint]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/org_policy/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OrgPolicy::V2::GetCustomConstraintRequest.new
              #
              #   # Call the get_custom_constraint method.
              #   result = client.get_custom_constraint request
              #
              #   # The returned object is of type Google::Cloud::OrgPolicy::V2::CustomConstraint.
              #   p result
              #
              def get_custom_constraint request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OrgPolicy::V2::GetCustomConstraintRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_custom_constraint.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OrgPolicy::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_custom_constraint.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_custom_constraint.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @org_policy_stub.get_custom_constraint request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves all of the custom constraints that exist on a particular
              # organization resource.
              #
              # @overload list_custom_constraints(request, options = nil)
              #   Pass arguments to `list_custom_constraints` via a request object, either of type
              #   {::Google::Cloud::OrgPolicy::V2::ListCustomConstraintsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OrgPolicy::V2::ListCustomConstraintsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_custom_constraints(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_custom_constraints` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The target Google Cloud resource that parents the set of custom
              #     constraints that will be returned from this call. Must be in one of the
              #     following forms:
              #
              #     * `organizations/{organization_id}`
              #   @param page_size [::Integer]
              #     Size of the pages to be returned. This is currently unsupported and will
              #     be ignored. The server may at any point start using this field to limit
              #     page size.
              #   @param page_token [::String]
              #     Page token used to retrieve the next page. This is currently unsupported
              #     and will be ignored. The server may at any point start using this field.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OrgPolicy::V2::CustomConstraint>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OrgPolicy::V2::CustomConstraint>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/org_policy/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OrgPolicy::V2::ListCustomConstraintsRequest.new
              #
              #   # Call the list_custom_constraints method.
              #   result = client.list_custom_constraints request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OrgPolicy::V2::CustomConstraint.
              #     p item
              #   end
              #
              def list_custom_constraints request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OrgPolicy::V2::ListCustomConstraintsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_custom_constraints.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OrgPolicy::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_custom_constraints.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_custom_constraints.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @org_policy_stub.list_custom_constraints request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @org_policy_stub, :list_custom_constraints, "custom_constraints", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a custom constraint.
              #
              # Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
              # constraint does not exist.
              #
              # @overload delete_custom_constraint(request, options = nil)
              #   Pass arguments to `delete_custom_constraint` via a request object, either of type
              #   {::Google::Cloud::OrgPolicy::V2::DeleteCustomConstraintRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OrgPolicy::V2::DeleteCustomConstraintRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_custom_constraint(name: nil)
              #   Pass arguments to `delete_custom_constraint` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the custom constraint to delete.
              #     See the custom constraint entry for naming rules.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/org_policy/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OrgPolicy::V2::DeleteCustomConstraintRequest.new
              #
              #   # Call the delete_custom_constraint method.
              #   result = client.delete_custom_constraint request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_custom_constraint request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OrgPolicy::V2::DeleteCustomConstraintRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_custom_constraint.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OrgPolicy::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_custom_constraint.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_custom_constraint.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @org_policy_stub.delete_custom_constraint request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the OrgPolicy REST API.
              #
              # This class represents the configuration for OrgPolicy REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_constraints to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_constraints.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::OrgPolicy::V2::OrgPolicy::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_constraints.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "orgpolicy.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the OrgPolicy API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_constraints`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_constraints
                  ##
                  # RPC-specific configuration for `list_policies`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_policies
                  ##
                  # RPC-specific configuration for `get_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_policy
                  ##
                  # RPC-specific configuration for `get_effective_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_effective_policy
                  ##
                  # RPC-specific configuration for `create_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_policy
                  ##
                  # RPC-specific configuration for `update_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_policy
                  ##
                  # RPC-specific configuration for `delete_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_policy
                  ##
                  # RPC-specific configuration for `create_custom_constraint`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_custom_constraint
                  ##
                  # RPC-specific configuration for `update_custom_constraint`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_custom_constraint
                  ##
                  # RPC-specific configuration for `get_custom_constraint`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_custom_constraint
                  ##
                  # RPC-specific configuration for `list_custom_constraints`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_custom_constraints
                  ##
                  # RPC-specific configuration for `delete_custom_constraint`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_custom_constraint

                  # @private
                  def initialize parent_rpcs = nil
                    list_constraints_config = parent_rpcs.list_constraints if parent_rpcs.respond_to? :list_constraints
                    @list_constraints = ::Gapic::Config::Method.new list_constraints_config
                    list_policies_config = parent_rpcs.list_policies if parent_rpcs.respond_to? :list_policies
                    @list_policies = ::Gapic::Config::Method.new list_policies_config
                    get_policy_config = parent_rpcs.get_policy if parent_rpcs.respond_to? :get_policy
                    @get_policy = ::Gapic::Config::Method.new get_policy_config
                    get_effective_policy_config = parent_rpcs.get_effective_policy if parent_rpcs.respond_to? :get_effective_policy
                    @get_effective_policy = ::Gapic::Config::Method.new get_effective_policy_config
                    create_policy_config = parent_rpcs.create_policy if parent_rpcs.respond_to? :create_policy
                    @create_policy = ::Gapic::Config::Method.new create_policy_config
                    update_policy_config = parent_rpcs.update_policy if parent_rpcs.respond_to? :update_policy
                    @update_policy = ::Gapic::Config::Method.new update_policy_config
                    delete_policy_config = parent_rpcs.delete_policy if parent_rpcs.respond_to? :delete_policy
                    @delete_policy = ::Gapic::Config::Method.new delete_policy_config
                    create_custom_constraint_config = parent_rpcs.create_custom_constraint if parent_rpcs.respond_to? :create_custom_constraint
                    @create_custom_constraint = ::Gapic::Config::Method.new create_custom_constraint_config
                    update_custom_constraint_config = parent_rpcs.update_custom_constraint if parent_rpcs.respond_to? :update_custom_constraint
                    @update_custom_constraint = ::Gapic::Config::Method.new update_custom_constraint_config
                    get_custom_constraint_config = parent_rpcs.get_custom_constraint if parent_rpcs.respond_to? :get_custom_constraint
                    @get_custom_constraint = ::Gapic::Config::Method.new get_custom_constraint_config
                    list_custom_constraints_config = parent_rpcs.list_custom_constraints if parent_rpcs.respond_to? :list_custom_constraints
                    @list_custom_constraints = ::Gapic::Config::Method.new list_custom_constraints_config
                    delete_custom_constraint_config = parent_rpcs.delete_custom_constraint if parent_rpcs.respond_to? :delete_custom_constraint
                    @delete_custom_constraint = ::Gapic::Config::Method.new delete_custom_constraint_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
