# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/orchestration/airflow/service/v1/environments_pb"
require "google/cloud/orchestration/airflow/service/v1/environments/rest"


class ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_environment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    environment = {}

    create_environment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_create_environment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_environment_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_environment({ parent: parent, environment: environment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_environment parent: parent, environment: environment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_environment ::Google::Cloud::Orchestration::Airflow::Service::V1::CreateEnvironmentRequest.new(parent: parent, environment: environment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_environment({ parent: parent, environment: environment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_environment(::Google::Cloud::Orchestration::Airflow::Service::V1::CreateEnvironmentRequest.new(parent: parent, environment: environment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_environment_client_stub.call_count
      end
    end
  end

  def test_get_environment
    # Create test objects.
    client_result = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_environment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_get_environment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_environment_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_environment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_environment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_environment ::Google::Cloud::Orchestration::Airflow::Service::V1::GetEnvironmentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_environment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_environment(::Google::Cloud::Orchestration::Airflow::Service::V1::GetEnvironmentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_environment_client_stub.call_count
      end
    end
  end

  def test_list_environments
    # Create test objects.
    client_result = ::Google::Cloud::Orchestration::Airflow::Service::V1::ListEnvironmentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_environments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_list_environments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_environments_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_environments({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_environments parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_environments ::Google::Cloud::Orchestration::Airflow::Service::V1::ListEnvironmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_environments({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_environments(::Google::Cloud::Orchestration::Airflow::Service::V1::ListEnvironmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_environments_client_stub.call_count
      end
    end
  end

  def test_update_environment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    environment = {}
    update_mask = {}

    update_environment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_update_environment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_environment_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_environment({ name: name, environment: environment, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_environment name: name, environment: environment, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_environment ::Google::Cloud::Orchestration::Airflow::Service::V1::UpdateEnvironmentRequest.new(name: name, environment: environment, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_environment({ name: name, environment: environment, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_environment(::Google::Cloud::Orchestration::Airflow::Service::V1::UpdateEnvironmentRequest.new(name: name, environment: environment, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_environment_client_stub.call_count
      end
    end
  end

  def test_delete_environment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_environment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_delete_environment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_environment_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_environment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_environment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_environment ::Google::Cloud::Orchestration::Airflow::Service::V1::DeleteEnvironmentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_environment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_environment(::Google::Cloud::Orchestration::Airflow::Service::V1::DeleteEnvironmentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_environment_client_stub.call_count
      end
    end
  end

  def test_execute_airflow_command
    # Create test objects.
    client_result = ::Google::Cloud::Orchestration::Airflow::Service::V1::ExecuteAirflowCommandResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    environment = "hello world"
    command = "hello world"
    subcommand = "hello world"
    parameters = ["hello world"]

    execute_airflow_command_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_execute_airflow_command_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, execute_airflow_command_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.execute_airflow_command({ environment: environment, command: command, subcommand: subcommand, parameters: parameters }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.execute_airflow_command environment: environment, command: command, subcommand: subcommand, parameters: parameters do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.execute_airflow_command ::Google::Cloud::Orchestration::Airflow::Service::V1::ExecuteAirflowCommandRequest.new(environment: environment, command: command, subcommand: subcommand, parameters: parameters) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.execute_airflow_command({ environment: environment, command: command, subcommand: subcommand, parameters: parameters }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.execute_airflow_command(::Google::Cloud::Orchestration::Airflow::Service::V1::ExecuteAirflowCommandRequest.new(environment: environment, command: command, subcommand: subcommand, parameters: parameters), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, execute_airflow_command_client_stub.call_count
      end
    end
  end

  def test_stop_airflow_command
    # Create test objects.
    client_result = ::Google::Cloud::Orchestration::Airflow::Service::V1::StopAirflowCommandResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    environment = "hello world"
    execution_id = "hello world"
    pod = "hello world"
    pod_namespace = "hello world"
    force = true

    stop_airflow_command_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_stop_airflow_command_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, stop_airflow_command_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.stop_airflow_command({ environment: environment, execution_id: execution_id, pod: pod, pod_namespace: pod_namespace, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.stop_airflow_command environment: environment, execution_id: execution_id, pod: pod, pod_namespace: pod_namespace, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.stop_airflow_command ::Google::Cloud::Orchestration::Airflow::Service::V1::StopAirflowCommandRequest.new(environment: environment, execution_id: execution_id, pod: pod, pod_namespace: pod_namespace, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.stop_airflow_command({ environment: environment, execution_id: execution_id, pod: pod, pod_namespace: pod_namespace, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.stop_airflow_command(::Google::Cloud::Orchestration::Airflow::Service::V1::StopAirflowCommandRequest.new(environment: environment, execution_id: execution_id, pod: pod, pod_namespace: pod_namespace, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, stop_airflow_command_client_stub.call_count
      end
    end
  end

  def test_poll_airflow_command
    # Create test objects.
    client_result = ::Google::Cloud::Orchestration::Airflow::Service::V1::PollAirflowCommandResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    environment = "hello world"
    execution_id = "hello world"
    pod = "hello world"
    pod_namespace = "hello world"
    next_line_number = 42

    poll_airflow_command_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_poll_airflow_command_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, poll_airflow_command_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.poll_airflow_command({ environment: environment, execution_id: execution_id, pod: pod, pod_namespace: pod_namespace, next_line_number: next_line_number }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.poll_airflow_command environment: environment, execution_id: execution_id, pod: pod, pod_namespace: pod_namespace, next_line_number: next_line_number do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.poll_airflow_command ::Google::Cloud::Orchestration::Airflow::Service::V1::PollAirflowCommandRequest.new(environment: environment, execution_id: execution_id, pod: pod, pod_namespace: pod_namespace, next_line_number: next_line_number) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.poll_airflow_command({ environment: environment, execution_id: execution_id, pod: pod, pod_namespace: pod_namespace, next_line_number: next_line_number }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.poll_airflow_command(::Google::Cloud::Orchestration::Airflow::Service::V1::PollAirflowCommandRequest.new(environment: environment, execution_id: execution_id, pod: pod, pod_namespace: pod_namespace, next_line_number: next_line_number), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, poll_airflow_command_client_stub.call_count
      end
    end
  end

  def test_list_workloads
    # Create test objects.
    client_result = ::Google::Cloud::Orchestration::Airflow::Service::V1::ListWorkloadsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_workloads_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_list_workloads_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_workloads_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_workloads({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_workloads parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_workloads ::Google::Cloud::Orchestration::Airflow::Service::V1::ListWorkloadsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_workloads({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_workloads(::Google::Cloud::Orchestration::Airflow::Service::V1::ListWorkloadsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_workloads_client_stub.call_count
      end
    end
  end

  def test_check_upgrade
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    environment = "hello world"
    image_version = "hello world"

    check_upgrade_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_check_upgrade_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, check_upgrade_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.check_upgrade({ environment: environment, image_version: image_version }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.check_upgrade environment: environment, image_version: image_version do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.check_upgrade ::Google::Cloud::Orchestration::Airflow::Service::V1::CheckUpgradeRequest.new(environment: environment, image_version: image_version) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.check_upgrade({ environment: environment, image_version: image_version }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.check_upgrade(::Google::Cloud::Orchestration::Airflow::Service::V1::CheckUpgradeRequest.new(environment: environment, image_version: image_version), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, check_upgrade_client_stub.call_count
      end
    end
  end

  def test_create_user_workloads_secret
    # Create test objects.
    client_result = ::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsSecret.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    user_workloads_secret = {}

    create_user_workloads_secret_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_create_user_workloads_secret_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_user_workloads_secret_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_user_workloads_secret({ parent: parent, user_workloads_secret: user_workloads_secret }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_user_workloads_secret parent: parent, user_workloads_secret: user_workloads_secret do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_user_workloads_secret ::Google::Cloud::Orchestration::Airflow::Service::V1::CreateUserWorkloadsSecretRequest.new(parent: parent, user_workloads_secret: user_workloads_secret) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_user_workloads_secret({ parent: parent, user_workloads_secret: user_workloads_secret }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_user_workloads_secret(::Google::Cloud::Orchestration::Airflow::Service::V1::CreateUserWorkloadsSecretRequest.new(parent: parent, user_workloads_secret: user_workloads_secret), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_user_workloads_secret_client_stub.call_count
      end
    end
  end

  def test_get_user_workloads_secret
    # Create test objects.
    client_result = ::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsSecret.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_user_workloads_secret_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_get_user_workloads_secret_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_user_workloads_secret_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_user_workloads_secret({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_user_workloads_secret name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_user_workloads_secret ::Google::Cloud::Orchestration::Airflow::Service::V1::GetUserWorkloadsSecretRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_user_workloads_secret({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_user_workloads_secret(::Google::Cloud::Orchestration::Airflow::Service::V1::GetUserWorkloadsSecretRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_user_workloads_secret_client_stub.call_count
      end
    end
  end

  def test_list_user_workloads_secrets
    # Create test objects.
    client_result = ::Google::Cloud::Orchestration::Airflow::Service::V1::ListUserWorkloadsSecretsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_user_workloads_secrets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_list_user_workloads_secrets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_user_workloads_secrets_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_user_workloads_secrets({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_user_workloads_secrets parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_user_workloads_secrets ::Google::Cloud::Orchestration::Airflow::Service::V1::ListUserWorkloadsSecretsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_user_workloads_secrets({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_user_workloads_secrets(::Google::Cloud::Orchestration::Airflow::Service::V1::ListUserWorkloadsSecretsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_user_workloads_secrets_client_stub.call_count
      end
    end
  end

  def test_update_user_workloads_secret
    # Create test objects.
    client_result = ::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsSecret.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    user_workloads_secret = {}

    update_user_workloads_secret_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_update_user_workloads_secret_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_user_workloads_secret_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_user_workloads_secret({ user_workloads_secret: user_workloads_secret }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_user_workloads_secret user_workloads_secret: user_workloads_secret do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_user_workloads_secret ::Google::Cloud::Orchestration::Airflow::Service::V1::UpdateUserWorkloadsSecretRequest.new(user_workloads_secret: user_workloads_secret) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_user_workloads_secret({ user_workloads_secret: user_workloads_secret }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_user_workloads_secret(::Google::Cloud::Orchestration::Airflow::Service::V1::UpdateUserWorkloadsSecretRequest.new(user_workloads_secret: user_workloads_secret), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_user_workloads_secret_client_stub.call_count
      end
    end
  end

  def test_delete_user_workloads_secret
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_user_workloads_secret_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_delete_user_workloads_secret_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_user_workloads_secret_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_user_workloads_secret({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_user_workloads_secret name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_user_workloads_secret ::Google::Cloud::Orchestration::Airflow::Service::V1::DeleteUserWorkloadsSecretRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_user_workloads_secret({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_user_workloads_secret(::Google::Cloud::Orchestration::Airflow::Service::V1::DeleteUserWorkloadsSecretRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_user_workloads_secret_client_stub.call_count
      end
    end
  end

  def test_create_user_workloads_config_map
    # Create test objects.
    client_result = ::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsConfigMap.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    user_workloads_config_map = {}

    create_user_workloads_config_map_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_create_user_workloads_config_map_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_user_workloads_config_map_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_user_workloads_config_map({ parent: parent, user_workloads_config_map: user_workloads_config_map }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_user_workloads_config_map parent: parent, user_workloads_config_map: user_workloads_config_map do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_user_workloads_config_map ::Google::Cloud::Orchestration::Airflow::Service::V1::CreateUserWorkloadsConfigMapRequest.new(parent: parent, user_workloads_config_map: user_workloads_config_map) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_user_workloads_config_map({ parent: parent, user_workloads_config_map: user_workloads_config_map }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_user_workloads_config_map(::Google::Cloud::Orchestration::Airflow::Service::V1::CreateUserWorkloadsConfigMapRequest.new(parent: parent, user_workloads_config_map: user_workloads_config_map), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_user_workloads_config_map_client_stub.call_count
      end
    end
  end

  def test_get_user_workloads_config_map
    # Create test objects.
    client_result = ::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsConfigMap.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_user_workloads_config_map_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_get_user_workloads_config_map_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_user_workloads_config_map_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_user_workloads_config_map({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_user_workloads_config_map name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_user_workloads_config_map ::Google::Cloud::Orchestration::Airflow::Service::V1::GetUserWorkloadsConfigMapRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_user_workloads_config_map({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_user_workloads_config_map(::Google::Cloud::Orchestration::Airflow::Service::V1::GetUserWorkloadsConfigMapRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_user_workloads_config_map_client_stub.call_count
      end
    end
  end

  def test_list_user_workloads_config_maps
    # Create test objects.
    client_result = ::Google::Cloud::Orchestration::Airflow::Service::V1::ListUserWorkloadsConfigMapsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_user_workloads_config_maps_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_list_user_workloads_config_maps_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_user_workloads_config_maps_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_user_workloads_config_maps({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_user_workloads_config_maps parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_user_workloads_config_maps ::Google::Cloud::Orchestration::Airflow::Service::V1::ListUserWorkloadsConfigMapsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_user_workloads_config_maps({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_user_workloads_config_maps(::Google::Cloud::Orchestration::Airflow::Service::V1::ListUserWorkloadsConfigMapsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_user_workloads_config_maps_client_stub.call_count
      end
    end
  end

  def test_update_user_workloads_config_map
    # Create test objects.
    client_result = ::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsConfigMap.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    user_workloads_config_map = {}

    update_user_workloads_config_map_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_update_user_workloads_config_map_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_user_workloads_config_map_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_user_workloads_config_map({ user_workloads_config_map: user_workloads_config_map }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_user_workloads_config_map user_workloads_config_map: user_workloads_config_map do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_user_workloads_config_map ::Google::Cloud::Orchestration::Airflow::Service::V1::UpdateUserWorkloadsConfigMapRequest.new(user_workloads_config_map: user_workloads_config_map) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_user_workloads_config_map({ user_workloads_config_map: user_workloads_config_map }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_user_workloads_config_map(::Google::Cloud::Orchestration::Airflow::Service::V1::UpdateUserWorkloadsConfigMapRequest.new(user_workloads_config_map: user_workloads_config_map), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_user_workloads_config_map_client_stub.call_count
      end
    end
  end

  def test_delete_user_workloads_config_map
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_user_workloads_config_map_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_delete_user_workloads_config_map_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_user_workloads_config_map_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_user_workloads_config_map({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_user_workloads_config_map name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_user_workloads_config_map ::Google::Cloud::Orchestration::Airflow::Service::V1::DeleteUserWorkloadsConfigMapRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_user_workloads_config_map({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_user_workloads_config_map(::Google::Cloud::Orchestration::Airflow::Service::V1::DeleteUserWorkloadsConfigMapRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_user_workloads_config_map_client_stub.call_count
      end
    end
  end

  def test_save_snapshot
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    environment = "hello world"
    snapshot_location = "hello world"

    save_snapshot_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_save_snapshot_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, save_snapshot_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.save_snapshot({ environment: environment, snapshot_location: snapshot_location }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.save_snapshot environment: environment, snapshot_location: snapshot_location do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.save_snapshot ::Google::Cloud::Orchestration::Airflow::Service::V1::SaveSnapshotRequest.new(environment: environment, snapshot_location: snapshot_location) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.save_snapshot({ environment: environment, snapshot_location: snapshot_location }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.save_snapshot(::Google::Cloud::Orchestration::Airflow::Service::V1::SaveSnapshotRequest.new(environment: environment, snapshot_location: snapshot_location), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, save_snapshot_client_stub.call_count
      end
    end
  end

  def test_load_snapshot
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    environment = "hello world"
    snapshot_path = "hello world"
    skip_pypi_packages_installation = true
    skip_environment_variables_setting = true
    skip_airflow_overrides_setting = true
    skip_gcs_data_copying = true

    load_snapshot_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_load_snapshot_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, load_snapshot_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.load_snapshot({ environment: environment, snapshot_path: snapshot_path, skip_pypi_packages_installation: skip_pypi_packages_installation, skip_environment_variables_setting: skip_environment_variables_setting, skip_airflow_overrides_setting: skip_airflow_overrides_setting, skip_gcs_data_copying: skip_gcs_data_copying }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.load_snapshot environment: environment, snapshot_path: snapshot_path, skip_pypi_packages_installation: skip_pypi_packages_installation, skip_environment_variables_setting: skip_environment_variables_setting, skip_airflow_overrides_setting: skip_airflow_overrides_setting, skip_gcs_data_copying: skip_gcs_data_copying do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.load_snapshot ::Google::Cloud::Orchestration::Airflow::Service::V1::LoadSnapshotRequest.new(environment: environment, snapshot_path: snapshot_path, skip_pypi_packages_installation: skip_pypi_packages_installation, skip_environment_variables_setting: skip_environment_variables_setting, skip_airflow_overrides_setting: skip_airflow_overrides_setting, skip_gcs_data_copying: skip_gcs_data_copying) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.load_snapshot({ environment: environment, snapshot_path: snapshot_path, skip_pypi_packages_installation: skip_pypi_packages_installation, skip_environment_variables_setting: skip_environment_variables_setting, skip_airflow_overrides_setting: skip_airflow_overrides_setting, skip_gcs_data_copying: skip_gcs_data_copying }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.load_snapshot(::Google::Cloud::Orchestration::Airflow::Service::V1::LoadSnapshotRequest.new(environment: environment, snapshot_path: snapshot_path, skip_pypi_packages_installation: skip_pypi_packages_installation, skip_environment_variables_setting: skip_environment_variables_setting, skip_airflow_overrides_setting: skip_airflow_overrides_setting, skip_gcs_data_copying: skip_gcs_data_copying), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, load_snapshot_client_stub.call_count
      end
    end
  end

  def test_database_failover
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    environment = "hello world"

    database_failover_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_database_failover_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, database_failover_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.database_failover({ environment: environment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.database_failover environment: environment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.database_failover ::Google::Cloud::Orchestration::Airflow::Service::V1::DatabaseFailoverRequest.new(environment: environment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.database_failover({ environment: environment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.database_failover(::Google::Cloud::Orchestration::Airflow::Service::V1::DatabaseFailoverRequest.new(environment: environment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, database_failover_client_stub.call_count
      end
    end
  end

  def test_fetch_database_properties
    # Create test objects.
    client_result = ::Google::Cloud::Orchestration::Airflow::Service::V1::FetchDatabasePropertiesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    environment = "hello world"

    fetch_database_properties_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::ServiceStub.stub :transcode_fetch_database_properties_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_database_properties_client_stub do
        # Create client
        client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_database_properties({ environment: environment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_database_properties environment: environment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_database_properties ::Google::Cloud::Orchestration::Airflow::Service::V1::FetchDatabasePropertiesRequest.new(environment: environment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_database_properties({ environment: environment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_database_properties(::Google::Cloud::Orchestration::Airflow::Service::V1::FetchDatabasePropertiesRequest.new(environment: environment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_database_properties_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Orchestration::Airflow::Service::V1::Environments::Rest::Client::Configuration, config
  end
end
