# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Orchestration
      module Airflow
        module Service
          module V1
            # List ImageVersions in a project and location.
            # @!attribute [rw] parent
            #   @return [::String]
            #     List ImageVersions in the given project and location, in the form:
            #     "projects/\\{projectId}/locations/\\{locationId}"
            # @!attribute [rw] page_size
            #   @return [::Integer]
            #     The maximum number of image_versions to return.
            # @!attribute [rw] page_token
            #   @return [::String]
            #     The next_page_token value returned from a previous List request, if any.
            # @!attribute [rw] include_past_releases
            #   @return [::Boolean]
            #     Whether or not image versions from old releases should be included.
            class ListImageVersionsRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The ImageVersions in a project and location.
            # @!attribute [rw] image_versions
            #   @return [::Array<::Google::Cloud::Orchestration::Airflow::Service::V1::ImageVersion>]
            #     The list of supported ImageVersions in a location.
            # @!attribute [rw] next_page_token
            #   @return [::String]
            #     The page token used to query for the next page if one exists.
            class ListImageVersionsResponse
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # ImageVersion information
            # @!attribute [rw] image_version_id
            #   @return [::String]
            #     The string identifier of the ImageVersion, in the form:
            #     "composer-x.y.z-airflow-a.b.c"
            # @!attribute [rw] is_default
            #   @return [::Boolean]
            #     Whether this is the default ImageVersion used by Composer during
            #     environment creation if no input ImageVersion is specified.
            # @!attribute [rw] supported_python_versions
            #   @return [::Array<::String>]
            #     supported python versions
            # @!attribute [rw] release_date
            #   @return [::Google::Type::Date]
            #     The date of the version release.
            # @!attribute [rw] creation_disabled
            #   @return [::Boolean]
            #     Whether it is impossible to create an environment with the image version.
            # @!attribute [rw] upgrade_disabled
            #   @return [::Boolean]
            #     Whether it is impossible to upgrade an environment running with the image
            #     version.
            class ImageVersion
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
