# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/orchestration/airflow/service/v1/environments_pb"

module Google
  module Cloud
    module Orchestration
      module Airflow
        module Service
          module V1
            module Environments
              module Rest
                ##
                # REST service stub for the Environments service.
                # Service stub contains baseline method implementations
                # including transcoding, making the REST call, and deserialing the response.
                #
                class ServiceStub
                  # @private
                  def initialize endpoint:, endpoint_template:, universe_domain:, credentials:, logger:
                    # These require statements are intentionally placed here to initialize
                    # the REST modules only when it's required.
                    require "gapic/rest"

                    @client_stub = ::Gapic::Rest::ClientStub.new endpoint: endpoint,
                                                                 endpoint_template: endpoint_template,
                                                                 universe_domain: universe_domain,
                                                                 credentials: credentials,
                                                                 numeric_enums: true,
                                                                 service_name: self.class,
                                                                 raise_faraday_errors: false,
                                                                 logger: logger
                  end

                  ##
                  # The effective universe domain
                  #
                  # @return [String]
                  #
                  def universe_domain
                    @client_stub.universe_domain
                  end

                  ##
                  # The effective endpoint
                  #
                  # @return [String]
                  #
                  def endpoint
                    @client_stub.endpoint
                  end

                  ##
                  # The logger used for request/response debug logging.
                  #
                  # @return [Logger]
                  #
                  def logger stub: false
                    stub ? @client_stub.stub_logger : @client_stub.logger
                  end

                  ##
                  # Baseline implementation for the create_environment REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::CreateEnvironmentRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def create_environment request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_create_environment_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "create_environment",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the get_environment REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::GetEnvironmentRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Orchestration::Airflow::Service::V1::Environment]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Orchestration::Airflow::Service::V1::Environment]
                  #   A result object deserialized from the server's reply
                  def get_environment request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_get_environment_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "get_environment",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Orchestration::Airflow::Service::V1::Environment.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the list_environments REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::ListEnvironmentsRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Orchestration::Airflow::Service::V1::ListEnvironmentsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Orchestration::Airflow::Service::V1::ListEnvironmentsResponse]
                  #   A result object deserialized from the server's reply
                  def list_environments request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_list_environments_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "list_environments",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Orchestration::Airflow::Service::V1::ListEnvironmentsResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the update_environment REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::UpdateEnvironmentRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def update_environment request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_update_environment_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "update_environment",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the delete_environment REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::DeleteEnvironmentRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def delete_environment request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_delete_environment_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "delete_environment",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the execute_airflow_command REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::ExecuteAirflowCommandRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Orchestration::Airflow::Service::V1::ExecuteAirflowCommandResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Orchestration::Airflow::Service::V1::ExecuteAirflowCommandResponse]
                  #   A result object deserialized from the server's reply
                  def execute_airflow_command request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_execute_airflow_command_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "execute_airflow_command",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Orchestration::Airflow::Service::V1::ExecuteAirflowCommandResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the stop_airflow_command REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::StopAirflowCommandRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Orchestration::Airflow::Service::V1::StopAirflowCommandResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Orchestration::Airflow::Service::V1::StopAirflowCommandResponse]
                  #   A result object deserialized from the server's reply
                  def stop_airflow_command request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_stop_airflow_command_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "stop_airflow_command",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Orchestration::Airflow::Service::V1::StopAirflowCommandResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the poll_airflow_command REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::PollAirflowCommandRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Orchestration::Airflow::Service::V1::PollAirflowCommandResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Orchestration::Airflow::Service::V1::PollAirflowCommandResponse]
                  #   A result object deserialized from the server's reply
                  def poll_airflow_command request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_poll_airflow_command_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "poll_airflow_command",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Orchestration::Airflow::Service::V1::PollAirflowCommandResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the list_workloads REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::ListWorkloadsRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Orchestration::Airflow::Service::V1::ListWorkloadsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Orchestration::Airflow::Service::V1::ListWorkloadsResponse]
                  #   A result object deserialized from the server's reply
                  def list_workloads request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_list_workloads_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "list_workloads",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Orchestration::Airflow::Service::V1::ListWorkloadsResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the check_upgrade REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::CheckUpgradeRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def check_upgrade request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_check_upgrade_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "check_upgrade",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the create_user_workloads_secret REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::CreateUserWorkloadsSecretRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsSecret]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsSecret]
                  #   A result object deserialized from the server's reply
                  def create_user_workloads_secret request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_create_user_workloads_secret_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "create_user_workloads_secret",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsSecret.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the get_user_workloads_secret REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::GetUserWorkloadsSecretRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsSecret]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsSecret]
                  #   A result object deserialized from the server's reply
                  def get_user_workloads_secret request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_get_user_workloads_secret_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "get_user_workloads_secret",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsSecret.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the list_user_workloads_secrets REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::ListUserWorkloadsSecretsRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Orchestration::Airflow::Service::V1::ListUserWorkloadsSecretsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Orchestration::Airflow::Service::V1::ListUserWorkloadsSecretsResponse]
                  #   A result object deserialized from the server's reply
                  def list_user_workloads_secrets request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_list_user_workloads_secrets_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "list_user_workloads_secrets",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Orchestration::Airflow::Service::V1::ListUserWorkloadsSecretsResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the update_user_workloads_secret REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::UpdateUserWorkloadsSecretRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsSecret]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsSecret]
                  #   A result object deserialized from the server's reply
                  def update_user_workloads_secret request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_update_user_workloads_secret_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "update_user_workloads_secret",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsSecret.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the delete_user_workloads_secret REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::DeleteUserWorkloadsSecretRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Protobuf::Empty]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Protobuf::Empty]
                  #   A result object deserialized from the server's reply
                  def delete_user_workloads_secret request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_delete_user_workloads_secret_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "delete_user_workloads_secret",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Protobuf::Empty.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the create_user_workloads_config_map REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::CreateUserWorkloadsConfigMapRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsConfigMap]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsConfigMap]
                  #   A result object deserialized from the server's reply
                  def create_user_workloads_config_map request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_create_user_workloads_config_map_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "create_user_workloads_config_map",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsConfigMap.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the get_user_workloads_config_map REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::GetUserWorkloadsConfigMapRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsConfigMap]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsConfigMap]
                  #   A result object deserialized from the server's reply
                  def get_user_workloads_config_map request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_get_user_workloads_config_map_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "get_user_workloads_config_map",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsConfigMap.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the list_user_workloads_config_maps REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::ListUserWorkloadsConfigMapsRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Orchestration::Airflow::Service::V1::ListUserWorkloadsConfigMapsResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Orchestration::Airflow::Service::V1::ListUserWorkloadsConfigMapsResponse]
                  #   A result object deserialized from the server's reply
                  def list_user_workloads_config_maps request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_list_user_workloads_config_maps_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "list_user_workloads_config_maps",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Orchestration::Airflow::Service::V1::ListUserWorkloadsConfigMapsResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the update_user_workloads_config_map REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::UpdateUserWorkloadsConfigMapRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsConfigMap]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsConfigMap]
                  #   A result object deserialized from the server's reply
                  def update_user_workloads_config_map request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_update_user_workloads_config_map_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "update_user_workloads_config_map",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Orchestration::Airflow::Service::V1::UserWorkloadsConfigMap.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the delete_user_workloads_config_map REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::DeleteUserWorkloadsConfigMapRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Protobuf::Empty]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Protobuf::Empty]
                  #   A result object deserialized from the server's reply
                  def delete_user_workloads_config_map request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_delete_user_workloads_config_map_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "delete_user_workloads_config_map",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Protobuf::Empty.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the save_snapshot REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::SaveSnapshotRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def save_snapshot request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_save_snapshot_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "save_snapshot",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the load_snapshot REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::LoadSnapshotRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def load_snapshot request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_load_snapshot_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "load_snapshot",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the database_failover REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::DatabaseFailoverRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def database_failover request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_database_failover_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "database_failover",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the fetch_database_properties REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::FetchDatabasePropertiesRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Orchestration::Airflow::Service::V1::FetchDatabasePropertiesResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Orchestration::Airflow::Service::V1::FetchDatabasePropertiesResponse]
                  #   A result object deserialized from the server's reply
                  def fetch_database_properties request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_fetch_database_properties_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "fetch_database_properties",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Orchestration::Airflow::Service::V1::FetchDatabasePropertiesResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the create_environment REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::CreateEnvironmentRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_create_environment_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{parent}/environments",
                                                              body: "environment",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/locations/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the get_environment REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::GetEnvironmentRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_get_environment_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the list_environments REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::ListEnvironmentsRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_list_environments_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}/environments",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/locations/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the update_environment REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::UpdateEnvironmentRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_update_environment_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :patch,
                                                              uri_template: "/v1/{name}",
                                                              body: "environment",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the delete_environment REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::DeleteEnvironmentRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_delete_environment_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :delete,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the execute_airflow_command REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::ExecuteAirflowCommandRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_execute_airflow_command_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{environment}:executeAirflowCommand",
                                                              body: "*",
                                                              matches: [
                                                                ["environment", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the stop_airflow_command REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::StopAirflowCommandRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_stop_airflow_command_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{environment}:stopAirflowCommand",
                                                              body: "*",
                                                              matches: [
                                                                ["environment", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the poll_airflow_command REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::PollAirflowCommandRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_poll_airflow_command_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{environment}:pollAirflowCommand",
                                                              body: "*",
                                                              matches: [
                                                                ["environment", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the list_workloads REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::ListWorkloadsRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_list_workloads_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}/workloads",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the check_upgrade REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::CheckUpgradeRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_check_upgrade_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{environment}:checkUpgrade",
                                                              body: "*",
                                                              matches: [
                                                                ["environment", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the create_user_workloads_secret REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::CreateUserWorkloadsSecretRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_create_user_workloads_secret_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{parent}/userWorkloadsSecrets",
                                                              body: "user_workloads_secret",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the get_user_workloads_secret REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::GetUserWorkloadsSecretRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_get_user_workloads_secret_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/userWorkloadsSecrets/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the list_user_workloads_secrets REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::ListUserWorkloadsSecretsRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_list_user_workloads_secrets_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}/userWorkloadsSecrets",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the update_user_workloads_secret REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::UpdateUserWorkloadsSecretRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_update_user_workloads_secret_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :put,
                                                              uri_template: "/v1/{user_workloads_secret.name}",
                                                              body: "user_workloads_secret",
                                                              matches: [
                                                                ["user_workloads_secret.name", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/userWorkloadsSecrets/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the delete_user_workloads_secret REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::DeleteUserWorkloadsSecretRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_delete_user_workloads_secret_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :delete,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/userWorkloadsSecrets/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the create_user_workloads_config_map REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::CreateUserWorkloadsConfigMapRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_create_user_workloads_config_map_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{parent}/userWorkloadsConfigMaps",
                                                              body: "user_workloads_config_map",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the get_user_workloads_config_map REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::GetUserWorkloadsConfigMapRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_get_user_workloads_config_map_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/userWorkloadsConfigMaps/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the list_user_workloads_config_maps REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::ListUserWorkloadsConfigMapsRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_list_user_workloads_config_maps_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}/userWorkloadsConfigMaps",
                                                              matches: [
                                                                ["parent", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the update_user_workloads_config_map REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::UpdateUserWorkloadsConfigMapRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_update_user_workloads_config_map_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :put,
                                                              uri_template: "/v1/{user_workloads_config_map.name}",
                                                              body: "user_workloads_config_map",
                                                              matches: [
                                                                ["user_workloads_config_map.name", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/userWorkloadsConfigMaps/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the delete_user_workloads_config_map REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::DeleteUserWorkloadsConfigMapRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_delete_user_workloads_config_map_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :delete,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/userWorkloadsConfigMaps/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the save_snapshot REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::SaveSnapshotRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_save_snapshot_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{environment}:saveSnapshot",
                                                              body: "*",
                                                              matches: [
                                                                ["environment", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the load_snapshot REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::LoadSnapshotRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_load_snapshot_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{environment}:loadSnapshot",
                                                              body: "*",
                                                              matches: [
                                                                ["environment", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the database_failover REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::DatabaseFailoverRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_database_failover_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{environment}:databaseFailover",
                                                              body: "*",
                                                              matches: [
                                                                ["environment", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the fetch_database_properties REST call
                  #
                  # @param request_pb [::Google::Cloud::Orchestration::Airflow::Service::V1::FetchDatabasePropertiesRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_fetch_database_properties_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{environment}:fetchDatabaseProperties",
                                                              matches: [
                                                                ["environment", %r{^projects/[^/]+/locations/[^/]+/environments/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
