# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Orchestration
      module Airflow
        module Service
          module V1
            module Environments
              # Path helper methods for the Environments API.
              module Paths
                ##
                # Create a fully-qualified Environment resource string.
                #
                # The resource will be in the following format:
                #
                # `projects/{project}/locations/{location}/environments/{environment}`
                #
                # @param project [String]
                # @param location [String]
                # @param environment [String]
                #
                # @return [::String]
                def environment_path project:, location:, environment:
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/environments/#{environment}"
                end

                ##
                # Create a fully-qualified UserWorkloadsConfigMap resource string.
                #
                # The resource will be in the following format:
                #
                # `projects/{project}/locations/{location}/environments/{environment}/userWorkloadsConfigMaps/{user_workloads_config_map}`
                #
                # @param project [String]
                # @param location [String]
                # @param environment [String]
                # @param user_workloads_config_map [String]
                #
                # @return [::String]
                def user_workloads_config_map_path project:, location:, environment:, user_workloads_config_map:
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "environment cannot contain /" if environment.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/environments/#{environment}/userWorkloadsConfigMaps/#{user_workloads_config_map}"
                end

                ##
                # Create a fully-qualified UserWorkloadsSecret resource string.
                #
                # The resource will be in the following format:
                #
                # `projects/{project}/locations/{location}/environments/{environment}/userWorkloadsSecrets/{user_workloads_secret}`
                #
                # @param project [String]
                # @param location [String]
                # @param environment [String]
                # @param user_workloads_secret [String]
                #
                # @return [::String]
                def user_workloads_secret_path project:, location:, environment:, user_workloads_secret:
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "environment cannot contain /" if environment.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/environments/#{environment}/userWorkloadsSecrets/#{user_workloads_secret}"
                end

                extend self
              end
            end
          end
        end
      end
    end
  end
end
