# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/oracledatabase/v1/oracledatabase_pb"
require "google/cloud/oracle_database/v1/oracle_database/rest"


class ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_cloud_exadata_infrastructures
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListCloudExadataInfrastructuresResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_cloud_exadata_infrastructures_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_cloud_exadata_infrastructures_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_cloud_exadata_infrastructures_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_cloud_exadata_infrastructures({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_cloud_exadata_infrastructures parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_cloud_exadata_infrastructures ::Google::Cloud::OracleDatabase::V1::ListCloudExadataInfrastructuresRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_cloud_exadata_infrastructures({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_cloud_exadata_infrastructures(::Google::Cloud::OracleDatabase::V1::ListCloudExadataInfrastructuresRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_cloud_exadata_infrastructures_client_stub.call_count
      end
    end
  end

  def test_get_cloud_exadata_infrastructure
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::CloudExadataInfrastructure.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_cloud_exadata_infrastructure_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_get_cloud_exadata_infrastructure_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_cloud_exadata_infrastructure_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_cloud_exadata_infrastructure({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_cloud_exadata_infrastructure name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_cloud_exadata_infrastructure ::Google::Cloud::OracleDatabase::V1::GetCloudExadataInfrastructureRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_cloud_exadata_infrastructure({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_cloud_exadata_infrastructure(::Google::Cloud::OracleDatabase::V1::GetCloudExadataInfrastructureRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_cloud_exadata_infrastructure_client_stub.call_count
      end
    end
  end

  def test_create_cloud_exadata_infrastructure
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    cloud_exadata_infrastructure_id = "hello world"
    cloud_exadata_infrastructure = {}
    request_id = "hello world"

    create_cloud_exadata_infrastructure_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_create_cloud_exadata_infrastructure_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_cloud_exadata_infrastructure_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_cloud_exadata_infrastructure({ parent: parent, cloud_exadata_infrastructure_id: cloud_exadata_infrastructure_id, cloud_exadata_infrastructure: cloud_exadata_infrastructure, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_cloud_exadata_infrastructure parent: parent, cloud_exadata_infrastructure_id: cloud_exadata_infrastructure_id, cloud_exadata_infrastructure: cloud_exadata_infrastructure, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_cloud_exadata_infrastructure ::Google::Cloud::OracleDatabase::V1::CreateCloudExadataInfrastructureRequest.new(parent: parent, cloud_exadata_infrastructure_id: cloud_exadata_infrastructure_id, cloud_exadata_infrastructure: cloud_exadata_infrastructure, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_cloud_exadata_infrastructure({ parent: parent, cloud_exadata_infrastructure_id: cloud_exadata_infrastructure_id, cloud_exadata_infrastructure: cloud_exadata_infrastructure, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_cloud_exadata_infrastructure(::Google::Cloud::OracleDatabase::V1::CreateCloudExadataInfrastructureRequest.new(parent: parent, cloud_exadata_infrastructure_id: cloud_exadata_infrastructure_id, cloud_exadata_infrastructure: cloud_exadata_infrastructure, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_cloud_exadata_infrastructure_client_stub.call_count
      end
    end
  end

  def test_delete_cloud_exadata_infrastructure
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_cloud_exadata_infrastructure_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_delete_cloud_exadata_infrastructure_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_cloud_exadata_infrastructure_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_cloud_exadata_infrastructure({ name: name, request_id: request_id, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_cloud_exadata_infrastructure name: name, request_id: request_id, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_cloud_exadata_infrastructure ::Google::Cloud::OracleDatabase::V1::DeleteCloudExadataInfrastructureRequest.new(name: name, request_id: request_id, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_cloud_exadata_infrastructure({ name: name, request_id: request_id, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_cloud_exadata_infrastructure(::Google::Cloud::OracleDatabase::V1::DeleteCloudExadataInfrastructureRequest.new(name: name, request_id: request_id, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_cloud_exadata_infrastructure_client_stub.call_count
      end
    end
  end

  def test_list_cloud_vm_clusters
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListCloudVmClustersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_cloud_vm_clusters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_cloud_vm_clusters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_cloud_vm_clusters_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_cloud_vm_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_cloud_vm_clusters parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_cloud_vm_clusters ::Google::Cloud::OracleDatabase::V1::ListCloudVmClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_cloud_vm_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_cloud_vm_clusters(::Google::Cloud::OracleDatabase::V1::ListCloudVmClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_cloud_vm_clusters_client_stub.call_count
      end
    end
  end

  def test_get_cloud_vm_cluster
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::CloudVmCluster.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_cloud_vm_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_get_cloud_vm_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_cloud_vm_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_cloud_vm_cluster({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_cloud_vm_cluster name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_cloud_vm_cluster ::Google::Cloud::OracleDatabase::V1::GetCloudVmClusterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_cloud_vm_cluster({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_cloud_vm_cluster(::Google::Cloud::OracleDatabase::V1::GetCloudVmClusterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_cloud_vm_cluster_client_stub.call_count
      end
    end
  end

  def test_create_cloud_vm_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    cloud_vm_cluster_id = "hello world"
    cloud_vm_cluster = {}
    request_id = "hello world"

    create_cloud_vm_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_create_cloud_vm_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_cloud_vm_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_cloud_vm_cluster({ parent: parent, cloud_vm_cluster_id: cloud_vm_cluster_id, cloud_vm_cluster: cloud_vm_cluster, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_cloud_vm_cluster parent: parent, cloud_vm_cluster_id: cloud_vm_cluster_id, cloud_vm_cluster: cloud_vm_cluster, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_cloud_vm_cluster ::Google::Cloud::OracleDatabase::V1::CreateCloudVmClusterRequest.new(parent: parent, cloud_vm_cluster_id: cloud_vm_cluster_id, cloud_vm_cluster: cloud_vm_cluster, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_cloud_vm_cluster({ parent: parent, cloud_vm_cluster_id: cloud_vm_cluster_id, cloud_vm_cluster: cloud_vm_cluster, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_cloud_vm_cluster(::Google::Cloud::OracleDatabase::V1::CreateCloudVmClusterRequest.new(parent: parent, cloud_vm_cluster_id: cloud_vm_cluster_id, cloud_vm_cluster: cloud_vm_cluster, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_cloud_vm_cluster_client_stub.call_count
      end
    end
  end

  def test_delete_cloud_vm_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_cloud_vm_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_delete_cloud_vm_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_cloud_vm_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_cloud_vm_cluster({ name: name, request_id: request_id, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_cloud_vm_cluster name: name, request_id: request_id, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_cloud_vm_cluster ::Google::Cloud::OracleDatabase::V1::DeleteCloudVmClusterRequest.new(name: name, request_id: request_id, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_cloud_vm_cluster({ name: name, request_id: request_id, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_cloud_vm_cluster(::Google::Cloud::OracleDatabase::V1::DeleteCloudVmClusterRequest.new(name: name, request_id: request_id, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_cloud_vm_cluster_client_stub.call_count
      end
    end
  end

  def test_list_entitlements
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListEntitlementsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_entitlements_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_entitlements_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_entitlements_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_entitlements({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_entitlements parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_entitlements ::Google::Cloud::OracleDatabase::V1::ListEntitlementsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_entitlements({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_entitlements(::Google::Cloud::OracleDatabase::V1::ListEntitlementsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_entitlements_client_stub.call_count
      end
    end
  end

  def test_list_db_servers
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListDbServersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_db_servers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_db_servers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_db_servers_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_db_servers({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_db_servers parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_db_servers ::Google::Cloud::OracleDatabase::V1::ListDbServersRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_db_servers({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_db_servers(::Google::Cloud::OracleDatabase::V1::ListDbServersRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_db_servers_client_stub.call_count
      end
    end
  end

  def test_list_db_nodes
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListDbNodesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_db_nodes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_db_nodes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_db_nodes_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_db_nodes({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_db_nodes parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_db_nodes ::Google::Cloud::OracleDatabase::V1::ListDbNodesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_db_nodes({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_db_nodes(::Google::Cloud::OracleDatabase::V1::ListDbNodesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_db_nodes_client_stub.call_count
      end
    end
  end

  def test_list_gi_versions
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListGiVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_gi_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_gi_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_gi_versions_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_gi_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_gi_versions parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_gi_versions ::Google::Cloud::OracleDatabase::V1::ListGiVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_gi_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_gi_versions(::Google::Cloud::OracleDatabase::V1::ListGiVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_gi_versions_client_stub.call_count
      end
    end
  end

  def test_list_minor_versions
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListMinorVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_minor_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_minor_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_minor_versions_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_minor_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_minor_versions parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_minor_versions ::Google::Cloud::OracleDatabase::V1::ListMinorVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_minor_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_minor_versions(::Google::Cloud::OracleDatabase::V1::ListMinorVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_minor_versions_client_stub.call_count
      end
    end
  end

  def test_list_db_system_shapes
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListDbSystemShapesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_db_system_shapes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_db_system_shapes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_db_system_shapes_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_db_system_shapes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_db_system_shapes parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_db_system_shapes ::Google::Cloud::OracleDatabase::V1::ListDbSystemShapesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_db_system_shapes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_db_system_shapes(::Google::Cloud::OracleDatabase::V1::ListDbSystemShapesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_db_system_shapes_client_stub.call_count
      end
    end
  end

  def test_list_autonomous_databases
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabasesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_autonomous_databases_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_autonomous_databases_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_autonomous_databases_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_autonomous_databases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_autonomous_databases parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_autonomous_databases ::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_autonomous_databases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_autonomous_databases(::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_autonomous_databases_client_stub.call_count
      end
    end
  end

  def test_get_autonomous_database
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::AutonomousDatabase.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_autonomous_database_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_get_autonomous_database_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_autonomous_database_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_autonomous_database({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_autonomous_database name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_autonomous_database ::Google::Cloud::OracleDatabase::V1::GetAutonomousDatabaseRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_autonomous_database({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_autonomous_database(::Google::Cloud::OracleDatabase::V1::GetAutonomousDatabaseRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_autonomous_database_client_stub.call_count
      end
    end
  end

  def test_create_autonomous_database
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    autonomous_database_id = "hello world"
    autonomous_database = {}
    request_id = "hello world"

    create_autonomous_database_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_create_autonomous_database_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_autonomous_database_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_autonomous_database({ parent: parent, autonomous_database_id: autonomous_database_id, autonomous_database: autonomous_database, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_autonomous_database parent: parent, autonomous_database_id: autonomous_database_id, autonomous_database: autonomous_database, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_autonomous_database ::Google::Cloud::OracleDatabase::V1::CreateAutonomousDatabaseRequest.new(parent: parent, autonomous_database_id: autonomous_database_id, autonomous_database: autonomous_database, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_autonomous_database({ parent: parent, autonomous_database_id: autonomous_database_id, autonomous_database: autonomous_database, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_autonomous_database(::Google::Cloud::OracleDatabase::V1::CreateAutonomousDatabaseRequest.new(parent: parent, autonomous_database_id: autonomous_database_id, autonomous_database: autonomous_database, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_autonomous_database_client_stub.call_count
      end
    end
  end

  def test_update_autonomous_database
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    autonomous_database = {}
    request_id = "hello world"

    update_autonomous_database_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_update_autonomous_database_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_autonomous_database_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_autonomous_database({ update_mask: update_mask, autonomous_database: autonomous_database, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_autonomous_database update_mask: update_mask, autonomous_database: autonomous_database, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_autonomous_database ::Google::Cloud::OracleDatabase::V1::UpdateAutonomousDatabaseRequest.new(update_mask: update_mask, autonomous_database: autonomous_database, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_autonomous_database({ update_mask: update_mask, autonomous_database: autonomous_database, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_autonomous_database(::Google::Cloud::OracleDatabase::V1::UpdateAutonomousDatabaseRequest.new(update_mask: update_mask, autonomous_database: autonomous_database, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_autonomous_database_client_stub.call_count
      end
    end
  end

  def test_delete_autonomous_database
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_autonomous_database_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_delete_autonomous_database_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_autonomous_database_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_autonomous_database({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_autonomous_database name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_autonomous_database ::Google::Cloud::OracleDatabase::V1::DeleteAutonomousDatabaseRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_autonomous_database({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_autonomous_database(::Google::Cloud::OracleDatabase::V1::DeleteAutonomousDatabaseRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_autonomous_database_client_stub.call_count
      end
    end
  end

  def test_restore_autonomous_database
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    restore_time = {}

    restore_autonomous_database_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_restore_autonomous_database_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, restore_autonomous_database_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.restore_autonomous_database({ name: name, restore_time: restore_time }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.restore_autonomous_database name: name, restore_time: restore_time do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.restore_autonomous_database ::Google::Cloud::OracleDatabase::V1::RestoreAutonomousDatabaseRequest.new(name: name, restore_time: restore_time) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.restore_autonomous_database({ name: name, restore_time: restore_time }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.restore_autonomous_database(::Google::Cloud::OracleDatabase::V1::RestoreAutonomousDatabaseRequest.new(name: name, restore_time: restore_time), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, restore_autonomous_database_client_stub.call_count
      end
    end
  end

  def test_generate_autonomous_database_wallet
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::GenerateAutonomousDatabaseWalletResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    type = :GENERATE_TYPE_UNSPECIFIED
    is_regional = true
    password = "hello world"

    generate_autonomous_database_wallet_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_generate_autonomous_database_wallet_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_autonomous_database_wallet_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_autonomous_database_wallet({ name: name, type: type, is_regional: is_regional, password: password }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_autonomous_database_wallet name: name, type: type, is_regional: is_regional, password: password do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_autonomous_database_wallet ::Google::Cloud::OracleDatabase::V1::GenerateAutonomousDatabaseWalletRequest.new(name: name, type: type, is_regional: is_regional, password: password) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_autonomous_database_wallet({ name: name, type: type, is_regional: is_regional, password: password }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_autonomous_database_wallet(::Google::Cloud::OracleDatabase::V1::GenerateAutonomousDatabaseWalletRequest.new(name: name, type: type, is_regional: is_regional, password: password), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_autonomous_database_wallet_client_stub.call_count
      end
    end
  end

  def test_list_autonomous_db_versions
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListAutonomousDbVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_autonomous_db_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_autonomous_db_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_autonomous_db_versions_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_autonomous_db_versions({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_autonomous_db_versions parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_autonomous_db_versions ::Google::Cloud::OracleDatabase::V1::ListAutonomousDbVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_autonomous_db_versions({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_autonomous_db_versions(::Google::Cloud::OracleDatabase::V1::ListAutonomousDbVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_autonomous_db_versions_client_stub.call_count
      end
    end
  end

  def test_list_autonomous_database_character_sets
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabaseCharacterSetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_autonomous_database_character_sets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_autonomous_database_character_sets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_autonomous_database_character_sets_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_autonomous_database_character_sets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_autonomous_database_character_sets parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_autonomous_database_character_sets ::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabaseCharacterSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_autonomous_database_character_sets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_autonomous_database_character_sets(::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabaseCharacterSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_autonomous_database_character_sets_client_stub.call_count
      end
    end
  end

  def test_list_autonomous_database_backups
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabaseBackupsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_autonomous_database_backups_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_autonomous_database_backups_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_autonomous_database_backups_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_autonomous_database_backups({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_autonomous_database_backups parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_autonomous_database_backups ::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabaseBackupsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_autonomous_database_backups({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_autonomous_database_backups(::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabaseBackupsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_autonomous_database_backups_client_stub.call_count
      end
    end
  end

  def test_stop_autonomous_database
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    stop_autonomous_database_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_stop_autonomous_database_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, stop_autonomous_database_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.stop_autonomous_database({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.stop_autonomous_database name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.stop_autonomous_database ::Google::Cloud::OracleDatabase::V1::StopAutonomousDatabaseRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.stop_autonomous_database({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.stop_autonomous_database(::Google::Cloud::OracleDatabase::V1::StopAutonomousDatabaseRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, stop_autonomous_database_client_stub.call_count
      end
    end
  end

  def test_start_autonomous_database
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    start_autonomous_database_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_start_autonomous_database_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, start_autonomous_database_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.start_autonomous_database({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.start_autonomous_database name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.start_autonomous_database ::Google::Cloud::OracleDatabase::V1::StartAutonomousDatabaseRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.start_autonomous_database({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.start_autonomous_database(::Google::Cloud::OracleDatabase::V1::StartAutonomousDatabaseRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, start_autonomous_database_client_stub.call_count
      end
    end
  end

  def test_restart_autonomous_database
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    restart_autonomous_database_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_restart_autonomous_database_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, restart_autonomous_database_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.restart_autonomous_database({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.restart_autonomous_database name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.restart_autonomous_database ::Google::Cloud::OracleDatabase::V1::RestartAutonomousDatabaseRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.restart_autonomous_database({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.restart_autonomous_database(::Google::Cloud::OracleDatabase::V1::RestartAutonomousDatabaseRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, restart_autonomous_database_client_stub.call_count
      end
    end
  end

  def test_switchover_autonomous_database
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    peer_autonomous_database = "hello world"

    switchover_autonomous_database_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_switchover_autonomous_database_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, switchover_autonomous_database_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.switchover_autonomous_database({ name: name, peer_autonomous_database: peer_autonomous_database }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.switchover_autonomous_database name: name, peer_autonomous_database: peer_autonomous_database do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.switchover_autonomous_database ::Google::Cloud::OracleDatabase::V1::SwitchoverAutonomousDatabaseRequest.new(name: name, peer_autonomous_database: peer_autonomous_database) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.switchover_autonomous_database({ name: name, peer_autonomous_database: peer_autonomous_database }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.switchover_autonomous_database(::Google::Cloud::OracleDatabase::V1::SwitchoverAutonomousDatabaseRequest.new(name: name, peer_autonomous_database: peer_autonomous_database), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, switchover_autonomous_database_client_stub.call_count
      end
    end
  end

  def test_failover_autonomous_database
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    peer_autonomous_database = "hello world"

    failover_autonomous_database_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_failover_autonomous_database_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, failover_autonomous_database_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.failover_autonomous_database({ name: name, peer_autonomous_database: peer_autonomous_database }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.failover_autonomous_database name: name, peer_autonomous_database: peer_autonomous_database do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.failover_autonomous_database ::Google::Cloud::OracleDatabase::V1::FailoverAutonomousDatabaseRequest.new(name: name, peer_autonomous_database: peer_autonomous_database) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.failover_autonomous_database({ name: name, peer_autonomous_database: peer_autonomous_database }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.failover_autonomous_database(::Google::Cloud::OracleDatabase::V1::FailoverAutonomousDatabaseRequest.new(name: name, peer_autonomous_database: peer_autonomous_database), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, failover_autonomous_database_client_stub.call_count
      end
    end
  end

  def test_list_odb_networks
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListOdbNetworksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_odb_networks_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_odb_networks_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_odb_networks_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_odb_networks({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_odb_networks parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_odb_networks ::Google::Cloud::OracleDatabase::V1::ListOdbNetworksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_odb_networks({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_odb_networks(::Google::Cloud::OracleDatabase::V1::ListOdbNetworksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_odb_networks_client_stub.call_count
      end
    end
  end

  def test_get_odb_network
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::OdbNetwork.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_odb_network_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_get_odb_network_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_odb_network_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_odb_network({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_odb_network name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_odb_network ::Google::Cloud::OracleDatabase::V1::GetOdbNetworkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_odb_network({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_odb_network(::Google::Cloud::OracleDatabase::V1::GetOdbNetworkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_odb_network_client_stub.call_count
      end
    end
  end

  def test_create_odb_network
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    odb_network_id = "hello world"
    odb_network = {}
    request_id = "hello world"

    create_odb_network_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_create_odb_network_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_odb_network_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_odb_network({ parent: parent, odb_network_id: odb_network_id, odb_network: odb_network, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_odb_network parent: parent, odb_network_id: odb_network_id, odb_network: odb_network, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_odb_network ::Google::Cloud::OracleDatabase::V1::CreateOdbNetworkRequest.new(parent: parent, odb_network_id: odb_network_id, odb_network: odb_network, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_odb_network({ parent: parent, odb_network_id: odb_network_id, odb_network: odb_network, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_odb_network(::Google::Cloud::OracleDatabase::V1::CreateOdbNetworkRequest.new(parent: parent, odb_network_id: odb_network_id, odb_network: odb_network, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_odb_network_client_stub.call_count
      end
    end
  end

  def test_delete_odb_network
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_odb_network_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_delete_odb_network_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_odb_network_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_odb_network({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_odb_network name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_odb_network ::Google::Cloud::OracleDatabase::V1::DeleteOdbNetworkRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_odb_network({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_odb_network(::Google::Cloud::OracleDatabase::V1::DeleteOdbNetworkRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_odb_network_client_stub.call_count
      end
    end
  end

  def test_list_odb_subnets
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListOdbSubnetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_odb_subnets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_odb_subnets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_odb_subnets_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_odb_subnets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_odb_subnets parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_odb_subnets ::Google::Cloud::OracleDatabase::V1::ListOdbSubnetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_odb_subnets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_odb_subnets(::Google::Cloud::OracleDatabase::V1::ListOdbSubnetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_odb_subnets_client_stub.call_count
      end
    end
  end

  def test_get_odb_subnet
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::OdbSubnet.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_odb_subnet_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_get_odb_subnet_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_odb_subnet_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_odb_subnet({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_odb_subnet name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_odb_subnet ::Google::Cloud::OracleDatabase::V1::GetOdbSubnetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_odb_subnet({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_odb_subnet(::Google::Cloud::OracleDatabase::V1::GetOdbSubnetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_odb_subnet_client_stub.call_count
      end
    end
  end

  def test_create_odb_subnet
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    odb_subnet_id = "hello world"
    odb_subnet = {}
    request_id = "hello world"

    create_odb_subnet_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_create_odb_subnet_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_odb_subnet_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_odb_subnet({ parent: parent, odb_subnet_id: odb_subnet_id, odb_subnet: odb_subnet, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_odb_subnet parent: parent, odb_subnet_id: odb_subnet_id, odb_subnet: odb_subnet, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_odb_subnet ::Google::Cloud::OracleDatabase::V1::CreateOdbSubnetRequest.new(parent: parent, odb_subnet_id: odb_subnet_id, odb_subnet: odb_subnet, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_odb_subnet({ parent: parent, odb_subnet_id: odb_subnet_id, odb_subnet: odb_subnet, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_odb_subnet(::Google::Cloud::OracleDatabase::V1::CreateOdbSubnetRequest.new(parent: parent, odb_subnet_id: odb_subnet_id, odb_subnet: odb_subnet, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_odb_subnet_client_stub.call_count
      end
    end
  end

  def test_delete_odb_subnet
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_odb_subnet_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_delete_odb_subnet_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_odb_subnet_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_odb_subnet({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_odb_subnet name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_odb_subnet ::Google::Cloud::OracleDatabase::V1::DeleteOdbSubnetRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_odb_subnet({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_odb_subnet(::Google::Cloud::OracleDatabase::V1::DeleteOdbSubnetRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_odb_subnet_client_stub.call_count
      end
    end
  end

  def test_list_exadb_vm_clusters
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListExadbVmClustersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_exadb_vm_clusters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_exadb_vm_clusters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_exadb_vm_clusters_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_exadb_vm_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_exadb_vm_clusters parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_exadb_vm_clusters ::Google::Cloud::OracleDatabase::V1::ListExadbVmClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_exadb_vm_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_exadb_vm_clusters(::Google::Cloud::OracleDatabase::V1::ListExadbVmClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_exadb_vm_clusters_client_stub.call_count
      end
    end
  end

  def test_get_exadb_vm_cluster
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ExadbVmCluster.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_exadb_vm_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_get_exadb_vm_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_exadb_vm_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_exadb_vm_cluster({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_exadb_vm_cluster name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_exadb_vm_cluster ::Google::Cloud::OracleDatabase::V1::GetExadbVmClusterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_exadb_vm_cluster({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_exadb_vm_cluster(::Google::Cloud::OracleDatabase::V1::GetExadbVmClusterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_exadb_vm_cluster_client_stub.call_count
      end
    end
  end

  def test_create_exadb_vm_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    exadb_vm_cluster_id = "hello world"
    exadb_vm_cluster = {}
    request_id = "hello world"

    create_exadb_vm_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_create_exadb_vm_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_exadb_vm_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_exadb_vm_cluster({ parent: parent, exadb_vm_cluster_id: exadb_vm_cluster_id, exadb_vm_cluster: exadb_vm_cluster, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_exadb_vm_cluster parent: parent, exadb_vm_cluster_id: exadb_vm_cluster_id, exadb_vm_cluster: exadb_vm_cluster, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_exadb_vm_cluster ::Google::Cloud::OracleDatabase::V1::CreateExadbVmClusterRequest.new(parent: parent, exadb_vm_cluster_id: exadb_vm_cluster_id, exadb_vm_cluster: exadb_vm_cluster, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_exadb_vm_cluster({ parent: parent, exadb_vm_cluster_id: exadb_vm_cluster_id, exadb_vm_cluster: exadb_vm_cluster, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_exadb_vm_cluster(::Google::Cloud::OracleDatabase::V1::CreateExadbVmClusterRequest.new(parent: parent, exadb_vm_cluster_id: exadb_vm_cluster_id, exadb_vm_cluster: exadb_vm_cluster, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_exadb_vm_cluster_client_stub.call_count
      end
    end
  end

  def test_delete_exadb_vm_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_exadb_vm_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_delete_exadb_vm_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_exadb_vm_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_exadb_vm_cluster({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_exadb_vm_cluster name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_exadb_vm_cluster ::Google::Cloud::OracleDatabase::V1::DeleteExadbVmClusterRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_exadb_vm_cluster({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_exadb_vm_cluster(::Google::Cloud::OracleDatabase::V1::DeleteExadbVmClusterRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_exadb_vm_cluster_client_stub.call_count
      end
    end
  end

  def test_update_exadb_vm_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    exadb_vm_cluster = {}
    request_id = "hello world"

    update_exadb_vm_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_update_exadb_vm_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_exadb_vm_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_exadb_vm_cluster({ update_mask: update_mask, exadb_vm_cluster: exadb_vm_cluster, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_exadb_vm_cluster update_mask: update_mask, exadb_vm_cluster: exadb_vm_cluster, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_exadb_vm_cluster ::Google::Cloud::OracleDatabase::V1::UpdateExadbVmClusterRequest.new(update_mask: update_mask, exadb_vm_cluster: exadb_vm_cluster, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_exadb_vm_cluster({ update_mask: update_mask, exadb_vm_cluster: exadb_vm_cluster, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_exadb_vm_cluster(::Google::Cloud::OracleDatabase::V1::UpdateExadbVmClusterRequest.new(update_mask: update_mask, exadb_vm_cluster: exadb_vm_cluster, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_exadb_vm_cluster_client_stub.call_count
      end
    end
  end

  def test_remove_virtual_machine_exadb_vm_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    hostnames = ["hello world"]

    remove_virtual_machine_exadb_vm_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_remove_virtual_machine_exadb_vm_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_virtual_machine_exadb_vm_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_virtual_machine_exadb_vm_cluster({ name: name, request_id: request_id, hostnames: hostnames }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_virtual_machine_exadb_vm_cluster name: name, request_id: request_id, hostnames: hostnames do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_virtual_machine_exadb_vm_cluster ::Google::Cloud::OracleDatabase::V1::RemoveVirtualMachineExadbVmClusterRequest.new(name: name, request_id: request_id, hostnames: hostnames) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_virtual_machine_exadb_vm_cluster({ name: name, request_id: request_id, hostnames: hostnames }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_virtual_machine_exadb_vm_cluster(::Google::Cloud::OracleDatabase::V1::RemoveVirtualMachineExadbVmClusterRequest.new(name: name, request_id: request_id, hostnames: hostnames), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_virtual_machine_exadb_vm_cluster_client_stub.call_count
      end
    end
  end

  def test_list_exascale_db_storage_vaults
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListExascaleDbStorageVaultsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_exascale_db_storage_vaults_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_exascale_db_storage_vaults_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_exascale_db_storage_vaults_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_exascale_db_storage_vaults({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_exascale_db_storage_vaults parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_exascale_db_storage_vaults ::Google::Cloud::OracleDatabase::V1::ListExascaleDbStorageVaultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_exascale_db_storage_vaults({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_exascale_db_storage_vaults(::Google::Cloud::OracleDatabase::V1::ListExascaleDbStorageVaultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_exascale_db_storage_vaults_client_stub.call_count
      end
    end
  end

  def test_get_exascale_db_storage_vault
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ExascaleDbStorageVault.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_exascale_db_storage_vault_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_get_exascale_db_storage_vault_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_exascale_db_storage_vault_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_exascale_db_storage_vault({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_exascale_db_storage_vault name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_exascale_db_storage_vault ::Google::Cloud::OracleDatabase::V1::GetExascaleDbStorageVaultRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_exascale_db_storage_vault({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_exascale_db_storage_vault(::Google::Cloud::OracleDatabase::V1::GetExascaleDbStorageVaultRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_exascale_db_storage_vault_client_stub.call_count
      end
    end
  end

  def test_create_exascale_db_storage_vault
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    exascale_db_storage_vault_id = "hello world"
    exascale_db_storage_vault = {}
    request_id = "hello world"

    create_exascale_db_storage_vault_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_create_exascale_db_storage_vault_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_exascale_db_storage_vault_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_exascale_db_storage_vault({ parent: parent, exascale_db_storage_vault_id: exascale_db_storage_vault_id, exascale_db_storage_vault: exascale_db_storage_vault, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_exascale_db_storage_vault parent: parent, exascale_db_storage_vault_id: exascale_db_storage_vault_id, exascale_db_storage_vault: exascale_db_storage_vault, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_exascale_db_storage_vault ::Google::Cloud::OracleDatabase::V1::CreateExascaleDbStorageVaultRequest.new(parent: parent, exascale_db_storage_vault_id: exascale_db_storage_vault_id, exascale_db_storage_vault: exascale_db_storage_vault, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_exascale_db_storage_vault({ parent: parent, exascale_db_storage_vault_id: exascale_db_storage_vault_id, exascale_db_storage_vault: exascale_db_storage_vault, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_exascale_db_storage_vault(::Google::Cloud::OracleDatabase::V1::CreateExascaleDbStorageVaultRequest.new(parent: parent, exascale_db_storage_vault_id: exascale_db_storage_vault_id, exascale_db_storage_vault: exascale_db_storage_vault, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_exascale_db_storage_vault_client_stub.call_count
      end
    end
  end

  def test_delete_exascale_db_storage_vault
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_exascale_db_storage_vault_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_delete_exascale_db_storage_vault_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_exascale_db_storage_vault_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_exascale_db_storage_vault({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_exascale_db_storage_vault name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_exascale_db_storage_vault ::Google::Cloud::OracleDatabase::V1::DeleteExascaleDbStorageVaultRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_exascale_db_storage_vault({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_exascale_db_storage_vault(::Google::Cloud::OracleDatabase::V1::DeleteExascaleDbStorageVaultRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_exascale_db_storage_vault_client_stub.call_count
      end
    end
  end

  def test_list_db_system_initial_storage_sizes
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListDbSystemInitialStorageSizesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_db_system_initial_storage_sizes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_db_system_initial_storage_sizes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_db_system_initial_storage_sizes_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_db_system_initial_storage_sizes({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_db_system_initial_storage_sizes parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_db_system_initial_storage_sizes ::Google::Cloud::OracleDatabase::V1::ListDbSystemInitialStorageSizesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_db_system_initial_storage_sizes({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_db_system_initial_storage_sizes(::Google::Cloud::OracleDatabase::V1::ListDbSystemInitialStorageSizesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_db_system_initial_storage_sizes_client_stub.call_count
      end
    end
  end

  def test_list_databases
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListDatabasesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_databases_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_databases_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_databases_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_databases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_databases parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_databases ::Google::Cloud::OracleDatabase::V1::ListDatabasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_databases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_databases(::Google::Cloud::OracleDatabase::V1::ListDatabasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_databases_client_stub.call_count
      end
    end
  end

  def test_get_database
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::Database.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_database_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_get_database_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_database_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_database({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_database name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_database ::Google::Cloud::OracleDatabase::V1::GetDatabaseRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_database({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_database(::Google::Cloud::OracleDatabase::V1::GetDatabaseRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_database_client_stub.call_count
      end
    end
  end

  def test_list_pluggable_databases
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListPluggableDatabasesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_pluggable_databases_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_pluggable_databases_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_pluggable_databases_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_pluggable_databases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_pluggable_databases parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_pluggable_databases ::Google::Cloud::OracleDatabase::V1::ListPluggableDatabasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_pluggable_databases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_pluggable_databases(::Google::Cloud::OracleDatabase::V1::ListPluggableDatabasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_pluggable_databases_client_stub.call_count
      end
    end
  end

  def test_get_pluggable_database
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::PluggableDatabase.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_pluggable_database_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_get_pluggable_database_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_pluggable_database_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_pluggable_database({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_pluggable_database name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_pluggable_database ::Google::Cloud::OracleDatabase::V1::GetPluggableDatabaseRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_pluggable_database({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_pluggable_database(::Google::Cloud::OracleDatabase::V1::GetPluggableDatabaseRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_pluggable_database_client_stub.call_count
      end
    end
  end

  def test_list_db_systems
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListDbSystemsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_db_systems_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_db_systems_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_db_systems_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_db_systems({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_db_systems parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_db_systems ::Google::Cloud::OracleDatabase::V1::ListDbSystemsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_db_systems({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_db_systems(::Google::Cloud::OracleDatabase::V1::ListDbSystemsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_db_systems_client_stub.call_count
      end
    end
  end

  def test_get_db_system
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::DbSystem.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_db_system_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_get_db_system_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_db_system_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_db_system({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_db_system name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_db_system ::Google::Cloud::OracleDatabase::V1::GetDbSystemRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_db_system({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_db_system(::Google::Cloud::OracleDatabase::V1::GetDbSystemRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_db_system_client_stub.call_count
      end
    end
  end

  def test_create_db_system
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    db_system_id = "hello world"
    db_system = {}
    request_id = "hello world"

    create_db_system_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_create_db_system_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_db_system_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_db_system({ parent: parent, db_system_id: db_system_id, db_system: db_system, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_db_system parent: parent, db_system_id: db_system_id, db_system: db_system, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_db_system ::Google::Cloud::OracleDatabase::V1::CreateDbSystemRequest.new(parent: parent, db_system_id: db_system_id, db_system: db_system, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_db_system({ parent: parent, db_system_id: db_system_id, db_system: db_system, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_db_system(::Google::Cloud::OracleDatabase::V1::CreateDbSystemRequest.new(parent: parent, db_system_id: db_system_id, db_system: db_system, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_db_system_client_stub.call_count
      end
    end
  end

  def test_delete_db_system
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_db_system_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_delete_db_system_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_db_system_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_db_system({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_db_system name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_db_system ::Google::Cloud::OracleDatabase::V1::DeleteDbSystemRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_db_system({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_db_system(::Google::Cloud::OracleDatabase::V1::DeleteDbSystemRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_db_system_client_stub.call_count
      end
    end
  end

  def test_list_db_versions
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListDbVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_db_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_db_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_db_versions_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_db_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_db_versions parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_db_versions ::Google::Cloud::OracleDatabase::V1::ListDbVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_db_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_db_versions(::Google::Cloud::OracleDatabase::V1::ListDbVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_db_versions_client_stub.call_count
      end
    end
  end

  def test_list_database_character_sets
    # Create test objects.
    client_result = ::Google::Cloud::OracleDatabase::V1::ListDatabaseCharacterSetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_database_character_sets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.stub :transcode_list_database_character_sets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_database_character_sets_client_stub do
        # Create client
        client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_database_character_sets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_database_character_sets parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_database_character_sets ::Google::Cloud::OracleDatabase::V1::ListDatabaseCharacterSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_database_character_sets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_database_character_sets(::Google::Cloud::OracleDatabase::V1::ListDatabaseCharacterSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_database_character_sets_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client::Configuration, config
  end
end
