# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/oracle_database/v1/oracle_database"

class ::Google::Cloud::OracleDatabase::V1::OracleDatabase::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_autonomous_database_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.autonomous_database_path project: "value0", location: "value1", autonomous_database: "value2"
      assert_equal "projects/value0/locations/value1/autonomousDatabases/value2", path
    end
  end

  def test_cloud_exadata_infrastructure_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.cloud_exadata_infrastructure_path project: "value0", location: "value1", cloud_exadata_infrastructure: "value2"
      assert_equal "projects/value0/locations/value1/cloudExadataInfrastructures/value2", path
    end
  end

  def test_cloud_vm_cluster_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.cloud_vm_cluster_path project: "value0", location: "value1", cloud_vm_cluster: "value2"
      assert_equal "projects/value0/locations/value1/cloudVmClusters/value2", path
    end
  end

  def test_crypto_key_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.crypto_key_path project: "value0", location: "value1", key_ring: "value2", crypto_key: "value3"
      assert_equal "projects/value0/locations/value1/keyRings/value2/cryptoKeys/value3", path
    end
  end

  def test_database_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.database_path project: "value0", location: "value1", database: "value2"
      assert_equal "projects/value0/locations/value1/databases/value2", path
    end
  end

  def test_db_system_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.db_system_path project: "value0", location: "value1", db_system: "value2"
      assert_equal "projects/value0/locations/value1/dbSystems/value2", path
    end
  end

  def test_exadb_vm_cluster_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.exadb_vm_cluster_path project: "value0", location: "value1", exadb_vm_cluster: "value2"
      assert_equal "projects/value0/locations/value1/exadbVmClusters/value2", path
    end
  end

  def test_exascale_db_storage_vault_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.exascale_db_storage_vault_path project: "value0", location: "value1", exascale_db_storage_vault: "value2"
      assert_equal "projects/value0/locations/value1/exascaleDbStorageVaults/value2", path
    end
  end

  def test_gi_version_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.gi_version_path project: "value0", location: "value1", gi_version: "value2"
      assert_equal "projects/value0/locations/value1/giVersions/value2", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_network_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.network_path project: "value0", network: "value1"
      assert_equal "projects/value0/global/networks/value1", path
    end
  end

  def test_odb_network_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.odb_network_path project: "value0", location: "value1", odb_network: "value2"
      assert_equal "projects/value0/locations/value1/odbNetworks/value2", path
    end
  end

  def test_odb_subnet_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.odb_subnet_path project: "value0", location: "value1", odb_network: "value2", odb_subnet: "value3"
      assert_equal "projects/value0/locations/value1/odbNetworks/value2/odbSubnets/value3", path
    end
  end

  def test_pluggable_database_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.pluggable_database_path project: "value0", location: "value1", pluggable_database: "value2"
      assert_equal "projects/value0/locations/value1/pluggableDatabases/value2", path
    end
  end
end
