# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # Details of the Cloud VM Cluster resource.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/CloudVmCluster/
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the VM Cluster resource with the format:
        #     projects/\\{project}/locations/\\{region}/cloudVmClusters/\\{cloud_vm_cluster}
        # @!attribute [rw] exadata_infrastructure
        #   @return [::String]
        #     Required. The name of the Exadata Infrastructure resource on which VM
        #     cluster resource is created, in the following format:
        #     projects/\\{project}/locations/\\{region}/cloudExadataInfrastuctures/\\{cloud_extradata_infrastructure}
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly name for this resource.
        # @!attribute [rw] properties
        #   @return [::Google::Cloud::OracleDatabase::V1::CloudVmClusterProperties]
        #     Optional. Various properties of the VM Cluster.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels or tags associated with the VM Cluster.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time that the VM cluster was created.
        # @!attribute [rw] cidr
        #   @return [::String]
        #     Optional. Network settings. CIDR to use for cluster IP allocation.
        # @!attribute [rw] backup_subnet_cidr
        #   @return [::String]
        #     Optional. CIDR range of the backup subnet.
        # @!attribute [rw] network
        #   @return [::String]
        #     Optional. The name of the VPC network.
        #     Format: projects/\\{project}/global/networks/\\{network}
        # @!attribute [r] gcp_oracle_zone
        #   @return [::String]
        #     Output only. The GCP Oracle zone where Oracle CloudVmCluster is hosted.
        #     This will be the same as the gcp_oracle_zone of the
        #     CloudExadataInfrastructure. Example: us-east4-b-r2.
        # @!attribute [rw] odb_network
        #   @return [::String]
        #     Optional. The name of the OdbNetwork associated with the VM Cluster.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network}
        #     It is optional but if specified, this should match the parent ODBNetwork of
        #     the odb_subnet and backup_odb_subnet.
        # @!attribute [rw] odb_subnet
        #   @return [::String]
        #     Optional. The name of the OdbSubnet associated with the VM Cluster for
        #     IP allocation. Format:
        #     projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network}/odbSubnets/\\{odb_subnet}
        # @!attribute [rw] backup_odb_subnet
        #   @return [::String]
        #     Optional. The name of the backup OdbSubnet associated with the VM Cluster.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network}/odbSubnets/\\{odb_subnet}
        # @!attribute [r] identity_connector
        #   @return [::Google::Cloud::OracleDatabase::V1::IdentityConnector]
        #     Output only. The identity connector details which will allow OCI to
        #     securely access the resources in the customer project.
        class CloudVmCluster
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Various properties and settings associated with Exadata VM cluster.
        # @!attribute [r] ocid
        #   @return [::String]
        #     Output only. Oracle Cloud Infrastructure ID of VM Cluster.
        # @!attribute [rw] license_type
        #   @return [::Google::Cloud::OracleDatabase::V1::CloudVmClusterProperties::LicenseType]
        #     Required. License type of VM Cluster.
        # @!attribute [rw] gi_version
        #   @return [::String]
        #     Optional. Grid Infrastructure Version.
        # @!attribute [rw] time_zone
        #   @return [::Google::Type::TimeZone]
        #     Optional. Time zone of VM Cluster to set. Defaults to UTC if not specified.
        # @!attribute [rw] ssh_public_keys
        #   @return [::Array<::String>]
        #     Optional. SSH public keys to be stored with cluster.
        # @!attribute [rw] node_count
        #   @return [::Integer]
        #     Optional. Number of database servers.
        # @!attribute [r] shape
        #   @return [::String]
        #     Output only. Shape of VM Cluster.
        # @!attribute [rw] ocpu_count
        #   @return [::Float]
        #     Optional. OCPU count per VM. Minimum is 0.1.
        # @!attribute [rw] memory_size_gb
        #   @return [::Integer]
        #     Optional. Memory allocated in GBs.
        # @!attribute [rw] db_node_storage_size_gb
        #   @return [::Integer]
        #     Optional. Local storage per VM.
        # @!attribute [r] storage_size_gb
        #   @return [::Integer]
        #     Output only. The storage allocation for the disk group, in gigabytes (GB).
        # @!attribute [rw] data_storage_size_tb
        #   @return [::Float]
        #     Optional. The data disk group size to be allocated in TBs.
        # @!attribute [rw] disk_redundancy
        #   @return [::Google::Cloud::OracleDatabase::V1::CloudVmClusterProperties::DiskRedundancy]
        #     Optional. The type of redundancy.
        # @!attribute [rw] sparse_diskgroup_enabled
        #   @return [::Boolean]
        #     Optional. Use exadata sparse snapshots.
        # @!attribute [rw] local_backup_enabled
        #   @return [::Boolean]
        #     Optional. Use local backup.
        # @!attribute [rw] hostname_prefix
        #   @return [::String]
        #     Optional. Prefix for VM cluster host names.
        # @!attribute [rw] diagnostics_data_collection_options
        #   @return [::Google::Cloud::OracleDatabase::V1::DataCollectionOptions]
        #     Optional. Data collection options for diagnostics.
        # @!attribute [r] state
        #   @return [::Google::Cloud::OracleDatabase::V1::CloudVmClusterProperties::State]
        #     Output only. State of the cluster.
        # @!attribute [r] scan_listener_port_tcp
        #   @return [::Integer]
        #     Output only. SCAN listener port - TCP
        # @!attribute [r] scan_listener_port_tcp_ssl
        #   @return [::Integer]
        #     Output only. SCAN listener port - TLS
        # @!attribute [r] domain
        #   @return [::String]
        #     Output only. Parent DNS domain where SCAN DNS and hosts names are
        #     qualified. ex: ocispdelegated.ocisp10jvnet.oraclevcn.com
        # @!attribute [r] scan_dns
        #   @return [::String]
        #     Output only. SCAN DNS name.
        #     ex: sp2-yi0xq-scan.ocispdelegated.ocisp10jvnet.oraclevcn.com
        # @!attribute [r] hostname
        #   @return [::String]
        #     Output only. host name without domain.
        #     format: "<hostname_prefix>-" with some suffix.
        #     ex: sp2-yi0xq where "sp2" is the hostname_prefix.
        # @!attribute [rw] cpu_core_count
        #   @return [::Integer]
        #     Required. Number of enabled CPU cores.
        # @!attribute [rw] system_version
        #   @return [::String]
        #     Optional. Operating system version of the image.
        # @!attribute [r] scan_ip_ids
        #   @return [::Array<::String>]
        #     Output only. OCIDs of scan IPs.
        # @!attribute [r] scan_dns_record_id
        #   @return [::String]
        #     Output only. OCID of scan DNS record.
        # @!attribute [r] oci_url
        #   @return [::String]
        #     Output only. Deep link to the OCI console to view this resource.
        # @!attribute [rw] db_server_ocids
        #   @return [::Array<::String>]
        #     Optional. OCID of database servers.
        # @!attribute [r] compartment_id
        #   @return [::String]
        #     Output only. Compartment ID of cluster.
        # @!attribute [r] dns_listener_ip
        #   @return [::String]
        #     Output only. DNS listener IP.
        # @!attribute [rw] cluster_name
        #   @return [::String]
        #     Optional. OCI Cluster name.
        # @!attribute [r] compute_model
        #   @return [::Google::Cloud::OracleDatabase::V1::ComputeModel]
        #     Output only. The compute model of the VM Cluster.
        class CloudVmClusterProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Different licenses supported.
          module LicenseType
            # Unspecified
            LICENSE_TYPE_UNSPECIFIED = 0

            # License included part of offer
            LICENSE_INCLUDED = 1

            # Bring your own license
            BRING_YOUR_OWN_LICENSE = 2
          end

          # Types of disk redundancy provided by Oracle.
          module DiskRedundancy
            # Unspecified.
            DISK_REDUNDANCY_UNSPECIFIED = 0

            # High -  3 way mirror.
            HIGH = 1

            # Normal - 2 way mirror.
            NORMAL = 2
          end

          # The various lifecycle states of the VM cluster.
          module State
            # Default unspecified value.
            STATE_UNSPECIFIED = 0

            # Indicates that the resource is in provisioning state.
            PROVISIONING = 1

            # Indicates that the resource is in available state.
            AVAILABLE = 2

            # Indicates that the resource is in updating state.
            UPDATING = 3

            # Indicates that the resource is in terminating state.
            TERMINATING = 4

            # Indicates that the resource is in terminated state.
            TERMINATED = 5

            # Indicates that the resource is in failed state.
            FAILED = 6

            # Indicates that the resource is in maintenance in progress state.
            MAINTENANCE_IN_PROGRESS = 7
          end
        end

        # Data collection options for diagnostics.
        # @!attribute [rw] diagnostics_events_enabled
        #   @return [::Boolean]
        #     Optional. Indicates whether diagnostic collection is enabled for the VM
        #     cluster
        # @!attribute [rw] health_monitoring_enabled
        #   @return [::Boolean]
        #     Optional. Indicates whether health monitoring is enabled for the VM cluster
        # @!attribute [rw] incident_logs_enabled
        #   @return [::Boolean]
        #     Optional. Indicates whether incident logs and trace collection are enabled
        #     for the VM cluster
        class DataCollectionOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
