# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # The PluggableDatabase resource.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/PluggableDatabase/
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the PluggableDatabase resource in the following
        #     format:
        #     projects/\\{project}/locations/\\{region}/pluggableDatabases/\\{pluggable_database}
        # @!attribute [rw] properties
        #   @return [::Google::Cloud::OracleDatabase::V1::PluggableDatabaseProperties]
        #     Optional. The properties of the PluggableDatabase.
        # @!attribute [r] oci_url
        #   @return [::String]
        #     Output only. HTTPS link to OCI resources exposed to Customer via UI
        #     Interface.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time that the PluggableDatabase was created.
        class PluggableDatabase
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The properties of a PluggableDatabase.
        # @!attribute [rw] compartment_id
        #   @return [::String]
        #     Required. The OCID of the compartment.
        # @!attribute [rw] connection_strings
        #   @return [::Google::Cloud::OracleDatabase::V1::PluggableDatabaseConnectionStrings]
        #     Optional. The Connection strings used to connect to the Oracle Database.
        # @!attribute [rw] container_database_ocid
        #   @return [::String]
        #     Required. The OCID of the CDB.
        # @!attribute [rw] defined_tags
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::OracleDatabase::V1::PluggableDatabaseProperties::DefinedTagValue}]
        #     Optional. Defined tags for this resource. Each key is predefined and scoped
        #     to a namespace.
        # @!attribute [rw] freeform_tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Free-form tags for this resource. Each tag is a simple key-value
        #     pair with no predefined name, type, or namespace.
        # @!attribute [r] ocid
        #   @return [::String]
        #     Output only. The OCID of the pluggable database.
        # @!attribute [rw] is_restricted
        #   @return [::Boolean]
        #     Optional. The restricted mode of the pluggable database. If a pluggable
        #     database is opened in restricted mode, the user needs both create a session
        #     and have restricted session privileges to connect to it.
        # @!attribute [r] lifecycle_details
        #   @return [::String]
        #     Output only. Additional information about the current lifecycle state.
        # @!attribute [r] lifecycle_state
        #   @return [::Google::Cloud::OracleDatabase::V1::PluggableDatabaseProperties::PluggableDatabaseLifecycleState]
        #     Output only. The current state of the pluggable database.
        # @!attribute [rw] pdb_name
        #   @return [::String]
        #     Required. The database name.
        # @!attribute [rw] pdb_node_level_details
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::PluggableDatabaseNodeLevelDetails>]
        #     Optional. Pluggable Database Node Level Details
        # @!attribute [r] database_management_config
        #   @return [::Google::Cloud::OracleDatabase::V1::DatabaseManagementConfig]
        #     Output only. The configuration of the Database Management service.
        # @!attribute [r] operations_insights_state
        #   @return [::Google::Cloud::OracleDatabase::V1::PluggableDatabaseProperties::OperationsInsightsState]
        #     Output only. The status of Operations Insights for this Database.
        class PluggableDatabaseProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Wrapper message for the value of a defined tag.
          # @!attribute [rw] tags
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     The tags within the namespace.
          class DefinedTagValue
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class TagsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::OracleDatabase::V1::PluggableDatabaseProperties::DefinedTagValue]
          class DefinedTagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class FreeformTagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The various lifecycle states of the PluggableDatabase.
          module PluggableDatabaseLifecycleState
            # The lifecycle state is unspecified.
            PLUGGABLE_DATABASE_LIFECYCLE_STATE_UNSPECIFIED = 0

            # The pluggable database is provisioning.
            PROVISIONING = 1

            # The pluggable database is available.
            AVAILABLE = 2

            # The pluggable database is terminating.
            TERMINATING = 3

            # The pluggable database is terminated.
            TERMINATED = 4

            # The pluggable database is updating.
            UPDATING = 5

            # The pluggable database is in a failed state.
            FAILED = 6

            # The pluggable database is relocating.
            RELOCATING = 7

            # The pluggable database is relocated.
            RELOCATED = 8

            # The pluggable database is refreshing.
            REFRESHING = 9

            # The pluggable database is restoring.
            RESTORE_IN_PROGRESS = 10

            # The pluggable database restore failed.
            RESTORE_FAILED = 11

            # The pluggable database is backing up.
            BACKUP_IN_PROGRESS = 12

            # The pluggable database is disabled.
            DISABLED = 13
          end

          # The status of Operations Insights for this Database.
          module OperationsInsightsState
            # The status is not specified.
            OPERATIONS_INSIGHTS_STATE_UNSPECIFIED = 0

            # Operations Insights is enabling.
            ENABLING = 1

            # Operations Insights is enabled.
            ENABLED = 2

            # Operations Insights is disabling.
            DISABLING = 3

            # Operations Insights is not enabled.
            NOT_ENABLED = 4

            # Operations Insights failed to enable.
            FAILED_ENABLING = 5

            # Operations Insights failed to disable.
            FAILED_DISABLING = 6
          end
        end

        # The connection strings used to connect to the Oracle Database.
        # @!attribute [rw] all_connection_strings
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. All connection strings to use to connect to the pluggable
        #     database.
        # @!attribute [rw] pdb_default
        #   @return [::String]
        #     Optional. The default connection string to use to connect to the pluggable
        #     database.
        # @!attribute [rw] pdb_ip_default
        #   @return [::String]
        #     Optional. The default connection string to use to connect to the pluggable
        #     database using IP.
        class PluggableDatabaseConnectionStrings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AllConnectionStringsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The Pluggable Database Node Level Details.
        # @!attribute [rw] node_name
        #   @return [::String]
        #     Required. The Node name of the Database home.
        # @!attribute [rw] open_mode
        #   @return [::Google::Cloud::OracleDatabase::V1::PluggableDatabaseNodeLevelDetails::PluggableDatabaseOpenMode]
        #     Required. The mode that the pluggable database is in to open it.
        # @!attribute [rw] pluggable_database_id
        #   @return [::String]
        #     Required. The OCID of the Pluggable Database.
        class PluggableDatabaseNodeLevelDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The mode that the pluggable database is in to open it.
          module PluggableDatabaseOpenMode
            # The open mode is unspecified.
            PLUGGABLE_DATABASE_OPEN_MODE_UNSPECIFIED = 0

            # The pluggable database is opened in read-only mode.
            READ_ONLY = 1

            # The pluggable database is opened in read-write mode.
            READ_WRITE = 2

            # The pluggable database is mounted.
            MOUNTED = 3

            # The pluggable database is migrated.
            MIGRATE = 4
          end
        end

        # The configuration of the Database Management service.
        # @!attribute [r] management_state
        #   @return [::Google::Cloud::OracleDatabase::V1::DatabaseManagementConfig::ManagementState]
        #     Output only. The status of the Database Management service.
        # @!attribute [r] management_type
        #   @return [::Google::Cloud::OracleDatabase::V1::DatabaseManagementConfig::ManagementType]
        #     Output only. The Database Management type.
        class DatabaseManagementConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The status of the Database Management service.
          module ManagementState
            # The status is not specified.
            MANAGEMENT_STATE_UNSPECIFIED = 0

            # The Database Management service is enabling.
            ENABLING = 1

            # The Database Management service is enabled.
            ENABLED = 2

            # The Database Management service is disabling.
            DISABLING = 3

            # The Database Management service is disabled.
            DISABLED = 4

            # The Database Management service is updating.
            UPDATING = 5

            # The Database Management service failed to enable.
            FAILED_ENABLING = 6

            # The Database Management service failed to disable.
            FAILED_DISABLING = 7

            # The Database Management service failed to update.
            FAILED_UPDATING = 8
          end

          # The Database Management type.
          module ManagementType
            # The type is not specified.
            MANAGEMENT_TYPE_UNSPECIFIED = 0

            # Basic Database Management.
            BASIC = 1

            # Advanced Database Management.
            ADVANCED = 2
          end
        end

        # The request for `PluggableDatabase.Get`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the PluggableDatabase resource in the following
        #     format:
        #     projects/\\{project}/locations/\\{region}/pluggableDatabases/\\{pluggable_database}
        class GetPluggableDatabaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for `PluggableDatabase.List`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of PluggableDatabases.
        #     Format: projects/\\{project}/locations/\\{location}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of PluggableDatabases to return. The service
        #     may return fewer than this value.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListPluggableDatabases`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListPluggableDatabases`
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression for filtering the results of the request. List for
        #     pluggable databases is supported only with a valid container database (full
        #     resource name) filter in this format:
        #     `database="projects/{project}/locations/{location}/databases/{database}"`
        class ListPluggableDatabasesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for `PluggableDatabase.List`.
        # @!attribute [rw] pluggable_databases
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::PluggableDatabase>]
        #     The list of PluggableDatabases.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListPluggableDatabasesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
