# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # Represents OdbNetwork resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the OdbNetwork resource in the following format:
        #     projects/\\{project}/locations/\\{region}/odbNetworks/\\{odb_network}
        # @!attribute [rw] network
        #   @return [::String]
        #     Required. The name of the VPC network in the following format:
        #     projects/\\{project}/global/networks/\\{network}
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels or tags associated with the resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time that the OdbNetwork was created.
        # @!attribute [r] state
        #   @return [::Google::Cloud::OracleDatabase::V1::OdbNetwork::State]
        #     Output only. State of the ODB Network.
        # @!attribute [r] entitlement_id
        #   @return [::String]
        #     Output only. The ID of the subscription entitlement associated with the
        #     OdbNetwork.
        # @!attribute [rw] gcp_oracle_zone
        #   @return [::String]
        #     Optional. The GCP Oracle zone where OdbNetwork is hosted.
        #     Example: us-east4-b-r2.
        #     If not specified, the system will pick a zone based on availability.
        class OdbNetwork
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The various lifecycle states of the ODB Network.
          module State
            # Default unspecified value.
            STATE_UNSPECIFIED = 0

            # Indicates that the resource is in provisioning state.
            PROVISIONING = 1

            # Indicates that the resource is in available state.
            AVAILABLE = 2

            # Indicates that the resource is in terminating state.
            TERMINATING = 3

            # Indicates that the resource is in failed state.
            FAILED = 4
          end
        end

        # The request for `OdbNetwork.Create`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent value for the OdbNetwork in the following format:
        #     projects/\\{project}/locations/\\{location}.
        # @!attribute [rw] odb_network_id
        #   @return [::String]
        #     Required. The ID of the OdbNetwork to create. This value is restricted
        #     to (^[a-z]([a-z0-9-]\\{0,61}[a-z0-9])?$) and must be a maximum of 63
        #     characters in length. The value must start with a letter and end with
        #     a letter or a number.
        # @!attribute [rw] odb_network
        #   @return [::Google::Cloud::OracleDatabase::V1::OdbNetwork]
        #     Required. Details of the OdbNetwork instance to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional ID to identify the request. This value is used to
        #     identify duplicate requests. If you make a request with the same request ID
        #     and the original request is still in progress or completed, the server
        #     ignores the second request. This prevents clients from
        #     accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateOdbNetworkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for `OdbNetwork.Delete`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource in the following format:
        #     projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network}.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional ID to identify the request. This value is used to
        #     identify duplicate requests. If you make a request with the same request ID
        #     and the original request is still in progress or completed, the server
        #     ignores the second request. This prevents clients from
        #     accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteOdbNetworkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for `OdbNetwork.List`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent value for the ODB Network in the following format:
        #     projects/\\{project}/locations/\\{location}.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of items to return.
        #     If unspecified, at most 50 ODB Networks will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression for filtering the results of the request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. An expression for ordering the results of the request.
        class ListOdbNetworksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for `OdbNetwork.List`.
        # @!attribute [rw] odb_networks
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::OdbNetwork>]
        #     The list of ODB Networks.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable locations when listing resources across all locations using
        #     wildcard location '-'.
        class ListOdbNetworksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for `OdbNetwork.Get`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the OdbNetwork in the following format:
        #     projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network}.
        class GetOdbNetworkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
