# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # MinorVersion represents a minor version of a GI.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/GiMinorVersionSummary/
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the MinorVersion resource with the format:
        #     projects/\\{project}/locations/\\{region}/giVersions/\\{gi_version}/minorVersions/\\{minor_version}
        # @!attribute [rw] grid_image_id
        #   @return [::String]
        #     Optional. The ID of the Grid Image.
        # @!attribute [rw] version
        #   @return [::String]
        #     Optional. The valid Oracle grid infrastructure software version.
        class MinorVersion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for `MinorVersion.List`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent value for the MinorVersion resource with the format:
        #     projects/\\{project}/locations/\\{location}/giVersions/\\{gi_version}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of items to return.
        #     If unspecified, a maximum of 50 System Versions will be returned.
        #     The maximum value is 1000; values above 1000 will be reset to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying the requested page of results to return. All
        #     fields except the filter should remain the same as in the request that
        #     provided this page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression for filtering the results of the request.
        #     Only shapeFamily and gcp_oracle_zone_id are supported in this format:
        #     `shape_family="{shapeFamily}" AND
        #     gcp_oracle_zone_id="\\{gcp_oracle_zone_id}"`.
        class ListMinorVersionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for `MinorVersion.List`.
        # @!attribute [rw] minor_versions
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::MinorVersion>]
        #     The list of MinorVersions.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListMinorVersionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
